h58605
s 00000/00000/00095
d D 1.2 83/03/31 12:45:27 mmm 2 1
c 
e
s 00095/00000/00000
d D 1.1 83/03/15 21:44:54 tes 1 0
c date and time created 83/03/15 21:44:54 by tes
e
u
4
U
t
T
I 1
subroutine gzcale
########################################################################
#                                                                      #
#          THIS MATERIAL IS CONFIDENTIAL AND IS FURNISHED UNDER        #
#          A WRITTEN LICENSE AGREEMENT.  IT MAY NOT BE USED,           #
#          COPIED OR DISCLOSED TO OTHERS EXCEPT IN ACCORDANCE          #
#          WITH THE TERMS OF THAT AGREEMENT.                           #
#                                                                      #
#          COPYRIGHT (C) 1982 GRAPHIC SOFTWARE SYSTEMS INC.            #
#          ALL RIGHTS RESERVED.                                        #
#                                                                      #
#     Function: calculate the current clipping edge                    #
#                                                                      #
#     Input Parameters:                                                #
#            None                                                      #
#      Output Parameters:                                              #
#            None                                                      #
#                                                                      #
#     Routines Called:                                                 #
#            gzcleg - clip a polygon to a specified edge               #
#            gzsedg - set the current clipping edge                    #
#                                                                      #
########################################################################
 
integer i,
	iedge1, iedge2,
	size1, size2
real xtmp1(5), ytmp1(5), xtmp2(5), ytmp2(5),
     edge1, edge2,
     xmin, xmax, ymin, ymax

include(`gkscom') 

   if (nclip != 0) {

      # Use the current world viewport as a polygon to clip against the
      #   workstation window. This will produce a polygon which is the
      #   intersection of the world viewport and the workstation window.
      #   This intersection can then be used to clip against thereby producing
      #   a clipped point with only one clipping action.
      size1 = 5
      i = nrmcur + 1
      xtmp1(1) = vxminl(i)
      xtmp1(2) = vxmaxl(i)
      xtmp1(3) = xtmp1(2)
      xtmp1(4) = xtmp1(1)
      xtmp1(5) = xtmp1(1)
      ytmp1(1) = vyminl(i)
      ytmp1(2) = ytmp1(1) 
      ytmp1(3) = vymaxl(i)
      ytmp1(4) = ytmp1(3)
      ytmp1(5) = ytmp1(1)

      iedge1 = LEFT       # Set up to clip the left and right extremes of the
      edge1 = cwrkwn(1) - zeps   # workstation window.
      iedge2 = RIGHT
      edge2 = cwrkwn(2) + zeps
            
      # clip to each clipping edge as pairs, LEFT/RIGHT and TOP/BOTTOM
      do i=1, 2 {
         call gzcleg (size1,xtmp1,ytmp1,edge1,iedge1,size2,xtmp2,ytmp2)
         call gzcleg (size2,xtmp2,ytmp2,edge2,iedge2,size1,xtmp1,ytmp1)
         iedge1 = TOP       # Set up to clip the top and bottom extremes of the
         edge1 = cwrkwn(4) + zeps  #   workstation window.
         iedge2 = BOTTOM
         edge2 = cwrkwn(3) - zeps
         }
        
      # Obtain and set the minimum and maximum clipping edge extents
      if (size1 >= 5) {
         xmin = amin1 (xtmp1(1), xtmp1(2), xtmp1(3), xtmp1(4))
         ymin = amin1 (ytmp1(1), ytmp1(2), ytmp1(3), ytmp1(4))
         xmax = amax1 (xtmp1(1), xtmp1(2), xtmp1(3), xtmp1(4))
         ymax = amax1 (ytmp1(1), ytmp1(2), ytmp1(3), ytmp1(4))
         }
      else {   # When there is no intersection, set a clipping edge which
	       #   will cause the entire output to be clipped.
	 xmin = cwrkwn(2)
	 xmax = cwrkwn(1)
	 ymin = cwrkwn(4)
	 ymax = cwrkwn(3)
	 }
      }
   else {   # When world clipping is off, we clip to the workstation window
      xmin = cwrkwn(1)
      xmax = cwrkwn(2)
      ymin = cwrkwn(3)
      ymax = cwrkwn(4)
      }
   
   # Set the clipping edge
   call gzsedg (xmin, xmax, ymin, ymax)

   return
end
E 1
