	page	0
	title	'Master Network I/F Module'
	name	'netwrkif'

;*********************************************************
;*********************************************************
;**                                                     **
;**   M a s t e r   N e t w o r k   I / F   M o d u l e **
;**                                                     **
;*********************************************************
;*********************************************************

;/*
;  Copyright (C) 1980
;  Digital Research
;  P.O. Box 579
;  Pacific Grove, CA 93950
;*/

false	equ	0
true	equ	not false

debug	equ	false

	if	debug
NmbSlvs	equ	1

	lxi	sp,NtwrkIS0+2eh
	mvi	c,145
	mvi	e,64
	call	bdos	; set priority to 64
	lxi	h,UQCBNtwrkQI0
	lxi	d,UQCBNtwrkQO0
	lxi	b,BufferQ0
	mvi	a,00h
	ret

bdosadr:
	dw	0005h

	else
NmbSlvs	equ	2

;  BDOS entry point address
bdosadr:
	dw	$-$
	endif

;  Network Interface Process #0
;
NtwrkIP0:
	dw	0		; link
	db	0		; status
	db	64		; priority
	dw	NtwrkIS0+46	; stack pointer
	db	'NtwrkIP0'	; name
	db	0		; console
	db	0ffh		; memseg
	ds	2		; b
	ds	2		; thread
	ds	2		; buff
	ds	1		; user code & disk slct
	ds	2		; dcnt
	ds	1		; searchl
	ds	2		; searcha
	ds	2		; active drives
	dw	0		; HL'
	dw	0		; DE'
	dw	0		; BC'
	dw	0		; AF'
	dw	0		; IY
	dw	0		; IX
	dw	UQCBNtwrkQI0	; HL
	dw	UQCBNtwrkQO0	; DE
	dw	BufferQ0	; BC
	dw	0		; AF, A = ntwkif console dev #
	ds	2		; scratch

NtwrkIS0:
	dw	0c7c7h,0c7c7h,0c7c7h,0c7c7h
	dw	0c7c7h,0c7c7h,0c7c7h,0c7c7h
	dw	0c7c7h,0c7c7h,0c7c7h,0c7c7h
	dw	0c7c7h,0c7c7h,0c7c7h,0c7c7h
	dw	0c7c7h,0c7c7h,0c7c7h,0c7c7h
	dw	0c7c7h,0c7c7h,0c7c7h
	dw	setup

QCBNtwrkQI0:
	ds	2		; link
	db	'NtwrkQI0'	; name
	dw	2		; msglen
	dw	1		; nmbmsgs
	ds	2		; dqph
	ds	2		; nqph
	ds	2		; msgin
	ds	2		; msgout
	ds	2		; msgcnt
	ds	2		; buffer

UQCBNtwrkQI0:
	dw	QCBNtwrkQI0	; pointer
	dw	BufferQI0Addr	; msgadr
BufferQI0Addr:
	dw	BufferQ0

QCBNtwrkQO0:
	ds	2		; link
	db	'NtwrkQO0'	; name
	dw	2		; msglen
	dw	1		; nmbmsgs
	ds	2		; dqph
	ds	2		; nqph
	ds	2		; msgin
	ds	2		; msgout
	ds	2		; msgcnt
	ds	2		; buffer

UQCBNtwrkQO0:
	dw	QCBNtwrkQO0	; pointer
	dw	BufferQO0Addr	; msgadr
BufferQO0Addr:
	ds	2

BufferQ0:
	ds	1		; FMT
	ds	1		; DID
	ds	1		; SID
	ds	1		; FNC
	ds	1		; SIZ
	ds	256		; MSG

;	Network Interface Process #1
;
	if	NmbSlvs GE 2
NtwrkIP1:
	if	NmbSlvs GE 3
	dw	NtwrkIP2	; link
	else
	dw	0		; link
	endif
	db	0		; status
	db	64		; priority
	dw	NtwrkIS1+46	; stack pointer
	db	'NtwrkIP1'	; name
	db	0		; console
	db	0ffh		; memseg
	ds	2		; b
	ds	2		; thread
	ds	2		; buff
	ds	1		; user code & disk slct
	ds	2		; dcnt
	ds	1		; searchl
	ds	2		; searcha
	ds	2		; active drives
	dw	0		; HL'
	dw	0		; DE'
	dw	0		; BC'
	dw	0		; AF'
	dw	0		; IY
	dw	0		; IX
	dw	UQCBNtwrkQI1	; HL
	dw	UQCBNtwrkQO1	; DE
	dw	BufferQ1	; BC
	dw	0100h		; AF, A = ntwkif console dev #
	ds	2		; scratch

NtwrkIS1:
	dw	0c7c7h,0c7c7h,0c7c7h,0c7c7h
	dw	0c7c7h,0c7c7h,0c7c7h,0c7c7h
	dw	0c7c7h,0c7c7h,0c7c7h,0c7c7h
	dw	0c7c7h,0c7c7h,0c7c7h,0c7c7h
	dw	0c7c7h,0c7c7h,0c7c7h,0c7c7h
	dw	0c7c7h,0c7c7h,0c7c7h
	dw	init

QCBNtwrkQI1:
	ds	2		; link
	db	'NtwrkQI1'	; name
	dw	2		; msglen
	dw	1		; nmbmsgs
	ds	2		; dqph
	ds	2		; nqph
	ds	2		; msgin
	ds	2		; msgout
	ds	2		; msgcnt
	ds	2		; buffer

UQCBNtwrkQI1:
	dw	QCBNtwrkQI1	; pointer
	dw	BufferQI1Addr	; msgadr
BufferQI1Addr:
	dw	BufferQ1

QCBNtwrkQO1:
	ds	2		; link
	db	'NtwrkQO1'	; name
	dw	2		; msglen
	dw	1		; nmbmsgs
	ds	2		; dqph
	ds	2		; nqph
	ds	2		; msgin
	ds	2		; msgout
	ds	2		; msgcnt
	ds	2		; buffer

UQCBNtwrkQO1:
	dw	QCBNtwrkQO1	; pointer
	dw	BufferQO1Addr	; msgadr
BufferQO1Addr:
	ds	2

BufferQ1:
	ds	1		; FMT
	ds	1		; DID
	ds	1		; SID
	ds	1		; FNC
	ds	1		; SIZ
	ds	256		; MSG
	endif

;	Network Interface Process #2
;
	if	NmbSlvs GE 3
NtwrkIP2:
	if	NmbSlvs GE 4
	dw	NtwrkIP3	; link
	else
	dw	0		; link
	endif
	db	0		; status
	db	64		; priority
	dw	NtwrkIS2+46	; stack pointer
	db	'NtwrkIP2'	; name
	db	0		; console
	db	0ffh		; memseg
	ds	2		; b
	ds	2		; thread
	ds	2		; buff
	ds	1		; user code & disk slct
	ds	2		; dcnt
	ds	1		; searchl
	ds	2		; searcha
	ds	2		; active drives
	dw	0		; HL'
	dw	0		; DE'
	dw	0		; BC'
	dw	0		; AF'
	dw	0		; IY
	dw	0		; IX
	dw	UQCBNtwrkQI2	; HL
	dw	UQCBNtwrkQO2	; DE
	dw	BufferQ2	; BC
	dw	0200h		; AF, A = ntwkif console dev #
	ds	2		; scratch

NtwrkIS2:
	dw	0c7c7h,0c7c7h,0c7c7h,0c7c7h
	dw	0c7c7h,0c7c7h,0c7c7h,0c7c7h
	dw	0c7c7h,0c7c7h,0c7c7h,0c7c7h
	dw	0c7c7h,0c7c7h,0c7c7h,0c7c7h
	dw	0c7c7h,0c7c7h,0c7c7h,0c7c7h
	dw	0c7c7h,0c7c7h,0c7c7h
	dw	init

QCBNtwrkQI2:
	ds	2		; link
	db	'NtwrkQI2'	; name
	dw	2		; msglen
	dw	1		; nmbmsgs
	ds	2		; dqph
	ds	2		; nqph
	ds	2		; msgin
	ds	2		; msgout
	ds	2		; msgcnt
	ds	2		; buffer

UQCBNtwrkQI2:
	dw	QCBNtwrkQI2	; pointer
	dw	BufferQI2Addr	; msgadr
BufferQI2Addr:
	dw	BufferQ2

QCBNtwrkQO2:
	ds	2		; link
	db	'NtwrkQO2'	; name
	dw	2		; msglen
	dw	1		; nmbmsgs
	ds	2		; dqph
	ds	2		; nqph
	ds	2		; msgin
	ds	2		; msgout
	ds	2		; msgcnt
	ds	2		; buffer

UQCBNtwrkQO2:
	dw	QCBNtwrkQO2	; pointer
	dw	BufferQO2Addr	; msgadr
BufferQO2Addr:
	ds	2

BufferQ2:
	ds	1		; FMT
	ds	1		; DID
	ds	1		; SID
	ds	1		; FNC
	ds	1		; SIZ
	ds	256		; MSG
	endif

;	Network Interface Process #3
;
	if	NmbSlvs GE 4
NtwrkIP3:
	dw	0		; link
	db	0		; status
	db	64		; priority
	dw	NtwrkIS3+46	; stack pointer
	db	'NtwrkIP3'	; name
	db	0		; console
	db	0ffh		; memseg
	ds	2		; b
	ds	2		; thread
	ds	2		; buff
	ds	1		; user code & disk slct
	ds	2		; dcnt
	ds	1		; searchl
	ds	2		; searcha
	ds	2		; active drives
	dw	0		; HL'
	dw	0		; DE'
	dw	0		; BC'
	dw	0		; AF'
	dw	0		; IY
	dw	0		; IX
	dw	UQCBNtwrkQI3	; HL
	dw	UQCBNtwrkQO3	; DE
	dw	BufferQ3	; BC
	dw	0300h		; AF, A = ntwkif console dev #
	ds	2		; scratch

NtwrkIS3:
	dw	0c7c7h,0c7c7h,0c7c7h,0c7c7h
	dw	0c7c7h,0c7c7h,0c7c7h,0c7c7h
	dw	0c7c7h,0c7c7h,0c7c7h,0c7c7h
	dw	0c7c7h,0c7c7h,0c7c7h,0c7c7h
	dw	0c7c7h,0c7c7h,0c7c7h,0c7c7h
	dw	0c7c7h,0c7c7h,0c7c7h
	dw	init

QCBNtwrkQI3:
	ds	2		; link
	db	'NtwrkQI3'	; name
	dw	2		; msglen
	dw	1		; nmbmsgs
	ds	2		; dqph
	ds	2		; nqph
	ds	2		; msgin
	ds	2		; msgout
	ds	2		; msgcnt
	ds	2		; buffer

UQCBNtwrkQI3:
	dw	QCBNtwrkQI3	; pointer
	dw	BufferQI3Addr	; msgadr
BufferQI3Addr:
	dw	BufferQ3

QCBNtwrkQO3:
	ds	2		; link
	db	'NtwrkQO3'	; name
	dw	2		; msglen
	dw	1		; nmbmsgs
	ds	2		; dqph
	ds	2		; nqph
	ds	2		; msgin
	ds	2		; msgout
	ds	2		; msgcnt
	ds	2		; buffer

UQCBNtwrkQO3:
	dw	QCBNtwrkQO3	; pointer
	dw	BufferQO3Addr	; msgadr
BufferQO3Addr:
	ds	2

BufferQ3:
	ds	1		; FMT
	ds	1		; DID
	ds	1		; SID
	ds	1		; FNC
	ds	1		; SIZ
	ds	256		; MSG
	endif


;  Watchdog Timer Process
;
WatchDogPD:
	if	NmbSlvs GT 1
	dw	NtwrkIP1	; link
	else
	dw	0		; link
	endif
	db	0		; status
	db	64		; priority
	dw	WatchDogSTK+46	; stack pointer
	db	'WatchDog'	; name
	db	0		; console
	db	0ffh		; memseg
	ds	2		; b
	ds	2		; thread
	ds	2		; buff
	ds	1		; user code & disk slct
	ds	2		; dcnt
	ds	1		; searchl
	ds	2		; searcha
	ds	2		; active drives
	dw	0		; HL'
	dw	0		; DE'
	dw	0		; BC'
	dw	0		; AF'
	dw	0		; IY
	dw	0		; IX
	dw	0		; HL
	dw	0		; DE
	dw	0		; BC
	dw	0		; AF
	ds	2		; scratch

WatchDogSTK:
	dw	0c7c7h,0c7c7h,0c7c7h,0c7c7h
	dw	0c7c7h,0c7c7h,0c7c7h,0c7c7h
	dw	0c7c7h,0c7c7h,0c7c7h,0c7c7h
	dw	0c7c7h,0c7c7h,0c7c7h,0c7c7h
	dw	0c7c7h,0c7c7h,0c7c7h,0c7c7h
	dw	0c7c7h,0c7c7h,0c7c7h
	dw	WatchDog

WatchDogTime:
	dw	$-$	; one-second counter

WatchDogTable:
	;	Waiting	Timeout	Start	Flag	Slave
	db	0,	0,	0,0,	0ah	; #0
	db	0,	0,	0,0,	0bh	; #1
	db	0,	0,	0,0,	0ch	; #2
	db	0,	0,	0,0,	0dh	; #3

QCBMXSXmitq:			; MX queue for slv xmiting
	ds	2		; link
	db	'MXSXmitq'	; name
	dw	0		; msglen
	dw	1		; nmbmsgs
	ds	2		; dqph
	ds	2		; nqph
	ds	2		; msgin
	ds	2		; msgout
	ds	2		; msgcnt
	ds	2		; buffer (owner PD)

UQCBMXSXmitq:
	dw	QCBMXSXmitq
;	dw	0
;	db	'MXSXmitq'

;	Master Configuration Table

configtbl:
	db	0	; Master status byte
	db	0	; Master processor ID
	db	NmbSlvs	; Maximum number of slaves supported
	db	0	; Number of logged in slaves
	dw	0	; 16 bit vector of logged in slaves
	ds	16	; Slave processor ID's
	db	'PASSWORD' ; login password

nmsg	equ	1	; number of messages buffered

;Slave0:		; storage allocated in SLAVESP
;	ds	52	; processor descriptor
;	ds	768	; stack area for reentrant slave sp

	if	NmbSlvs GE 2
Slave1:
	ds	52	; processor descriptor
	ds	768	; stack area for reentrant slave sp
	endif

	if	NmbSlvs GE 3
Slave2:
	ds	52	; processor descriptor
	ds	768	; stack area for reentrant slave sp
	endif

	if	NmbSlvs GE 4
Slave3:
	ds	52	; processor descriptor
	ds	768	; stack area for reentrant slave sp
	endif

;
; Interprocessor Electronic Mail Data Segment
;
MailBox:
	ds	2		; link
	db	'MailBoxQ'	; name
	dw	2		; msglen
	dw	1		; nmbmsgs
	ds	2		; dqph
	ds	2		; nqph
	ds	2		; msgin
	ds	2		; msgout
	ds	2		; msgcnt
	ds	2		; buffer

MailBoxUQCB:
	dw	MailBox		; pointer
	dw	MailBoxAdr	; msgadr

MailBoxAdr:
	dw	MailBoxes	; Mail Box Data Structure Adr

nmb$mail	equ	4	; # pieces mail max per slave
size$mail	equ	128	; max size per piece of mail
				;  includes two byte overhead of
				;  source ID and size

mail$buffer$size equ	nmb$mail*size$mail

Mail$boxes:
	db	nmb$mail
	db	size$mail

MstrMail:
	db	0	; Master Mail In Ptr
	db	0	; Master Mail Out Ptr
	db	0	; Master Mail Cnt
	dw	MstrMailBuffer	; Master Mail Buffer Adr

Slv0Mail:
	db	0	; Slave #0 Mail In Ptr
	db	0	; Slave #0 Mail Out Ptr
	db	0	; Slave #0 Mail Cnt
	dw	Slv0MailBuffer	; Slave #0 Mail Buffer Adr

	if	NmbSlvs GE 2
Slv1Mail:
	db	0	; Slave #1 Mail In Ptr
	db	0	; Slave #1 Mail Out Ptr
	db	0	; Slave #1 Mail Cnt
	dw	Slv1MailBuffer	; Slave #1 Mail Buffer Adr
	endif

	if	NmbSlvs GE 3
Slv2Mail:
	db	0	; Slave #2 Mail In Ptr
	db	0	; Slave #2 Mail Out Ptr
	db	0	; Slave #2 Mail Cnt
	dw	Slv2MailBuffer	; Slave #2 Mail Buffer Adr
	endif

	if	NmbSlvs GE 4
Slv3Mail:
	db	0	; Slave #3 Mail In Ptr
	db	0	; Slave #3 Mail Out Ptr
	db	0	; Slave #3 Mail Cnt
	dw	Slv3MailBuffer	; Slave #3 Mail Buffer Adr
	endif

MstrMailBuffer:
	ds	mail$buffer$size

Slv0MailBuffer:
	ds	mail$buffer$size

	if	NmbSlvs GE 2
Slv1MailBuffer:
	ds	mail$buffer$size
	endif

	if	NmbSlvs GE 3
Slv2MailBuffer:
	ds	mail$buffer$size
	endif

	if	NmbSlvs GE 4
Slv3MailBuffer:
	ds	mail$buffer$size
	endif

;	Local Data Segment
;
BinaryASCII:
	db	0ffh	; Slave #0: 0=7 bit ASCII, FF=8 bit binary
	db	0ffh	;       #1
	db	0ffh	;       #2
	db	0ffh	;       #3

Networkstatus:
	db	0	; Slave #0 network status byte
	db	0	;       #1
	db	0	;       #2
	db	0	;       #3

const:	dw	$-$
conin:	dw	$-$
conout:	dw	$-$

delaycounts:
	db	4	; Slave #0 delay between xmitd chars
	db	4	;       #1
	db	4	;	#2
	db	4	;	#3

chariotbl:
	db	2	; Slave #0 character i/o device number
	db	3	;	#1
	db	4	;	#2
	db	5	;	#3

;	Network Status Byte Equates
;
ntwrktxrdy	equ	10000000b	; ntwrk I/F ready to send msg
active		equ	00010000b	; slave logged into network
msgerr		equ	00001000b	; error in received message
ntwrk		equ	00000100b	; network alive
msgovr		equ	00000010b	; message overrun
ntwrkrxrdy	equ	00000001b	; ntwrk I/F has rcvd msg

;	BDOS and XDOS Equates
;
flagset	equ	133	; flag set
makeq	equ	134	; make queue
readq	equ	137	; read queue
writeq	equ	139	; write queue
delay	equ	141	; delay
dsptch	equ	142	; dispatch
createp	equ	144	; create process
sydatad	equ	154	; system data page address

;	General Equates
;
SOH	equ	01h	; Start of Header
STX	equ	02h	; Start of Data
ETX	equ	03h	; End of Data
EOT	equ	04h	; End of Transmission
ENQ	equ	05h	; Enquire
ACK	equ	06h	; Acknowledge
LF	equ	0ah	; Line Feed
CR	equ	0dh	; Carriage Return
NAK	equ	15h	; Negative Acknowledge


;	Utility Procedures
;
bdos:
	lhld	bdosadr
	pchl

Nibout:			; A = nibble to be transmitted in ASCII
	cpi	10
	jnc	nibatof	; jump if A-F
	adi	'0'
	mov	c,a
	jmp	Charout
nibatof:
	adi	'A'-10
	mov	c,a
	jmp	Charout

PreCharout:
	mov	a,d
	add	c
	mov	d,a	; update the checksum

Charout:		; C = byte to be transmitted
	push	b
	push	d
	push	h
	PUSH	B
	call	dly
	POP	B
	lxi	h,Charout$return
	push	h
	lxi	h,chariotbl
	mov	e,b
	mvi	d,0
	dad	d
	mov	d,m	; D = character i/o console device number
	lhld	conout
	pchl

Charout$return:
	pop	h
	pop	d
	pop	b
	ret

Nibin:		; return nibble in A register
	call	Charin
	rc
	ani	7fh
	sui	'0'
	cpi	10
	jc	Nibin$return ; must be 0-9
	adi	('0'-'A'+10) and 0ffh
	cpi	16
	jc	Nibin$return ; must be 10-15
	lda	networkstatus
	ori	msgerr
	sta	networkstatus
	mvi	a,0
	stc
	ret
Nibin$return:
	ora	a
	ret

Charin:		; return byte in A register
	push	b
	push	d
	push	h
	lxi	h,WatchDogTable-5
	lxi	d,0005h
	mov	c,b
	inr	c
tbloop:
	dad	d
	dcr	c
	jnz	tbloop
	push	h	; HL = .WDT(slave)
	mvi	m,0ffh	; WDT(slave).waiting = true
	inx	h
	mvi	m,0	; WDT(slave).timeout = false
	inx	h
	xchg
	lhld	WatchDogTime
	xchg
	di
	mov	m,e
	inx	h
	mov	m,d	; WDT(slave).startime = WatchDogTime
	ei
	lxi	h,Charin$return
	push	h
	lxi	h,chariotbl
	mov	e,b
	mvi	d,0
	dad	d
	mov	d,m	; D = character i/o console device number
	lhld	conin
	pchl

Charin$return:
	pop	h	; HL = .WDT(slave)
	mvi	m,0	; WDT(slave).waiting = false
	inx	h
	mov	b,a
	mov	a,m
	ral		; Carry set if WDT(slave).timeout true
	mov	a,b
	mvi	m,0	; WDT(slave).timeout = false
	pop	h
	pop	d
	pop	b
	ret		; return with carry set if timed out

Netout:	; C = byte to be transmitted
	mov	a,d
	add	c
	mov	d,a
	lda	BinaryASCII
	ora	a
	jnz	Charout	; transmit byte in Binary mode
	mov	a,c
	push	psw
	rar
	rar
	rar
	rar
	ani	0FH	; mask HO nibble to LO nibble
	call	Nibout
	pop	psw
	ani	0FH
	jmp	Nibout

Netin:		; byte returned in A register
		; D  = checksum accumulator
	lda	BinaryASCII
	ora	a
	jz	ASCIIin
	call	charin	;receive byte in Binary mode
	rc
	jmp	chksin
ASCIIin:
	call	Nibin
	rc
	add	a
	add	a
	add	a
	add	a
	push	psw
	call	Nibin
	rc
	xthl
	ora	h
	pop	h
chksin:
	ora	a
	push	psw
	add	d	; add & update checksum accum.
	mov	d,a
	pop	psw
	ret

Msgin:		; HL = destination address
		; E  = # bytes to input
	call	Netin
	rc
	mov	m,a
	inx	h
	dcr	e
	jnz	Msgin
	ret

Msgout:	; HL = source address
	; E  = # bytes to output
	; D  = checksum
	; C  = preamble character
	mvi	d,0
	call	PreCharout
Msgoutloop:
	mov	c,m
	inx	h
	call	Netout
	dcr	e
	jnz	Msgoutloop
	ret

;	Network Initialization
nwinit:
;	device initialization, as required
	lhld	0001h
	inx	h
	mov	e,m
	inx	h
	mov	d,m
	lxi	h,0003h
	xchg
	dad	d
	shld	const
	dad	d
	shld	conin
	dad	d
	shld	conout
	xra	a		;return code is 0=success
	ret


;	Network Status
nwstat:		; C = Slave #
	mvi	b,0
	lxi	h,networkstatus
	dad	b
	mov	a,m
	mov	b,a
	ani	not (msgerr+msgovr)
	mov	m,a
	mov	a,b
	ret


;	Return Configuration Table Address
cfgadr:
	lxi	h,configtbl
	ret


;	Send Message on Network
sndmsg:			; DE = message addr
			;  C = Slave #
	mov	b,c
send:
	xchg
	push	h
	mvi	c,ENQ
	call	Charout	; send ENQ
	call	getACK
	mvi	e,5
	mvi	c,SOH
	call	Msgout	; send SOH FMT DID SID FNC SIZ
	xra	a
	sub	d
	mov	c,a
	call	Netout	; send HCS (header checksum)
	call	getACK
	dcx	h
	mov	e,m
	inx	h
	inr	e
	mvi	c,STX
	call	Msgout	; send STX DB0 DB1 ...
	mvi	c,ETX
	call	PreCharout	; send ETX
	xra	a
	sub	d
	mov	c,a
	call	Netout	; send CKS
	mvi	c,EOT
	call	PreCharout	; send EOT
	call	getACK
	pop	d
	ret

getACK:
	call	Charin
	jc	getACK$timeout
	ani	7fh
	sui	ACK
	rz
getACK$timeout:
	pop	d	; discard return address
	pop	d	; DE = message address
	jmp	send

;	Receive Message from Network
rcvmsg:			; DE = message addr
			;  C = Slave #
	mov	b,c
receive:
	xchg
	push	h
	call	get$ENQ
	; a return to this point indicates an error
receive$retry:
	push	b
	call	release$MX
	pop	b
	pop	d
	jmp	receive

get$ENQ:
	call	Charin
	jc	get$ENQ
	ani	7fh
	cpi	ENQ	; Start of Header ?
	jnz	get$ENQ
	;get the slave xmit MX message before allowing slv to xmit
	push	b
	push	h
	mvi	c,readq
	lxi	d,UQCBMXSXmitq
	call	bdos
	pop	h
	pop	b
	mvi	c,ACK
	call	charout	; send ACK to slave, allows it to xmit
	call	Charin
	rc
	ani	7fh
	cpi	SOH
	rnz
	mov	d,a	; initialize the HCS
	mvi	e,5
	call	Msgin
	cnc	Netin
	rc
	mov	a,d
	ora	a
	jnz	sendNAK
	mvi	c,ACK
	call	Charout
	call	Charin
	rc
	ani	7fh
	cpi	STX
	rnz
	mov	d,a	; initialize the CKS
	dcx	h
	mov	e,m
	inx	h
	inr	e
	call	msgin
	cnc	Charin
	rc
	ani	7fh
	cpi	ETX
	rnz
	add	d
	mov	d,a
	call	Netin	; get Checksum byte
	rc
	mov	a,d
	ora	a	; should be zero
	jz	sendACK
sendNAK:
	mvi	c,NAK
	jmp	Charout	; & return to receive$retry

sendACK:
	call	Charin	; get EOT
	rc
	ani	7fh
	cpi	EOT
	rnz
	mvi	c,ACK
	call	Charout  ; send ACK if checksum ok
	pop	d	; discard return address
	pop	d	; discard message address

release$MX:
	;send back slv xmit MX message
	mvi	c,writeq
	lxi	d,UQCBMXSXmitq
	call	bdos
	xra	a
	ret

dly:	;dly for dlycounts(Slave #) * 0.5 milliseconds
	lxi	h,delaycounts
	mov	e,b
	mvi	d,0
	dad	d
	mov	a,m
dly1:
	mvi	c,86h	; 4MHz constant
dly2:
	dcr	c
	jnz	dly2
	dcr	a
	jnz	dly1
	ret

restore:
	di
	pop	h
	shld	rtnadr
	pop	h
	pop	d
	pop	b
	pop	psw
	push	psw
	push	b
	push	d
	push	h
	push	h
	lhld	rtnadr
	xthl
	ei
	ret
rtnadr:	ds	2

;
;  WatchDog Timer Process
;
WatchDog:
	mvi	c,Delay
	lxi	d,60	; dly for 1 second
	call	bdos
	lhld	WatchDogTime
	inx	h
	shld	WatchDogTime
	lxi	h,WatchDogTable-5
	mvi	c,NmbSlvs
WatchDogLoop:
	lxi	d,0005h
	dad	d
	mov	a,m
	ora	a
	jz	WatchDogDec
	inx	h
	ana	m
	dcx	h
	jnz	WatchDogDec	; waiting & timeout set
	push	h		; save HL -> WDT.waiting
	inx	h
	inx	h
	di
	mov	e,m
	inx	h
	mov	d,m
	ei
	lhld	WatchDogTime
	mov	a,l
	sub	e
	mov	l,a
	mov	a,h
	sbb	d
	mov	h,a
	mvi	a,5	; # seconds since started Charinn
	sub	l
	mvi	a,0
	sbb	h
	pop	h
	jnc	WatchDogDec
	push	h
	inx	h
	mvi	m,0ffh	; WDT.timeout = 0ffh
	inx	h
	inx	h
	inx	h
	push	b
	mov	e,m	; E = Flag #
	mvi	c,Flagset
	call	bdos
	pop	b
	pop	h

WatchDogDec:
	dcr	c
	jnz	WatchDogLoop

	jmp	WatchDog

;
;	Setup code for Network Interface Procedures
;
Setup:
	push	psw
	push	b
	push	d
	push	h
	call	nwinit
	mvi	c,makeq
	lxi	d,QCBMXSXmitq
	call	bdos
	mvi	c,writeq
	lxi	d,UQCBMXSXmitq
	call	bdos
	mvi	c,makeq
	lxi	d,MailBox
	call	bdos
	mvi	c,writeq
	lxi	d,MailBoxUQCB
	call	bdos
	lxi	d,WatchDogPD
	mvi	c,createp
	call	bdos
	mvi	c,dsptch
	call	bdos
	mvi	c,sydatad
	call	bdos
	lxi	d,9
	dad	d
	lxi	d,configtbl
	mov	m,e
	inx	h
	mov	m,d	; sysdatpage(9&10) = co.configtbl
	pop	h
	pop	d
	pop	b
	pop	psw
;
;  Network Interface Reentrant Procedure
;
Init:
	push	psw	; A = network i/f console dev #
	push	B	; BC= buffer address
	push	D	; DE= UQCB ntwrk queue out
	push	H	; HL= UQCB ntwrk queue in
	mov	e,m
	inx	h
	mov	d,m
	mvi	c,makeq
	call	bdos	; make the ntwrk queue in
	call	restore
	xchg
	mov	e,m
	inx	h
	mov	d,m
	mvi	c,makeq
	call	bdos	; make the ntwrk queue out

Loop:
	call	restore
	mov	d,b
	mov	e,c
	mov	c,a
	call	rcvmsg

	call	restore
	xchg
	mvi	c,writeq
	call	bdos

	call	restore
	mvi	c,readq
	call	bdos

	call	restore
	mov	d,b
	mov	e,c
	mov	c,a
	call	sndmsg

	jmp	Loop

	end
