/*	WINDOW.C	9/08/83-11/26/83	LEE JAY LORENZEN	*/

/*  Modified 7/10/84 							*/
/*    Change window numbers from (0-3) to (1-4)				*/


/*** INCLUDE FILES ******************************************************/

#include <portab.h>
#include <fields.h>


/*** DEFINES ***********************************************************/

#define toupper(x) ( ((x < 'a') || (x > 'z')) ? (x) : (x - 'a' + 'A') )
#define isdigit(x) ( ((x < '0') || (x > '9')) ? FALSE : TRUE )
#define P_TERMCPM 0x00
#define VC_GET 0x99
#define C_WRITESTR 0x09

#define NUM_VC 4
#define NUM_FLDS 13
#define NUM_CMDS 5
#define NUM_COLORS 8
#define NUM_HELPLINES 12

#define ERROR 0
#define VIEW 1
#define CHANGE 2
#define TOP 3
#define FULL 4
#define WRITE 5

#define VS_TOP_LEFT 2
#define VS_WIN_SIZE 12
#define VS_CRT_SEG 24
#define VS_ATTRIB 28
#define VS_CUR_TRACK 30

#define IO_NEW_WINDOW 0x14
#define IO_CURSOR_VIEW 0x15


/*** STRUCTURES DECLARATIONS ******************************************/

struct window
{
	BYTE		w_vc;
	BYTE		w_prow;
	BYTE		w_pcol;
	BYTE		w_nrow;
	BYTE		w_ncol;
	BYTE		w_vrow;
	BYTE		w_vcol;
	BYTE		w_fgnd;
	BYTE		w_bgnd;
	BYTE		w_ctrk;
	BYTE		w_disp;
};


/*** EXTERNAL FUNCTION DECLARATIONS ***********************************/

EXTERN VOID PD_KEEP();				/* in PDKEEP.A86	*/

EXTERN VOID WM_PK();				/* in WWCALL.A86	*/
EXTERN VOID WM_CALL();
EXTERN VOID IO_CALL();

EXTERN VOID wm_color();				/* in WMCOLOR.C		*/

EXTERN WORD wm_write();				/* in WMWRITE.C		*/

EXTERN WORD wrap();				/* in WMUTIL.C		*/
EXTERN WORD between();
EXTERN VOID d2_format();
EXTERN VOID wm_nrnc();
EXTERN VOID wm_vrvc();
EXTERN WORD version_chk();
EXTERN VOID copy_bytes();
EXTERN VOID dz2_format();
EXTERN VOID format_fld();
EXTERN VOID wm_sync();

EXTERN VOID wm_full();				/* in WMFTD.C		*/
EXTERN WORD wm_top();
EXTERN WORD wm_display();


/*** GLOBAL VARIABLES *************************************************/

BYTE	*plines[] =
{
"Number PRow PCol NRows NCols VRow VCol Tracking Display FGColor BGColor\r\n$",
"------ ---- ---- ----- ----- ---- ---- -------- ------- ------- -------\r\n$",
"  x     xx   xx   xx    xx    xx   xx     xxx    xxxxx  xxxxxxx xxxxxxx\r\n$"
};


BYTE	fld_pos[] =
{
	2,8,13,18,24,30,35,42,49,56,64
};


BYTE	*pmessages[] =
{
	"WINDOW requires Concurrent CP/M system that supports windows.\r\n$",
	"Filename requested is not an acceptable filename.\r\n$",
	"Error writing file, check disk.\r\n$",
	"COPYRIGHT (C) 1983, DIGITAL RESEARCH INC., 12/07/83"
};


BYTE	*perrors[] =
{
	"No window sub-command given.\r\n$",
	"Not a valid window sub-command.\r\n$",
	"Sub-command requires NUMBER=<1-4>\r\n$",
	"WINDOW WRITE command requires TYPE=<Window, Console, or Setup>\r\n$",
	"WINDOW WRITE command requires FILE=<filename>\r\n$",
	"Could not interpret parameters in WINDOW CHANGE command.\r\n$",
	"Not allowed to change NUMBER field.\r\n$",
	"The range of acceptable values for PROW is 1 to 24.\r\n$",
	"The range of acceptable values for PCOL is 1 to 80.\r\n$",
	"The range of acceptable values for NROW is 1 to 24.\r\n$",
	"The range of acceptable values for NCOL is 1 to 80.\r\n$",
	"The range of acceptable values for VROW is 1 to 24.\r\n$",
	"The range of acceptable values for VCOL is 1 to 80.\r\n$",
	"The acceptable values for TRACKING are NO and ROW\r\n.$",
	"The acceptable values for DISPLAY are B&W and COLOR\r\n.$",
	"The acceptable values for FGCOLOR are:\r\n$",
	"The acceptable values for BGCOLOR are:\r\n$",
	"  White, Yellow, Magenta, Red, Cyan, Green, Blue, and Black.\r\n$"
};

BYTE	*phelp[] =
{
	"Valid window commands are:\r\n$",
	"  WINDOW VIEW\r\n$",
	"  WINDOW TOP N=<1-4>\r\n$",
	"  WINDOW FULL N=<1-4>\r\n$",
	"  WINDOW WRITE N=<1-4> Type=<Window, Console, or Setup>,File=<filename>\r\n$",
	"  WINDOW CHANGE N=<1-4> PRow=<1-24>,PCol=<1-80>\r\n$",
        "  WINDOW CHANGE N=<1-4> NRows=<1-24>,NCols=<1-80>\r\n$",
        "  WINDOW CHANGE N=<1-4> VRow=<1-24>,VCol=<1-80>\r\n$",
        "  WINDOW CHANGE N=<1-4> Tracking=<No or Row>,Display=<B&W or Color>\r\n$",
        "  WINDOW CHANGE N=<1-4> FGColor=<color>,BGColor=<color>\r\n$",
        "    <color> = <White,Yellow,Magenta,Red,Cyan,Green,Blue,Black>\r\n$",
	"Abbreviations are allowed.\r\n$"
};


BYTE	*pcmds[] =
{
	"V*IEW",
	"C*HANGE",
	"T*OP",
	"F*ULL",
	"W*RITE"
};


BYTE	*pflds[] =
{
	"N*UMBER",
	"PR*OW",
	"PC*OL",
	"NR*OWS", 
	"NC*OLS",
	"VR*OW",
	"VC*OL",
	"TR*ACKING",
	"D*ISPLAY",
	"F*GCOLOR", 
	"B*GCOLOR",
	"TY*PE",
	"FI*LENAME"
};


BYTE	*pmcolors[] =
{
	"BLA*CK",
	"BLU*E",
	"G*REEN",
	"C*YAN",
	"R*ED",
	"M*AGENTA",
	"Y*ELLOW",
	"W*HITE"
};


/*** SUB FUNCTIONS *******************************************************/



/*** NEXT_TOKEN routine ****************************************************/

	VOID
next_token(pstring, ppbeg, ppend)
	BYTE		*pstring;
	BYTE		**ppbeg;
	BYTE		**ppend;
{

						/* skip over leading	*/
						/*   white space	*/
	while ( ( *pstring == 0x09 ) || 
		( *pstring == ' ' )  ||
		( *pstring == ',' )  )
	    pstring++;
						/* return beg pointer	*/
	*ppbeg = pstring;
						/* if single character	*/
						/*   delimiter then	*/
						/*   scan past it and	*/
						/*   return		*/
	if ( ( *pstring == '=' ) ||
	     ( *pstring == ',' )   )
	{
	  pstring++;
	  *ppend = pstring;
	  return;
	}
						/* look for white space	*/
						/*   character or 	*/
						/*   delimiter	 	*/
	while ( ( *pstring != 0x09 ) &&
		( *pstring != ' ' ) &&
		( *pstring != '=' ) &&
		( *pstring != ',' ) &&
		( *pstring != NULL )   )
	  pstring++;
						/* return end pointer	*/
	*ppend = pstring;
						/* get out of here	*/
	return;
}


/*** ASTERISK_MATCH *****************************************************/

	WORD
asterisk_match(p1temp, p2temp)
	BYTE		*p1temp;
	BYTE		*p2temp;
{
	WORD		match_made;
	WORD		match_possible;
	WORD		match_found;

	match_found = FALSE;
	match_made = FALSE;
	match_possible = TRUE;
	while ( ( !match_found )  &&
		( match_possible )    )
	{
	  if ( *p2temp == '*' )
	  {
	    match_made = TRUE;
	    p2temp++;
	  }
	  if ( ( *p1temp == NULL ) ||
	       ( *p2temp == NULL )   )
	  {
	    match_found = match_made;
	    match_possible = match_made;
	  }
	  else
	    match_possible = ( *p1temp++ == *p2temp++ );
	}  /* while */

	return(match_found);
}


/*** GET_FEQV routine **************************************************/

	BYTE
*get_feqv(pcmdtail, perror, pfld, ppvalue)
	BYTE		*pcmdtail;
	WORD		*perror;
	WORD		*pfld;
	BYTE		**ppvalue;
{
	WORD		i;
	BYTE		*pbeg;
	BYTE		*pend;
	WORD		match;
	BYTE		save_byte;
						/* init error to no	*/
						/*   error condition	*/
	*perror = 0;
						/* get first token	*/
	next_token(pcmdtail, &pbeg, &pend);
						/* Is it a field?	*/ 
	save_byte = *pend;
	*pend = NULL;
	match = FALSE;
	for (i=0; (i<NUM_FLDS) && (!match); i++)
	  match = asterisk_match(pbeg, pflds[i]);
	*pend = save_byte;
						/* If field is found,	*/
						/*   look for equal	*/
						/*   sign		*/
	if ( match )
	{
	  *pfld = i - 1;
	  next_token(pend, &pbeg, &pend);
	  if ( *pbeg == '=' )
	  {
						/* If '=' is found,	*/
						/*   look for value	*/
	    next_token(pend, &pbeg, &pend);
	    if ( *pbeg != NULL )
	    {
	      *ppvalue = pbeg;
	      if ( *pend != NULL )
	      {
	        *pend = NULL;
	        pend++;
	      }
	    }
	    else
	      *perror = 3;
	  }
	  else
	    *perror = 2;
	}
	else
	  *perror = 1;

	return(pend);
}


/*** GET_NUMBER routine **************************************************/

	BYTE
*get_number(pcmdtail, perror, pnumber)
	BYTE		*pcmdtail;
	WORD		*perror;
	WORD		*pnumber;
{
	WORD		fld;
	BYTE		*pvalue;


	pcmdtail = get_feqv(pcmdtail, perror, &fld, &pvalue);

	if ( *perror == 0 )
	{
	  if ( fld == NUMBER )
	  {
	    if ( ( *pvalue >= '1' ) &&
	         ( *pvalue <= '4' )   )
	    {
	      *pnumber = *pvalue - '1';
	      return(pcmdtail);
	    }
	  } 
	}

	*perror = 2;
	return(pcmdtail);
}


/*** DO_ERROR routine ******************************************************/

	VOID
do_error(err_num)
	WORD		err_num;
{
	WORD		i;

	__BDOS(C_WRITESTR, perrors[err_num]);

	if ( err_num == 0 )
	{
	  for (i=0; i<NUM_HELPLINES; i++)
	    __BDOS(C_WRITESTR, phelp[i]);
	}

	if ( ( err_num == (FGCOLOR + 6) ) ||
	     ( err_num == (BGCOLOR + 6) )   )
	{
	  __BDOS(C_WRITESTR, perrors[BGCOLOR + 7]);
	} 

	return;
}


/*** DO_VIEW routine ******************************************************/

	VOID
do_view()
{
	WORD		i,j;
	BYTE		poutline[83];
						/* print heading lines	*/
	__BDOS(C_WRITESTR, plines[0]);
	__BDOS(C_WRITESTR, plines[1]);
						/* init data line	*/
	copy_bytes(poutline, plines[2], strlen(plines[2]) +1);
						/* build and print out	*/
						/*   data lines		*/
	for (i=0; i<NUM_VC; i++)
	{
	  for (j=0; j<NUM_FLDS; j++)
	    format_fld(i, j, fld_pos[j], poutline);
	  __BDOS(C_WRITESTR, poutline);
	}

	return;
}



/*** INput 2 Decimal Digits routine **************************************/

	BYTE
in2d(pstring)
	BYTE		*pstring;
{
	BYTE		digit1;
	BYTE		digit2;
	BYTE		total;

	digit1 = *pstring++;
	digit2 = *pstring++;
	total = 0;
	if ( isdigit(digit1) )
	{
	  if ( isdigit(digit2) )
	    total = ((digit1 - '0') * 10) + (digit2 - '0');
	  else
	    total = (digit1 - '0');
	}
	return(total);
}


/*** INput COLOR routine **************************************************/

	BYTE
incolor(pstring)
	BYTE		*pstring;
{
	WORD		i;
	BYTE		color;
	WORD		match_found;

	color = 0;
	match_found = FALSE;

	for (i=0; (i<NUM_COLORS) && (!match_found); i++)
	  match_found = asterisk_match(pstring, pmcolors[i]);

	if ( match_found )
	  color = i;

	return(color);
}


/*** INITialize window VALUE routine **************************************/

	VOID
init_value(vc, pw)
	BYTE		vc;
	struct	window	*pw;
{
	WORD		value;
	WORD		r,c;

	pw->w_vc = vc;

	WM_PK(0, vc, VS_TOP_LEFT, &value);
	pw->w_prow = ((value & 0xff00) >> 8) + 1;
	pw->w_pcol = (value & 0x00ff) + 1;

	wm_nrnc(vc, &r, &c);
	pw->w_nrow = r;
	pw->w_ncol = c;

	wm_vrvc(vc, &r, &c);
	pw->w_vrow = r;
	pw->w_vcol = c;

	WM_PK(0, vc, VS_CUR_TRACK, &value);
	pw->w_ctrk = value & 0x0001;

	WM_PK(0, vc, VS_CRT_SEG, &value);
	pw->w_disp = (value == 0xb000) ? 0 : 1;

	WM_PK(0, vc, VS_ATTRIB, &value);
	pw->w_fgnd = value & 0x0007;
	pw->w_bgnd = (value & 0x0070) >> 4;

	return; 
}


/*** STORE window VALUE routine **************************************/

	WORD
store_value(pw, fld, pvalue)
	struct	window	*pw;
	WORD		fld;
	BYTE		*pvalue;
{
	WORD		error;
	WORD		value;

	error = 0;
	value = in2d(pvalue);
	switch (fld)
	{
	  case NUMBER:				/* Number		*/
		error = 1;
		break;
	  case PROW:				/* Physical Row		*/
		if ( ( value >= 1 ) &&
		     ( value <= 24 )  )
		  pw->w_prow = value;
		else
		  error = 1;
		break;
	  case PCOL:				/* Physical Column	*/
		if ( ( value >= 1 ) &&
		     ( value <= 80 )  )
		  pw->w_pcol = value;
		else
		  error = 1;
		break;
	  case NROWS:				/* Number of Rows	*/
		if ( ( value >= 1 ) &&
		     ( value <= 24 )  )
		  pw->w_nrow = value;
		else
		  error = 1;
		break;
	  case NCOLS:				/* Number of Columns	*/
		if ( ( value >= 1 ) &&
		     ( value <= 80 )  )
		  pw->w_ncol = value;
		else
		  error = 1;
		break;
	  case VROW:				/* Virtual Row		*/
		if ( ( value >= 1 ) &&
		     ( value <= 24 )  )
		  pw->w_vrow = value;
		else
		  error = 1;
		break;
	  case VCOL:				/* Virtual Column	*/
		if ( ( value >= 1 ) &&
		     ( value <= 80 )  )
		  pw->w_vcol = value;
		else
		  error = 1;
		break;
	  case TRACKING:			/* Tracking Style	*/
		if ( asterisk_match(pvalue, "N*O") )
		  pw->w_ctrk = 0;
		else
		{
		  if ( asterisk_match(pvalue, "R*OW") )
		    pw->w_ctrk = 1;
		  else
		    error = 1;
		}
		break;
	  case DISPLAY:				/* Display to use	*/
		if ( asterisk_match(pvalue, "B*&W") )
		  pw->w_disp = 0;
		else
		{
		  if ( asterisk_match(pvalue, "C*OLOR") )
		    pw->w_disp = 1;
		  else
		    error = 1;
		}
		break;
	  case FGCOLOR:				/* Foreground Color	*/
		value = incolor(pvalue);
		if ( ( value >= 1 ) &&
		     ( value <= NUM_COLORS )  )
		  pw->w_fgnd = value - 1;
		else
		  error = 1;
		break;
	  case BGCOLOR:				/* Background Color	*/
		value = incolor(pvalue);
		if ( ( value >= 1 ) &&
		     ( value <= NUM_COLORS )  )
		  pw->w_bgnd = value - 1;
		else
		  error = 1;
		break;
	} /* switch */

	error = (error == 0) ? 0 : (6 + fld);
	return(error);
}


/*** CHANGE window VALUE routine **************************************/

	VOID
change_value(pw)
	struct	window	*pw;
{
	WORD		value;
	WORD		vc;
	WORD		r,c;
	WORD		ax,bx,cx,dx;

	vc = pw->w_vc;
						/* make sure windows are*/
						/*   in sync		*/
	wm_sync(vc);
						/* get top left into cx	*/
	r = between(1, pw->w_prow, 24);
	c = between(1, pw->w_pcol, 80);
	cx = ((r - 1) << 8) + (c - 1);
						/* get bottom right	*/
						/*   into bx		*/
	r = between(1, pw->w_prow + pw->w_nrow - 1, 24);
	c = between(1, pw->w_pcol + pw->w_ncol - 1, 80);
	bx = ((r - 1) << 8) + (c - 1);
 						/* set new window size	*/
	ax = IO_NEW_WINDOW;
	dx = vc;
	IO_CALL(&ax, &bx, &cx, &dx);
						/* poke window size	*/
	r = between(1, pw->w_nrow, 24);
	c = between(1, pw->w_ncol, 80);
	value = (r << 8) + c;
	WM_PK(1, vc, VS_WIN_SIZE, &value);
						/* set view point and	*/
						/*   cursor tracking	*/
	ax = IO_CURSOR_VIEW;
	dx = pw->w_ctrk;
	dx = ( dx << 8 ) + vc;
	r = between(1, pw->w_vrow, 24);
	c = between(1, pw->w_vcol, 80);
	cx = ((r-1) << 8) + (c - 1);
	IO_CALL(&ax, &bx, &cx, &dx);
						/* set foreground and	*/
						/*   background colors	*/
	wm_color(vc, 0, pw->w_fgnd);
	wm_color(vc, 1, pw->w_bgnd);
						/* set display type	*/
	wm_display(vc, pw->w_disp);
						/* get out of here	*/
	return;
}


/*** DO_CHANGE routine ******************************************************/

	VOID
do_change(pcmdtail)
	BYTE		*pcmdtail;
{
	WORD		error;
	WORD		vc;
	WORD		fld;
	struct window	w_values;
	BYTE		*pvalue;
						/* get the number of 	*/
						/*   window to change	*/
	pcmdtail = get_number(pcmdtail, &error, &vc);
						/* handle error case	*/
	if ( error != 0 )
	{
	  do_error(error);
	  return;
	}
						/* initialize the 	*/
						/*   window structure	*/
						/*   that will hold	*/
						/*   requested changes	*/
	init_value(vc, &w_values);
						/* if empty tail then	*/
						/*   error else okay	*/
	if ( pcmdtail == NULL )
	  error = 1;
	else
	  error = 0;
						/* as long as there is	*/
						/*   any tail left, look*/
						/*   for and store	*/
						/*   field = value	*/
						/*   combinations	*/
	while ( ( *pcmdtail != NULL ) &&
		( error == 0 )	  )
	{
	  pcmdtail = get_feqv(pcmdtail, &error, &fld, &pvalue);
	  if (error == 0)
	    error = store_value(&w_values, fld, pvalue);
	  else
	    error = ( error == 0 ) ? 0 : 5;
	}
						/* if there were no	*/
						/*   errors then do the	*/
						/*   changes specified	*/
	if ( error == 0 )
	  change_value(&w_values);
	else
	  do_error(error);

	return;
}


/*** DO_TOP routine ******************************************************/

	VOID
do_top(pcmdtail)
	BYTE		*pcmdtail;
{
	WORD		ret;
	WORD		error;
	WORD		vc;
	WORD		ax,bx,cx,dx;
	WORD		imhere,nvc,top;

	pcmdtail = get_number(pcmdtail, &error, &vc);
	if ( error == 0 )
	  ret = wm_top(vc);
	else
	  do_error(error);
	return;
}


/*** DO_FULL routine ******************************************************/

	VOID
do_full(pcmdtail)
	BYTE		*pcmdtail;
{
	WORD		error;
	WORD		vc;

	pcmdtail = get_number(pcmdtail, &error, &vc);
	if ( error == 0 )
	  wm_full(vc);
	else
	  do_error(error);
	return;
}


/*** DO_WRITE routine ******************************************************/

	VOID
do_write(pcmdtail)
	BYTE		*pcmdtail;
{
	WORD		ret;
	WORD		error;
	WORD		vc;
	WORD		fld;
	BYTE		*pvalue;
	WORD		window;
	WORD		console;
	WORD		setup;
	BYTE		save_byte;

	pcmdtail = get_number(pcmdtail, &error, &vc);
	if ( error == 0 )
	{
	  pcmdtail = get_feqv(pcmdtail, &error, &fld, &pvalue);
	  if ( ( error == 0 ) && 
	       ( fld == TYPE )  )
	  {
	     save_byte = *pcmdtail;
	     *pcmdtail = NULL;
	     window = asterisk_match(pvalue, "W*INDOW");
	     console = asterisk_match(pvalue, "C*ONSOLE");
	     setup = asterisk_match(pvalue, "S*ETUP");
	     *pcmdtail = save_byte;
	     if ( ( window ) ||
		  ( console ) ||
		  ( setup )     )
	     {
	       pcmdtail = get_feqv(pcmdtail, &error, &fld, &pvalue);
	       if ( ( error == 0 ) && 
		     ( fld == FILENAME) )
	       {
		 *pcmdtail = NULL;
						/* do the write		*/
		 if ( window )
		   ret = wm_write(0, vc, pvalue);
		 if ( console )
		   ret = wm_write(1, vc, pvalue);
		 if ( setup )
		   ret = wm_write(2, vc, pvalue);
						/* handle file error	*/
		 if ( ret != 0 )
	         {
		    if ( ret == 0x01 )
		      __BDOS(C_WRITESTR, pmessages[1]);
		    else
		      __BDOS(C_WRITESTR, pmessages[2]);		
		 } 
	       }
	       else
	         do_error(4);	
	     }
	     else
	       do_error(3);
	  }
	  else
            do_error(3);
	}
	else
	  do_error(2);
	return;
}


/*** PARSE_SUB command routine *********************************************/

	BYTE
*parse_sub(pcmdtail, psub_command)
	BYTE		*pcmdtail;
	WORD		*psub_command;
{
	WORD		i;
	BYTE		*pbeg;
	BYTE		*pend;
	BYTE		save_byte;
	WORD		match_found;

						/* get pointers to beg	*/
						/*   and ends of token	*/
	next_token(pcmdtail, &pbeg, &pend);
						/* make sure end byte	*/
						/*   is null		*/
	save_byte = *pend;
	*pend = NULL;
						/* make sub_command	*/
						/*   equal error cond.	*/
	*psub_command = ERROR;
						/* see if token is one	*/
						/*   of the commands	*/
	if ( *pbeg != NULL )
	{
	  match_found = FALSE;

	  for (i=0; (i<NUM_CMDS) && (!match_found); i++)
	    match_found = asterisk_match(pbeg, pcmds[i]);

	  if ( match_found )
	    *psub_command = i;
	}
						/* restore end byte	*/
	*pend = save_byte;
						/* return pointer to	*/
						/*   end of token	*/
	return(pend);
}


/*** MAIN FUNCTION ******************************************************/

main()
{
	WORD		ret;
	WORD		i;
	BYTE		*pcmdtail;
	BYTE		sub_command;
	WORD		length;
						/* do OS version check	*/
	ret = version_chk();
						/* handle error case if	*/
						/*   wrong version	*/
	if ( !ret )
	{
	  __BDOS(C_WRITESTR, pmessages[0]);
	  return;
	};
						/* get command tail	*/
						/*   from default dma	*/
						/*   buffer in basepage	*/
	pcmdtail = 0x0080;
	length = *pcmdtail++;
	for (i=0; i<length; i++)
	{
	  if ( *pcmdtail == NULL )
	    *pcmdtail = ' ';
	  else
	    *pcmdtail = toupper(*pcmdtail);
	  pcmdtail++;
	}
	*pcmdtail = NULL;
	pcmdtail = 0x0081;
						/* see if null command	*/
						/*   tail		*/
	if ( *pcmdtail == NULL )
	{
	  do_error(0);
	  return;
	}
						/* parse sub-command	*/
	pcmdtail = parse_sub(pcmdtail, &sub_command);
						/* set keep flag so we	*/
						/*   don't get aborted	*/
						/*   while we own the	*/
						/*   internal vc mx	*/
						/*   semaphore		*/
	PD_KEEP(1);
						/* do appropriate	*/
						/*   routine		*/
	switch ( sub_command )
	{
	  case ERROR:
		do_error(1);
		break;
	  case VIEW:
		do_view();
		break;
	  case CHANGE:
		do_change(pcmdtail);
		break;
	  case TOP:
		do_top(pcmdtail);
		break;
	  case FULL:
		do_full(pcmdtail);
		break;
	  case WRITE:
		do_write(pcmdtail);
		break;
	}  /* switch */
						/* reset my keep flag	*/
	PD_KEEP(0);
}


/*** _MAIN routine *******************************************************/

_main()
{
						/* this minimizes which	*/
						/*   part of the run-	*/
						/*   time library is	*/
						/*   linked in		*/
	main();
	__BDOS(P_TERMCPM, 0);
}

                                                                                                                                                                                                         