/*	WMWRITE.C	09/08/83-10/28/83	LEE JAY LORENZEN	*/

/*** INCLUDE FILES ******************************************************/

#include <portab.h>
#include <caparm.h>


/*** DEFINES ***********************************************************/

#define CR 0x0d

#define NUM_VC 4
#define NUM_FLDS 13

#define F_DMAOFF 0x1a
#define F_DMASEG 0x33
#define F_ERRMODE 0x2d
#define F_PARSE 0x98
#define F_MAKE 0x16
#define F_OPEN 0x0f
#define F_CLOSE 0x10
#define F_WRITE 0x15
#define F_DELETE 0x13
#define F_MULTISEC 0x2c

#define ERR_PARSE 0x01
#define ERR_MAKE 0x02
#define ERR_WRITE 0x03
#define ERR_CLOSE 0x04

#define BUFF_SIZE 2048				/* plenty of room for	*/
						/*   whole console plus	*/
						/*   24 crlf's		*/

#define VS_VC_SEG 22


/*** STRUCTURES DECLARATIONS ******************************************/

struct pf
{
	BYTE		*pf_pfilename;
	BYTE		*pf_pfcb;
};


/*** EXTERNAL FUNCTION DECLARATIONS ***********************************/

EXTERN VOID GENCOPY();				/* in WMCA.A86		*/
EXTERN VOID GENALT();

EXTERN VOID WM_PK();				/* in WWCALL.A86	*/
EXTERN VOID WM_CALL();
EXTERN VOID IO_CALL();
EXTERN VOID WM_MXQ();

EXTERN WORD wm_nrnc();				/* in WMUTIL.C		*/
EXTERN VOID wm_vrvc();
EXTERN VOID wm_sync();
EXTERN VOID copy_bytes();
EXTERN VOID dz2_format();
EXTERN VOID format_fld();


/*** GLOBAL VARIABLES ***************************************************/

GLOBAL BYTE	vc_buffer[BUFF_SIZE];		/* room for 24 crlf's	*/


BYTE	*pwline[] =
{
"window ch n=x pr=xx,pc=xx,nr=xx,nc=xx,vr=xx,vc=xx,tr=xxx,d=xxxxx,fg=xxxxxxx,bg=xxxxxxx\r\n"
};


BYTE	wfld_pos[] =
{
	12, 17, 23, 29, 35, 41, 47, 53, 59, 68, 79
};


/*** SUB FUNCTIONS ******************************************************/

/*** DO_FWRITE routine ***************************************************/

	UWORD
do_fwrite(pfname, ptext)
	UBYTE		*pfname;
	UBYTE		*ptext;
{
	WORD		ret;
	WORD		index;
	BYTE		*ptemp;
	BYTE		pfcb[32];
	struct pf	pf_input;
	WORD		sec_cnt;
	UWORD		ds;

						/* get segment		*/
	ptemp = 9;
	ds = *ptemp++ + (*ptemp << 8);
						/* calculate number of	*/
						/*   sectors to write	*/
	index = strlen(ptext);
	sec_cnt = (index / 128);
	if ( (index % 128) > 0 )
	  sec_cnt++;
						/* set return error	*/
						/*   mode to no display	*/
	ret = __BDOS(F_ERRMODE, 0xff);
						/* parse filename	*/
	pf_input.pf_pfilename = pfname;
	pf_input.pf_pfcb = &pfcb[0];
	ret = __BDOS(F_PARSE, &pf_input);
						/* handle error case if	*/
						/*   parse fails	*/
	if ( ret == 0xff )
	{
						/* set return error	*/
						/*   mode to default	*/
  	  ret = __BDOS(F_ERRMODE, 0xfd);
	  return(ERR_PARSE);
	}
						/* try to delete file	*/
						/*   by this name	*/
	ret = __BDOS(F_DELETE, &pfcb[0]);
						/* make a file by this	*/
						/*   name		*/
	ret = __BDOS(F_MAKE, &pfcb[0]);
						/* handle error case if	*/
						/*   make fails		*/
	if ( ret == 0xff )
	{
						/* set return error	*/
						/*   mode to default	*/
  	  ret = __BDOS(F_ERRMODE, 0xfd);
	  return(ERR_MAKE);
	}
						/* set dma to point to	*/
						/*   buffer		*/
	ret = __BDOS(F_DMAOFF, ptext);
	ret = __BDOS(F_DMASEG, ds);
						/* set mulitsector cnt	*/
	ret = __BDOS(F_MULTISEC, sec_cnt);
						/* set CR byte to 0	*/
	pfcb[0x20] = 0x00;
						/* do the write		*/
	ret = __BDOS(F_WRITE, &pfcb[0]);
						/* handle error case if	*/
						/*   write fails	*/
	if ( ret != 0x00 )
	{
						/* set return error	*/
						/*   mode to default	*/
  	  ret = __BDOS(F_ERRMODE, 0xfd);
	  return(ERR_WRITE);
	}
						/* reset mulitsector cnt*/
	ret = __BDOS(F_MULTISEC, 1);
						/* close file		*/
	ret = __BDOS(F_CLOSE, &pfcb[0]);
						/* handle error case if	*/
						/*   close fails	*/
	if ( ret == 0xff )
	{
						/* set return error	*/
						/*   mode to default	*/
  	  ret = __BDOS(F_ERRMODE, 0xfd);
	  return(ERR_CLOSE);
	}
						/* set return error	*/
						/*   mode to default	*/
	ret = __BDOS(F_ERRMODE, 0xfd);
						/* get out of here	*/
	return(0);
}


/*** Window Manager 01WRITE routine *******************************************/

	VOID
wm_01write(worc, number)
	WORD		worc;			/* 0=Window, 1=Console	*/
	BYTE		number;			/* VC number to write	*/
{
	WORD		ret;
	WORD		i;
	WORD		index;
	WORD		imhere,
			nvc,
			top;
	WORD		ax,bx,cx,dx;
	struct ca_parm	src,dest;
	WORD		nrows,ncols;
	BYTE		*ptemp;
	WORD		ds;
	BYTE		junkbyte;
	WORD		winsize;
	WORD		vp,vpx,vpy;
	BYTE		*pbyte1,*pbyte2,*pbyte3,
			*strsrc,*strdest;
						/* get segment		*/
	ptemp = 9;
	ds = *ptemp++ + (*ptemp << 8);
						/* set up for copying	*/
						/*   console as source	*/
	src.ca_choffset = 0x0000;
	WM_PK(0, number, VS_VC_SEG, &src.ca_chsegment);
	src.ca_atoffset = &junkbyte;
	src.ca_atsegment = ds;
	src.ca_chcoladj = 2;
	src.ca_atcoladj = 0;
	src.ca_chrowadj = 0;
	src.ca_atrowadj = 0;
						/* set up nrows and 	*/
						/*   ncols for full	*/
						/*   console		*/
	nrows = 24;
	ncols = 80;
						/* fix up copy source	*/
						/*   if its window	*/
	if ( worc == 0 )
	{
	  wm_nrnc(number, &nrows, &ncols);
	  wm_vrvc(number, &vpy, &vpx);
	  vpy--;
	  vpx--;
	  src.ca_choffset = 2 * ((vpy * 80) + vpx);
	  src.ca_chcoladj = 2;
	  src.ca_chrowadj = 2 * (80 - ncols);
	}
						/* set up copy dest.	*/
						/*   to point to local	*/
						/*   buffer		*/
	dest.ca_choffset = &vc_buffer[0];
	dest.ca_chsegment = ds;
	dest.ca_atoffset = &junkbyte;
	dest.ca_atsegment = ds;
	dest.ca_chcoladj = 1;
	dest.ca_atcoladj = 0;
	dest.ca_chrowadj = 2;			/* leaves room for crlf	*/
	dest.ca_atrowadj = 0;
						/* if vc is full	*/
						/*   screen and on top	*/
						/*   make sure image and*/
						/*   screen are in sync	*/
	wm_sync(number);
						/* get mxq		*/
	WM_MXQ(0, number);
						/* do the copy		*/
	GENCOPY(&src, &dest, nrows, ncols);
						/* free up mxq		*/
	WM_MXQ(1, number);
						/* make sure it's all	*/
						/*   chars., coerce to	*/
						/*   spaces if not	*/
	index = (nrows * ncols) + (nrows * 2);
	for (i=0; i<index; i++)
	{
	  if ( ( vc_buffer[i] < ' ' ) ||
	       ( vc_buffer[i] > '~' )    )
	    vc_buffer[i] = ' ';
	}
						/* put CTRL-Z at end	*/
	vc_buffer[index++] = 0x1a;
						/* put null in last 	*/
						/*   byte		*/
	vc_buffer[index] = NULL;
						/* run through window	*/
						/*   text and stick in	*/
						/*   crlf's at end of	*/
						/*   each row		*/
	for (i=1; i<=nrows; i++)
	{
	  index = (i * ncols) + (2 * (i-1));
	  vc_buffer[index++] = 0x0d;
	  vc_buffer[index] = 0x0a;
	}
						/* run through window	*/
						/*   text and strip out	*/
						/*   trailing spaces	*/
						/*   on each line	*/
	pbyte1 = &vc_buffer[0];
	pbyte2 = &vc_buffer[0];
	while ( *pbyte2 != NULL )
	{
						/* scan to end of spaces*/
	  pbyte3 = pbyte2;
	  while ( *pbyte3 == ' ' )
	    pbyte3++;
						/* if <cr> at end of 	*/
						/*   spaces then skip	*/
						/*   over them		*/
						/* else copy any spaces	*/
						/*   and chars. as a	*/
						/*   group		*/
	  if ( *pbyte3 == 0x0d )
	  {
	    pbyte2 = pbyte3;			/* skip over spaces	*/
	    *pbyte1++ = *pbyte2++;		/* copy <cr>		*/
	    *pbyte1++ = *pbyte2++;		/* copy <lf>		*/
	  }
	  else
	  {
	    strsrc = pbyte2;
	    strdest = pbyte1;
	    pbyte3++;
	    pbyte1 += (pbyte3 - pbyte2); 
	    strncpy(strdest, strsrc, pbyte3 - pbyte2);
	    pbyte2 = pbyte3;
	  }
	}
						/* put null in last	*/
						/*   byte		*/
	*pbyte1 = NULL;
						/* get out of here	*/
	return;
}


/*** Window Manager 2WRITE routine **************************************/

	VOID
wm_2write()
{
	WORD		ret;
	WORD		i, j;
	BYTE		*pdest;
	BYTE		*psrc;
	BYTE		*ptemp;
	WORD		size;

						/* calc size of the	*/
						/*   string		*/
	size = strlen(pwline[0]);
						/* build up change	*/
						/*   lines and put them	*/
						/*   out		*/
	for (i=0; i<NUM_VC; i++)
	{
	  pdest = &vc_buffer[i * size];
	  copy_bytes(pdest, pwline[0], size);
	  for (j=0; j<NUM_FLDS; j++)
	    format_fld(i, j, wfld_pos[j], pdest);
	}
						/* finish off with	*/
						/*   CTRL-Z and NULL	*/
	pdest = &vc_buffer[i * size];
	*pdest++ = 0x1a;
	*pdest = NULL;
						/* run through buffer	*/
						/*   and remove spaces	*/
						/*   that immediately	*/
						/*   follow an equal	*/
						/*   sign or precede a	*/
						/*   comma or CR	*/
	pdest = &vc_buffer[0];
	psrc = pdest;
	while ( *psrc != NULL )
	{
          if ( *psrc != ' ' )
	    *pdest++ = *psrc++;
	  else
	  {
						/* handle case of a 	*/
						/*   space after an '='	*/
	    psrc--;
	    if ( *psrc == '=' )
	      psrc += 2;
	    else
	      psrc++;
	    if ( *psrc != ' ' )
	      *pdest++ = *psrc++;
	    else
	    {
						/* handle case of 	*/
						/*   spaces before a ','*/
						/*   or a CR		*/
	      ptemp = psrc;
	      while ( *ptemp == ' ' )
	        ptemp++;
	      if ( (*ptemp == ',') ||
		   (*ptemp == CR)   )
	        psrc = ptemp;
	      *pdest++ = *psrc++; 
	    }
	  }
	}
	*pdest = NULL;
						/* get out of here	*/
	return;
}


/*** Window Manager WRITE routine ***************************************/

	WORD
wm_write(wcors, number, pfname)
	WORD		wcors;			/* 0=Window, 1=Console	*/
						/*   2 = Setup		*/
	BYTE		number;			/* VC number to write	*/
	BYTE		*pfname;
{
	WORD		ret;

						/* branch to appropriate*/
						/*   routine		*/
	if ( ( wcors == 0 ) ||
	     ( wcors == 1 )   )
	  wm_01write(wcors, number);
	else
	  wm_2write();
						/* write out buffer to 	*/
						/*   the file		*/
	ret = do_fwrite(pfname, &vc_buffer[0]);
						/* get out of here	*/
	return(ret);
}


                                                                                                                                                                                                                                                                                                                                                                                                                                                                         