/****************************************************************************
*
*	  C P / M   C   R U N   T I M E   L I B   H E A D E R   F I L E
*	  -------------------------------------------------------------
*	Copyright 1982 by Digital Research Inc.  All rights reserved.
*
*	This is an include file for assisting the user to write portable
*	programs for C.  All processor dependencies should be located here.
*
****************************************************************************/
/*
 *	Standard type definitions
 */
#define	BYTE	char				/* Signed byte		   */
#define UBYTE	unsigned char			/* Unsigned byte 	   */
#define BOOLEAN	int				/* 2 valued (true/false)   */
#define	WORD	int  				/* Signed word (16 bits)   */
#define	UWORD	unsigned int			/* unsigned word	   */

#define	LONG	long				/* signed long (32 bits)   */
#define	ULONG	long				/* Unsigned long	   */

#define	REG	register			/* register variable	   */
#define	LOCAL	auto				/* Local var on 68000	   */
#define	EXTERN	extern				/* External variable	   */
#define	MLOCAL	static				/* Local to module	   */
#define	GLOBAL	/**/				/* Global variable	   */
#define VOID	void
#define	DEFAULT	int				/* Default size		   */
#define FLOAT	float				/* Floating Point	   */
#define DOUBLE	double				/* Double precision	   */

#ifdef MSC					/* MicroSoft C		     */

#define	CDECL	cdecl				/* C calling convention	     */
#define	PASCAL	pascal				/* Pascal Calling Convention */
#define FAR	far				/* FAR pointer or Function   */
#define NEAR	near				/* NEAR pointer or Function  */
#define	CONST	/**/				/* CONSTANT Value	     */
#define	VOLATILE /**/				/* VOLATILE must Always Read */

#else
#ifdef __HIGHC__			/* MetaWare High C	     */

					/********************************/
#define METAWARE 1			/* High C version 1.4		*/
					/********************************/
#define	_PASCAL_CONV _CALLEE_POPS_STACK|_SAVE_REGS
#define	_C_CONV _REVERSE_PARMS|_SAVE_REGS
#define	FIXFUNC	pragma Global_aliasing_convention("%C%r");
#define	VARFUNC	pragma Global_aliasing_convention("_%a%r");
					/********************************/
#define	CDECL	_cc (_C_CONV)		/* MS C conventions		*/
#define	PASCAL	_cc (_PASCAL_CONV)	/* MS Pascal conventions	*/
#define	FAR	_far			/* FAR pointer or function	*/
#define NEAR	_near			/* NEAR pointer or function 	*/
#define	CONST	const			/* CONSTANT value -- R/O	*/
#define	VOLATILE volatile		/* VOLATILE must always read	*/
					/********************************/
pragma Calling_convention (_C_CONV,_DEFAULT);
VARFUNC					/* set default to C		*/
					/********************************/
pragma On (Optimize_for_space);		/* space, not speed		*/
pragma On (Quiet);			/* don't be too verbose		*/
pragma Off (Public_var_warnings);	/* referenced before set	*/
pragma Code ("_TEXT");			/* MSC compatible		*/
pragma Static_segment ("_DATA");	/* MSC compatible		*/
pragma Literals ("_DATA");		/* put constants into _DATA	*/
pragma On (Char_default_unsigned);	/* unsigned is safer		*/
pragma Off (Push_regsize);		/* push [mem] is safe		*/
					/********************************/
#ifdef QUIET				/********************************/
pragma On (PCC_msgs);			/* don't talk too much -	*/
#endif					/*   UNIX PCC errors only...	*/
					/********************************/
#ifdef REG				/* if register defined already	*/
#undef REG				/* redefine register variables	*/
#endif					/*				*/
#define	REG /**/			/* make it ignore register vars	*/
pragma On (Use_reg_vars);		/* allocate vars to SI, DI	*/
pragma On (Auto_reg_alloc);		/* HC figures out SI,DI		*/
					/*				*/
#ifndef	NOPROTO				/*				*/
pragma Off (Prototype_override_warnings);
#define LINT_ARGS	YES		/* ANSI prototype checking	*/
#endif					/*				*/
					/********************************/
#else					/* all other compilers		*/
					/* (might not support ANSI)	*/
#define	CDECL	/**/			/* C calling convention		*/
#define	PASCAL	/**/			/* Pascal calling convention	*/
#define FAR	/**/			/* FAR pointer or function	*/
#define NEAR	/**/			/* NEAR pointer or function	*/
#define	CONST	/**/			/* CONSTANT value		*/
#define	VOLATILE /**/			/* VOLATILE must always read	*/

#endif					/* #ifdef __HIGHC__		*/
#endif					/* #ifdef MSC			*/

/****************************************************************************/
/*	Miscellaneous Definitions:					    */
/****************************************************************************/
#define	FAILURE	(-1)			/*	Function failure return val */
#define SUCCESS	(0)			/*	Function success return val */
#define	YES	1			/*	"TRUE"			    */
#define	NO	0			/*	"FALSE"			    */
#define	FOREVER	for(;;)			/*	Infinite loop declaration   */
#define	NULL	0			/*	Null character value	    */
#define NULLPTR (char *) 0		/*	Null pointer value	    */
#define	EOF	(-1)			/*	EOF Value		    */
#define	TRUE	(1)			/*	Function TRUE  value	    */
#define	FALSE	(0)			/*	Function FALSE value	    */

/****************************************************************************/
/****************************************************************************/
