; ***********************************************************************
; *									*
; *			Queue Bindings Assembly Module			*
; *									*
; * Copyright (c) 1986 by Digital Research Inc.				*
; *									*
; * Modification History:						*
; * =====================						*
; *									*
; *   Date   Author Version   Modification				*
; * 02/07/86  NJW     1.0     Initial Version				*
; *									*
; ***********************************************************************
;

FALSE		equ	0
TRUE		equ	not FALSE


LARGE_MODEL	equ	FALSE			; Large or small memory model ?



BDOS		equ	224			; DRI BDOS entry point
S_SYSDAT	equ	154			; Return sysdat BDOS function


; Subroutines made public:
; ========================

public		__DRIDOS
if LARGE_MODEL
public		__PTRSUB
public		__SYSDAT
endif

; Memory made global:
; ===================

public		__EXTEND			; __extended_error (lc only has
						;     8 significant characters)

prog	segment public	'prog'
	assume	cs:prog, ds:data

;
; ***********************************************************************
; *				__DRIDOS				*
; *				========				*
; * Action:								*
; * Call the DRI BDOS (int 224)						*
; *									*
; * Input parameters:							*
; * (On stack)		DX parameter					*
; *			Routine to call					*
; *									*
; * Output parameters:							*
; * AX			BDOS error code					*
; * __extended_error	CX extended error code				*
; *									*
; ***********************************************************************
;
if LARGE_MODEL
__DRIDOS 	proc	far
else
__DRIDOS	proc	near
endif

; Set up stack frame

push	bp
mov	bp,sp					; Stack is [bp] [ret] [dx] [cx]

if LARGE_MODEL
push	ds					; Save DS too if large model
endif

; Get parameters

if LARGE_MODEL
mov	cx,[bp + 6]
lds	dx,[bp + 8]				; DS:DX is pointer

else

mov	cx,[bp + 4]
mov	dx,[bp + 6]				; Function call parameter
endif

; Call the DOS

int	BDOS

; Save the extended error code

if LARGE_MODEL
pop	ds
endif

mov	cs:__EXTEND,cx

; Kill BX (returns an 'int' not a 'long')

mov	bx,0

; END

pop	bp
ret

__DRIDOS endp


if LARGE_MODEL
;
; ***********************************************************************
; *				__PTRSUB				*
; *				========				*
; * Action:								*
; * Convert pointer difference s2-s1 into 16 bit offset.		*
; *									*
; * Input parameters:							*
; * (On Stack):		s1						*
; *			s2						*
; *									*
; * Output parameters:							*
; * ax			(s2-s1) (as offset)				*
; *									*
; ***********************************************************************
;
__PTRSUB proc	far

; Set up stack frame

push	bp
mov	bp,sp					; Stack is [bp] [ret] [s1] [s2]

; Subtract segments to get segment offset (-> bytes)

mov	ax,[bp + 12]				; S2(h)
sub	ax,[bp + 8]				; S1(h)
mov	cl,4
shl	ax,cl

; Add s2 offset to segment offset

add	ax,[bp + 10]				; S2(l)

; Reset stack

pop	bp

; END

ret

__PTRSUB endp


;
; ***********************************************************************
; *				__SYSDAT				*
; *				========				*
; * Action:								*
; * Return a long pointer to sysdat.					*
; *									*
; * Input parameters:							*
; * None.								*
; *									*
; * Output parameters:							*
; * Long pointer to sysdat.						*
; *									*
; ***********************************************************************
;
__SYSDAT proc	far

; Save registers

push	es

; Get sysdat segment

mov	cl,S_SYSDAT
int	BDOS

; Set return values

mov	ax,es				; AX:BX is long pointer

; Restore registers

pop	es

; END

ret

__SYSDAT endp

endif
prog	ends


data	segment	public 'data'

__EXTEND	dw	0			; Extended error code

data	ends

end
