/*  	
	File		queslave.c
	Title		Queue test slave prog.
	Author(s)	/usr/NICK/WEBB
	Date		9th July 1986


Rev  	Date 	 Inits	Description
----------------------------------------------------------------------
1.0   09/07/86	  NJW	Initial version
----------------------------------------------------------------------


*/

#include <stdio.h>
#include <stdlib.h>
#include "quelib.h"

void main()
{

	int	qidin;			/* INQ handle */
	int	qidout;			/* OUTQ handle */
	char	in_buffer[64];		/* Message buffer */
	int	in_error;		/* Input error */
	int	out_error;		/* Output error */

/* OPEN  "IN" Queue */

	if ((qidin = q_open ("INQ")) == -1)
	    {
	    printf ("(INQ) Queue open error, code >%d<\n\n", q_error());
	    exit (1);
	    }

/* OPEN  "OUT" Queue */

	if ((qidout = q_open ("OUTQ")) == -1)
	    {
	    printf ("(OUTQ) Queue open error, code >%d<\n\n", q_error());
	    exit (1);
	    }

/* Keep reading / writing the queue */

	for (;;)
	    {
	    if ((in_error = q_cread (qidout, in_buffer)) == 1)
		printf ("<");			/* Output < if no message */
	    else if (in_error == -1)
		{				/* Terminate if error */
		printf ("Error reading queue, code >%d<\n\n", q_error());
		exit (1);
		}
	    else if (!in_error)
		{				/* No error, try to output */
		while ((out_error = q_write (qidin, in_buffer)) == 1)
		    printf (">");		/* Queue busy, output > */
		if (out_error == -1)		/* Queue error, terminate */
		    {
		    printf ("Error writing queue, code >%d<\n\n", q_error());
		    exit (1);
		    }
		else if (out_error)		/* Queue library bug ! */
		    {
		    printf ("Unknown error writing queue, code >%d<\n\n", out_error);
		    exit (1);
		    }
		else				/* Successful write, output . */
		    printf(".");
		}
	    else
		{				/* Queue library bug on read */
		printf ("Unknown return, >%d<\n\n", in_error);
		exit (1);
		}
	    }
}
