/*  	
	File		quetst.c
	Title		Queue test master prog.
	Author(s)	/usr/NICK/WEBB
	Date		9th July 1986


Rev  	Date 	 Inits	Description
----------------------------------------------------------------------
1.0   09/07/86	  NJW	Initial version
----------------------------------------------------------------------


*/

#include <stdio.h>
#include <stdlib.h>
#include "quelib.h"


void main()
{

	int	qidin;			/* INQ handle */
	int	qidout;			/* OUTQ handle */
	int	i;			/* A.N.Other integer */
	char	in_buffer[64];		/* Input message buffer */
	char	out_buffer[64];		/* Output message buffer */
	int	in_error;		/* Input error */
	int	out_error;		/* Output error */

/* MAKE and OPEN  "IN" Queue */

	if (q_make ("INQ", 64, 3))
	    {
	    printf ("Error on INQ queue make, code >%d<\n\n", q_error());
	    exit (1);
	    }
	if ((qidin = q_open ("INQ")) == -1)
	    {
	    printf ("(INQ) Queue open error, code >%d<\n\n", q_error());
	    exit (1);
	    }

/* MAKE and OPEN  "OUT" Queue */

	if (q_make ("OUTQ", 64, 3))
	    {
	    printf ("Error on OUTQ queue make, code >%d<\n\n", q_error());
	    exit (1);
	    }
	if ((qidout = q_open ("OUTQ")) == -1)
	    {
	    printf ("(OUTQ) Queue open error, code >%d<\n\n", q_error());
	    exit (1);
	    }

/* KEEP WRITING TO THE QUEUE */

	for (i = 0; i < 1000; i++)
	    {
	    sprintf (out_buffer, "%d", i);	/* Put message in buffer */
	    do
		{				/* If queue busy output > */
		while ((out_error = q_cwrite (qidout, out_buffer)) == 1)
		    printf (">");
		if (out_error == -1)		/* If queue error, terminate */
		    {
		    printf ("Error writing queue, code >%d<\n\n", q_error());
		    exit (1);
		    }
		else if (out_error)		/* (library bug error !) */
		    {
		    printf ("Unknown error writing queue, code >%d<\n\n", out_error);
		    exit (1);
		    }
		printf("Written Message >%d<....", i);
						/* If no messages, output < */
		if ((in_error = q_cread (qidin, in_buffer)) == 1)
		    printf ("<");
		else if (in_error == -1)	/* If queue error, terminate */
		    {
		    printf ("Error reading queue, code >%d<\n\n", q_error());
		    exit (1);
		    }
		else if (!in_error)		/* No error, output message */
		    printf ("Read Message >%s<\n", in_buffer);
		else
		    {				/* Library bug error */
		    printf ("Unknown return, >%d<\n\n", in_error);
		    exit (1);
		    }
		}
		while (out_error);		/* Keep in this loop until */
	    }					/*   message successfully output */

/* FLUSH THE LAST FEW MESSAGES OUT OF THE BUFFER */

	do
	    {
	    if ((in_error = q_cread (qidin, in_buffer)) == 1)
		printf ("<");
	    else if (in_error == -1)
		{
		printf ("Error reading queue, code >%d<\n\n", q_error());
		exit (1);
		}
	    else if (in_error == 0)
		printf ("Read Message >%s<\n", in_buffer);
	    else
		{
		printf ("Unknown return, >%d<\n\n", in_error);
		exit (1);
		}
	    }
	    while (strncmp (in_buffer, "999", 3));

/* DELETE THE QUEUES */

	if (q_delete (qidin))
	    {
	    printf ("Error on INQ queue delete, code >%d<\n\n", q_error());
	    exit (1);
	    }
	if (q_delete (qidout))
	    {
	    printf ("Error on OUTQ queue delete, code >%d<\n\n", q_error());
	    exit (1);
	    }
	printf ("Test completed normally\007\n\n");
	exit (0);
}
