/******************************************************************************
* CONFIG.H - CONFIG Control Module: IBM PC/AT, Protected	Version 1.3.02
*******************************************************************************
* Version   Date   Who  Description
* ======= ======== ===  =======================================================
* v1.3.02 10/10/86 ldt  rename file to config.h - config.c includes config.h
* v1.3.01 09/14/86 ldt  Reduced FS tuning specs by 1/4th.
* v1.3.00 09/14/86 ldt  Doubled the FS tuning specs.
* v1.2.04 06/12/86 RFW  Changed GMAN define to GIF Graphics Interface 
*  1.2.03 06/10/86 mei  #ifndef ICONF286 for Metaware functional prototypes.
* v1.2.02 06/02/86 tdm  Added network defines.
* v1.2.01 04/29/86 LDT	Corrected GMAN define.
* v1.2.00 04/11/86 FRH	Add sysbuild.h (struct.h assumes this)
*	8 03/10/86 LDT	Increased FSMEMSIZE to 6K. (was 2K)
*	7 01/09/86 RFW	added GMAN define to setup graphics
*	6 09/19/85 cpg	OSPOOL, FNUMTAB and ASR table init changes
******************************************************************************/


#define	LOADADDR	0x2f0C0		/* system load address if not booted */

/*#define DEBUG*/			/* remove this line for release */

#define  DOSFE    	             	/* remove this line to omit
					   DOS front end. */

#define GIF	            	 	/* remove this line to omit 
					   the Graphics Interface */

/* Network defines:  True  =  linked with system or non-existent. 	  */
/*		     False =  loaded as driver. 			  */
/*								          */
/* Note:  * NETWORK must be set to true if any one of the other net       */
/*	    defines is set to true.					  */
/*	  * Set NETSERV to false to have a requester only node.		  */

#define NETWORK		FALSE		/* Network Resource Manager 	  */
#define	NETXPORT	FALSE		/* Transporter.			  */
#define	NETNAMES	FALSE		/* Name server.			  */
#define NETDEV		FALSE		/* Net: device.			  */
#define NETSERV		FALSE		/* Server module.		  */
	

/***********
************
** MEMORY **
************
***********/

#define	DEFSTK	2536L		/* default stack size for process */
#define	MAXLDT	200		/* number ldt entries allocated per process */

/****************
*****************
** ATTACHMENTS **
*****************
****************/


/* Define the following three variables based on how many	*/
/* partions the hard disk is broken up into			*/

#define	HARD		FALSE		/* hard disk driver to be installed by
					   config */
#define	TWOHARD		FALSE		/* it has two partitions */
#define	THREEHARD	FALSE		/* it has three partitions */

#define	PRINTER		FALSE		/* TRUE if printer linked in	*/
					/* FALSE if loaded		*/
/*
**
** First DOS partition on the hard disk (if applicable), this is where
** the window manager and shell are to be loaded from
** This define is used to skip the CP/M partition (if applicable),
** when setting up the system and process define tables
**
*/

#define	DOSPART		1	/* 1 - first partition	*/
				/* 2 - second partition	*/
				/* 3 - third partition	*/

#define MOUSE		1	/* 2 = Mouse sub-driver will be linked in */
				/* 1 = Mouse sub-driver is loadable */
				/* 0 = OLD Mouse sub-driver is linked in */

/***********************
************************
** FILE SYSTEM TUNING **
************************
***********************/

#define	DIRFATSZ	0x6000L
#define	DATASZ		0x2100L
#define	PATHQUOTA	0x600
#define	TOTALQUOTA	0x1200
#define FSMEMSIZE	0x9000

#define NUM_FNUMT	128	/* Maximum # of current open files */
				/* NOTE:  must be same as in ACONFAT.A86 */

#define NUM_ASR		32	/* Maximum # of currently scheduled ASR's */

