/*======================================================================*
 *   Version 2.9        Console Driver					*
 *			Copy/Alter function				*
 *----------------------------------------------------------------------*
 * VERSION   DATE    TIME  BY   CHANGE/COMMENTS				*
 *----------------------------------------------------------------------*
 *   1.00   3/19/85  8:12 DR-K  Added this intro to files		*
 *   1.01   4/23/85 16:00 DR-K	Exit on cursor movement only call	*
 *   1.02   5/10/85 19:12 DR-K	update vcd->v_cursxy on cursor-only call* 
 *   1.03   5/12/85 19:11 DR-K	use c2to2copy as cpp if vcs is physical *
 *				 color screen				*
 *   1.04   5/22/85 14:29 DR-K	condition update() if unit == BITMAP	*
 *   1.05   6/05/85 11:25 DR-K  move inline cursor placement code to 	*
 *				 pos_cursor()				*
 *   1.06   6/12/85 12:40 DR-K	include io.h not pd.h, del .sys externs	*
 *   1.07   7/24/85 21:11 DR-K	call c_update (in icdrtool.c) not update*
 *   1.08   9/30/85 11:30 DR-K	store v_top,v_att,v_mode if VP_REORDER	*
 *   2.0   10/30/85 15:07 DR-K	store/set pcurs,modes at REORDER	*
 *   2.1   11/01/85 16:28 RFW   When reordering to the top virtual 	*
 *				consoles the virtual's desired crt mode *
 * 				checked if not the same as the physicals*
 *				call video_init.  Also do copy the      *
 *				graphic screens as needed (someday 	*
 *				a BitBlit will do this.)		*      
 *   2.2   11/19/85       DR-K	update phys cursor only when topvc+phys *
 *   2.3    1/13/86       DR-K	remove vdtop=vstop if REORDER		*
 *   2.4     3/4/86       DR-K	add hardware scroll support		*
 *   2.5   06/10/86       mei	High C port.				*
 *   2.6   08/06/86 16:05 BVH	Add EGA board support.			*
 *   2.7   08/18/86 14:53 BVH	Allow mode switching with CGA card.	*
 *   2.8   08/19/86 11:02 BVH	Only re-init card on certain occasions.	*
 *   2.9   09/19/86 13:16 BVH	More MetaWare fix-ups.			*
 *   3.0   10/27/86       KJ	add mode switching for Hercules 32Kbyte *
 *				changed gsxdef.h to ega.h		*
 *======================================================================*/

#include "portab.h"
#include "io.h"
#include "system.h"
#include "icdrv.h"
#include "ega.h"

#if METAWARE 
#define ICDRCOPY
#include "protos.h"
#endif

EXTERN	VCBLK	*pcb[];
EXTERN	CTE	contab[];

EXTERN	BYTE	ranupd[];
EXTERN	CPBLK	cptbl[];

EXTERN	VOID	c_update();
EXTERN	VOID	pos_cursor();
EXTERN  VOID    video_init();  /* Reinitialize CRT when needed */
EXTERN	BOOLEAN	clip();
EXTERN	VOID	on_pcursor(), off_pcursor(), _bmove(), c1to1copy(), PCHScrol();
EXTERN	VOID	cegatobuf(), cbuftoega(), load_port();

/************************************************************************/
/*      c_copy - copy/alter a destination rectangle                     */
/************************************************************************/
LONG c_copy( pb )
	CDCOPALT   *pb ;

{
     BYTE   unit,option,pl2use,*altb,msk ;
     FRAME  *sf,*df,
	    lsf,ldf ;		/* local copies of user frames */
     RECT   *psr,*pdr ; /* adjusted ptr to rectangles	*/
     RECT     sr,  dr ;	/* local copies of rectangles */

     WORD   vstop,vdtop,	/* ptr to topline */
	    tmpsrow,tmpdrow,	/* the top row we are working on */
	    srow,drow,		/* the row we are working on now */
	    nsrow,ndrow,	/* number of rows in this frame */
	    isrow,idrow;	/* increment between rows */
     WORD   rmax;
     UBYTE  *dp,*dirt_p;	/* current ptr into a plane */
     WORD   p,r;		/* temp vars */
     VCBLK  *vcd,*vcs;		/* Virtual Con data blocks */
     CPBLK  *cpp;		/* Copy Block ptr for table info */
     BYTE   PFrame;		/* destination is to physical		*/
     LONG   retc = 0L;		/* emask or success return code		*/
     UWORD  flags;

    vstop = vdtop = 0;
    PFrame = FALSE;
    unit = pb->cd_unit ;
    option = pb->cd_opt ;
    flags = pb->cd_flags;

    /* translate all user addresses to system memory addresses */
    if ( flags & DPF_UADDR )
	{
	  mapu( pb->cd_pd );
	  pdr = (RECT *)saddr( pb->cd_drect );
	  psr = (RECT *)saddr( pb->cd_srect );
	}
	else
	{
	  pdr = pb->cd_drect ;
	  psr = pb->cd_srect ;
	}
    if (option & DESTUFRAME)	/* destination */
	{
	  if ( flags & DPF_UADDR )
		{
		  df = (FRAME *)saddr( pb->cd_dfram );
		  _bmove( df,&ldf,(WORD)sizeof(FRAME));	/*make a local copy*/
		  df = &ldf;				/* and point at it */
		  for (p=0; p<PL_NPLANE; p++)		/*fixup plane addrs*/
			df->fr_pl[p] = (BYTE *) saddr( df->fr_pl[p] );
		}
	    else df = pb->cd_dfram ;
	}
	else
	{
	  if (( vcd = (VCBLK *)pb->cd_dfram ) == NULLPTR )  /* if to VFRAME */
		{
		vcd = pcb[unit] ;		/*  if to PFRAME */
    		PFrame = TRUE;
#if (COMPU == FALSE)
		if (unit == BITMAP)
		  {
		    if ((contab[unit].CT_flags & 8) !=0)  /*the color adapter board*/
				option |= VSYNC;
		    PFrame = FALSE;
		  }
#endif
		}
	  df = (FRAME *) vcd ;
	  vdtop = vcd->v_top;
	  /****ptop = (vcd->v_mode & PCFRAME) ? 1 : 0 ;**someday***/
	}

    if (flags & CP_CURMOVE )
	{
	    vcd->v_cursx = pb->cd_crow;
	    vcd->v_cursy = pb->cd_ccol;
	    goto exitcopy ;
	}

    _bmove( pdr, &dr, (WORD)sizeof(RECT) );

	/* clip recangles to be within frame */
    if (clip(&dr,0,0,df->fr_nrow,df->fr_ncol) == FAILURE)
		goto exitcopy;

    dirt_p = 0L;
    pl2use = ( ( flags &  df->fr_use ) & PL_USEALL );

	/*assign the appropriate routine to do our work */
    cpp = &cptbl[ (option & CPPMASK) | ((option & VSYNC) >> 1)];

			/* end of common code section */

    if (option & ALTER)		/* if this is an ALTER operation ***/
/**************************** c_alter()	**************************/
    {
	altb = (BYTE *) (&(pb->cd_sfram));
		/*  Update Frames  */
	rmax = dr.r_row + dr.r_nrow;
				/** if not user mem nor PCframe **/

	ndrow = df->fr_nrow * (idrow = df->fr_ncol * cpp->cp_dindex);
	drow = ( (((dr.r_row + vdtop) * df->fr_ncol) + dr.r_col)
						 * cpp->cp_dindex) % ndrow ;
	for (p=0;p<3;p++,altb +=2)	/* for each plane */
	{
	    if (pl2use & (1<<p))
	    {
		    tmpdrow = drow ;
		    for (r=dr.r_row; r<rmax; r++) /* for each row */
		    {
			if (PFrame) dirt_p = pcb[unit]->v_dirty + (tmpdrow >> 1);
			(*cpp->cp_rowalt)((BYTE *)(df->fr_pl[p] + tmpdrow),*altb,*(altb+1),dr.r_ncol,dirt_p);
			tmpdrow = (tmpdrow + idrow) % ndrow;
		    }
	    }
	}

    }  /******** end of alter() **************/
    else
/********************* copy() *****************************/

    {
	if(option & SRCUFRAME){				/* source */
	    if( flags & DPF_UADDR ){
		_bmove(saddr(pb->cd_sfram),&lsf,(WORD)sizeof(FRAME));	/*make a local copy*/
		sf = &lsf;				/* and point at it */
		for(p=0; p<PL_NPLANE; p++)		/*fixup plane addrs*/
		    sf->fr_pl[p] = (BYTE *) saddr( sf->fr_pl[p] );
		}
	    else sf = pb->cd_sfram ;
	    }
	else{
	    if((vcs = (VCBLK *)pb->cd_sfram ) == NULLPTR ){
		vcs = pcb[unit] ;

#if (COMPU == FALSE)
		if((unit == BITMAP) && ((contab[unit].CT_flags & 8) !=0))
						  /*the color adapter board*/
		    cpp = &cptbl[ (option & CPPMASK) + (VSYNC >> 1)];
#endif
		}
	    sf = (FRAME *) vcs ;

/* Changed for EGA board - BVH */

	    if(!(option & DESTUFRAME) && (flags & CP_REORDER)){
		vcd->v_att = vcs->v_att;
		vcd->v_escflg = vcs->v_escflg;
		vcd->v_tempx = vcs->v_tempx;
		vcd->v_tempy = vcs->v_tempy;

/* Preserve the state of PCFRAME and PCURSOFF bit. */

		vcd->v_mode &= PCFRAME + PCURSOFF;
		vcd->v_mode |= (vcs->v_mode & ~(PCFRAME+PCURSOFF) );

/* If destination is physical then special things need to be done. */

		if(!(pb->cd_dfram)){

/* If pcurs on/off != vcurs on/off then call pcurson/off() for newest. */

		    if (vcd->v_mode & CURSOFFM) off_pcursor(unit);
		    else			 on_pcursor(unit);

		    if((vcd->v_ptop != 0) &&
					(contab[unit].CT_flags & COLOR)){

/* Not at physical top of buffer - make it big so block move happens. */

			vcd->v_ptop = 85;
			PCHScrol(vcd);
	    		}
		    }

		if(pb->cd_dfram){
		    if((vcd->v_imode > 3) && (vcd->v_imode < 7))
			{
			c1to1copy(sf->fr_pl[0],df->fr_pl[0],0x2000);
			return(E_SUCCESS);
			}
		    else if (vcd->v_imode ==8)	/* KJ   added for Hercules */
			{
			c1to1copy(sf->fr_pl[0],df->fr_pl[0],0x4000);
			return(E_SUCCESS);
			}
		    else if(vcd->v_imode == 14)
			{
			cegatobuf(sf->fr_pl[0],df->fr_pl[0]);
			return(E_SUCCESS);
			}
		    }	
		else{
		    if ((vcs->v_imode > 3) && (vcs->v_imode < 7))
			{
			c1to1copy(sf->fr_pl[0],df->fr_pl[0],0x2000);
			}
		    else if (vcs->v_imode == 8)	/* KJ  added for Hercules */
			{
			c1to1copy(sf->fr_pl[0],df->fr_pl[0],0x4000);
			}

		    else if (vcs->v_imode == 14)
			{
			cbuftoega(sf->fr_pl[0],df->fr_pl[0]);
			if(vcs->v_imode != vcd->v_imode)
			    {
			    load_port(E_GC_A,I_MISC,E_GC_D,0xE);
			    }
			}

/* We also set the crt controller chip correctly for the new physical 
   environment if it's needed. RFW */
					
		    if((vcs->v_imode >= 13) || (vcd->v_imode != vcs->v_imode)){
			video_init(vcs->v_imode);
			vcd->v_imode = vcs->v_imode;
			}

		    if((vcs->v_imode > 3 && vcs->v_imode < 7) ||
		       vcs->v_imode == 8 || (vcs->v_imode >= 13))
			return(E_SUCCESS);
		    }
		}
	    vstop = vcs->v_top;
	    }

	_bmove( psr, &sr, (WORD)sizeof(RECT) );

	if( sf->fr_use & PL_USEALL ){	/*if not all single byte planes */
	    if(clip(&sr,0,0,sf->fr_nrow,sf->fr_ncol) == FAILURE)
			goto exitcopy;
	
		/* Force rectangles to be the same size		*/
		dr.r_ncol = sr.r_ncol = min(sr.r_ncol,dr.r_ncol);
		dr.r_nrow = sr.r_nrow = min(sr.r_nrow,dr.r_nrow);
	     }
	rmax = dr.r_nrow + dr.r_row ;
	nsrow = sf->fr_nrow * sf->fr_ncol * cpp->cp_sindex;
	ndrow = df->fr_nrow * df->fr_ncol * cpp->cp_dindex;

	srow = (sr.r_row + vstop) * sf->fr_ncol ;
	drow = (dr.r_row + vdtop) * df->fr_ncol ;
	isrow = sf->fr_ncol * cpp->cp_sindex;
	idrow = df->fr_ncol * cpp->cp_dindex;

		/* if same frame copy then set direction correctly */
	if (sf == df)
		if ((dr.r_row >= sr.r_row) && (dr.r_row < (sr.r_row + sr.r_nrow)))
		{
			srow = (srow + ((sr.r_nrow-1) * sf->fr_ncol));
			isrow = -isrow;
			drow = (drow + ((dr.r_nrow-1) * df->fr_ncol));
			idrow = -idrow;
		}
	srow = ((srow + sr.r_col) * cpp->cp_sindex) % nsrow ;
	drow = ((drow + dr.r_col) * cpp->cp_dindex) % ndrow ;

		/*  Copy Source RECT to Destination RECT	*/
		/*  Do nothing if Destination Use bit is off	*/

	for (p=0 ; p<PL_NPLANE ; p++)	/* for each plane */
	{
	    msk = 1<<p;
	    if (pl2use & msk)
		{
		    tmpsrow = srow;
	            tmpdrow = drow;	
		    for (r=dr.r_row; r < rmax; r++)	/* for each row */
		    {
			dp = df->fr_pl[p] + tmpdrow;
			if (PFrame) dirt_p = pcb[unit]->v_dirty + (tmpdrow >> 1);
			if (sf->fr_use & msk)
			     (*cpp->cp_rowcopy)((sf->fr_pl[p] + tmpsrow),
							dp,sr.r_ncol,dirt_p);
			else	/* 1 byte plane */ 
			     (*cpp->cp_rowalt)(dp,0x00,*sf->fr_pl[p],
							dr.r_ncol,dirt_p);
			tmpsrow = (tmpsrow + isrow) % nsrow;
			tmpsrow = (tmpsrow < 0) ? (nsrow + tmpsrow) : tmpsrow;
			tmpdrow = (tmpdrow + idrow) % ndrow;
			tmpdrow = (tmpdrow < 0) ? (ndrow + tmpdrow) : tmpdrow;
		    }
		}
	}

    }  /************ end of copy() ***************************/

exitcopy:
    if (!(option & DESTUFRAME))	/* if destination is not to User memory */
    {				/* then we might have to fixup the cursor */
				/* and start physical update process	*/
	if (flags & topVF)
	{
		vcd->v_cursx = pb->cd_crow;
		vcd->v_cursy = pb->cd_ccol;

#if (COMPU == FALSE)
			/* the BITMAP screen needs it's cursor updated */
		if ( (unit == BITMAP) && ((vcd->v_mode & CURSOFFM) ==0) )
		   pos_cursor( vcd->v_cursx + vcd->v_ptop,vcd->v_cursy,contab[unit].CT_cols);
#endif
	}
	if ( (PFrame) && (unit != BITMAP) )
	{
		nodisp();
		ranupd[unit]++;
		if(ranupd[unit] == 1) doasr( c_update, 0L, (LONG)unit, 200);
		okdisp();
			/* c_update will position the cursor when done */
	}

    }	/* destination was to vframe */

    if ( flags & DPF_UADDR )
	  unmapu();

return( retc ) ;
}

/***************************************************************************
*	CEGATOBUF(source,dest) and
*	CBUFTOEGA(source,dest)
*
*	Transfer the physical screen to the virtual, and vice-versa, when
*	going to/from EGA Graphics Mode 14.
****************************************************************************/

#if 0
cegatobuf(source,dest)
REG BYTE *source, *dest;
{
    REG WORD i, plsize;
    REG BYTE *ts;
    EXTERN BYTE *baseaddr[];

    load_port(E_GC_A,I_MODER,E_GC_D,0);
    load_port(E_GC_A,I_BITM,E_GC_D,0xFF);
    source = baseaddr[0];
    for(i=0; i<NUM_PLANES; ++i){
	load_port(E_GC_A,I_RMS,E_GC_D,i);
	for(ts=source, plsize=0; plsize++ < 16384;)
	    *dest++ = *ts++;
	}
    load_port(E_GC_A,I_RMS,E_GC_D,0);
}

cbuftoega(source,dest)
REG BYTE *source, *dest;
{
    REG WORD i, plsize;
    REG BYTE *ts;
    EXTERN BYTE *baseaddr[];

    load_port(E_GC_A,I_MISC,E_GC_D,0x05);
    load_port(E_GC_A,I_MODER,E_GC_D,0);
    load_port(E_GC_A,I_BITM,E_GC_D,0xFF);
    dest = baseaddr[0];
    for(i=0; i<NUM_PLANES; ++i){
	load_port(E_SEQ_A,I_MAPM,E_SEQ_D,1 << i);
	for(ts=dest, plsize=0; plsize++ < 16384;)
	    *ts++ = *source++;
	}
    load_port(E_SEQ_A,I_MAPM,E_SEQ_D,0xF);
    load_port(E_GC_A,I_MISC,E_GC_D,0x0E);
}
#endif
