/************************************************************************/
/*      PROGRAM CONTROLS                                                */
#define	LOADABLE	TRUE 	/* FALSE driver to be linked into system*/
				/* TRUE == to be loaded from disk	*/
/************************************************************************/

/*      MDRV.C */
/*======================================================================*
*   Version 1.02        Mouse Systems Special Driver			*
*			Main Code Section				*
*-----------------------------------------------------------------------*
*                                                                       *
* VERSION   DATE    BY	CHANGE/COMMENTS					*
*-----------------------------------------------------------------------*
*   1.00  03/11/87  KJ	Chanced serial Port Driver to do all		*
*			mouse stuff inside the driver.			*
*			Currently this driver is only for 1 Unit,	*
*			so we are faster in the interrupt routine	*
*			becaus we have direct addresses instead of array*
*   1.01  03/26/87  KJ  changed MOUSE_TBL structure to be more		*
*			compatible with the VCB structure for mouse.	*
*									*
*   1.02  03/30/87  KJ  added the scaling utility for screens with	*
*			low y - resolutions. e.g 200 lines 		*
*									*
*	This driver is only for one MOUSE device, so the variables	*
*	have fixed adresses and the interrupt routine is faster !!	*
*									*
*======================================================================*/

/*======================================================================*
*       Title: Mouse driver for serial Mouse Systems Mouse		*
*                                                                       *
*       Discription: here is a Mouse driver which uses the 		*
*	port driver as a SUB-DRIVER					*
*                                                                       *
*	This Mouse driver purpose is to reside between the Console 	*
*	Driver  and the Port driver. It has limited usefulness, only	*
*	for counting the bytes send from the mouse and calculate the 	*
*	current mouse position and the mouse button status.		*
*	Most parts of this code are copied from the serial device	*
*	driver.								*
*									*
*======================================================================*/

/*======================================================================*
*	mouse table for GET / SET 					*
*									*
*	+----------+----------+----------+----------+			*
*    0  |        y_max        |        x_max        |			*
*	+----------+----------+----------+----------+			*
*    4	|       reserved      |    number_buttons   |			*
*	+----------+----------+----------+----------+			*
*    8	|       scale_y       |       scale_x       |			*
*	+----------+----------+----------+----------+			*
*   12	|       double_y      |       double_x      |			*
*	+----------+----------+----------+----------+			*
*   16  |      current_y      |      current_x      |			*
*	+----------+----------+----------+----------+			*
*   20	|      button_state   |      reserved       |			*
*	+----------+----------+----------+----------+			*
*									*
*	description:							*
*									*
*	y_max / x_max	highest y/x return value, normaly set to the	*
*			physical screen resolution from sreen driver	*
*	number_buttons	number of mouse buttons.			*
*	scale_y /_x	internal mouse points per x/y pixel. Value set	*
*			by the driver, depending on x_max/y_max.	*
*			( for 640 x 200 = 1, 2, for 640 x 350 = 1, 1)	*
*	double_y /_x	if the mouse is moved quick and the received	*
*			delta value >= double_y/_x, than the delta 	*
*			value from the mouse is doubled.		*
*	current_y/ _x	current absolute mouse y, x values. Range 	*
*			from ( 0... y_max/x_max)			*
*	button_state	each bit represents a mouse button. The		*
*			leftmost button is the least significant bit.	*
*			0 -> Button not pressed				*
*			1 -> Button pressed				*
*									*
*======================================================================*/

#include "portab.h"
#include "io.h"
#include "system.h"
#undef NODISP
#undef PD
#include "console.h"
#include "mdrv.h"

#if METAWARE 
#define MDRV
#include "protos.h"
#endif

#if LOADABLE		/* if this driver will be loaded from a diskfile */
EXTERN	LONG	fix_ds();
#endif
EXTERN	LONG	dvrif();

/************************************************************************/
/* forward referenced functions                                         */
/************************************************************************/
GLOBAL  LONG
        mouse_init(),
        mouse_subdrvr(),
        mouse_uninit(),
        mouse_select(),
        mouse_flush(),
        mous_rd(),
        mous_wrt(),
        mous_get(),
        mous_set(),
        mouse_special();
VOID	mous_interpt(),
	m_asrdummy();

#if LOADABLE		/* if this driver will be loaded from a diskfile */
VOID	_bmove();
#endif

/************************************************************************/
/* local initializations                                                */
/************************************************************************/

#define MAXsUNIT 1	/* for the first step only one unit */
#define FLAGVAL  0x10	/* no syncs needed, 8-bit, has delimited read func */

/************************************************************************/
/*      Driver header                                                   */
/*  This header must be the first structure in the data segment         */
/*   so, don't put any data generating code before this section         */
/************************************************************************/

DH  mouse_dh =
{       DVR_MOUSE,MAXsUNIT,FLAGVAL,
        mouse_init,
        mouse_subdrvr,
        mouse_uninit,
        mouse_select,
        mouse_flush,
        mous_rd,
        mous_wrt,
        mous_get,
        mous_set,
        mouse_special,
        0L,0L,0L,0L,0L
};

			/* Mouse table can be changed by SET call	*/
MOUSE_TBL mouse =
{
	199,		/* .y_max	*/
	639,		/* .x_max	*/
	0,		/*  reserved	*/
	3,		/* .buttons	*/
	1,		/* .scale_y	*/
	1,		/* .scale_x	*/
	8,		/* .double_y	*/
	10,		/* .double_x	*/
	100,		/* .y		*/
	320,		/* .x		*/
	0,		/* .but		*/
	0
};

WORD	byte_count = 0;
int	delta_x = 0;
int	delta_y = 0;
WORD	new_but = 0;
DPB	set_port;	/* driver parm block for set baudrate to subdriver */
			/* 1200 Baud, no parity, 1 stopbit for MOUSE       */
PORT_TBL  port_table = { 
		PT0_TYPE,
		0,
		PT0_BAUD,
		PT0_MODE,
		PT0_CTRL,
		0  };

int	but_table[8] = {
		0x07,		/* all 3 buttons pressed	*/
		0x03,		/* left and middle button	*/
		0x05,		/* left and right button	*/
		0x01,		/* left button			*/
		0x06,		/* middle and right button	*/
		0x02,		/* middle button		*/
		0x04,		/* right button			*/
		0x00 };		/* no button pressed		*/

BYTE	mous_unit[MAXsUNIT];	/* misman's unitno indexed by sub-driver's */
BYTE    pt_unit[MAXsUNIT];	/* sub-driver's unitno indexed by drvr_unitno*/
DH      *pt_hdr[MAXsUNIT];	/* stores drvr headers of sub-drivers	*/

typedef  VOID	(*PINPTR)();

PINPTR	mmove_pin[MAXsUNIT] = { m_asrdummy };	/* save mouse move ASR      */
PINPTR	mbut_pin[MAXsUNIT] = { m_asrdummy };	/* save mouse button ASR    */
LONG	con_dle[MAXsUNIT] = { 0L };		/* save console DLE address */

/************************************************************************/
/*      mouse_init                                                      */
/************************************************************************/

LONG    mouse_init(unitno)
        LONG	unitno;
{
	BYTE	unit;

	unit = (BYTE)unitno;
	if (unit > MAXsUNIT)
	    return( E_IllUnitno );
		/* here the driver type has to be returned 		*/
                /* and in the high word, --> we need a PORT subdriver	*/
	return( (((LONG)DVR_PORT << 16) | (LONG)DVR_MOUSE) );
}

/************************************************************************/
/*      mouse_subdrvr                                                   */
/************************************************************************/

LONG    mouse_subdrvr(pb)
        DPB     *pb;
{
	BYTE	unit;
	DH	*subd_head;

	if ( (unit = pb->dp_unitno) > MAXsUNIT )
	    return(E_IllUnitno);		/* wrong unit number */

	subd_head = (DH *) pb->dp_swi;

	if ( subd_head->dh_dtype != DVR_PORT)
	    return(E_MISMATCH | ED_PORT);  /* wrong subdriver type linked */

	if (pb->dp_flags & 0x400)
	{				/* bit 10 set uninstall subdriver */
	    /* uninstall the subdriver and return we need a new subdriver */
	    return( (((LONG)DVR_PORT << 16) | (LONG)DVR_MOUSE) );
	}
	else
	{				/* link in the subdriver	*/
	    pt_hdr[unit] = (DH *) pb->dp_swi;	/* header address	*/
	    pt_unit[unit] = pb->dp_option;	/* get sub-drvr unitno	*/

	    /* here we have to set the baudrate for the portdriver */

	    set_port.dp_unitno = pb->dp_option;	/* subdrivers unit number */
	    set_port.dp_option = 0;
	    set_port.dp_flags  = 0;			/* system address space	*/
	    set_port.dp_swi    = 0;			/* must be 0		*/
	    set_port.dp_pdaddr = pb->dp_pdaddr;
	    set_port.dp_buffer = (BYTE *) &port_table;	/* new port values */
	    set_port.dp_bufsiz = (LONG)sizeof(PORT_TBL) -2;	/* size of buffer  */
	    set_port.dp_offset = 0;
	    set_port.dp_parm7  = 0;
	    set_port.dp_parm8  = 0;
	    return (dvrif(pt_hdr[unit],pt_hdr[unit]->dh_set, &set_port) );
	}
}

/************************************************************************/
/*      mouse_uninit                                                    */
/*	call on driver un-link mouse:					*/
/************************************************************************/

LONG    mouse_uninit(unitno)
        LONG	unitno;
{
        DPB     pb;
	BYTE	unit;

	unit = (BYTE)unitno;
        if (unit > MAXsUNIT) return( E_IllUnitno );

        pb.dp_unitno = pt_unit[unit];

	/* lets point the ASR call in the interrupt routine to a dummy ret */

	con_dle[unit]   = 0L;			/* reinitialize the pointer */
	mmove_pin[unit] = m_asrdummy;		/* to an  ASR dummy routine */
	mbut_pin[unit]  = m_asrdummy;		/* instead of dorat and ratbut */
        return ( dvrif(pt_hdr[unit],pt_hdr[unit]->dh_flush,&pb) );
}

/************************************************************************/
/*      mouse_select                                                    */
/*	called on "open mouse" or "select mouse" call			*/
/*	the calling routine passes down addresses for  the move and 	*/
/*	button ASR's. (dorat and ratbut)				*/
/*	initialise the interrupt for the port driver and pass down the 	*/
/*	address of the interrupt service routine for received chars	*/
/************************************************************************/

LONG    mouse_select(pb)

        CDSELECT	*pb ;
{
        BYTE    unitno,sunit;
	
        unitno = pb->cdse_unit ;
        if (unitno > MAXsUNIT) return( E_IllUnitno );

	mouse.y = mouse.y_max /2;	/* set default values */
	mouse.x = mouse.x_max /2;
	mouse.but = 0;

	sunit = pt_unit[unitno];

	if ( pb->cdse_mouse != 0L )	/* Test if ASR pointer is passed */
	    mmove_pin[unitno] = (PINPTR) pb->cdse_mouse;	/* mouse ASR */
	else
	    mmove_pin[unitno] = (PINPTR) m_asrdummy;	/* mouse ASR dummy */

	if ( pb->cdse_but != 0L )	/* Test if ASR pointer is passed */
	    mbut_pin[unitno] = (PINPTR) pb->cdse_but;	/* mouse ASR */
	else
	    mbut_pin[unitno] = (PINPTR) m_asrdummy;	/* mouse ASR dummy */

	con_dle[unitno] = pb->cdse_pconid;	/* save console DLE address */

        /* call the sub-drivers select routine */
        pb->cdse_unit = sunit ;			/* subdriver unit number */
        pb->cdse_kbd = (LONG) mous_interpt ;	/* address of mouse ISR */

        return( dvrif(pt_hdr[unitno],pt_hdr[unitno]->dh_select,pb) );
}

/************************************************************************/
/*      mouse_flush                                                     */
/*	called on close mouse: call					*/
/*	deinitialise the interrupt for the port driver			*/
/************************************************************************/

LONG    mouse_flush(pb)
        DPB     *pb;
{
        LONG    r;
	BYTE	unit, sunit;

	r = 0L ;
	unit = pb->dp_unitno;
        if (unit > MAXsUNIT) return( E_IllUnitno );
				/* call the sub-drives flush(this unitno) */
	pb->dp_unitno = sunit = pt_unit[unit];
	if (!(pb->dp_option & 1))			/* on last close */
	{
	    con_dle[unit]   = 0L;		/* reinitialize the pointer */
	    mmove_pin[unit] = m_asrdummy;	/* to an  ASR dummy routine */
	    mbut_pin[unit]  = m_asrdummy;	/* instead of dorat and ratbut */
	    r = dvrif(pt_hdr[unit],pt_hdr[unit]->dh_flush,pb);
	}
        return( r );
}

/************************************************************************/
/*      mous_rd - no read necessary, only get and set 			*/
/************************************************************************/
LONG mous_rd( pb )
	DPB	*pb ;
{
	pb->dp_offset = 0L;	/* buffsize = 0 */
	return(E_SUCCESS);
}

/************************************************************************/
/*      mous_wrt - no write to the mouse.                              */
/************************************************************************/
LONG	mous_wrt( pb )
	DPB	*pb;
{
	pb->dp_offset = 0L;	/* buffsize = 0 */
	return (E_SUCCESS);
}

/************************************************************************/
/*      mous_get -   return the status of the mouse			*/
/************************************************************************/

LONG	mous_get(pb)
	DPB	*pb;
{
	BYTE	unit;
	WORD	*buff, *mouse_ptr;
	WORD	i;

	unit = pb->dp_unitno;
        if (unit > MAXsUNIT) return( E_IllUnitno );

	mouse_ptr = (WORD *)&mouse;	/* make it a byte pointer to struct */
	buff = (WORD *)pb->dp_buffer;
	if (pb->dp_flags & DPF_UADDR)
		buff = (WORD *) SADDR(buff);
	if (pb->dp_bufsiz > sizeof (MOUSE_TBL))
		pb->dp_bufsiz = sizeof (MOUSE_TBL);
	i = ((WORD)pb->dp_bufsiz -2 ) / 2;			/* make i a word pointer */

	switch (pb->dp_bufsiz)
	{
	    case 24:	buff[i] = mouse_ptr[i];	i--;

	    case 23:
	    case 22:	buff[i] = mouse_ptr[i];	i--;

	    case 21:
	    case 20:	buff[i] = mouse_ptr[i];	i--;

	    case 19:
	    case 18:	buff[i] = mouse_ptr[i];	i--;

	    case 17:
	    case 16:	buff[i] = mouse_ptr[i];	i--;

	    case 15:
	    case 14:	buff[i] = mouse_ptr[i];	i--;

	    case 13:
	    case 12:	buff[i] = mouse_ptr[i];	i--;

	    case 11:
	    case 10:	buff[i] = mouse_ptr[i];	i--;

	    case 9:
	    case 8:	buff[i] = mouse_ptr[i];	i--;

	    case 7:
	    case 6:	buff[i] = mouse_ptr[i];	i--;

	    case 5:
	    case 4:	buff[i] = mouse.x_max; i--;

	    case 3:
	    case 2:	buff[i] = mouse.y_max / mouse.scale_y;

	    case 1: 		
	    case 0:	 break;

	    default:	 return(E_RECSIZE);
	}

	return (E_SUCCESS);
}

/************************************************************************/
/*      mous_set -  the new parameters for the mouse 			*/
/************************************************************************/

LONG	mous_set(pb)
	DPB	*pb;
{
	BYTE	unit;
	WORD	*buff, *mouse_ptr;
	WORD	i;

	unit = pb->dp_unitno;
        if (unit > MAXsUNIT) return( E_IllUnitno );

	mouse_ptr = (WORD *)&mouse;		/* make it a byte pointer */
	buff = (WORD *)pb->dp_buffer;
	if (pb->dp_flags & DPF_UADDR)
		buff = (WORD *) SADDR(buff);

	if (pb->dp_bufsiz > sizeof (MOUSE_TBL))
		pb->dp_bufsiz = sizeof (MOUSE_TBL);

	i = ((WORD)pb->dp_bufsiz -2) / 2;	/* make i a word pointer */

	switch (pb->dp_bufsiz)
	{
	    case 24:	mouse_ptr[i] = buff[i];	i--;

	    case 23:
	    case 22:	mouse_ptr[i] = buff[i];	i--;

	    case 21:
	    case 20:	mouse_ptr[i] = buff[i];	i--;

	    case 19:
	    case 18:	mouse_ptr[i] = buff[i];	i--;

	    case 17:
	    case 16:	mouse_ptr[i] = buff[i];	i--;

	    case 15:
	    case 14:	mouse_ptr[i] = buff[i];	i--;

	    case 13:
	    case 12:	mouse_ptr[i] = buff[i];	i--;

	    case 11:
	    case 10:	mouse_ptr[i] = buff[i];	i--;

	    case 9:
	    case 8:	mouse_ptr[i] = buff[i];	i--;

	    case 7:
	    case 6:	mouse_ptr[i] = buff[i];	i--;

	    case 5:
	    case 4:	mouse.x_max = buff[i]; i--;

	    case 3:
	    case 2:	mouse.y_max = buff[i];

	    case 1: 		
	    case 0:	 break;

	    default:	 return(E_RECSIZE);
	}

	if (mouse.y_max < 201)
	{
	    mouse.scale_y = 2;
	    mouse.y_max = mouse.y_max * 2;	/* mutiply by scale */
	}
	else
	    mouse.scale_y = 1;
	return (E_SUCCESS);
}

/************************************************************************/
/*      mouse_special                					*/
/************************************************************************/
	 	
LONG	mouse_special(pb)
	DPB	*pb;
{
	BYTE	unit;

    if ( (pb->dp_option & 0x7F) == 0x13 )
    {			/** Call a PORT driver to Get/Set table **/
	if ( (unit = pb->dp_unitno) > MAXsUNIT ) return(E_IllUnitno);
	pb->dp_unitno = pt_unit[unit];
	return( dvrif(pt_hdr[unit],pt_hdr[unit]->dh_special,pb) );
    }
    return(ED_CON | E_IMPLEMENT);
}

/************************* end of main routines *****************************/

/************************* start of sub-routines ****************************/

VOID	mous_interpt(ch,unitno)    /* called in ISR context by Port Driver */
	LONG	ch;		    /* mouse input interrupt via pin addr */
	LONG	unitno;
{
	register WORD	mchar ;
	BYTE	unit;
#if LOADABLE
	LONG	oldds;
#endif

	unit = (BYTE) unitno;

#if LOADABLE
	oldds = fix_ds(NULLPTR);
#endif
	if ( ((mchar = (WORD) ch ) & 0xF8) == 0x80)
	{				/* first mchar is button state */
	    byte_count = 1;
	    new_but = but_table[mchar & 0x7];
	}
	else
	{
	    if (mchar & 0x80) 
		mchar = mchar | 0xFF00;		/* if negativ make it 16 bit */
	    switch (byte_count++)
	    {
		case 1:	delta_x  = mchar;
		    break;
		case 2:	delta_y  = mchar;
		    break;
		case 3:	if ((delta_x += mchar) >= 0)
			    mouse.x += (delta_x < mouse.double_x)
						? delta_x : (delta_x << 2);
			else
			    mouse.x += (delta_x >= -mouse.double_x)
						? delta_x : (delta_x << 2);
			if (mouse.x < 0) mouse.x = 0;
			else
			    if (mouse.x > mouse.x_max) mouse.x = mouse.x_max;
		    break;
		case 4:
			if ((delta_y += mchar) >=0)
			    mouse.y -= (delta_y < mouse.double_y)
						? delta_y : (delta_y << 2);
			else
			    mouse.y -= (delta_y >= -mouse.double_y)
						? delta_y : (delta_y << 2);

			if (mouse.y < 0) mouse.y = 0;
			else
			    if (mouse.y > mouse.y_max) mouse.y = mouse.y_max;


			if ( new_but != mouse.but )
			{
			    mouse.but = new_but;
				/* call button ASR */
			    doasr(mbut_pin[0], con_dle[0],
					(LONG) new_but, (BYTE)200);
			}
			else if ( (delta_x | delta_y) != 0)
			{
				/* call dorat ASR  */

			  if (mouse.scale_y == 2)
			    doasr(mmove_pin[0],((LONG)(mouse.y >> 1) << 16) |
					mouse.x, con_dle[0],(BYTE)200);
			  else
			    doasr(mmove_pin[0],((LONG) mouse.y << 16) |
					mouse.x, con_dle[0],(BYTE)200);
			}
		    break;
		default: byte_count = 0;
	    }  /* end switch */
	}

#if LOADABLE
	fix_ds(oldds);
#endif
}

VOID m_asrdummy()
{			/* dummyroutine for ASR calls if they 
			    are not initialiesed */
	return;
}

#if LOADABLE		/* if this driver will be loaded from a diskfile */
			/* when needed, then we need a _bmove tool	*/
VOID	_bmove(s,d,size)
	BYTE	*s;
	BYTE	*d;
	WORD	size;
{
	while (size--) *d++ = *s++;
}

#endif	/* LOADABLE */

