/*****************************************************************
 * "Copyright (C) 1985, Digital Research, Inc.  All Rights       *
 * Reserved.  The Software Code contained in this listing is     *
 * proprietary to Digital Research Inc., Monterey, California    *
 * and is covered by U.S. and other copyright protection.        *
 * Unauthorized copying, adaptation, distribution, use or        *
 * display is prohibited and may be subject to civil and         *
 * criminal penalties.  Disclosure to others is prohibited.  For *
 * the terms and conditions of software code use refer to the    *
 * appropriate Digital Research License Agreement."              *
 *****************************************************************/

/*===============================================================*
 *   Version 1.1        FMTLIB.C				 *
 *                      Library of floppy formats.		 *
 *---------------------------------------------------------------*
 *    VERSION   DATE    BY      CHANGE/COMMENTS                  *
 *---------------------------------------------------------------*
 *                                                               *
 *	1.1    5/09.86 DR-K	modified for MetaWare compiler	 *
 *	1.0   04/10/85	jsr					 *
 *                                                               *
 *===============================================================*/

/* This module contains the library of built-in formats and thier	     */
/* initialization routine.						     */

#include	"portab.h"
#include	"concur.h"
#include	"format.h"

/* cast local procedures */

VOID fmlibint();

/* declare externals */
							    /* from BOOT.OBJ */
union	{				/* The following union is an effort to	*/
     VOID	(*bootcode)();		/* case the bootloader code into a data	*/
     BOOTREC	*bitimage;		/* block pointer (kludge)		*/
} bootimage;

EXTERN	VOID	lbase();

/* declare (allocate and initialize) global variables */

					    /* Library of FMTINFO structures */
FMTINFO	fmtlib[] = {
  { 2, (LONG)640, 8, 512,
    1, STARTSEC, DOSLIST, UWNULLPTR, 0, (LONG)0, 1,
    2, 2, 1, 112, (LONG)0, DBL_DEN, DFM_DOS1,
    0xff, 0xf6, NULLPTR, MRNULLPTR, BRNULLPTR, -1, -1 },

  { 1, (LONG)320, 8, 512,
    1, STARTSEC, DOSLIST, UWNULLPTR, 0, (LONG)0, 1,
    1, 2, 1, 64, (LONG)0, DBL_DEN, DFM_DOS1,
    0xfe, 0xf6, NULLPTR, MRNULLPTR, BRNULLPTR, -1, -1 },

  { 2, (LONG)720, 9, 512,
    1, STARTSEC, DOSLIST, UWNULLPTR, 0, (LONG)0, 1,
    2, 2, 2, 112, (LONG)0, DBL_DEN, DFM_DOS1,
    0xfd, 0xf6, NULLPTR, MRNULLPTR, BRNULLPTR, -1, -1 },

  { 1, (LONG)360, 9, 512,
    1, STARTSEC, DOSLIST, UWNULLPTR, 0, (LONG)0, 1,
    1, 2, 2, 64, (LONG)0, DBL_DEN, DFM_DOS1,
    0xfc, 0xf6, NULLPTR, MRNULLPTR, BRNULLPTR, -1, -1 },

  { 2, (LONG)2400, 15, 512,
    1, STARTSEC, DOSLIST, UWNULLPTR, 0, (LONG)0, 1,
    1, 2, 7, 224, (LONG)0, DBL_DEN, DFM_DOS1,
    0xf9, 0xf6, NULLPTR, MRNULLPTR, BRNULLPTR, -1, -1 }
};

/* fmlibint() : Initialization routine for above library of formats */

VOID fmlibint()
{

    WORD	i;

    for(i = 0; i < NUMFMTS; ++i) {
	if(fmtlib[i].fi_lstflg == STARTSEC)
	    fmtlib[i].fi_interleave = &fmtlib[i].fi_startsec;
	bootimage.bootcode = lbase;
	fmtlib[i].fi_bimage = bootimage.bitimage;
    }
}
