/*****************************************************************
 * "Copyright (C) 1985, Digital Research, Inc.  All Rights       *
 * Reserved.  The Software Code contained in this listing is     *
 * proprietary to Digital Research Inc., Monterey, California    *
 * and is covered by U.S. and other copyright protection.        *
 * Unauthorized copying, adaptation, distribution, use or        *
 * display is prohibited and may be subject to civil and         *
 * criminal penalties.  Disclosure to others is prohibited.  For *
 * the terms and conditions of software code use refer to the    *
 * appropriate Digital Research License Agreement."              *
 *****************************************************************/

/*===============================================================*
 *   Version 1.2        SYS.C	                      		 *
 *                      Main shell for system transfer utility   *
 *---------------------------------------------------------------*
 *    VERSION   DATE    BY      CHANGE/COMMENTS                  *
 *---------------------------------------------------------------*
 *                                                               *
 *	1.2    5/09/86	DR-K	modified for MetaWare compiler	 *
 *	1.1   08/06/85	jsr	Added CRLF, DOSERR and 68K stuff.*
 *	1.0   03/22/85  jsr	                                 *
 *                                                               *
 *===============================================================*/
/*									     */
/* Command line syntax:							     */
/* SYS todisk: [[fromdisk:][path\filename]]				     */
/*									     */
#include	"portab.h"
#include	"concur.h"
#include	"ccutls.h"
#include	"sysut.h"

/* SYSMSGS.C */
EXTERN	BYTE	sy0000[], sy0002[];

/* Globals */
BYTE		sysldd[DEVMAX];			 /* logical dest device name */
BYTE		syslsd[DEVMAX];		       /* logical source device name */
BYTE		syssf[SPECMAX];			         /* system file spec */
MCB		sysmcb;				    /* Message Control Block */
jumpbuff	sysjbf;		      /* error bailout transfer control info */

/* Locals */
VOID	sysinit(), syserrhnd();

/* start of code */
LONG utlmain(rawtail)
BYTE	*rawtail;
{

    BYTE	tail[BUFSIZ];

    if( (sysmcb.retcode = utstjmp(sysjbf)) !=0)	     /* set error abort info */
    {
	uterrmsg(&sysmcb, STDERR, FATAL);
	goto bailout;
    }

    utt1(rawtail, tail);				  /* discard garbage */
    sysinit(tail);		/* parse command tail and perform main setup */

    if( (sysmcb.utilcode = utxfrsys(sysldd,syslsd,syssf,&sysmcb)) !=0)
	syserrhnd((sysmcb.utilcode+XFERROFF), sysmcb.dosfunc, sysmcb.retcode);

    sysmcb.retcode = UR_SUCCESS;

bailout:
    s_write(WRF_END, STDOUT, crlfmsg, utslen(crlfmsg), 0L);

    if(sysmcb.retcode < 0)
	sysmcb.retcode = (UR_SOURCE | UR_DOSERR);

    return(sysmcb.retcode);
}

/* sysinit() : initialize variables etc, and parse command tail */
VOID sysinit(tail)
BYTE	*tail;
{
    BYTE	*ptr;
    DEFINE	ldef;

							   /* set up the MCB */
    utintmcb(&sysmcb,sy0000,nullstr,nullstr,nullstr,nullstr);
					    /* get "default:" logical device */
    if((sysmcb.retcode =
      utgtdf(defname, &ldef, GDLITR, &sysmcb)) < 1)
	    syserrhnd(SYERR001, sysmcb.dosfunc, sysmcb.retcode);

    ptr = (BYTE *)(ldef.def_prefix + utslen(ldef.def_prefix));
    while((ptr > ldef.def_prefix) && (*ptr != devdelim))
	--ptr;
    *++ptr = NULL;

					  /* parse the DEST device from tail */
    ptr = utstdv(tail, sysldd, ldef.def_prefix, MANDATORY, &sysmcb);
    if(sysmcb.utilcode)
	syserrhnd((sysmcb.utilcode + SDERROFF), 0, (UR_SOURCE | UR_PARM));
			       /* parse the SOURCE device from tail (if any) */
    ptr = utstdv(utskpwht(ptr), syslsd, ldef.def_prefix, OPTIONAL, &sysmcb);
    if(sysmcb.utilcode)
	syserrhnd((sysmcb.utilcode + SDERROFF), 0, (UR_SOURCE | UR_PARM));
					       /* set up the SOURCE filespec */
    syssf[0] = NULL;
    if(*ptr)
	strcat(syssf, ptr);			       /* use any given name */
}

/* syserrhnd() : fatal error handler (message formation) */
VOID syserrhnd(uc, df, rcl)
REG WORD	uc;
REG WORD	df;
LONG		rcl;
{
    REG	WORD	code;

    switch(uc)
    {
	case SYERR010:
	case SYERR011:
	case SYERR012:
	case SYERR016:
	case SYERR017:
	case SYERR018:
	case SYERR019:
	case SYERR022:
	case SYERR028:
	case SYERR029:
	    code = UE_DEVONLY;
	    break;

	default:
	    code = UE_DEVFIL;
	    break;
    }

    sysmcb.pptr[PARM8] = cc0500[HLVL3];

    switch(df)
    {
	case 0:
	    switch(uc)
	    {
		case SYERR004:			     /* sysfile format error */
		    utstmcb(&sysmcb, cc0810, uc, df, (UR_SOURCE|UR_FORMAT));
		    break;

		case SYERR007:
		    utstmcb(&sysmcb, cc0413, uc, df, (UR_SOURCE|UR_PARM));
		    break;

		case SYERR009:
		    sysmcb.pptr[PARM6] = cc0443;
		    sysmcb.pptr[PARM7] = cc0455;
		    sysmcb.pptr[PARM5] = cc0430[HLVL3];
		    utstmcb(&sysmcb, cc0430, uc, df, (UR_SOURCE|UR_PARM));
		    break;

		case SYERR012:
		    sysmcb.pptr[PARM5] = cc0811[HLVL3];
		    utstmcb(&sysmcb, cc0811, uc, df, (UR_SOURCE|UR_FORMAT));
		    break;

		case SYERR021:
		    sysmcb.pptr[PARM6] = cc0490;
		    sysmcb.pptr[PARM5] = cc0812[HLVL3];
		    utstmcb(&sysmcb, cc0812, uc, df, (UR_SOURCE|UR_FORMAT));
		    break;

		case SYERR022:
		    sysmcb.pptr[PARM5] = cc0813[HLVL3];
		    utstmcb(&sysmcb, cc0813, uc, df, (UR_SOURCE|UR_FORMAT));
		    break;

		case SYERR028:
		    sysmcb.pptr[PARM6] = cc0440;
		    sysmcb.pptr[PARM7] = cc0450;
		    sysmcb.pptr[PARM5] = cc0430[HLVL3];
		    utstmcb(&sysmcb, cc0430, uc, df, (UR_SOURCE|UR_PARM));
		    break;

		case SYERR029:
		    sysmcb.pptr[PARM6] = cc0446;
		    sysmcb.pptr[PARM7] = sy0002;
		    sysmcb.pptr[PARM5] = cc0431[HLVL3];
		    utstmcb(&sysmcb, cc0431, uc, df, (UR_SOURCE|UR_PARM));
		    break;

		default:
		    utstmcb(&sysmcb, nullmsg, uc, df, (UR_SOURCE|UR_INTERNAL));
		    break;

	    }
	    break;

	case S_GET:
	case S_LOOKUP:
	    utegtlk(&sysmcb, sysmcb.pptr[PARM1], sysmcb.pptr[PARM2], code);
	    break;

	case S_SET:
	    uteset(&sysmcb);
	    break;

	case S_OPEN:
	case S_CREATE:
	    utecrop(&sysmcb, sysmcb.pptr[PARM1], sysmcb.pptr[PARM2], code);
	    break;

	case S_READ:
	case S_WRITE:
	    uterw(&sysmcb, sysmcb.pptr[PARM1], sysmcb.pptr[PARM2], code);
	    break;

	case S_MALLOC:
	    utemaloc(&sysmcb);
	    break;

	case S_MFREE:
	    utemfree(&sysmcb);
	    break;

	default:
	    utstmcb(&sysmcb, nullmsg, uc, df, (UR_SOURCE | UR_INTERNAL));
	    break;
    }

    utfarjmp(sysjbf, rcl);

}
/* */
