/*****************************************************************
 * "Copyright (C) 1985, Digital Research, Inc.  All Rights       *
 * Reserved.  The Software Code contained in this listing is     *
 * proprietary to Digital Research Inc., Monterey, California    *
 * and is covered by U.S. and other copyright protection.        *
 * Unauthorized copying, adaptation, distribution, use or        *
 * display is prohibited and may be subject to civil and         *
 * criminal penalties.  Disclosure to others is prohibited.  For *
 * the terms and conditions of software code use refer to the    *
 * appropriate Digital Research License Agreement."              *
 *****************************************************************/

/*===============================================================*
 *   Version 1.0        IFDMA.H                                  *
 *                      DMA addresses and defines.               *
 *---------------------------------------------------------------*
 *    VERSION   DATE    BY      CHANGE/COMMENTS                  *
 *---------------------------------------------------------------*
 *    1.0       6/12/85 reb     rewritten/added to system        *
 *                                                               *
 *                                                               *
 *===============================================================*
 *  INCLUDES:                                                    */

/************************************************************************  
*                               xmachine (pc at) 
*                               dma header file
*************************************************************************/

/***********************************************************************
*  dma equates
*/

#define DMMAXCOUNT      0x10000         /*  max count value for dma (64K) */

#define DMC2ADDR        0x04            /*  dma ch 2 address reg        */
#define DMC2COUNT       0x05            /*  dma ch 2 count reg          */
#define DMSTAT          0x08            /*  dma status reg              */
#define DMCMD           DMSTAT          /*  dma command reg             */
#define DMREQ           DMSTAT+1        /*  dma request reg             */
#define DMBMASK         DMSTAT+2
#define DMMODE          DMSTAT+3
#define DMCBPF          DMSTAT+4
#define DMTEMP          DMSTAT+5
#define DMCLEAR         DMSTAT+5
#define DMMASK          DMSTAT+7

#define DMPAGEFDC       0x81            /*  fdc page register for dma   */
#define DMM_WRITE       0x4a            /*  write to floppy             */
#define DMM_READ        0x46            /*  read from floppy            */
#define DMB_FDCMASK     0x02            /*  fdc binary channel mask     */
/* (reb) add verify mode */
#define DMM_VFY         0x42            /* verify mode                  */
