
/*****************************************************************
 * "Copyright (C) 1985, Digital Research, Inc.  All Rights       *
 * Reserved.  The Software Code contained in this listing is     *
 * proprietary to Digital Research Inc., Monterey, California    *
 * and is covered by U.S. and other copyright protection.        *
 * Unauthorized copying, adaptation, distribution, use or        *
 * display is prohibited and may be subject to civil and         *
 * criminal penalties.  Disclosure to others is prohibited.  For *
 * the terms and conditions of software code use refer to the    *
 * appropriate Digital Research License Agreement."              *
 *****************************************************************/

/*===============================================================*
 *   Version 1.0        SPLDRV.H                                 *
 *                      Header file for the spool driver modules.*
 *---------------------------------------------------------------*
 *    VERSION  DATE     BY      CHANGE/COMMENTS                  *
 *---------------------------------------------------------------*
 *    1.0      3/10/86  LDT     1st intro into the FlexOS system.  *
 *    1.1      7/08/86  Lin	Modified for Metaware conversion *
 *                                                               *
 *===============================================================*/

#define STATUS  struct _status  /* Job status message       */
#define MSG     struct _msg     /* SPOOLER message          */
#define JOB     struct _job     /* Spool job entry          */
#define DSPOOL  struct _despool /* DSPL list entry          */
#define SFE     struct _sfe     /* SFE list entry           */
#define PROCESS struct _process /* Process table            */
#define FILE    struct _file    /* Disk file table          */
#define PINFO   struct _pinfo   /* Proccess info. structure */

   /* Format attributes */
#define FMT_RAW      0x01   /* Raw print                */
#define FMT_FORM     0x02   /* Form feeds               */
#define FMT_TAB      0x04   /* Expand tabs              */
#define FMT_HEAD     0x08   /* Page headers             */

   /* Message flags*/
#define MF_DSPL      0x00   /* 0 - DSPL sent message    */
#define MF_SFE       0x01   /* 1 - SFE sent message     */
#define MF_STATUS    0x02   /* Status request flag      */
#define MF_DELETE    0x04   /* Delete file after print  */

   /* Message types */
#define MT_INIT      0x0001 /* Initialize sfe entry         */
#define MT_PRINT     0x0002 /* Print a file                 */
#define MT_CANCEL    0x0004 /* Cancel a job                 */
#define MT_TERMINATE 0x0008 /* Terminate SPOOLER            */
#define MT_STATUS    0x0010 /* Return job status            */
#define MT_DINIT     0x0020 /* De-initialize sfe entry      */
#define MT_HOTJOB    0x0040 /* Hot job print request        */
#define MT_LOAD      0x0080 /* Load PLD file jobs in memory */

   /* Spooler return codes */
#define MT_ACK      0x0001 /* DESPOOL job acknowledgement  */
#define MT_HEADER   0x0002 /* Header record return         */
#define MT_MEMORY   0x4000 /* Spooler out of memory return */
#define MT_ERROR    0x8000 /* Error return                 */

   /* Job status */
#define JS_QUEUED   0x0001 /* Job is queued for printing */
#define JS_PRINT    0x0002 /* Job is currenty printing   */
#define JS_COMPLETE 0x0004 /* Completed print job        */
#define JS_ERROR    0x0008 /* DESPOOL error              */
#define JS_OFFLINE  0x0010 /* Printer offline            */

   /* Despooler status flags */
#define DSP_FREE     0x00  /* Despooler free               */
#define DSP_INUSE    0x01  /* Despooler in use             */
#define DSP_OFFLINE  0x02  /* Despooler printer is offline */
#define DSP_UNINIT   0x04  /* Despooler not initialized    */

    /* Print status flags */
#define SPL_PRIOR  200   /* Spooler process priority */
#define PRN_OPT  0x0001  /* Print option             */
#define CAN_OPT  0x0002  /* Cancel option            */
#define TERM_OPT 0x0004  /* Terminate option         */
#define HOT_OPT  0x0008  /* Hot job option           */
#define LD_OPT   0x0010  /* Load PLD file option     */
#define T_NAME	 0x63	 /* Name table		     */
#define N_LOCAL  0x80    /* Local Name		     */
#define E_DOS	 0x4400L /* it's a PC-DOS node	     */

    /* Misc */
#define MAXREQMEM    512        /* Maximum memory needed for a request  */
#define MAXBUFLEN    512L  
#define DSP_PRIOR    200        /* Despooler process priority           */
#define HOTJOB       1          /* Hotjob jobadd() hardcode parm        */
#define POOLSIZ   MAXPOOL+MAXREQMEM /* Mem pool size with safety buffer */
#define T_LOGON	  0x62
#define WAIT_TIME    180000L    /* Wait time(msec) for spooler s_exit() */

#define UPCASE(ch)   ( (ch >= SMALLa && ch <= SMALLz) ? (ch - 0x20) : ch )

/* Note well: MSG structure must be congruent with STATUS structure
   and with all but the first 4 bytes of the JOB structure, since the
   spooler programs freely write one kind of structure and read
   another.  Sigh.                            -DAB 12/18/85
*/
MSG /* Message format */
{
        UBYTE msg_len;        /* Message length               */
        UBYTE msg_flags;      /* Message flags byte           */
        UWORD msg_type;       /* Message type                 */

        UWORD msg_fmt;        /* Print format                 */
        UBYTE msg_uid;        /* Job owner user id            */
        UBYTE msg_gid;        /* Job owner group id           */

        UWORD msg_jid;        /* Job id                       */
        UBYTE msg_nc;         /* # of copies                  */
        UBYTE msg_plen;       /* Page length                  */

        WORD  msg_stat;       /* Message status               */
        UBYTE msg_pwid;       /* Page width                   */
        UBYTE msg_dsp;        /* Despooler id                 */
        UBYTE msg_sfe;        /* Spooler front end id         */
        char  pad;            /* dummy, for even alignment    */
        UBYTE msg_name[10];   /* User name from procdef table */
        UBYTE msg_dev[32];    /* Target device name           */
        UBYTE msg_fspec[128]; /* File spec. or mbox name      */
};

JOB /* Spool job entry format */
{
        JOB   *job_link;     /* Next job in list             */
        /* Note well: the rest of the JOB structure must be congruent with
           STATUS structure and the MSG structure, since the spooler programs
           freely write one kind of structure and read another. Sigh.
                                                            -DAB 12/18/85
        */

        UBYTE job_len;       /* Job message length           */
        UBYTE job_flags;     /* Job flags                    */
        UWORD job_cmd;       /* Despooler command            */

        UWORD job_fmt;       /* Print format                 */
        UBYTE job_uid;       /* Job owner user id            */
        UBYTE job_gid;       /* Job owner group id           */

        UWORD job_id;        /* Job unique id                */
        UBYTE job_nc;        /* # of copies                  */
        UBYTE job_cd;        /* # of copies done             */

        WORD  job_prior;     /* Job priority                 */
        UBYTE job_stat;      /* Job status                   */
        UBYTE job_dsp;       /* Despooler id                 */
        UBYTE job_sfe;       /* Spooler front end id         */
        char  pad;           /* dummy, for even alignment    */
        UBYTE job_name[10];  /* User name from procdef table */
        UBYTE job_dev[32];   /* Target device name           */
        UBYTE job_fspec[128];/* File spec.                   */
};


/* Note well: STATUS structure must be congruent with MSG structure
   and with all but the first 4 bytes of the JOB structure, since the
   spooler programs freely write one kind of structure and read
   another.  Sigh.                            -DAB 12/18/85
*/
STATUS
{
        UBYTE st_len;        /* Status message length      */
        UBYTE st_flags;      /* Status flags               */
        UWORD st_type;       /* Unused                     */

        UWORD st_fmt;        /* Unused                     */
        UBYTE st_uid;        /* Unused                     */
        UBYTE st_gid;        /* Unused                     */

        UWORD st_dcnt;       /* Dspl record returned count */
        UWORD st_jcnt;       /* Jobs returned count        */

        WORD  st_prior;      /* Unused                     */
        UWORD st_size;       /* Size of status pipe        */
        UBYTE st_fill;       /* Unused                     */
        char  pad;           /* dummy, for even alignment  */
        UBYTE st_res[10];    /* Reserved                   */
        UBYTE st_dev[32];    /* Unused                     */
        UBYTE st_fspec[128]; /* Status pipe pathname       */
};

DSPOOL /* Despool status entry format */
{
        DSPOOL *dsp_link;   /* Despooler link list       */
        JOB    *dsp_job;    /* Despooler job list        */
        JOB    *dsp_ljob;   /* Last job on list          */
        LONG   dsp_fn;      /* Despooler mbox filenumber */
        BOOLEAN dsp_permanent;  /* flag set if despooler permanently resident */
        UWORD /*LONG*/ dsp_pid; /* Despooler process id (never used) */
         /* note: dsp_pid is not filled in for permanently resident despooler */
         /* Note2: The Process ID, of course, is 32 bits.  Since we don't ever
            actually use this field, I stole half of it for the `dsp_permanent'
            field.  Thus, dsp_pid only contains the low half of the PID.  -DAB
         */
        UWORD  dsp_jcnt;    /* Despooler job count       */
        UBYTE  dsp_id;      /* Despooler id              */
        UBYTE  dsp_ucnt;    /* Despooler user count      */
        UBYTE  dsp_stat;    /* Despooler status          */
        UBYTE  dsp_dev[32]; /* Device name               */
};

SFE /* Spooler Front End entry */
{
        SFE   *sfe_link; /* SFE link list            */
        LONG  sfe_fn;    /* SFE mbox open filenumber */
        UBYTE sfe_id;    /* SFE unique id            */
        UBYTE sfe_dsp;   /* SFE despooler id         */
};

PROCESS /* Process table entry format */
{
        LONG  pt_pid;      /* Process id         */
        UWORD pt_fid;      /* Family id          */
        UBYTE pt_cid;      /* Console id         */
        UBYTE pt_vcid;     /* Virtual console id */
        BYTE  pt_name[10]; /* Process name       */
};

FILE /* Disk file table entry format */
{
        LONG  df_lookid;   /* lookup ID */
        UBYTE df_name[18]; /* file name */
};

PINFO
{
        BYTE pi_pname[10];
        BYTE pi_prior;
        BYTE pi_fill;
        LONG pi_maxmem;
        LONG pi_addmem;
};

#define DEVICE struct _device
DEVICE
{
        LONG  dev_key;
        BYTE  dev_name[10];
        UWORD dev_type;
        UWORD dev_access;
};

#define TIMEDATE struct _timedate
TIMEDATE
{
        WORD td_year;
        BYTE td_month;
        BYTE td_day;
        LONG td_time;
};

#define ENVIRON struct _environment
ENVIRON
{
        LONG  en_stdin;
        LONG  en_stdout;
        LONG  en_stderr;
        LONG  en_stdovr;
        UWORD en_security;
        UWORD en_res;
        BYTE  en_user;
        BYTE  en_group;
        WORD  en_fid;
        LONG  en_pid;
        WORD  en_rnid;
        WORD  en_rfid;
        LONG  en_rpid;
};

#define DISKFILE struct _diskfile
DISKFILE
{
        LONG df_key;
        BYTE df_name[18];
        WORD df_attrib;
        WORD df_recsize;
        BYTE df_user;
        BYTE df_group;
        WORD df_protect;
        BYTE df_reserved[6];
        LONG df_size;
        WORD df_mdyear;
        BYTE df_mdmonth;
        BYTE df_mdday;
        BYTE df_mdhr;
        BYTE df_mdmin;
        BYTE df_mdsec;
        BYTE df_rsrvd;
};

#define NETNAME	struct	_netname
NETNAME
{
	LONG	nn_key;
	UWORD	nn_flags;
	UWORD	nn_alen;
	BYTE	nn_name[16];
	BYTE	nn_addr[16];
};

#define LOGON	struct	_logon
LOGON
{
	LONG	lo_key;
	BYTE	lo_node[16];
	UBYTE	lo_user;
	UBYTE	lo_group;
	UWORD	lo_rsvd;
	BYTE	lo_uname[32];
	BYTE	lo_passw[32];
};

#define	PBLK	struct 	_pblkstruct
PBLK			
{
	BYTE	pa_mode;	/* See Mode Flags below		*/
	BYTE	pa_option;	/* Byte Parameter		*/
	UWORD	pa_flags;	/* See Flags below		*/
	BYTE	*pa_swi;	/* Software Interrupt Routine	*/
	LONG	pa_id;		/* usually File Number or Name	*/
	LONG	pa_buf;		/* Buffer Checking done on buf	*/
	LONG	pa_bsiz;	/*	and bsiz if necessary	*/
};

#define PTSIZE ((LONG)sizeof(PROCESS)) /* Size of proc. table        */
#define LENFT  ((LONG)sizeof(FILE))    /* Size of disk file table    */
#define DSIZE  ((LONG)sizeof(DEVICE))  /* Size of device table entry */
#define MSIZE  (sizeof(MSG))           /* Size of message buffer     */
#define JSIZE  (sizeof(JOB))           /* Size of job buffer         */
        /* Message box access flags */


#define SFE_READ   0                 /* Sfe mbox read flags      */
#define SFE_WRITE  A_EOFOFF          /* Sfe mbox write flags     */
#define SFE_SOPEN  (A_SHARE+A_WRITE) /* Sfe send mbox access     */
#define SFE_STOPEN A_READ            /* Status pipe open access  */

/* Spooler Front End flags for s_create of mailbox pipe */
#define SFE_MBCREATE_FLG (A_TEMP+A_SHARE+A_READ+A_SECURITY)

/* Spooler Front End flags for s_open of MX pipe */
#define SFE_MXOPEN_FLG (A_TEMP+A_SHARE+A_READ)

/* Spooler Front End (SFE) (SPLDVR/PRINT.286) MX pipe s_create flags */
#define SFE_MXCREATE_FLG (A_TEMP+A_SHARE+A_READ+A_SECURITY)

#define SPL_READ  0         /* Spl mbox read flags  */
#define SPL_WRITE WA_STDOUT /* Spl mbox write flags */

/* SPOOL.286 status pipe (for sending job status to PRINT.286) s_create flags */
#define SPL_STOPEN (A_WRITE+A_SECURITY)

/* SPOOL.286 pipe s_open flags (MX pipe, SFE mailbox, and DSP mailbox) */
#define SPL_SOPEN (A_SHARE+A_WRITE)

/* SPOOL.286 mailbox pipe s_create flags */
#define SPL_MBCREATE_FLG (A_TEMP+A_SHARE+A_READ+A_SECURITY)

/* SPOOL.286 mailbox pipe flags for reopen attempt */
#define SPL_MBREOPEN_FLG (A_TEMP+A_SHARE+A_READ)

/* SPOOL.286 (SPL) MX (mutual exclusion) pipe s_create flags */
#define SPL_MXCREATE_FLG (A_TEMP+A_SHARE+A_READ+A_SECURITY)

#define DSP_READ   0        /* Dspl. mbox read flags    */
#define DSP_FREAD  A_FPOFF  /* Dspl. file read flags    */
#define DSP_WRITE  A_EOFOFF /* Dspl. mbox write flags   */
#define DSP_DWRITE A_EOFOFF /* Dspl. device write flags */
#define DSP_DOPEN  A_WRITE  /* Dspl. device access      */

/* DESPOOL.286 s_open flags for pipes (MX and spooler mailbox) */
#define DSP_SOPEN (A_SHARE+A_WRITE)

/* DESPOOL.286 (DSP) mailbox pipe s_create flags */
#define DSP_MBCREATE_FLG (A_TEMP+A_SHARE+A_READ+A_SECURITY)

/* DESPOOL.286 s_open flags for opening files to be printed */
#define DSP_FOPEN (A_SHARE+A_SHRO+A_READ)


        /* Misc. defines */

#define MAX_FSPEC  20 /* Max. # filespecs allowed at a time   */
#define MAX_FN     10 /* Max. # filenames expanded at a time  */
#define SWCHAR     1  /* SWITCHAR position in dels table      */
#define TERMINATE  1L /* Terminate print jobs flag            */

#define DFLT_FMT    0       /* Default page format          */
#define DFLT_NC     1       /* Default # of copies to print */
#define DFLT_PLEN   54      /* Default page length          */
#define DFLT_PWIDTH 80      /* Default page width           */
#define DFLT_SEC    0x0fff  /* Default mbox security        */
#define DFLT_PRIOR  200     /* Def. process priority        */
#define DFLT_MMEM   0x20000L /* Def. process memory size    */
#define DFLT_AMEM   0x10000L /* Def. process add mem. size  */

#define QSIZE  0x2000  /* Default mbox size     */
#define QSEC   0x0fff  /* Default mbox security */

#define PTRLEN (sizeof(BYTE*))

#define MAXJOBS  40      /* Max. number of jobs queued     */
#define MAXROOTS 20      /* Max. number of free list roots */
#define MAXPOOL  MAXJOBS * sizeof( JOB ) /* Pool size      */

#define debug_c 0   /* enable compilation of diagnostic code  -DAB */


#define CREATE_FLG      0x140C          /* Create SVC flag value        */
#define CREATE_SEC      0x088F          /* Create SVC security value    */
#define WRITE_FLG       0x0101          /* Write SVC flag value         */
#define OPEN_FLG        0x005C          /* Open SVC flag value          */
#define MEM_MSK         0x8000          /* User/system memory flag bit  */
#define DVR_SPL         0x0099          /* Spool driver type number     */
#define ED_SPLDVR       0x80990000L     /* Spool driver error word      */

#define DVRHDR  struct _dvrhdr
DVRHDR                          	/* Driver header type           */
{
        UWORD   dh_reserve;             /* Driver type number           */
        UBYTE   dh_nbrunits;            /* Number of units              */
        UBYTE   dh_flags;               /* Flag bits                    */
        LONG    (*dh_init)();           /* Driver entry points          */
        LONG    (*dh_subdrv)();
        LONG    (*dh_uninit)();
        LONG    (*dh_select)();
        LONG    (*dh_flush)();
        LONG    (*dh_read)();
        LONG    (*dh_write)();
        LONG    (*dh_get)();
        LONG    (*dh_set)();
        LONG    (*dh_special)();
        LONG    dh_ct11;                /* Driver control fields        */
        LONG    dh_ct12;
        LONG    dh_ct13;
        PD      *dh_rlr;                /* Current process pointer      */
        LONG    dh_functab;             /* Driver services table        */
};

#define SEL_PB  struct _sel_pb
SEL_PB                          /* Select entry point parameter block   */
{
        UBYTE   sel_unit;
        UBYTE   sel_info;
        UWORD   sel_flags;
        LONG    sel_zero;
        LONG    sel_pdaddr;
        LONG    sel_option;
};

#define FLU_PB  struct _flu_pb
FLU_PB                          /* Flush entry point parameter block    */
{
        UBYTE   flu_unit;
        UBYTE   flu_info;
        UWORD   flu_flags;
        LONG    flu_zero;
        LONG    flu_pdaddr;
        LONG    flu_option;
};

#define WRI_PB  struct _wri_pb
WRI_PB                          /* Write entry point parameter block    */
{
        UBYTE   wri_unit;
        UBYTE   wri_option;
        UWORD   wri_flags;
        LONG    wri_swi;
        LONG    wri_pdaddr;
        BYTE    *wri_buffer;
        LONG    wri_bufsize;
        LONG    wri_offset;
};

#define FLIST   struct  _flist
FLIST                           /* Open file list entry                 */
{
        FLIST   *f_next;        /* Next open file list entry            */
        FLIST   *f_prev;        /* Previous open file list entry        */
        BYTE    *f_fspec;       /* Temporary file path specification    */
        LONG    f_fnum;         /* Temporary file open file number      */

        LONG    f_pid;          /* Process id                           */
        UWORD   f_ocount;       /* File open count                      */
};

#define SPD     struct  _spd
SPD                             /* Spooler descriptor                   */
{
        LONG    spd_sfn;        /* Spool driver send file number        */
        LONG    spd_rfn;        /* Spool driver receive file number     */
        UBYTE   spd_sfeid;      /* Spool driver id                      */
        UBYTE   spd_dspid;      /* Despooler id                         */
        MSG     spd_msg;        /* Message buffer                       */
};

/* Sizes for the above structures */

#define DH_SIZ  sizeof(DVRHDR)
#define SPB_SIZ sizeof(SEL_PB)
#define FPB_SIZ sizeof(FLU_PB)
#define WPB_SIZ sizeof(WRI_PB)
#define FL_SIZ  sizeof(FLIST)
#define SL_SIZ  sizeof(SPD)


/* CCRTL.L86 */
EXTERN LONG __OSIF();
EXTERN LONG s_cancel(), s_close(),  s_create(), s_define();
EXTERN LONG s_delete(), s_enable(), s_get(),    s_disable();
EXTERN LONG s_lookup(), s_open(),   s_read(),   s_return();
EXTERN LONG s_wait(),   s_write(),  s_swiret(), s_exit();
EXTERN LONG e_read(),   e_command(),s_set(),    e_termevent();
EXTERN LONG s_seek(),   e_timer(),  e_write(),  s_timer();

/* CCUTLS.L86 */
EXTERN	WORD	utds2i();
pragma Calling_convention( _CALLING_CONVENTION | _FAR_CALL);
EXTERN	LONG    sptr_lptr();
pragma Calling_convention( _DEFAULT_CALLING_CONVENTION );

/* UTOOLS.L86 */
EXTERN BYTE *strcpy(), *strncpy(), *skpspace();
EXTERN WORD strlen(), strcmp(), makarg();
EXTERN VOID ltoa(), itoa(), new_line(), fputs(), bzfill(), ucase();

/* DRTL.L86 */
EXTERN  LONG    ds_open();
EXTERN  LONG    ds_close();
EXTERN  LONG    ds_define();
EXTERN  LONG    ds_create(), ds_delete(), ds_return(), ds_cancel();
EXTERN  LONG    ds_wait(),   ds_read(),   ds_write(),  ds_lookup();
EXTERN  LONG    de_read(),   ds_abort(),  de_command();
EXTERN  LONG    flagget(),  flagevent(), flagset();
EXTERN  LONG    flagrel(),  flagclr();
