/*****************************************************************
 * "Copyright (C) 1985, Digital Research, Inc.  All Rights       *
 * Reserved.  The Software Code contained in this listing is     *
 * proprietary to Digital Research Inc., Monterey, California    *
 * and is covered by U.S. and other copyright protection.        *
 * Unauthorized copying, adaptation, distribution, use or        *
 * display is prohibited and may be subject to civil and         *
 * criminal penalties.  Disclosure to others is prohibited.  For *
 * the terms and conditions of software code use refer to the    *
 * appropriate Digital Research License Agreement."              *
 *****************************************************************/
/*===============================================================*
 *   Version 3.1        CONCUR.H                                 *
 *   Standard set of logical names for Flexos Utilities.         *
 *---------------------------------------------------------------*
 *     VERSION   DATE    BY     CHANGE/COMMENTS                  *
 *---------------------------------------------------------------*
 *	V1.0	05/24/84 ??	Created.			 *
 *	V3.1	02/23/87 ldt	Removed all old comments.	 *
 *===============================================================*/

/* error codes */

/****************************************************************/
/*								*/
/*  Error Definitions						*/
/*								*/
/*	All error codes are negative numbers (LONGS).          	*/
/*	Error Code Format :					*/
/*								*/
/*      31|30   24|23    16|15             0 (bits)		*/
/*	+-+-------+--------+----------------+			*/
/*	|1|   0   | module |   Error Code   |			*/
/*	+-+-------+--------+----------------+			*/
/*	(high byte)		(low word)			*/
/*								*/
/*	Error Code	16 bit number as described below	*/
/*			(NOTE: these are all cast as WORD)	*/
/*	Module		8 bit number indicating source Module	*/
/*	High Byte	high bit is 1, low 7 bits are reserved	*/
/*								*/
/*			00H - Kernel & Supervisor		*/
/*			10H - Pipe System			*/
/*			20H - Disk System			*/
/*			21H-2FH - Disk drivers			*/
/*			30H - Console System			*/
/*			31H-3FH - Console drivers		*/
/*			40H - Command				*/
/*			50H - Extension				*/
/*			51H-5FH - OEM Ext. Drivers		*/
/*			60H - Network System			*/
/*			61H-6FH - Network Drivers		*/
/*			70H - Misc. Resource Manager		*/
/*			71H-7FH - Misc. drivers			*/
/*			81H - Port Driver			*/
/*			Special driver ID's begin at 82H.	*/
/*			Driver ID's cannot have a zero in the	*/
/*			low nibble of ID byte.			*/
/*								*/
/*	Resource Managers return errors that they generated	*/
/*	by ORing the RM number with the Error Code.		*/
/*	ie.							*/
/*		return( EM_CON | E_EXISTS );			*/ 
/*	  (The Console RM is noting that a file already exists)	*/
/*								*/
/*	ALSO:  DON'T OR Module Number with E_SUCCESS...		*/
/*								*/
/****************************************************************/

/****************************************************************/
/*								*/	
/*	Module numbers, used to identify the source of the	*/
/*	error.							*/
/*								*/
/****************************************************************/

#define EM_KERN	0x80000000L	/* Kernel			*/
#define	EM_SUP	0x80000000L	/* Internal Supervisor Module	*/
#define EM_PIPE	0x80100000L	/* Pipe Resource Manager	*/
#define EM_DISK	0x80200000L	/* Disk Resource Manager	*/
#define EM_CON	0x80300000L	/* Console Resource Manager	*/
#define EM_LOAD	0x80400000L	/* Command (Load) Resource Mgr.	*/
#define EM_EXT	0x80500000L	/* Extension Resource Manager	*/
#define EM_NET	0x80600000L	/* Networ Resource Manager	*/
#define	EM_MSC	0x80700000L	/* Misc. Driver Resoure Mgr.	*/

#define	ED_TIME	0x80010000L	/* Timer driver			*/
#define	ED_PIPE	0x80110000L	/* Pipe driver			*/
#define	ED_DISK	0x80210000L	/* Disk driver			*/
#define	ED_CON	0x80310000L	/* Console driver		*/
#define	ED_PRN	0x80710000L	/* Printer driver		*/
#define	ED_SER	0x80720000L	/* Serial driver		*/
#define	ED_CLOCK 0x807e0000L	/* DOS clock driver emulator	*/
#define	ED_NULL	0x807f0000L	/* Null device driver		*/
#define	ED_PORT	0x80810000L	/* Port driver			*/

/****************************************************************/
/*								*/
/*  Common Error Definitions - Range 0x4000 - 0x407F		*/
/*								*/
/*  These error codes are shared by more than one system module.*/
/*								*/
/****************************************************************/

#define	E_SUCCESS	0x0L	/* No Error				*/

#define	E_ACCESS	0x4001	/* Cannot access file due to ownership.	*/
#define	E_CANCEL	0x4002	/* Event Cancelled			*/
#define	E_EOF		0x4003	/* End of File				*/
#define	E_EXISTS	0x4004	/* File already exists			*/
				/* INSTALL - Device already exists	*/
#define	E_DEVICE	0x4005	/* Device does not match.		*/
				/* RENAME on different devices.		*/
#define	E_DEVLOCK	0x4006	/* Device is LOCKED			*/
#define	E_FILENUM	0x4007	/* Bad File Number			*/
#define	E_FUNCNUM	0x4008	/* Bad function number			*/
#define	E_IMPLEMENT	0x4009	/* This function not implemented	*/
#define	E_INFOTYPE	0x400A	/* Illegal Infotype for this file	*/
#define	E_INIT		0x400B	/* Error on Initialization of Driver	*/
#define	E_CONFLICT	0x400C	/* Cannot access file due to current usage */
				/* DELETE of open file.			*/
				/* INSTALL- Replace Driver in use	*/
#define	E_MEMORY	0x400D	/* Not enough memory available		*/
#define	E_MISMATCH	0x400E	/* Function Mismatch.  Attempt to perform */
				/*    a function on a file that does not*/
				/*    support the function.		*/
				/* INSTALL- Subdrive type mismatch	*/
#define	E_NAME		0x400F	/* Illegal file name specified		*/
#define	E_NO_FILE	0x4010	/* File Not Found.			*/
				/* CREATE- Device or Directory		*/
				/*    does not exist			*/
#define	E_PARAM		0x4011	/* Illegal Parameter specified		*/
				/* EXCEPTION- Illegal number		*/
#define	E_RECSIZE	0x4012	/* Record Size does not match request.	*/
#define	E_SUBDEV	0x4013	/* INSTALL - Sub-drive required		*/
#define	E_FLAG		0x4014	/* Bad Flag Number			*/

#define	E_NOMEM		0x4015	/* Non-existant memory			*/
#define	E_MBOUND	0x4016	/* Memory Bound error			*/
#define E_EBOUNDEX	E_MBOUND
#define	E_ILLINS	0x4017	/* Illegal instruction			*/
#define	E_DIVZERO	0x4018	/* Divide by zero			*/
#define	E_BOUND		0x4019	/* Bound exception			*/
#define	E_OFLOW		0x401A	/* Overflow exception			*/
#define	E_PRIV		0x401B	/* Privilege violation			*/
#define	E_TRACE		0x401C	/* Trace				*/
#define	E_BRKPT		0x401D	/* Breakpoint				*/
#define	E_FLOAT		0x401E	/* Floating point exception		*/
#define	E_STACK		0x401F	/* Stack fault				*/
#define	E_NOTON286	0x4020	/* Exception not caught by 286		*/
#define E_EM1		0x4021	/* emulated instruction group 1		*/


/****************************************************************/
/*								*/
/*  Supervisor - Range 0x4080 - 0x40FF				*/
/*								*/
/****************************************************************/

#define	E_ASYNC		0x4080	/* Asynchronous I/O not supported on	*/
				/*   function.				*/
#define	E_LOAD		0x4082	/* Bad Load Format			*/
#define	E_LOOP		0x4083	/* Infinite recursion (99 times) on	*/
				/*    Prefix Substitution.		*/
				/* INSTALL- Subdrive type mismatch	*/
#define	E_FULL		0x4084	/* File number table full		*/
#define	E_DEFINE	0x4085	/* DEFINE - Illegal name		*/

#define E_UNIT		0x4086	/* Too Many Driver Units		*/
#define E_UNWANTED	0x4087	/* Driver does not need Subdriver	*/
#define E_DVRTYPE	0x4088	/* Driver returns bad Driver type	*/
#define	E_LSTACK	0x4089	/* No load stack in cmd header		*/

/****************************************************************/
/*								*/
/*  Memory Error Definitions - Range 0x4100 - 0x417F		*/
/*								*/
/****************************************************************/

#define	E_POOL		0x4100	/* Out of memory pool			*/
#define	E_BADADD	0x4101	/* Bad address specified to free	*/

/****************************************************************/
/*								*/
/*  Kernel Error Definitions - Range 0x4180 - 0x41FF		*/
/*								*/
/****************************************************************/


#define	E_OVERRUN	0x4180	/* Flag already set			*/
#define	E_FORCE		0x4181	/* Return code of process being aborted	*/
#define	E_PDNAME	0x4182	/* Process ID not found on abort	*/
#define	E_PROCINFO	0x4183	/* COMMAND - no procinfo specified	*/
#define	E_LOADTYPE	0x4184	/* COMMAND - invalid loadtype		*/
#define	E_ADDRESS	0x4185	/* CONTROL - invalid memory access	*/
#define	E_EMASK		0x4186	/* Invalid event mask			*/
#define	E_COMPLETE	0x4187	/* Event has not completed		*/
#define	E_SRTL		0x4188	/* The required SRTL could no be found	*/
#define	E_ABORT		0x4189	/* Process cannot be terminated		*/
#define	E_CTLC		0x418A	/* Ctrl-C abort				*/
#define	E_SPACE		0x4300	/* No block or directory entries	*/
				/* available				*/
#define E_MEDIACHANGE	0x4301	/* Media change occured			*/
#define E_MEDCHGERR	0x4302	/* Detected media change after a write	*/
#define E_PATH		0x4303	/* Bad path				*/
#define E_DEVCONFLICT	0x4304	/* Devices locked exclusively		*/
#define E_RANGE         0x4305	/* Address out of range			*/
#define E_READONLY	0x4306	/* Rename or delete on R/O file		*/
#define E_DIRNOTEMPTY	0x4307	/* Delete of non-empty directory	*/
#define E_BADOFFSET	0x4308	/* Badoffset in read, write or seek	*/
#define E_CORRUPT	0x4309	/* Corrupted Fat			*/
#define E_PENDLK        0x430A	/* Cannot unlock a pending lock		*/
#define E_RAWMEDIA	0x430B	/* Media does not support file system.	*/
				/* Not DOS media.			*/
#define	E_FILECLOSED	0x430C	/* File was closed before async lock	*/
				/* could be completed.			*/
#define	E_LOCK		0x430D	/* Lock access conflict			*/
#define	E_FATERR	0x430E	/* Error while reading the FAT		*/

/****************************************************************/
/*								*/
/*  Note the order and definition of the following 16 error	*/
/*  codes must not change.  These error are to be returned to 	*/
/*  the appropriate resource manager.				*/
/*								*/
/****************************************************************/

#define	E_WPROT		0x0000	/*  write protect violation     */
#define	E_UNITNO	0x0001	/*  illegal unitnumber		*/
#define	E_READY		0x0002	/*  drive not ready		*/
#define	E_INVCMD	0x0003	/*  invalid command issued	*/
#define	E_CRC		0x0004	/*  crc error on i/o		*/
#define	E_BADPB		0x0005	/*  bad parameter block		*/
#define	E_SEEK		0x0006	/*  seek operation failed	*/
#define	E_UNKNOWNMEDIA	0x0007	/*  unknown media present	*/
#define	E_SEC_NOTFOUND	0x0008	/*  req'd sector not found	*/
#define	E_DKATTACH	0x0009	/*  attchmt didn't respond	*/
#define	E_WRITEFAULT	0x000A	/*  write fault			*/
#define	E_READFAULT	0x000B	/*  read fault			*/
#define	E_GENERAL	0x000C	/*  general failure		*/
#define	E_MISADDR	0x000D	/*  missing address mark	*/
#define	E_RES1		0x000E	/*  reserved			*/
#define	E_RES2		0x000F	/*  reserved			*/

/* Utility Return Codes */

/****************************************************************/
/*								*/
/*	Utility Return codes follow the same basic format of    */
/*	DOS return codes, with the following exceptions:	*/
/*								*/
/*	   All error codes are positive numbers (LONGS) since   */
/*	   the high bit (31) is always zero (0).		*/
/*								*/
/*	   The error code field should use one of the following */
/*	   listed codes when possible.				*/
/*								*/
/*	Utility return code format:				*/
/*								*/
/*      31|30   24|23    16|15             0 (bits)		*/
/*	+-+-------+--------+----------------+			*/
/*	|0|   0   | module |   Error Code   |			*/
/*	+-+-------+--------+----------------+			*/
/*	(high byte)		(low word)			*/
/*								*/
/*	Error Code	16 bit number as described below	*/
/*			(NOTE: these are all cast as WORD)	*/
/*	Module		8 bit number indicating source Module	*/
/*			This value may be used to designate	*/
/*			certain modules within a utility.	*/
/*	High Byte	high bit is 0, low 7 bits are reserved	*/
/*								*/
/*	Applications return errors that they generated		*/
/*	by ORing the Module with the Error Code.		*/
/*	ie.							*/
/*		return( UR_SOURCE | UR_PARM );			*/ 
/* (The Utility is noting that a parameter error was detected)	*/
/*								*/
/*	ALSO:  DON'T OR Module Number with UR_SUCCESS...	*/
/*								*/
/****************************************************************/

#define	UR_SOURCE	(LONG)0			/* Utility Return Module ID  */

#define	UR_SUCCESS	(LONG)0			/* Successful completion     */

#define	UR_PARM		0x0001			/* Parameter error	     */
#define	UR_CONFLICT	0x0002			/* Contention conflict	     */
#define	UR_UTERM	0x0003			/* Terminated by user	     */
#define	UR_FORMAT	0x0004			/* Data structure format err */
#define	UR_INTERNAL	0x0005			/* Internal utility error    */
#define	UR_DOSERR	0x0006			/* Other errors (DOS)	     */


/* table ids */

#define	PROC_INFO	(BYTE)0x00	/* Process table		    */
#define ENV_INFO	(BYTE)0x01	/* Process environment table	    */
#define	TD_INFO		(BYTE)0x02	/* Time and date table		    */
#define	MEM_INFO	(BYTE)0x03	/* Memory information table	    */
#define	PIPE_INFO	(BYTE)0x10	/* Pipe information table	    */
#define	DF_INFO		(BYTE)0x20	/* Disk file information table	    */
#define	DISK_INFO	(BYTE)0x21	/* Disk device driver info table    */
#define	CON_INFO	(BYTE)0x30	/* Screen and Keyboard information  */
#define	PCON_INFO	(BYTE)0x31	/* Physical console info table	    */
#define	VCON_INFO	(BYTE)0x32	/* Virtual console info table	    */
#define	MOU_INFO	(BYTE)0x33	/* Mouse information table	    */
#define	TOP_INFO	(BYTE)0x34	/* Top border (no table)	    */
#define	BOT_INFO	(BYTE)0x35	/* Bottom border (no table)	    */
#define	LEFT_INFO	(BYTE)0x36	/* Left border (no table)	    */
#define	RGHT_INFO	(BYTE)0x37	/* Right border (no table)	    */
#define	SYS_INFO	(BYTE)0x40	/* Global system information table  */
#define	FNUM_INFO	(BYTE)0x41	/* Opened file number info table    */
#define	SDEF_INFO	(BYTE)0x42	/* System DEFINE table		    */
#define	PDEF_INFO	(BYTE)0x43	/* Process DEFINE table		    */
#define	CMD_INFO	(BYTE)0x44	/* Command environment info table   */
#define	DEV_INFO	(BYTE)0x45	/* Device information table	    */
#define	PATH_INFO	(BYTE)0x46	/* Path compression/maintainance    */
#define	PRN_INFO	(BYTE)0x71	/* Printer device info table	    */
#define	SER_INFO	(BYTE)0x72	/* Serial table			    */
#define	CLK_INFO	(BYTE)0x7e	/* DOS clock driver table	    */
#define	NUL_INFO	(BYTE)0x7f	/* Null device table		    */
#define	PORT_INFO	(BYTE)0x81	/* Port device information table    */
#define	SPEC_INFO	(BYTE)0x82	/* Special device info table	    */

/* table structures */

#define	SERSIZ		8	/* Size of serialization sequence	    */
#define	NAME1		10	/* Size of a name field			    */
#define	NAME2		14	/* Size of a name field			    */
#define	NAME3		18	/* Size of a name field			    */
#define	MOUSIZ		16	/* Size of mouse data and mask fields	    */
#define	BUFSIZ		128	/* Size of buffers			    */


#define	CMDENV	struct	_cmdenv
CMDENV
{
	UBYTE	cmd_file[BUFSIZ];
	UBYTE	cmd_string[BUFSIZ];
	UBYTE	cmd_info;	/* parent env. strings here, variable length */
};

#define	CONSOLE	struct	_console
CONSOLE
{
	UWORD	cn_numkey;
	UWORD	cn_smode;
	UWORD	cn_kmode;
	UWORD	cn_currow;
	UWORD	cn_curcol;
	UWORD	cn_nrows;
	UWORD	cn_ncols;
	UBYTE	cn_vcnum;
	UBYTE	cn_type;
	UBYTE	cn_name[NAME1];
};

						 /* console smode bit values */
#define	CSM_DUMB	0x0001		       /* disables ANSI/VT52 support */
#define	CSM_SXB		0x0002			   /* sixteen bit characters */
#define	CSM_NOC		0x0004					/* no cursor */
#define	CSM_CRLF	0x0008			    /* convert lf's to cr/lf */
						 /* console kmode bit values */
#define	CKM_NAB		0x0001			  /* disable aborts (CTRL-C) */
#define	CKM_NSC		0x0002		     /* disable scroll (CTRLs S & Q) */
#define	CKM_NXL		0x0004				   /* no translation */
#define	CKM_NV52	0x0008				 /* no VT52 decoding */
#define	CKM_SXB		0x0010			   /* sixteen bit characters */
#define	CKM_NEC		0x0020					  /* no echo */
#define	CKM_NCZ		0x0040				     /* no control z */
#define	CKM_TOG		0x0080				/* toggle characters */
#define	CKM_CRLF	0x0100			 /* convert CR or LF to CRLF */
#define	CKM_ENEWLIN	0x0200			   /* echo CRLF on delimiter */
#define	CKM_NECR	0x0400				    /* no echo on CR */

#define	DEFINE	struct	_define				/* for PDEF and SDEF */
DEFINE
{
	ULONG	def_lookid;
	UBYTE	def_lname[NAME1];
	UBYTE	def_prefix[BUFSIZ];
};

#define	DEVICE	struct	_device
DEVICE
{
	ULONG	dev_lookid;
	UBYTE	dev_name[NAME1];
	UWORD	dev_type;
	UWORD	dev_access;
	UWORD	dev_instat;
	UWORD	dev_owner;
};
						 /* device access bit values */
#define	DVA_SET		0x0001				      /* set allowed */
#define	DVA_WRT		0x0004				    /* write allowed */
#define	DVA_RD		0x0008				     /* read allowed */
#define	DVA_SHR		0x0010			    /* shared access allowed */
#define	DVA_RMVD	0x0020				 /* removable device */
#define	DVA_DLCK	0x0040				  /* DEVLOCK allowed */
#define	DVA_SHRO	0x0080			       /* shared access only */

#define	DISK	struct	_disk
DISK
{
	UBYTE	dsk_name[NAME1];
	UWORD	dsk_type;
	UWORD	dsk_ioptions;
	UWORD	dsk_status;
	UWORD	dsk_lrfid;
	UWORD	dsk_lrnid;
	ULONG	dsk_lrpid;
	ULONG	dsk_free;
	ULONG	dsk_size;
	UWORD	dsk_sectsize;
	UWORD	dsk_1stsect;
	ULONG	dsk_nsectors;
	UWORD	dsk_spt;
	UWORD	dsk_spb;
	UBYTE	dsk_nfats;
	UBYTE	dsk_fatid;
	UWORD	dsk_nfrecs;
	UWORD	dsk_dirsize;
	UBYTE	dsk_nheads;
	UBYTE	dsk_format;
	ULONG	dsk_nhidesecs;
	ULONG	dsk_syssize;
	UBYTE	dsk_laflag;
	UBYTE	dsk_lamode;
	UBYTE	dsk_lauser;
	UBYTE	dsk_lagroup;
	UBYTE	dsk_label[NAME2];
};

					       /* disk table type bit values */
#define	DTP_RMV		0x0001				  /* removable media */
					    /* disk table ioption bit values */
#define	DIO_URST	0x0001			     /* user raw set allowed */
#define	DIO_URWR	0x0004			   /* user raw write allowed */
#define	DIO_URRD	0x0008			    /* user raw read allowed */
#define	DIO_RDD		0x0020			  /* removable device driver */
#define	DIO_DLK		0x0040				 /* DEVLOCKs allowed */
#define	DIO_PDD		0x0100			  /* Partitioned disk driver */
#define	DIO_VER		0x0200				   /* Verify control */
					     /* disk table status bit values */
#define	DST_DLP		0x0001			   /* disk locked to process */
#define	DST_DLF		0x0002			    /* disk locked to family */
#define	DST_DOE		0x0004	      /* disk opened exclusively as a device */
#define	DST_IUP		0x0008		   /* disk in use by another process */
#define	DST_IUF		0x0010	 /* disk in use by processes in other family */
#define	DST_AFS		0x0020		   /* disk activated for file system */
#define	DST_FOP		0x0040			       /* files open on disk */
						  /* disk table format codes */
#define	DFM_RAW		(BYTE)0			/* RAW (unknown) file system */
#define	DFM_DOS1	(BYTE)1		  /* DOS (1.5 FAT bytes) file system */
#define	DFM_DOS2	(BYTE)2		    /* DOS (2 FAT bytes) file system */
					      /* disk table label flag codes */
#define	DLF_NOL		(BYTE)0				  /* no label exists */
#define	DLF_LEX		(BYTE)1				     /* label exists */
#define	DLF_DER		(BYTE)2		/* return device error on label read */
					 /* disk table label mode bit values */
#define	DLM_FSE		(BYTE)0x01		    /* file security enabled */
#define	DLM_CSE		(BYTE)0x02		/* lower & upper case enable */

#define	DISKFILE	struct	_diskfile
DISKFILE
{
	ULONG	df_lookid;
	UBYTE	df_name[NAME3];
	UWORD	df_attrib;
	UWORD	df_recsize;
	UBYTE	df_user;
	UBYTE	df_group;
	UWORD	df_protect;
	UWORD	df_dostime;
	UWORD	df_dosdate;
	UWORD	df_fatindex;
	ULONG	df_size;
	UWORD	df_modyear;
	UBYTE	df_modmonth;
	UBYTE	df_modday;
	UBYTE	df_modhr;
	UBYTE	df_modmin;
	UBYTE	df_modsec;
	UBYTE	df_rsvdb;
};

#define	ENVIRON	struct	_environ
ENVIRON
{
	LONG	en_stdin;
	LONG	en_stdout;
	LONG	en_stderr;
	LONG	en_overlay;
	UWORD	en_security;
	UWORD	en_rsvd;
	UBYTE	en_user;
	UBYTE	en_group;
	UWORD	en_fid;
	ULONG	en_pid;
	UWORD	en_rnid;
	UWORD	en_rfid;
	ULONG	en_rpid;
};

#define	FILENUM	struct	_filenum
FILENUM
{
	LONG	fn_filenum;
	UBYTE	fn_access;
	UBYTE	fn_table;
};

					  /* filenum table access bit values */
#define	FNA_SET		0x0001			       /* set access allowed */
#define	FNA_EXC		0x0002			   /* execute access allowed */
#define	FNA_WRT		0x0004			     /* write access allowed */
#define	FNA_RD		0x0008			      /* read access allowed */

#define	MEMORY	struct	_mem
MEMORY
{
	ULONG	mem_nfree;
	ULONG	mem_total;
	ULONG	mem_sys;
};

#define	MOUSE	struct	_mouse
MOUSE
{
	WORD	mou_row;
	WORD	mou_col;
	WORD	mou_pixrow;
	WORD	mou_pixcol;
	WORD	mou_click;
	BYTE	mou_height;
	BYTE	mou_width;
	WORD	mou_hotrow;
	WORD	mou_hotcol;
	UWORD	mou_mask[MOUSIZ];
	UWORD	mou_data[MOUSIZ];
};

#define	PATH	struct	_path
PATH
{
	UBYTE	pa_text[BUFSIZ];
};

#define	PCONSOLE	struct	_pconsole
PCONSOLE
{
	UBYTE	pc_name[NAME1];
	UBYTE	pc_nvc;
	UBYTE	pc_cid;
	UWORD	pc_rows;
	UWORD	pc_cols;
	UWORD	pc_crows;
	UWORD	pc_ccols;
	UBYTE	pc_flags;
	UBYTE	pc_planes;
	UBYTE	pc_attrp;
	UBYTE	pc_extp;
	UWORD	pc_country;
	UBYTE	pc_nfkeys;
	UBYTE	pc_buttons;
	ULONG	pc_serial;
};

					   /* pconsole table flag bit values */
#define	PCF_GRP		0x0001				 /* graphics console */
#define	PCF_NNK		0x0002			      /* no numerical keypad */
#define	PCF_MSS		0x0004			   /* mouse support provided */
#define	PCF_CLR		0x0008				    /* color console */
					  /* pconsole table plane bit values */
#define	PCP_CHAR	0x0001			/* character plane supported */
#define	PCP_ATTR	0x0002			/* attribute plane supported */
#define	PCP_EXTN	0x0004			/* extension plane supported */


#define	PIPE	struct	_pipe
PIPE
{
	ULONG	pi_lookid;
	UBYTE	pi_name[NAME1];
	UWORD	pi_size;
	UWORD	pi_recsiz;
	UWORD	pi_secur;
};

#define	PORT	struct	_port
PORT
{
	ULONG	pt_lookid;
	UWORD	pt_type;
	UWORD	pt_state;
	UBYTE	pt_name[NAME1];
};

#define	PRINTER	struct	_printer
PRINTER
{
	ULONG	pr_lookid;
	UBYTE	pr_name[NAME1];
	UWORD	pr_state;
	UWORD	pr_width;
	UWORD	pr_type;
};

#define	PROCDEF	struct	_define

#define	PROCESS	struct	_process
PROCESS
{
	ULONG	p_pid;
	UWORD	p_fid;
	UBYTE	p_cid;
	UBYTE	p_vcid;
	UBYTE	p_name[NAME1];
	UBYTE	p_state;
	UBYTE	p_prior;
	ULONG	p_maxmem;
	UWORD	p_flags;
	UBYTE	p_cuser;
	UBYTE	p_cgroup;
	ULONG	p_parent;
	ULONG	p_events;
	ULONG	p_code;
	ULONG	p_csize;
	ULONG	p_data;
	ULONG	p_dsize;
	ULONG	p_heap;
	ULONG	p_hsize;
};

					    /* process table flag bit values */
#define	PCF_SYS		0x0001				   /* system process */
#define	PCF_LKM		0x0002				 /* locked in memory */
#define	PCF_SWI		0x0004			   /* running in SWI context */
#define	PCF_SUP		0x0008			     /* originally superuser */


#define	SPECIAL	struct	_special
SPECIAL
{
	ULONG	sp_size;	/* all specials start with size field	     */
};

#define	SYSDEF	struct	_define

#define	SYS	struct	_sys
SYS
{
	UBYTE	sys_cpu;
	UBYTE	sys_os;
	UBYTE	sys_version;
	UBYTE	sys_release;
	UBYTE	sys_serial[SERSIZ];
	ULONG	sys_idlecnt;
};

						   /* system table cpu codes */
#define	P8080		(BYTE)1		/* Intel 8080			     */
#define	P8085		(BYTE)2		/* Intel 8085			     */
#define	PZ80		(BYTE)3		/* Zilog Z80			     */
#define	P8086		(BYTE)4		/* Intel 8086			     */
#define	PZ8000		(BYTE)5		/* Zilog Z8000			     */
#define	P68000		(BYTE)6		/* Motorola 68000		     */
#define	P68010		(BYTE)7		/* Motorola 68010		     */
#define	P68020		(BYTE)8		/* Motorola 68020		     */
#define	P80286		(BYTE)9		/* Intel 80286			     */
#define	P80386		(BYTE)10	/* Intel 80386			     */
#define	P80186		(BYTE)11	/* Intel 80186			     */
						/* system table ostype codes */
#define	FLEXOS	        (BYTE)0

#define	TD	struct	_td
TD
{
	UWORD	td_year;
	UBYTE	td_month;
	UBYTE	td_day;
	ULONG	td_time;
	UWORD	td_tzone;
	BYTE	td_weekday;
	UBYTE	td_rsvd;
};

#define	VCONSOLE	struct	_vconsole
VCONSOLE
{
	ULONG	vc_lookid;
	UWORD	vc_mode;
	UBYTE	vc_vcnum;
	UBYTE	vc_type;
	WORD	vc_viewrow;
	WORD	vc_viewcol;
	WORD	vc_nrow;
	WORD	vc_ncol;
	WORD	vc_posrow;
	WORD	vc_poscol;
	WORD	vc_rows;
	WORD	vc_cols;
	BYTE	vc_top;
	BYTE	vc_bottom;
	BYTE	vc_left;
	BYTE	vc_right;
};

				    /* virtual console table mode bit values */
#define	VCM_FZB		0x0001				    /* freeze border */
#define	VCM_AVC		0x0002			   /* allow auto view change */
#define	VCM_KCE		0x0004		     /* keep cursor on edge (on AVC) */
#define	VCM_AVO		0x0008		       /* auto view change on output */
					  /* virtual console type bit values */
#define	VCT_GRP		(BYTE)0x01			    /* graphics vcon */

/* file attributes */

#define	FA_READ	0x0001		/* read/only				     */
#define	FA_HIDE	0x0002		/* hidden file				     */
#define	FA_SYS	0x0004		/* system file				     */
#define	FA_VOL	0x0008		/* volume entry				     */
#define	FA_DIR	0x0010		/* directory entry			     */
#define	FA_ARCH	0x0020		/* archive				     */
#define	FA_PROT	0x0040		/* protection enable			     */

/* file security */

#define	FS_OD	0x0001		/* owner delete/set			     */
#define	FS_OE	0x0002		/* owner execute			     */
#define	FS_OW	0x0004		/* owner write				     */
#define	FS_OR	0x0008		/* owner read				     */
#define	FS_GD	0x0010		/* group delete/set			     */
#define	FS_GE	0x0020		/* group execute			     */
#define	FS_GW	0x0040		/* group write				     */
#define	FS_GR	0x0080		/* group read				     */
#define	FS_WD	0x0100		/* world delete/set			     */
#define	FS_WE	0x0200		/* world execute			     */
#define	FS_WW	0x0400		/* world write				     */
#define	FS_WR	0x0800		/* world read				     */

/* standard logical names */

#define	LN_AUX		"aux"
#define	LN_BOOT		"boot:"
#define	LN_BTM		"bottom"
#define	LN_COM1		"com1"
#define	LN_COM2		"com2"
#define LN_CON		"con"
#define	LN_CNS		"console"
#define	LN_DEF		"default:"
#define	LN_DRA		"a:"
#define	LN_DRB		"b:"
#define	LN_DRC		"c:"
#define	LN_DRD		"d:"
#define	LN_DRE		"e:"
#define	LN_DRF		"f:"
#define	LN_DRG		"g:"
#define	LN_DRH		"h:"
#define	LN_DRI		"i:"
#define	LN_DRJ		"j:"
#define	LN_DRK		"k:"
#define	LN_DRL		"l:"
#define	LN_DRM		"m:"
#define	LN_DRN		"n:"
#define	LN_DRO		"o:"
#define	LN_DRP		"p:"
#define	LN_GID		"groupid"
#define	LN_HLP		"helplvl"
#define	LN_HOME		"home:"
#define	LN_LEFT		"left"
#define	LN_LPT1		"lpt1"
#define	LN_LPT2		"lpt2"
#define	LN_LPT3		"lpt3"
#define	LN_MOUSE	"mouse"
#define	LN_NAME		"name"
#define	LN_NUL		"nul"
#define	LN_NULL		"null:"
#define	LN_PASS		"password"
#define	LN_PATH		"path"
#define	LN_PRN		"prn"
#define	LN_PMT		"prompt"
#define	LN_PROT		"protect"
#define	LN_RIGHT	"right"
#define	LN_SHELL	"shell"
#define	LN_STDI		"stdin"
#define	LN_STDE		"stderr"
#define	LN_STDO		"stdout"
#define	LN_SWIT		"switchar"
#define	LN_SYS		"system:"
#define	LN_TOP		"top"
#define	LN_UID		"userid"
#define	LN_VCON		"vc000"
#define	LN_VER		"version"
#define	LN_WMGR		"wmanager"
#define	LN_WMSG		"wmessage"

/* FlexOS functions and field descriptors */

					/* DOS function numbers		     */
#define	F_GET		(WORD)0
#define	F_SET		(WORD)1
#define	F_LOOKUP	(WORD)2
#define	F_CREATE	(WORD)3
#define	F_DELETE	(WORD)4
#define	F_OPEN		(WORD)5
#define	F_CLOSE		(WORD)6
#define	F_READ		(WORD)7
#define	F_WRITE		(WORD)8
#define	F_SPECIAL	(WORD)9
#define	F_RENAME	(WORD)10
#define	F_DEFINE	(WORD)11
#define	F_DEVLOCK	(WORD)12
#define	F_INSTALL	(WORD)13
#define	F_LOCK		(WORD)14
#define	F_COPY		(WORD)15
#define	F_ALTER		(WORD)16
#define	F_XLAT		(WORD)17
#define	F_RWAIT		(WORD)18
#define	F_KCTRL		(WORD)19
#define	F_ORDER		(WORD)20
#define	F_KEYPUT	(WORD)21
#define	F_GIVE		(WORD)22
#define	F_BWAIT		(WORD)23
#define	F_TIMER		(WORD)24
#define	F_EXIT		(WORD)25
#define	F_ABORT		(WORD)26
#define	F_CANCEL	(WORD)27
#define	F_WAIT		(WORD)28
#define	F_STATUS	(WORD)29
#define	F_RETURN	(WORD)30
#define	F_EXCEPTION	(WORD)31
#define	F_ENABLE	(WORD)32
#define	F_DISABLE	(WORD)33
#define	F_SWIRET	(WORD)34
#define	F_MALLOC	(WORD)35
#define	F_MFREE		(WORD)36
#define	F_OVERLAY	(WORD)37
#define	F_COMMAND	(WORD)38
#define	F_CONTROL	(WORD)39
#define	F_GSX		(WORD)40
#define	F_SEEK		(WORD)41

#define NUFUNCS		(WORD)41		  /* Highest function number */

#define	S_ABORT		F_ABORT+1		/* assigned function code   */

#define	S_ALTER		F_ALTER+1 		 /* alter flag values	     */
#define	ALF_CHAR	0x0001			/* Alter character plane     */
#define	ALF_ATTR	0x0002			/* Alter attribute plane     */
#define	ALF_EXTN	0x0004			/* Alter extension plane     */
						/* alter byte array indexes  */
#define	ALB_CAND	0x0000			/* Character plane AND	     */
#define	ALB_CXOR	0x0001			/* Character plane XOR	     */
#define	ALB_AAND	0x0002			/* Attribute plane AND	     */
#define	ALB_AXOR	0x0003			/* Attribute plane XOR	     */
#define	ALB_EAND	0x0004			/* Extension plane AND	     */
#define	ALB_EXOR	0x0005			/* Extension plane XOR	     */

#define	S_BWAIT		F_BWAIT+1
#define	E_BWAIT		F_BWAIT+1
#define	S_CANCEL	F_CANCEL+1

#define	S_CLOSE		F_CLOSE+1		/* close flag values	     */
#define	CLF_PART	0x0001			/* partial close	     */

#define	S_COMMAND	F_COMMAND+1
#define	E_COMMAND	F_COMMAND+1		/* command flag values	     */
#define	CMF_NOP		0x0010			/* No process (use CMF_PRCH) */
#define	CMF_CHAN	0x0020			/* chain = 1, procedure = 0  */
#define	CMF_KEEP	0x0040			/* Keep memory allocated     */
#define	CMF_NFAM	0x0080			/* start new process family  */
#define	CMF_FCAS	0x2000			/* Force case to media deflt */
#define	CMF_LIT		0x4000			/* Literal command	     */

#define	S_CONTROL	F_CONTROL+1
#define	E_CONTROL	F_CONTROL+1		/* Control option values     */
#define	CTO_INV		(BYTE)0x00		/* Invalid		     */
#define	CTO_LDP		(BYTE)0x01		/* Load program for control  */
#define	CTO_DEL		(BYTE)0x02		/* Delete program	     */
#define	CTO_RTCM	(BYTE)0x03		/* Read target code memory   */
#define	CTO_RTDM	(BYTE)0x04		/* Read target data memory   */
#define	CTO_WTCM	(BYTE)0x05		/* Write target code memory  */
#define	CTO_WTDM	(BYTE)0x06		/* Write target data memory  */
#define	CTO_RTR		(BYTE)0x07		/* Read target registers     */
#define	CTO_WTR		(BYTE)0x08		/* Write target registers    */
#define	CTO_GO		(BYTE)0x09		/* Go			     */
#define	CTO_TRAC	(BYTE)0x0a		/* Trace		     */
#define	CTO_HALT	(BYTE)0x0b		/* Halt			     */
#define	CTO_ATON	(BYTE)0x0c		/* All exception traps ON    */
#define	CTO_ATOFF	(BYTE)0x0d		/* All exception traps OFF   */
#define	CTO_STON	(BYTE)0x0e		/* Select exception trap ON  */
#define	CTO_STOFF	(BYTE)0x0f		/* Select exception trap OFF */

#define	S_COPY		F_COPY+1		/* copy flag values	     */
#define	CPF_CHAR	0x0001			/* Copy character plane	     */
#define	CPF_ATTR	0x0002			/* Copy attribute plane	     */
#define	CPF_EXTN	0x0004			/* Copy extension plane	     */

#define	S_CREATE	F_CREATE+1		/* create option values	     */
#define	CRO_NRML	(BYTE)0x00		/* Normal file or pipe	     */
#define	CRO_DIR		(BYTE)0x01		/* Disk directory	     */
#define	CRO_VCON	(BYTE)0x02		/* Virtual console (below)   */
						/* create flag values	     */
#define	CRF_DEL		0x0001			/* Delete/Set privileges     */
#define	CRF_WRT		0x0004			/* Write privileges	     */
#define	CRF_RD		0x0008			/* Read privileges	     */
#define	CRF_SHAR	0x0010			/* Shared access	     */
#define	CRF_SHRD	0x0020			/* Share reads only	     */
#define	CRF_SHFP	0x0040			/* Shared file pointer	     */
#define	CRF_ZERO	0x0080			/* Zerofill prealloc'd space */
#define	CRF_TEMP	0x0100			/* Temporary:delete on close */
#define	CRF_CONT	0x0200			/* Contiguous allocation     */
#define	CRF_FDEL	0x0400			/* Delete file if it exists  */
#define	CRF_RDUN	0x0800			/* Rsvd: Redundant file (0)  */
#define	CRF_SEC		0x1000			/* Use specified security    */
#define	CRF_FCAS	0x2000			/* Force case to media deflt */
#define	CRF_LIT		0x4000			/* Literal name		     */
		/* NOTE: for secur field use FS_XX file security definitions */

#define	S_VCCREATE	F_CREATE+1		/* vccreate option value     */
#define	VCO_VCON	(BYTE)0x02		/* virtual console create    */
						/* vccreate flag values	     */
#define	VCF_BITS	0x0001			/* Bit mapped screen	     */
#define	VCF_BITB	0x0002			/* Bit mapped borders	     */
#define	VCF_SIZE	0x0004			/* Sized as specified	     */
#define	VCF_RMVP	0x0008			/* Remove parent screen mem  */
#define	VCF_TEMP	0x0100			/* Temporary:delete on close */

#define	S_DEFINE	F_DEFINE+1		/* define flag values	     */
#define	DFF_SYS		0x0001			/* System define table	     */
#define	DFF_RET		0x0002			/* Return prfix string	     */
#define	DFF_LIT		0x4000			/* Literal returned prefix   */

#define	S_DELETE	F_DELETE+1		/* delete flag values	     */
#define	DLF_FCAS	0x2000			/* Force case to media deflt */
#define	DLF_LIT		0x4000			/* Literal name		     */

#define	S_DISABLE	F_DISABLE+1
#define	S_ENABLE	F_ENABLE+1

#define	S_DEVLOCK	F_DEVLOCK+1		/* device lock options	     */
#define	DVO_LPR		(BYTE)0x00		/* Lock for process	     */
#define	DVO_LFM		(BYTE)0x01		/* Lock for Family use	     */
#define	DVO_UNL		(BYTE)0x02		/* Unlock		     */


#define	S_EXCEPTION	F_EXCEPTION+1		/* exception numbers	     */
#define	EXN_NEM		0x0000			/* Non-existant memory	     */
#define	EXN_MBD		0x0001			/* Memory boundary error     */
#define	EXN_ILL		0x0002			/* Illegal instruction	     */
#define	EXN_ZER		0x0003			/* Divide by zero 	     */
#define	EXN_BND		0x0004			/* Bound exception	     */
#define	EXN_OVR		0x0005			/* Overflow exception	     */
#define	EXN_PRV		0x0006			/* Privilege violation	     */
#define	EXN_TRC		0x0007			/* Trace exception	     */
#define	EXN_BPT		0x0008			/* Breakpoint exception	     */
#define	EXN_FLP		0x0009			/* Floating point exception  */
#define	EXN_STK		0x000a			/* Stack fault		     */
#define	EXN_EIG0	0x000b			/* Emulated instruction grp0 */
#define	EXN_EIG1	0x000c			/* Emulated instruction grp1 */
#define	EXN_EIG2	0x000d			/* Emulated instruction grp2 */
#define	EXN_EIG3	0x000e			/* Emulated instruction grp3 */
#define	EXN_EIG4	0x000f			/* Emulated instruction grp4 */
#define	EXN_EIG5	0x0010			/* Emulated instruction grp5 */
#define	EXN_EIG6	0x0011			/* Emulated instruction grp6 */
#define	EXN_EIG7	0x0012			/* Emulated instruction grp7 */
#define	EXN_SWIN	0x0100			/* Software ints. (00 to FF) */

#define	S_EXIT		F_EXIT+1		/* exit flag values	     */
#define	ETF_STAY	0x00010000		/* Stay resident	     */

#define	S_GET		F_GET+1
#define	S_GIVE		F_GIVE+1
#define	S_GSX		F_GSX+1

#define	S_INSTALL	F_INSTALL+1		/* install option values     */
#define	INO_RMV		(BYTE)0x00		/* Remove driver	     */
#define	INO_LOD		(BYTE)0x01		/* Load driver		     */
#define	INO_ADD		(BYTE)0x02		/* Add unit to driver	     */
#define	INO_ASS		(BYTE)0x03		/* Associate sub-device	     */
						/* install flag values	     */
#define	INF_SET		0x0001			/* User raw SET allowed	     */
#define	INF_WRT		0x0004			/* User raw WRITE allowed    */
#define	INF_RRD		0x0008			/* User raw READ allowed     */
#define	INF_SHR		0x0010			/* Shared access allowed     */
#define	INF_RMV		0x0020			/* Removable device	     */
#define	INF_LCK		0x0040			/* DEVLOCKs allowed	     */
#define	INF_SHO		0x0080			/* Shared access only	     */
#define	INF_ADP		0x0100			/* Allow device partitions   */
#define	INF_FCAS	0x2000			/* Force case to media deflt */
#define	INF_LIT		0x4000			/* Literal name		     */

#define	S_KCTRL		F_KCTRL+1
#define	S_MCTRL		F_KCTRL+1		/* k/m ctrl flag values	     */
#define	KMF_MOU		0x0001			/* Mouse control	     */

#define	S_KEYPUT	F_KEYPUT+1

#define	SE_LOCK		F_LOCK+1		/* lock flag values	     */
#define	LKF_UNL		0x0000			/* Unlock		     */
#define	LKF_XL		0x0001			/* Exclusive lock	     */
#define	LKF_XWL		0x0002			/* Exclusive write lock	     */
#define	LKF_SWL		0x0003			/* Shared write lock	     */
#define	LKF_ERR		0x0010			/* Return error if conflict  */
#define	LKF_BEG		0x0000			/* Offset rel. to Beginning  */
#define	LKF_FP		0x0100			/* Offset rel. to File Ptr   */
#define	LKF_END		0x0200			/* Offset rel. to End	     */

#define	S_LOOKUP	F_LOOKUP+1		/* lookup flag values        */
#define	LUF_FCAS	0x2000			/* Force case to media deflt */
#define	LUF_LIT		0x4000			/* Literal name		     */
				       /* special flags for DISKFILE lookups */
#define	LDF_HID		0x0001			     /* include hidden files */
#define	LDF_SYS		0x0002			     /* include system files */
#define	LDF_VOL		0x0004			     /* include volume label */
#define	LDF_DIR		0x0008			      /* include directories */
#define	LDF_EXN		0x0010			   /* exclude "normal" files */
#define OP_LMOUNT	0x0100		/* Force a logical remount 	     */
#define OP_PMOUNT	0x0200		/* Force a physical mount only       */

#define	S_MALLOC	F_MALLOC+1

#define	SMO_XPND	0x0000
#define	SMO_NEW		0x0001

#define	S_MFREE		F_MFREE+1

#define	S_OPEN		F_OPEN+1		/* open flag values	     */
#define	OPF_DEL		0x0001			/* Delete/Set privileges     */
#define	OPF_EXC		0x0002			/* Execute privileges	     */
#define	OPF_WRT		0x0004			/* Write privileges	     */
#define	OPF_RD		0x0008			/* Read privileges	     */
#define	OPF_SHAR	0x0010			/* Shared access	     */
#define	OPF_SHRD	0x0020			/* Shared read access	     */
#define	OPF_SHFP	0x0040			/* Shared file pointer	     */
#define	OPF_RDC		0x0080			/* Reduced access accepted   */
#define	OPF_FCAS	0x2000			/* Force case to media deflt */
#define	OPF_LIT		0x4000			/* Literal name		     */

#define	S_ORDER		F_ORDER+1
#define	S_OVERLAY	F_OVERLAY+1

#define	S_READ		F_READ+1
#define	E_READ		F_READ+1
#define	S_RDELIM	F_READ+1		/* read flag values	     */
#define	RDF_FLS		0x0001			/* Flush bufs before read    */
#define	RDF_DLM		0x0002			/* Read until delimiter	     */
#define	RDF_NDS		0x0004			/* Non-destructive read	     */
#define	RDF_PINT	0x0008			/* Preinitialized read	     */
#define	RDF_INC		0x0010			/* Include delimiter in data */
#define	RDF_EDT		0x0020			/* Edited read		     */
#define	RDF_BEG		0x0000			/* Offset rel. to beginning  */
#define	RDF_FP		0x0100			/* Offset rel. to file ptr   */
#define	RDF_END		0x0200			/* Offset rel. to end	     */

#define	RDLIMAX		256			/* Max size of RDELIM buffer */

#define	S_RENAME	F_RENAME+1		/* rename flag values	     */
#define	RNF_FCAS	0x2000			/* Force case to media deflt */
#define	RNF_LIT		0x4000			/* Literal name		     */
#define	S_RETURN	F_RETURN+1

#define	S_RWAIT		F_RWAIT+1
#define	E_RWAIT		F_RWAIT+1		/* rwait flag values	     */
#define	RWF_CLIP	0x0001			/* clip to current window    */
#define	RWF_REXT	0x0002			/* return on exit from rect. */

#define	S_SEEK		F_SEEK+1		/* seek flag values	     */
#define	SKF_BEG		0x0000			/* Offset rel. to beginning  */
#define	SKF_FP		0x0100			/* Offset rel. to file ptr   */
#define	SKF_END		0x0200			/* Offset rel. to end	     */

#define	S_SET		F_SET+1

#define	S_SPECIAL	F_SPECIAL+1
#define	E_SPECIAL	F_SPECIAL+1		/* special options (subfunc) */
#define	SPF_RDSYS	(BYTE)0x00		/* Read system area	     */
#define	SPF_WTSYS	(BYTE)0x41		/* Write system area	     */
#define	SPF_FMSYS	(BYTE)0x02		/* Format system area	     */
#define	SPF_FMTRK	(BYTE)0x83		/* Format track		     */
#define	SPF_MDCHK	(BYTE)0x04		/* Media check		     */
#define	SPF_FLSBF	(BYTE)0x05		/* Flush buffers	     */
#define	SPF_RPHYS	(BYTE)0x86		/* Read physical: see below  */
#define	SPF_WPHYS	(BYTE)0xc7		/* Write physical see below  */
#define	SPF_INITF	(BYTE)0x48		/* Initialize format	     */
#define	SPF_PUD		(BYTE)0x09		/* Get PUD info		     */
#define	SPF_GTPT	(BYTE)0x13		/* Get port info	     */
#define	SPF_STPT	(BYTE)0x93		/* Set port info	     */

#define	SPF_OEM		(BYTE)0x20		/* OEM specials base value   */
#define	SPF_FMASK	(BYTE)0x3f		/* Mask for function number  */
#define	SPF_DMASK	(BYTE)0xc0		/* Mask for direction bits   */
					     /* format track flag bit values */
#define	FTF_BAD		0x0002			/* force bad format enable   */
#define	FTF_DLS		0x0004			/* DOS style seclist	     */
#define	FTF_CLS		0x0008			/* FlexOS style seclist  */
					    /* read physical flag bit values */
#define	RPF_VRF		0x0004			/* perform verify	     */

#define	S_STATUS	F_STATUS+1

#define	S_SWIRET	F_SWIRET+1		/* swiret option values	     */
#define	SWO_CONT	(LONG)0			/* Return and continue	     */
#define	SWO_MAIN	(LONG)1			/* Return as main process    */


#define	S_TIMER		F_TIMER+1
#define	E_TIMER		F_TIMER+1		/* timer flag values	     */
#define	TMF_ABS		0x0001			/* Absolute (non-relative)   */

#define	S_WAIT		F_WAIT+1

#define	S_WRITE		F_WRITE+1
#define	E_WRITE		F_WRITE+1		/* write flag values	     */
#define	WRF_FLS		0x0001			/* Flush LRUs after write    */
#define	WRF_TRUN	0x0002			/* Truncate to offset size   */
#define	WRF_ZERO	0x0080			/* Write with zero fill	     */
#define	WRF_BEG		0x0000			/* Offset rel. to beginning  */
#define	WRF_FP		0x0100			/* Offset rel. to file ptr   */
#define	WRF_END		0x0200			/* Offset rel. to end	     */

#define	S_XLAT		F_XLAT+1		/* xlat flag values	     */
#define	XLF_REP		0x0001			/* Replace table (don't add) */


/* miscellaneous structures */
					   /* key xlat table entry structure */
#define	KXMAX	14
#define	KEYXLAT	struct	_keyxlat
KEYXLAT
{
	UWORD	kx_key;			  /* 16 bit keychar to be translated */
	UWORD	kx_nch;		       /* number of chars to replace it with */
	UWORD	kx_str[KXMAX];			       /* replacement string */
};

#define	PL_NPLANE	3
#define FRAME	struct	_frame
FRAME
{
    BYTE	*fr_pl[PL_NPLANE];	/* char, attrib and extension planes */
    UWORD	fr_nrow;
    UWORD	fr_ncol;
    UWORD	fr_use;
};

#define RECT	struct	_rect
RECT
{
    WORD	r_row;
    WORD	r_col;
    WORD	r_nrow;
    WORD	r_ncol;
};
						/* command process info	     */
#define	PINFO		struct	_pinfo
PINFO
{
	BYTE	pi_pname[NAME1];
	BYTE	pi_prior;
	BYTE	pi_rsvd1;
	LONG	pi_maxm;
	LONG	pi_addm;
};
					/* GSX parameter block structure     */
#define	GSXPB	struct	_gsxpb
GSXPB
{
	ULONG	gsx_contrl;
	ULONG	gsx_intin;
	ULONG	gsx_ptsin;
	ULONG	gsx_intout;
	ULONG	gsx_ptsout;
	ULONG	gsx_rsvd;
};

				      /* memory parameter block for S_MALLOC */
#define	MPB	struct	_mpb
MPB
{
	ULONG	mpb_start;
	ULONG	mpb_minact;
	ULONG	mpb_max;
};
						/* structure for physicals   */
#define	PHYSP	struct	_physp
PHYSP
{
	UBYTE		phys_head;
	UBYTE		phys_sector;
	UWORD		phys_cylinder;
};

#define	DIRENT	struct	_direntry
DIRENT	
{
	UBYTE	f_name[11];		/* file name */
	UBYTE	f_datts;		/* attributes */

		/* 0x01 = read/only */
		/* 0x02 = hidden */
		/* 0x04 = system */
		/* 0x08 = volume label */
		/* 0x10 = sub-directory */
		/* 0x20 = archive attribute */
		/* 0x40 = reserved */
		/* 0x80 = reserved */

	UBYTE	f_datts2;		/* More attributes */

		/* 0x01 = security enabled (label only) */
		/* 0x02 = disk supports upper/lower case */
		/* 0x04 - 0x80 = reserved */
	
	UBYTE	f_rsrv[3];

	UWORD	f_recsize;		/* record size */
	UBYTE	f_user;			/* user ID of file owner */
	UBYTE	f_group;		/* group ID of file owner */
	UWORD	f_protect;		/* file protection */

		/* format = (----rwedrwedrwed) */
		/*                 w   g   o   */

	UWORD	f_time;			/* time of last modification */

		/* format = (hhhhhmmmmmmsssss) */

	UWORD	f_date;			/* date of last modification */

		/* format = (yyyyyyymmmmddddd) */

	UWORD	f_block1;		/* 1st block in file */
	LONG	f_size;			/* file size */
};


#define	MDB	struct	_mdb			   /* Media Descriptor Block */
MDB
{
	UWORD	mdb_ssize;			     /* bytes per sector (*) */
	UWORD	mdb_firstsec;	 /* Physical sector # of 1st FAT or ROOT dir */
	ULONG	mdb_nsectors;	  /* Total # of sectors in logical image (*) */
	UWORD	mdb_spt;			    /* sectors per track (*) */
	UWORD	mdb_spb;		     /* sectors per allocation block */
	UBYTE	mdb_nfats;			     /* number of FAT copies */
	UBYTE	mdb_media;				       /* media code */
	UWORD	mdb_fsecs;		/* number of sectors in a single FAT */
	UWORD	mdb_dirsize;	       /* # of directory entries in the ROOT */
	UBYTE	mdb_nheads;				  /* number of heads */
	UBYTE	mdb_format;			  /* file system format code */
	ULONG	mdb_hidesecs;		     /* number of hidden sectors (*) */
	ULONG	mdb_sysize;		   /* number of bytes in SYSAREA (*) */
};

#define	BOOTREC	struct	_bootrec		    /* Boot record structure */
BOOTREC
{
	UBYTE	br_jmp2code[3];	  /* NEAR jump to code area at end of struct */
	UBYTE	br_oemname[8];			     /* OEM name and version */
	UWORD	br_ssize;				 /* bytes per sector */
	UBYTE	br_spb;			     /* sectors per allocation block */
	UWORD	br_rsvdsecs;		       /* number of reserved sectors */
	UBYTE	br_nfats;			     /* number of FAT copies */
	UWORD	br_dirsize;	       /* # of directory entries in the ROOT */
	UWORD	br_nsectors;	       /* # of sectors in logical disk image */
	UBYTE	br_media;			    /* media descriptor code */
	UWORD	br_fsecs;		/* number of sectors in a single FAT */
	UWORD	br_spt;			      /* number of sectors per track */
	UWORD	br_nheads;				  /* number of heads */
	ULONG	br_hidesecs;			 /* number of hidden sectors */
	ULONG	br_drinsecs;			   /* DRI nsectors extension */
	ULONG	br_filestart;			/* start of filespace (sec#) */
	ULONG	br_cbase;			/* address of code load base */
	ULONG	br_clen;				   /* length of code */
	ULONG	br_dbase;			/* address of data load base */
	ULONG	br_dlen;				   /* length of data */
	UBYTE	br_code[454];					 /* bootcode */
	UBYTE	br_signature[2];		    /* boot record signature */
};

#define	SHDR286	struct	_shdr286		 /* System file header (286) */
SHDR286
{
	ULONG	h86_cbase;			/* address of code load base */
	ULONG	h86_clen;				   /* length of code */
	ULONG	h86_dbase;			/* address of data load base */
	ULONG	h86_dlen;				   /* length of data */
	UWORD	h86_rsvd[56];/* reserved filler to make total size 80H bytes */
};

#define	SHDR68K	struct	_shdr68K		 /* System file header (68K) */
SHDR68K
{
	UBYTE	h68_signature[2];		/* CP/M-68K Linker signature */
	ULONG	h68_clen;				   /* length of code */
	ULONG	h68_dlen;				   /* length of data */
	ULONG	h68_udlen;		       /* length of unitialized data */
	ULONG	h68_rl[2];				   /* reserved longs */
	ULONG	h68_cbase;			/* address of code load base */
	UWORD	h68_rw;					    /* reserved word */
	ULONG	h68_dbase;			/* address of data load base */
	ULONG	h68_udbase;	    /* address of unitialized data load base */
};

#define	H68KSIG1	(BYTE)0x60	      /* 68K header signature values */
#define	H68KSIG2	(BYTE)0x1b


#define	PTE	struct	_pte		 /* Fixed disk partition table entry */
PTE
{
	UBYTE	pte_bootind;		  /* active boot partition indicator */
	UBYTE	pte_shead;				       /* start head */
	UBYTE	pte_ssector;		      /* start sector (lower 6 bits) */
	UBYTE	pte_scylinder; /* start cylinder (plus upper 2 sector bits ) */
	UBYTE	pte_sysind;		/* system indicator 1 = DOS, 0 = unk */
	UBYTE	pte_ehead;					 /* end head */
	UBYTE	pte_esector;			      /* end sector (6 bits) */
	UBYTE	pte_ecylinder;			   /* end cylinder (10 bits) */
	ULONG	pte_relsec;		     /* relative start sector number */
	ULONG	pte_nsecs;		   /* number of sectors in partition */
};
						   /* values for pte.bootind */
#define	PARTACTIVE	(BYTE)0x80		  /* active (boot) partition */
#define	PARTINACT	(BYTE)0x00
						    /* values for pte.sysind */
#define	UNKSYS		(BYTE)0x00
#define	DOS12B		(BYTE)0x01
#define	DOS16B		(BYTE)0x04

#define	MAXPARTS	4		     /* maximum number of partitions */

#define	MBPR	struct	_mbpr		     /* Master Boot Partition Record */
MBPR
{
	UBYTE	mbpr_bootcode[446];		       /* area for boot code */
	PTE	mbpr_pte[MAXPARTS];			  /* partition table */
	UBYTE	mbpr_signature[2];		      /* MBPR/boot signature */
};

#define	BSIG1	0x55			       /* MBPR/boot signature values */
#define	BSIG2	0xaa


#define	MAXSPT		256	  /* practical max, actual use as word value */

#define	FMTDAT	struct	_fmtdat		  /* Special function #3 data buffer */
FMTDAT
{
	UBYTE	fmt_head;				     /* current head */
	UBYTE	fmt_rsvd;
	UWORD	fmt_cyl;				 /* current cylinder */
	UBYTE	fmt_density;				     /* density info */
	UBYTE	fmt_fill;				   /* data fill byte */
	UWORD	fmt_ssize;				 /* bytes per sector */
	UWORD	fmt_spt;				/* sectors per track */
	UWORD	fmt_sector;				   /* current sector */
};

#define	DOSLST	struct	_doslst		 /* Dos style interleave info struct */
DOSLST
{
	UBYTE	dl_cyl;
	UBYTE	dl_hd;
	UBYTE	dl_sec;
	UBYTE	dl_n;
};

#define	FDATDOS	struct	_fdatdos	  /* Special func #3 - for DOS style */
FDATDOS
{
	FMTDAT	fd;
	DOSLST	fmt_dosilv[MAXSPT];			 /* interleave table */
};

#define	FDATCON	struct	_fdatcon	  /* Special func #3 - for CON style */
FDATCON
{
	FMTDAT	fd;
	UWORD	fmt_conilv[MAXSPT];			 /* interleave table */
};

		 /* media density codes for FMTDAT.density & FMTINFO.density */
#define	SNG_DEN		(UBYTE)0x00
#define	DBL_DEN		(UBYTE)0x01


#define	FMTINFO	struct	_fmtinfo		 /* Format information block */
FMTINFO
{
	UWORD	fi_nhds;				  /* number of heads */
	ULONG	fi_nsecs;				/* number of sectors */
	UWORD	fi_spt;					/* sectors per track */
	UWORD	fi_ssize;				 /* bytes per sector */
	UWORD	fi_startsec;		   /* start sector (usually 0 or 1 ) */
	BOOLEAN	fi_lstflg;    /* interleave flag, TRUE = list, FALSE = start */
	BOOLEAN	fi_ltype;	     /* list type, TRUE = FlexOS, FALSE = DOS */
	UWORD	*fi_interleave;		      /* pointer to interleave table */
	UWORD	fi_skewf;			    /* skew factor, 0 = none */
	ULONG	fi_hidesecs;			 /* number of hidden sectors */
	UWORD	fi_bootsecs;			   /* number of boot sectors */
	UWORD	fi_spb;		   /* number of sectors per allocation block */
	UWORD	fi_nfats;			     /* number of FAT copies */
	UWORD	fi_fsecs;		   /* number of FAT sectors per copy */
	UWORD	fi_dirsize;	      /* number of directory entries in ROOT */
	ULONG	fi_sysize;			/*number of bytes in sysarea */
	UBYTE	fi_density;				     /* density info */
	UBYTE	fi_format;				 /* file system code */
	UBYTE	fi_media;				       /* media code */
	UBYTE	fi_fill;				      /* filler byte */
	UBYTE	*fi_saimage;		     /* pointer to system area image */
	MBPR	*fi_mbprimg;			/* pointer to full disk MBPR */
	BOOTREC	*fi_bimage;		       /* pointer to boot image data */
	UWORD	fi_landzone;		     /* landing zone cylinder number */
	UWORD	fi_precomp;		       /* write pre-comp start track */
};

#define BRDFN   struct _brdfn				 /* Backup & Restore */
struct _brdfn
{
        LONG    dfn_lookid;
        BYTE    dfn_name[18];
};

/* miscellaneous defines */
						       /* FlexOS stddevs */
#ifndef STDIN
#define	STDIN		(LONG)0
#endif

#ifndef STDOUT
#define	STDOUT		(LONG)1
#endif

#ifndef STDERR
#define	STDERR		(LONG)2
#endif

#define	SECLIST		TRUE			 /* list flag, list or start */
#define	STARTSEC	!SECLIST

#define	CCLIST		TRUE		      /* list type flag, FlexOS or DOS */
#define	DOSLIST		!CCLIST
							 /* FAT table values */
#define	FREE_FAT	0x0000				/* unallocated entry */
#define	FILE_FAT	0x0002			 /* starting file FAT number */
#define	BADB_FAT	0xfff7				  /* bad block entry */
#define	ENDF_FAT	0xfff8		/* (up to 0xffff) end of file marker */

#define	MAXBPS		4096			  /* maximum byte per sector */
#define	BPDE		32			/* bytes per directory entry */

							     /* buffer sizes */
#define	VOLMAX		11			 /* volume label name length */
#define	DEVMAX		33	/* device name (with node::) buffer size (?) */
#define	PATHMAX		128		/* path spec buffer size: see BUFSIZ */
#define	FILMAX		10		  /* filename buffer size: see NAME1 */
#define	EXTMAX		5		       /* file extension buffer size */
#define	SPECMAX		DEVMAX+PATHMAX+FILMAX+EXTMAX-3	   /* full spec size */

#define	UWNULLPTR	(UWORD *) 0
#define	BRNULLPTR	(BOOTREC *)0
#define	MRNULLPTR	(MBPR *)0

/* */
