/*===============================================================*
 *   Version 1.2        YDK.H                                    *
 *                      O.S. interface and internal definitions  *
 *                      for the PC/AT hard disk driver           *
 *---------------------------------------------------------------*
 *    VERSION   DATE    BY      CHANGE/COMMENTS                  *
 *---------------------------------------------------------------*
 *                                                               *
 *     1.1    8/14/86   mei     DKO_INFM must be DKO_INFMT       *
 *     1.2    9/17/86	DR-K	added DKO_PUD for format	 *
 *                                                               *
 *===============================================================*
 */

/*
 *  structure name defines
 */

#define LUTE    struct _DkLUTEntry
#define P2L     struct _Physical2Logical
#define DKPBLK  struct _DkIoParmBlock
#define DKSPPB  struct _DkSpecParmBlock
#define DKSELPB struct _DkSelParmBlock
#define DKGETPB struct _DkGetParmBlock
#define DKSDPB  struct _DkSubDrvPBlock
#define PUD struct _PUnitDescr
#define LDD struct _LogDiskDescr
#define BPB struct _BiosPartBlock
#define BTREC   struct _BootRecord
#define MDB struct DK_Media_Descriptor
#define HSCADDR struct _DiskAddress
#define IORB    struct _IoReqBlock
#define DKH struct _DkDriverHeader
#define PTE struct _partitionTable
#define MBPR    struct _MasterBootRecord
#define FPBUF   struct _FmtParmBuff
#define DKTIMPB struct _dktimerparmblock


/**********************************************************************
*  disk driver configuration constants
*/

#define DKASRPRI    190 /* asr priority     */

/**********************************************************************
*  disk driver constants
*/

#define DKREAD      1
#define DKWRITE     2
#define DKRECAL     3
#define DKRDID      4
#define DKRDTRK     5
#define DKFMT       6
#define DKFMTLST    7
#define DKFMTBB     8
#define DKFMTBBLST  9
#define DKVERIFY    10


/************************************************************************
*  general disk driver conditional compile switches
*/


/************************************************************************
*  general disk driver code macros
*
*/


#define DKASR(a,b,c)    DOASR(a,b,c,DKASRPRI)
#define DKNASR(a,b,c,d) NEXTASR(a,b,c,d,DKASRPRI)

/************************************************************************
 *  disk driver type definitions
 ************************************************************************/

#define SSN LONG        /*  Sequential Sector Number        */
#define SECTOR  UWORD       /*  Sector Number           */


/************************************************************************
 *  disk driver structure type definitions
 ************************************************************************/


/***************************************************
 *  HSCADDR -
 *  disk address.  Head, Sector, Cylinder
 *
 */

HSCADDR
{
	UBYTE   hsc_head ;  /*  head number (0, 1, ... )        */
	UBYTE   hsc_sector ;    /*  sector number (1, 2, ...)       */
	UWORD   hsc_cyl ;   /*  cylinder number (0, 1, ...)     */
} ;


/***************************************************
 *  DKPBLK -
 *  Disk Parm Block.  Parameter block given to disk drivers
 *  for reads and writes.
 *
 */

DKPBLK
{
	UBYTE   dk_unitno ; /*  unit number             */
	UBYTE   dk_option ; /*  option byte             */
	UWORD   dk_flags ;  /*  flag word               */
	LONG    dk_swi ;    /*  software interrupt routine address  */
	LONG    dk_pdaddr ; /*  address of Process Descriptor   */
	BYTE    *dk_buffer ;    /*  address of caller's  buffer     */
	LONG    dk_nsecs ;  /*  number of records for i/o       */
	LONG    dk_record ; /*  disk address to start i/o       */
				/*  (either hh,ss,cccc or log sec nbr)  */
} ;

/*
 *  option values
 */

#define DKO_RDSYS   0
#define DKO_WRSYS   1
#define DKO_FMSYS   2
#define DKO_FMTRK   3
#define DKO_INFMT   8
#define DKO_PUD	    9

/*
 *  flags in dk_flags
 */

#define DKF_UADDR   0x8000      /* user not system address  */
#define DKF_VERIFY  0x04        /* verify not read i/o      */
#define DKF_HSCADDR 0x02
			/*  record is in  Head Sector Cylinder Format   */
			/*               (BYTE)(BYTE) (WORD)        */

/**************************************************
 * FPBUFF - format parameter buffer
 *
 */

FPBUF
{
	BYTE    fp_head ;   /* head #           */
	BYTE    fp_res ;    /* reserved         */
	WORD    fp_cyl ;    /* cylinder #           */
	BYTE    fp_ddens ;  /* density          */
	BYTE    fp_fill ;   /* fill character       */
	WORD    fp_bytsec ; /* bytes/sector         */
	WORD    fp_sectrk ; /* sectors/track        */
	WORD    fp_stsec ;  /* starting sector      */
	BYTE    fp_list ;   /* list of sectors      */
} ;




/***************************************************
*  DKSPPB -
*   Disk Special Parm BLock.  Parm Block for
*   special i/o calls.
*/

DKSPPB
{
	BYTE    dsp_unitno ;    /*  logical unit number         */
	BYTE    dsp_funcno ;    /*  special function code       */
	WORD    dsp_flags ; /*  flags -  see DKF_  flags in DKPBLK  */
	BYTE    *dsp_res1 ; /*  reserved                */
	LONG    dsp_pdaddr ;    /*  process descriptor address      */
	BYTE    *dsp_buffer ;   /*  ptr to i/o buffer           */
	LONG    dsp_bufsiz ;    /*  number of bytes in i/o buffer   */
	FPBUF   *dsp_prbuf ;    /*  ptr to format parm buffer       */
	LONG    dsp_prsiz ; /*  size of format parm buffer      */
} ;

/*
*  [1]  if DKF_HSCADDR is true (in the flag word), then this is a physical
*   head/track address in HSC format.  otherwise, it is a logical track
*   number, which is an offset from Logical Track 0.
*/

/***************************************************
*  DKSELPB -
*   Disk Select Parameter Block.  Parm Block for
*   Select Calls to disk drivers.
*/

DKSELPB
{
	BYTE    dks_unitno ;        /*  hi level logical unit nbr   */
	BYTE    dks_reserved ;      /*  unused          */
	MDB *dks_mdbp ;     /*  ptr to dsk man's med descr  */
} ;

/***************************************************
*  DKGETPB -
*   disk get parm block.
*/

DKGETPB
{
	UBYTE   fgt_unitno ;
	UBYTE   fgt_res[3] ;
	UWORD   fgt_dtype ;
	UWORD   fgt_maxrs ;
	UBYTE   *fgt_addr ;
	UWORD   fgt_maxfatrecs ;
	UWORD   fgt_mxfsize ;
	UWORD   fgt_mxdsize ;
} ;


/***************************************************
*  DKSDPB -
*   disk subdrive parm block.
*/

DKSDPB
{
	UBYTE   dsd_unitno ;        /*  hi level logical unit nbr   */
	UBYTE   dsd_driveno ;       /*  low level phys drive nbr    */
	WORD    dsd_res ;
	DKH *dsd_dh ;       /*  ptr to subdrive's DH    */
} ;


/*******************************************************************
 *  MDB -
 *  Media Descriptor Block.
 *
 */

MDB
{
	SECTOR  md_secsiz ;
	SECTOR  md_1sec ;
	ULONG   md_nsecs ;
	SECTOR  md_sectrk ;
	SECTOR  md_secblk ;
	UBYTE   md_nfats ;
	UBYTE   md_mdb ;
	SECTOR  md_nfrecs ;
	UWORD   md_dirsize ;
	UBYTE   md_nheads ;
	UBYTE   md_format ;
	ULONG   md_hidden ;
	ULONG   md_syssize ;
} ;

#define MDCPM       0   /*  format byte, cpm media (non-DOS)    */
#define MDDOS       1   /*  format byte, DOS media 1.5 byte fats */
#define MDDOSX      2   /*  format byte, DOS media 2.0 byte fats */



/***************************************************
*  IORB -
*   I/O Request Block.  Parms past to the lowest command level
*   routines.
*
*   The block is broken into three parts:
*
*       i/o parameters... The disk op field, the total number
*       of sectors, the starting seq sector number, the buffer
*       address (in system space), the proc descriptor address,
*       and the swi address... These fields are setup and passed
*       to the low level routines by the high level routines.
*
*       physical i/o paramaters... these fields are provided for
*       use by the low level drivers, who may need to break up
*       the request in to several requests, and may need head,
*       sector, cylinder addresses.
*
*       dma block... parms for the dma.  This also must be setup by
*       by the low level routines.
*/

IORB
{
	WORD    io_op ;     /*  opcode (read,write,format,etc)  */
	WORD    io_type ;   /*  type of io ( fat,dir,data r/w ) */
	LONG    io_totnsecs ;   /*  total number of sectors     */
	SSN     io_stssn ;  /*  starting sequential sector #    */
	SYSADDR io_buffer ; /*  address of buffer in system space   */
	WORD    io_rtc ;    /*  retry count             */

	HSCADDR io_dkaddr ; /*  head sector cyl address     */
	WORD    io_nsecs ;  /*  current number of sectors       */

	PHYSADDR io_dmaddr ;    /*  dma address, setup by low level */
	LONG    io_dmcount ;    /*  number of bytes, setup by low level */

	ERROR   io_error ;  /*  return code for request     */
	LONG    io_savnsecs ;   /*  same as io_totnsecs for verify  */
	SSN io_savssn ; /*  same as io_stssn for verify     */
} ;

/***************************************************
*  LDD -
*   Logical Disk Descriptor
*/

LDD
{
	SSN ld_stssn ;  /*  starting ssn for the logical disk   */
	SSN ld_endssn ; /*  ending   ssn for the logical disk   */
	BYTE    ld_stsec ;  /*  starting phy sec #          */
	MDB ld_mdb ;    /*  mdb                 */
} ;



/***************************************************
*  LUTE -
*   disk logical unit table entry.
*/

LUTE
{
	IORB    lu_iorb ;       /*  i/o request block       */

	PD  *lu_b_pdaddr ;      /*  ptr to PB PD        */
	PD  *lu_pdaddr ;        /*  ptr to requesting PD    */
	LONG    lu_swi ;        /*  address of req proc's swi   */

	PUD *lu_pudp ;      /*  ptr to phy unit table   */
	LDD *lu_lddp ;      /*  ptr to Log Disk Descriptor  */


	FLAGNO  lu_ioflagno ;       /*  i/o flagnumber      */
	BYTE    lu_unitno ;     /*  logical unit number     */
	BYTE    lu_driveno ;        /*  physical unit number    */
	WORD    lu_iflag ;      /*  install flags       */
	WORD    lu_flags ;      /*  request flags       */
} ;

/*****************************************************************
* Physical to Logical Mapping table entry.
*/

P2L
{
	ISR     (*seqisr)() ;   /* next ISR for current command sequence */
	LUTE    *physlute ;     /* pointer to the logical unit table for unit */
	WORD    curcyl ;        /* current cylinder for the seek */
} ;


/***************************************************
*  PUD -
*   Physical Unit Descr
*
*/
#define PUD struct _PUnitDescr

PUD
{
	UWORD   pu_maxcyl ;     /* max cyl # for i/o        */
	UWORD   pu_precomp ;        /*  precomp cylinder no     */
	UWORD   pu_crashpad ;       /*  landing zone cylinder no    */
	UBYTE   pu_nheads ;     /*  no of heads         */
	UBYTE   pu_sectors ;        /*  no sectors/track        */
	UBYTE   pu_step ;       /*  step rate           */
	UBYTE   pu_eat ;        /*  even            */
} ;


/***************************************************
*  BPB -
*   Bios Parameter Block
*
*/

BPB
{
	UBYTE   bpb_njump[3];   /* 3 BYTE near JUMP to boot code    */
	UBYTE   bpb_oem[8]; /* 8 BYTE OEM name and version      */
	UWORD   bpb_bps;    /* WORD bytes per sector        */
	UBYTE   bpb_spau;   /* BYTE sectors per allocation unit */
	UWORD   bpb_rs;     /* WORD reserved sectors        */
	UBYTE   bpb_nof;    /* BYTE number of FATs          */
	UWORD   bpb_nrde;   /* WORD number of root dir entries  */
	UWORD   bpb_nsli;   /* WORD number of sectors in logical im.*/
	UBYTE   bpb_md;     /* BYTE media descriptor        */
	UWORD   bpb_nsobsf; /* WORD number of sectors in single FAT */
	UWORD   bpb_spt;    /* WORD sectors per track       */
	UWORD   bpb_noh;    /* WORD number of heads         */
	UWORD   bpb_nohs;   /* WORD number of hidden sectors    */
	ULONG   bpb_nslx;   /* LONG DRI extension to # sec in log im.*/
};


/***********************************************************************
*  DKH -
*   Disk Driver Header.
*
*/

DKH
{
	UWORD   dkh_reserved    ;/* reserved field          */
	UBYTE   dkh_nbrunits    ;/* max number of units supported   */
	UBYTE   dkh_flags   ;/* flag word               */

	ERROR   (*dkh_init)()   ;/* pointer to init code        */
	ERROR   (*dkh_recal)()  ;/* pointer to recalibrate code     */
	ERROR   (*dkh_seek)()   ;/* pointer to init code        */
	ERROR   (*dkh_select)() ;/* pointer to select code      */
	ERROR   (*dkh_flush)()  ;/* pointer to flush code       */
	ERROR   (*dkh_io)() ;/* pointer to read code        */

	ERROR   (*dkh_res1)()   ;/*  reserved               */

	ERROR   (*dkh_get)()    ;/* pointer to get code         */
	ERROR   (*dkh_set)()    ;/* pointer to set code         */
	ERROR   (*dkh_format)() ;/* pointer to special code     */

	/*
	 *   all items below are filled in by the o/s and should be
	 *   initialized to 0L
	 */

	LONG    dkh_ctl0    ;/* reserved                */
	LONG    dkh_ctl1    ;/* reserved                */
	LONG    dkh_sync    ;/*  mxid for syncing on driver     */
	PD  **dkh_pdaddr    ;/*  pointer to current pd pointer  */
	LONG    dkh_sysfunc ;/*  ptr to os function table       */
} ;


/************************************************************************
 * PTE - partition table entry
 *  in the master boot record of DOS type fixed disk media
 *  defines 1 of 4 possible partitions on the media
 */

PTE
{
	BYTE    bootind ;   /* active boot partition indicator 1 per sys*/
	BYTE    shead ;     /* start head               */
	BYTE    ssector ;   /* starting sector (lower 6 bits)   */
	BYTE    scylinder ; /* start cylinder less upper 2 sector bits*/
	BYTE    sysird ;    /* sys type indicator 1=DOS 0=OTHER */
	BYTE    ehead ;     /* ending head no for this partition    */
	BYTE    esector ;   /* end sector (6 bits)          */
	BYTE    ecylinder ; /* end cylinder (10 bits )      */
	LONG    relsec ;    /* relative starting sector no      */
	LONG    nsecs ;     /* no of sectors in partition       */
} ;

MBPR
{
	BYTE    bootcode[446];  /* offset to PTE in master boot record  */
	PTE pte[4];     /* partition table has 4 partition table entries*/
	WORD    signature;  /* MBPR/boot signature          */
} ;

DKTIMPB
{
	UBYTE   tim_sync ;  /* 0=sync , 1=async     */
	UBYTE   tim_res ;   /* reserved         */
	UWORD   tim_flags ; /* 1=absolute , 0 = relative    */
	LONG    tim_swi ;   /* action address       */
	LONG    tim_time ;  /* milliseconds         */
} ;
