
/*****************************************************************
 * "Copyright (C) 1985, Digital Research, Inc.  All Rights       *
 * Reserved.  The Software Code contained in this listing is     *
 * proprietary to Digital Research Inc., Monterey, California    *
 * and is covered by U.S. and other copyright protection.        *
 * Unauthorized copying, adaptation, distribution, use or        *
 * display is prohibited and may be subject to civil and         *
 * criminal penalties.  Disclosure to others is prohibited.  For *
 * the terms and conditions of software code use refer to the    *
 * appropriate Digital Research License Agreement."              *
 *****************************************************************/

/*===============================================================*
 *   Version 1.0        IFDGLOB.C                                *
 *                      Contians Global Declarations for         *
 *                      the Floppy Disk Driver.			 *
 *---------------------------------------------------------------*
 *    VERSION   DATE    BY      CHANGE/COMMENTS                  *
 *---------------------------------------------------------------*
 *    1.0       6/12/85 reb     rewritten/added to system        *
 *                                                               *
 *                                                               *
 *===============================================================*
 *  INCLUDES:                                                    */

#include        "portab.h"
#include        "system.h"              /*  system defines              */
#include        "atmc286.h"             /* machine defs                 */
#include        "io.h"                  /*  i/o driver definitions      */
/* (gam) 1 may - combined dk.h and floppy.h to one header file  */
#include        "fd.h"

/*****************************************************************************
*  FDU -
*       Global Unit Table ptr.
*       points to the FDLUTE for the unit we are currently working on.
*/

FDLUTE  *FDU ;

/*****************************************************************************
*  FDI -
*       Global Iorb Ptr.
*       Points to the IORB containing the request currently being served.
*/

IORB    *FDI ;

/*****************************************************************************
*  FDDRIVE -
*       Global Drive nbr.
*       Physical Drive number of the drive for the current request.
*/

BYTE    FDDRIVE ;

/*****************************************************************************
*  FDASR -
*       Global Async Routine pointer.
*       If routine wishes an ASR to be dispatched after the next FDC interrupt
*       occurs, it will set the address of that routine in this pointer.  The
*       ISR will shedule it for dispatch.  It should be set to 0000 if it is
*       not being used.
*/

ASR     (*FDASR)() = NULLASR ;

/*****************************************************************************
*  FDISR -
*       Global ISR routine pointer.
*       If a routine wishes a routine to be called in ISR context to perform 
*       some specific action when the next FDC interrupt occurs, it should
*       set the address of that routine in this pointer.  This is so that the
*       second part of two step operations, such as SEEK/IO, can start the 2nd
*       step without haveing to wait for an ASR dispatch.  This pointer should
*       be set to 0000 when not in use.
*/

ISR     (*FDISR)() = NULLISR ;                                  /*  M0003  */

/************************************************************************
*  CurCyl -
*       The last cylinder we did a seek to is stored here so we can avoid
*       seeking to a cylinder we are already on.
*
*       a value of -1 indicates that the fdc has been reset or is lost,
*       and therefore a recal should be done before the next seek.
*/

WORD    CurCyl[] = { -1 , -1 }  ;


/************************************************************************
*  CurTF -
*       Global for ptr to currently active task file.
*/
FDTF    *CurTF ;

/*****************************************************************************
*  IOTF -
*       Task File used for the actual read/write/format request
*/
FDTF    IOTF ;

/*****************************************************************************
*  PSNTF -
*       Task File used for positioning the r/w heads (recal/seek).
*/
FDTF    PSNTF ;


/************************************************************************
*  IoRdy -
*       Indicates that the i/o task file is built and ready to be output
*       to the FDC.
*/

BOOLEAN         IoRdy ;

/************************************************************************
*  InPosn -
*       indicates that the r/w heads are in the correct location for the
*       r/w request.
*/

BOOLEAN         InPosn ;

/************************************************************************
*  IoFlag -
*       set to one at the start of each i/o request by fd_motor(ON,*).

        (gam): ioflag for  MACHINE == XMACHINE only

*       set to zero at periodic intervals by motortime.  Used to tell
*       if any i/o has occurred during the last motor polling period.
*/

BYTE            IoFlag[] = { 0 , 0 } ;

/************************************************************************
*  IoInProg -
*       set to one at the start of each i/o and set to 0 in fd_iocompl().
*       this prevents the motor routines from setting IoFlag 0 during a 
*       request (in case the motor poll routine gets called twice during
*       a single request).
*/

BYTE            IoInProg = 0 ;


/************************************************************************
*  motor_on -
*       indicates whether the diskette is spun up or not.
*/

#if     (MACHINE == XMACHINE)
BOOLEAN motor_on[] = { FALSE , FALSE } ;
#endif

#if     (MACHINE == COMPUPRO)
BOOLEAN motor_on[] = { TRUE , TRUE } ;          /* no motor, so always on */
#endif

/************************************************************************
*  dor_image -
*       the image of the last value output to the digital output reg.
*/

BYTE    dor_image = 0x0c ;  

/************************************************************************
*       StuckFdc -
*       If FOutCmd2Fdc determines a stuck fdc it will set this boolean as
*       well as returning false.                                [M0007]
*/

BOOLEAN StuckFdc = FALSE ;

/************************************************************************
*  FDG_PGFAULT -
*       Signals page fault mode.  This means that the i/o requests crosses
*       a page boundary, and we are currently processing the sector which
*       will cross it.  The users buffer is saved, and the sector is read
*       into a tmp allocated buffer, then copied into the users buffer.
*/

BOOLEAN FDG_PGFAULT = FALSE ;

/************************************************************************
*  FDG_Ubuff -
*       Original address of user's buffer is placed here when we go into
*       page fault mode.
*/

BYTE    *FDG_Ubuff ;

/************************************************************************
*  SPC_BUFF -
*       The starting address of the buffer used for
*               chrn buffer in format
*               special reads in media determination
*               blocking/deblocking when users buffer crosses pg boundary
*/
BYTE    *SPC_BUFF ;

BYTE    *SPR_BUFF ;             


/************************************************************************
*  RecalRetry -
*       nbr of retries on a recal.
*/

BYTE    RecalRetry ;

