/******************************************************************************
*	LOGOS.C
*
*	usage: LOGOS [-f device_name] [-m] [-c max_color]
*
*	Draws a fractal pyramid on the screen. Uses color when available.
*
*	-f	Choose the output device. Default is vdi01:
*	-m	Force output to be monochrome on color devices.
*	-c	Maximum colors available. Overwritten by -m.
*******************************************************************************/


#include <portab.h>
#undef	NULL
#include <stdio.h>
#include <ctype.h>
#include <string.h>
#include "vdibind.h"

EXTERN LONG s_open(), s_close();
EXTERN LONG s_timer(), s_swiret(), e_termevent();
EXTERN WORD atoi();

WORD qsetheight();
void docolors();

WORD contrl[12];
WORD intin[128];
WORD ptsin[128];
WORD intout[128];
WORD ptsout[128];

LONG gdvr;
WORD xmax, ymax;
WORD maxcol;
WORD work_out[60];
WORD handle;

BYTE dftdev[20] = "vdi01:";
WORD mono = 0;

WORD drilogo[32] = {
    0x7FFF,0xFFFC,
    0x8000,0x0002,
    0x9FFC,0x7FF2,
    0xBFFE,0x800A,
    0xBFFE,0x800A,
    0xBFFE,0x800A,
    0xBFFE,0x800A,
    0xBFFE,0x800A,
    0xBFFE,0x800A,
    0xBFFE,0x800A,
    0xBFFE,0x800A,
    0xBFFE,0x800A,
    0xBFFE,0x800A,
    0x9FFC,0x7FF2,
    0x8000,0x0002,
    0x7FFF,0xFFFC
    };

struct _mfdb {
    WORD *mfd_image;
    WORD mfd_width, mfd_height;
    WORD mfd_wwidth;
    WORD mfd_format;
    WORD mfd_planes;
    WORD mfd_dummy[8];
};

WORD toscreen[] = { 0, 0, 31, 15, 0, 0, 0, 0 };

WORD gembuff[32];

struct _mfdb stdmfdb = { drilogo, 32, 16, 2, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0 };
struct _mfdb gemmfdb = { gembuff, 32, 16, 2, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0 };
struct _mfdb scnmfdb = {       0,  0,  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 };

WORD col[2] = { 9, 7 };

BYTE mes1[] = "Digital Research";
BYTE mes2[] = "We Make Computers Work";

WORD pextent[10];

WORD doswitch(argc,argv)
WORD argc;
BYTE *argv[];
{
    LONG rc;
    WORD acnt, i, collim = -1;
    BYTE *s;

    for(acnt=0; ++acnt < argc;){
	if(*argv[acnt] == '-'){
	    s = argv[acnt] + 1;
	    switch(*s++){
		case 'f':			/* Alt vdi name */
		    if(!*s){
			if(acnt == (argc-1)){
			    printf("Missing device name.\n");
			    return(0);
			    }
			else{
			    s = argv[++acnt];
			    strcpy(dftdev,s);
			    strcpy(s,"-");
			    }
			}
		    else strcpy(dftdev,s);
		    printf("VDI = %s\n",dftdev);
		    break;

		case 'c':			/* Set maximum color */
		    if(!*s){
			if(acnt == (argc-1)){
			    printf("Missing maximum color.\n");
			    return(0);
			    }
			else{
			    s = argv[++acnt];
			    collim = atoi(s);
			    strcpy(s,"-");
			    }
			}
		    else collim = atoi(s);
		    if(collim < 2){
			printf("Maximum Color must be >= 2.\n");
			return(0);
			}
		    printf("Maximum Color = %d\n",collim);
		    break;

		case 'm':			/* Run it in monochrome */
		    printf("Monochrome enabled.\n");
		    ++mono;
		    break;

		case '\0':			/* Null argument */
		    break;

		default:
		    printf("Unrecognized argument -- \"-%s\"\n",s);
		    return(0);
		}
	    }
	}
    if(strncmp(dftdev,"vdi",3) || !(isdigit(dftdev[3])) ||
	!(isdigit(dftdev[4])) || (dftdev[5] != ':')){
	printf("Illegal vdi name \"%s\".\n",dftdev);
	return(0);
	}
    else i = (dftdev[3]-'0')*10 + (dftdev[4]-'0');

    if((rc=s_open(0,dftdev)) < 0){
	printf("Error %4lx while opening \"%s\".\n",rc,dftdev);
	return(0);
	}
    gdvr = rc;
    intin[0] = i;

    for(i=1; i<10;) intin[i++] = 1;
    intin[10] = 2;
    (void) v_opnwk(intin,&handle,work_out);
    xmax = work_out[0];
    ymax = work_out[1];
    maxcol = work_out[13];
    if((collim >= 2) && (collim < maxcol)) maxcol = collim;
    if(maxcol == 2) ++mono;
    else if(mono) maxcol = 2;
    return(1);
}

LONG shutdown(){
    (void) s_swiret(1L);
    (void) v_clswk(handle);
    return(s_close(0,gdvr));
}

LONG main(argc,argv)
WORD argc;
BYTE *argv[];
{
    WORD x, y, c, lim;

    if(!doswitch(argc,argv)) return(1);		/* Error in switches */

    if(maxcol == 16) (void) e_termevent(shutdown,0L);

    (void) vr_trnfm(handle,&stdmfdb,&gemmfdb);

    lim = (maxcol < 16) ? (maxcol-3) : 6;
    if(mono) col[0] = 1;

    for(x=0; x <= xmax; x += 36){
	for(y=0; y <= ymax; y += 17){
	    toscreen[6] = xmax; toscreen[7] = ymax;
	    
	    if(!mono) col[0] = (x/36 + y/17) % lim + 2;
		
	    toscreen[4] = x; toscreen[5] = y;
	    (void) vrt_cpyfm(handle,2,toscreen,&gemmfdb,&scnmfdb,col);
	    }
	}

    (void) vst_load_fonts(handle,0);
    (void) vst_font(handle,2);

    (void) vst_alignment(handle,1,0,&c,&c);

    (void) vswr_mode(handle, 2);

    qsetheight(mes1);

    if(mono)
	(void) vst_effects(handle,2);

    (void) vst_color(handle,1);
    (void) v_gtext(handle,(xmax+1)/2-3,3*ymax/8+2,mes1);

    if(mono)
	(void) vst_effects(handle,0);

    (void) vst_color(handle,maxcol-1);
    (void) v_gtext(handle,(xmax+1)/2,3*ymax/8,mes1);

    qsetheight(mes2);

    if(mono)
	(void) vst_effects(handle,2);

    (void) vst_color(handle,1);
    (void) v_gtext(handle,(xmax+1)/2-3,5*ymax/8+2,mes2);

    if(mono)
	(void) vst_effects(handle,0);

    (void) vst_color(handle,maxcol-1);
    (void) v_gtext(handle,(xmax+1)/2,5*ymax/8,mes2);

    if(maxcol == 16)
	docolors();
    else
	(void) vrq_locator(handle,0,0,&x,&x,&x);

    return(shutdown());
}

WORD qsetheight(mes)
BYTE *mes;
{
    WORD y, c;

    y = 1000;
    do{
	(void) vst_point(handle,y,&c,&y,&c,&c);
	(void) vqt_extent(handle,mes,pextent);
	--y;
	} while(pextent[2] >= xmax);
    return(y+1);
}

WORD colarr[6][3] = {
    { 1000,	0,	0	},
    { 0,	1000,	0	},
    { 0,	0,	1000	},
    { 0,	1000,	1000	},
    { 1000,	1000,	0	},
    { 1000,	0,	1000	}
};

void docolors(){
    WORD i, sc, tc;

    sc = 0;
    for(;;--sc){
	if(sc == -1) sc = 5;
	for(tc=sc, i=2; i<8; ++i, ++tc){
	    if(tc == 6) tc = 0;
	    (void) vs_color(handle,i,colarr[tc]);
	    }
	(void) s_timer(0,33L);
	}
}
