/*****************************************************************************
*	EGA.H							   Version 1.0
*
*	Port values for the EGA card.
*
*	When		Who	Why
*	==============	=======	==============================================
* v1.0	10/24/86 11:31	BVH	Took it from the EGA GSXDEF.H
******************************************************************************/

/* External Registers */

#define	E_MOR	0x3C2		/* Miscellaneous output register */
#define	E_FCR	0x3DA		/* Feature control register */
#define	E_ISR0	0x3C2		/* Input status reg 0 */
#define	E_ISR1	0x3DA		/* Input status reg 1 */

/* Sequencer Registers */

#define	E_SEQ_A	0x3C4
#define	E_SEQ_D	0x3C5

/* CRT Control Registers */

#define	E_CC_A	0x3D4		/* CRT controller address */
#define	E_CC_D	0x3D5		/* CRT controller data */

/* Graphics Controller Registers */

#define	E_GC_P1	0x3CC		/* Graphics 1 position */
#define	E_GC_P2	0x3CA		/* Graphics 2 position */
#define	E_GC_A	0x3CE		/* Graphics 1 & 2 position */
#define	E_GC_D	0x3CF		/* Graphics Control Data */

/* Attribute Control Registers */

#define	E_ATT_C	0x3C0		/* Attribute Control Register */

/* Sequencer Registers */

#define	I_RESET	0x00		/* Sequencer Reset */
#define	I_CLOCK	0x01		/* Clock Mode */
#define	I_MAPM	0x02		/* Map Mask */
#define	I_CHARM	0x03		/* Character Map Select */
#define	I_MEMM	0x04		/* Memory Mode */

/* CRT Controller Registers */

#define	I_HTOT	0x00		/* Horizontal Total */
#define	I_HDISE	0x01		/* Horizontal Display End */
#define	I_HSTBL	0x02		/* Start Horizontal Blank */
#define	I_HEBL	0x03		/* End Horizontal Blank */
#define	I_HSTRE	0x04		/* Start Horizontal Retrace */
#define	I_HERE	0x05		/* End Horizontal Retrace */
#define	I_VTOT	0x06		/* Vertical Total */
#define	I_OVERF	0x07		/* Overflow */
#define	I_PRERS	0x08		/* Preset Row Scan */
#define	I_MAXSL	0x09		/* Maximum Scan Lines */
#define	I_CURS	0x0A		/* Cursor Start */
#define	I_CURE	0x0B		/* Cursor End */
#define	I_STAH	0x0C		/* Start Address High */
#define	I_STAL	0x0D		/* Start Address Low */
#define	I_CLH	0x0E		/* Cursor Location High */
#define	I_CLL	0x0F		/* Cursor Location Low */
#define	I_VSTRE	0x10		/* Vertical Retrace Start */
#define	I_LPH	0x10		/* Light Pen High */
#define	I_VEST	0x11		/* Vertical Retrace End */
#define	I_LPL	0x11		/* Light Pen Low */
#define	I_VDISE	0x12		/* Vertical Display End */
#define	I_OFFS	0x13		/* Offset */
#define	I_UNLOC	0x14		/* Underline Location */
#define	I_VSTBL	0x15		/* Start Vertical Blank */
#define	I_VEBI	0x16		/* End Vertical Blank */
#define	I_MODEC	0x17		/* Mode Control */
#define	I_LINEC	0x18		/* Line Compare */

/* Graphic Controller Registers */

#define	I_SETRE	0x00		/* Set/Reset */
#define	I_ENSR	0x01		/* Enable Set/Reset */
#define	I_COLCM	0x02		/* Color Compare */
#define	I_DAROT	0x03		/* Data Rotate */
#define	I_RMS	0x04		/* Read Map Select */
#define	I_MODER	0x05		/* Mode Register */
#define	I_MISC	0x06		/* Miscellaneous */
#define	I_CDC	0x07		/* Color Don't Care */
#define	I_BITM	0x08		/* Bit Mask */

/* Attribute Controller Registers */

#define	I_MODEA	0x10		/* Mode Control */
#define	I_OCR	0x11		/* Overscan Color Register */
#define	I_CPER	0x12		/* Color Plane Enable Register */
#define	I_HPPR	0x13		/* Horizontal Pel Panning Register */

/* Miscellaneous Values */

#define	RESET	0x00
#define	ENABLE_PALETTE	0x20

