/******************************************************************************
* PROTOS.H - Funtional prototypes of Common FlexOS routines	Version 1.3.01
*******************************************************************************
* Copyright (c) 1985, Digital Research, Inc. All Rights Reserved. The Software
* Code contained in this listing is proprietary to Digital Research, Inc.,
* Monterey, California and is covered by U.S. and other copyright protection.
* Unauthorized copying, adaptation, distribution, use or display is prohibited
* and may be subject to civil and criminal penalties.  Disclosure to others is
* prohibited.  For the terms and conditions of software code use refer to the
* appropriate Digital Research License Agreement.
*******************************************************************************
* Version   Date   Who  Description
* ======= ======== ===  =======================================================
*  1.3.01 05/05/87 jmb  Add new functions in lutils.c and free.c
*  1.3.00 09/12/86 mei  Creation
*
******************************************************************************/
/*****************************************************************************
*									     *
*  			This is protos.h				     *
*		Prototypes of common FLEXOS modules. 			     *						     *
*									     *
*	These prototypes were created by the Metaware Compiler using 	     *  	
*	pragma (print_protos).  These are C-Language routines only.	     *
*	Routines labeled MLOCAL are not included. MLOCALS have been 	     *
*	identified throughout the common modules except for console 	     *
*	manager modules. 						     *
*									     *
*	All common modules have been compiled with this prototype 	     *
*	file included. (9-12-86)							     *
*									     *
*	To include these prototypes in a Metaware compile, simply set	     *
*	the PROTOS switch in sysbuild.h. 				     *
*									     *
*	When fixing further modules for prototypes, be sure to change	     *
*	the "#if METAWARE" line near the beginning of each module to	     *
*	"#if PROTOS". The METAWARE switch pertains to return code 	     *
*	conventions, and is not presently being turned on.		     * 		
*									     *
******************************************************************************/
/*
**  10/1/86  PKB
**  references to CDOS, Concurrent or Concurrent DOS changed to FlexOS
*/



						/*  KERNEL  */
#ifndef ABORT
int trmsig(struct _pd *p, LONG errc);
VOID term_entry(LONG tcode);
int abt_chk(struct _pd *p, LONG errc);
VOID terminate(LONG rc);
VOID release();
LONG a_wterm(LONG pid, LONG aswi);
LONG abort_ctlc(LONG pid);
LONG abort_spec(LONG pid);
LONG abort_any(LONG pid, LONG errc);
VOID noabort();
VOID noabtspec(struct _pd *p);
VOID okabort();
VOID okabtspec(struct _pd *p);
#endif

#ifndef	AFLAG
LONG flagget();
LONG flagrel(struct _flag *f);
LONG flagclr(struct _flag *f);
LONG flagset(struct _flag *f, struct _pd *p, LONG rc);
WORD flgcan(struct evb *e);
LONG flagevent(struct _flag *f, LONG aswi);
WORD dlacan(struct evb *p);
LONG a_delay(LONG c, BYTE *aswi);
VOID tickit(LONG n);
#endif

#ifndef ASYNC
WORD setetype(WORD (*cod)());
VOID signal(struct evb *e);
VOID zombie(struct evb *e);
VOID evremove(struct evb *e);
VOID evinsert(struct evb *e, struct evb **root);
LONG mwait(LONG mask);
struct evb *asetup(LONG aswi);
struct evb *fasetup(LONG aswi, struct evb *e);
LONG garet(struct _pd *px, LONG mask);
LONG faret(struct _asr *asr);
LONG aret(LONG mask);
LONG acancel(LONG m);
VOID aacancel(LONG m);
LONG facan(struct _asr *asr);
WORD takeoff(struct evb *p);
LONG doasr(VOID (*fcode)(), LONG fdata1, LONG fdata2, WORD pri);
LONG ndoasr(LONG dh, VOID (*fcode)(), LONG fdata1, LONG fdata2,
	WORD pri);
LONG evasr(LONG mask, VOID (*cod)(), LONG dat2, WORD pri);
LONG nevasr(LONG dh, LONG mask, VOID (*cod)(), LONG dat2, WORD pri);
LONG pevasr(LONG mask, VOID (*cod)(), LONG dat2, WORD pri);
VOID nextasr(struct _asr *asr, VOID (*cod)(), LONG dat1, LONG dat2,
	WORD pri);
VOID nnextasr(LONG dh, struct _asr *asr, VOID (*cod)(), LONG dat1,
	LONG dat2, WORD pri);
VOID asrinsert(struct _asr *asr);
LONG pollevent(LONG p, LONG swi);
LONG npollevent(LONG dh, LONG p, LONG swi);
VOID goasr(LONG ev, VOID (*asr)(), LONG p1, LONG p2, WORD prior);
LONG _waitret(LONG event);
WORD _iecancel(struct evb *e);
VOID _ievinit();
LONG _adummy(BYTE *swi, LONG r);
VOID _evdone(struct evb *e);
struct spb *mxinit();
LONG mxuninit(struct spb *s);
LONG mxevent(struct spb *sy);
LONG fmxevent(struct spb *sy, struct evb *e);
LONG asrmx(struct spb *sy);
LONG sync(struct spb *sy);
LONG mxrel(struct spb *sy);
VOID unsync(struct spb *sy);
VOID iunsyn(struct spb *sy);
WORD ownsyncs(struct _pd *p);
#endif

#ifndef DINIT
LONG dinit();
#endif

#ifndef EXCEPT
LONG exception(WORD n);
#endif

#ifndef KTOOLS
VOID psetjmp();
VOID ulongjmp();
VOID m_lock();
VOID m_unlock();
#endif

#ifndef  PROCESS
VOID pinton();
VOID pstart(struct _pd *px, WORD pri, BYTE *dsp);
struct _pd *getpd(LONG stksiz, WORD user);
struct _pd *prucreate(LONG *bmask, LONG stksiz, UWORD fid, UWORD user,
	LONG swi);
VOID spushl(struct _pd *p, LONG val);
VOID spushw(struct _pd *p, WORD val);
LONG pcreate(LONG *pidp, WORD (*addr)(), BYTE *name, WORD pri,
	LONG stksiz, LONG parm1, LONG parm2);
LONG npcreate(BYTE *dsp, LONG *pidp, WORD (*addr)(), BYTE *name,
	WORD pri, LONG stksiz, LONG parm1, LONG parm2);
VOID pgoto(struct _pd *p, VOID (*addr)(), LONG parm);
VOID freepd(struct _pd *fp);
VOID ins_thread(struct _pd *p);
struct _pd *findpid(LONG pid);
struct _pd *findpd(struct _pd *root, struct _pd *px);
VOID forcerun(struct _pd *p, LONG routine);
#endif

						/* MEMORY  */

#ifndef ALLOCATE
VOID getmtab(struct _memtab *t);
LONG roundup(LONG addr, WORD sysflg);
LONG rounddn(LONG addr, WORD sysflg);
struct md *maxgt(LONG min, struct mpb *mp, WORD sysflg);
struct md *ffit(LONG amount, struct mpb *mp, WORD sysflg);
struct md *allocrel(LONG min, LONG max);
struct md *lgetmem(struct _pd **pshare, WORD flags, LONG min,
	LONG max);
LONG malloc(struct pblkstruct *p);
LONG mchange(BYTE *addr, WORD oldtype, WORD newtype);
#endif

#ifndef FREE
VOID sfreex(LONG m);
LONG lmfree(LONG m);
LONG lmfreex(LONG m);
LONG sfree(LONG m);
LONG isfree(LONG addr);
LONG freeit1(struct md *m, struct mpb *mp);
LONG freeit(struct md *m, struct mpb *mp);
LONG mfree(LONG addr);
VOID mfreeall(WORD term);
VOID mfreenrp();
VOID unlinkpd(struct _pd *p);
VOID freescl(struct md *m);
VOID invscl(BYTE *devname);
#endif

#ifndef HEAP 
struct md *splitmd(struct md *mdp, struct md *prevmdp, LONG addr,
	LONG amount);
struct md *allocabs(LONG minbase, LONG maxbase, LONG minend,
	LONG maxend);
LONG growheap(struct _mapb *m);
#endif

#ifndef M286 
LONG L2PG(LONG s);
LONG L2PGS(LONG s);
LONG L2AG(LONG s);
int getlas(struct md *l, LONG last, WORD typ);
LONG copyadd(struct _pd *pshare, struct md *lbase, WORD itype,
	LONG oldadd);
VOID setldt(struct ldt *ld, struct md *pm, LONG offset, WORD type);
BYTE *getadd(struct md *lbase, LONG offset, WORD type, WORD flg);
BYTE *growadd(struct md *lm, LONG offset);
LONG saddr(LONG s);
LONG getrange(LONG uptr, LONG ulen);
UWORD retinrange(LONG uptr, UWORD ulen);
LONG mrange(BYTE *start, LONG length);
LONG urange(LONG start, LONG length);
LONG setrpl(LONG s, WORD rpl);
LONG uaddr(LONG s);
VOID freeadd(struct md *lm);
VOID remap(struct md *lm);
LONG A2AG(LONG s);
LONG A2AGS(LONG s);
#endif

#ifndef OSMEM 
LONG mapu(struct _pd *px);
VOID unmapu();
VOID mlock();
VOID munlock();
LONG lmap(struct md *l, WORD typ);
LONG mapphys(struct md *pm, WORD typ);
struct md *lsalloc(LONG len, WORD typ);
LONG salloc(LONG len);
#endif

						/*  FRONT END ; EXCEPTION */

#ifndef FE
LONG nofe();
LONG simint(WORD n, WORD flags, LONG ret);
#endif

#ifndef FEPROT
LONG feint(WORD n);
VOID setcache();
VOID chngpriv_ldt();
UWORD upop();
VOID upush(UWORD item);
#endif
 
#ifndef PANIC86
VOID xputs(BYTE *s);
VOID showregs(struct regsav *regs);
VOID doregs(BYTE *tab, BYTE *regs);
BYTE *ltohex(LONG l, BYTE *s);
BYTE *itohex(WORD i, BYTE *s);
BYTE *ctohex(BYTE c, BYTE *s);
#endif

						/* SWI */

#ifndef SWI 
VOID runswi(struct evb *e);
VOID forceswi();
WORD goswi();
VOID jumpswi();
VOID srpushl(struct _pd *p, LONG val);
LONG swiret(LONG bmaster);
#endif


						/* PIPE */

#ifndef PPIPE
LONG cpipeman(WORD f, struct pblkstruct *p);
#endif


						/* MISMAN */

#ifndef MISMAN
LONG misman(WORD f, struct pblkstruct *p);
#endif

#ifndef RDELIM
LONG rdelim(struct pblkstruct *rp, UWORD bit16, LONG (*getch)(),
	UWORD parm);
#endif

#ifndef OOFILE 
UWORD chrwed(UWORD uflags, UWORD rwed);
int ofchacc(UWORD uflags, struct ofilestruct *of, UWORD access);
LONG openof(UWORD uflags, struct ofilestruct **root);
VOID closeof(struct ofilestruct *of, struct ofilestruct **root);
LONG dlockof(UWORD uflags, struct ofilestruct *uof, struct ofilestruct **root);
#endif

						/* NULL DEVICE DRIVER */

#ifndef  NULLDEV 
LONG null_init(LONG unit);
LONG nullnull(struct rwpbstruct *p);
LONG nullaret(struct rwpbstruct *p, LONG r);
LONG nullread(struct rwpbstruct *p);
LONG nullwrite(struct rwpbstruct *p);
LONG nullspecial(struct rwpbstruct *p);
#endif

						/* LOADERS */

#ifndef COMMAND
LONG noload();
LONG cmdentry(WORD f, struct cpb *p);
WORD cmps(WORD n, BYTE *s1, BYTE *s2);
#endif
 
#ifndef L286
LONG getoff(struct md *lbase, BYTE *useradd);
VOID l_close(LONG fnum, UWORD type);
VOID additem(UWORD id, LONG offset, LONG log_addr, struct symtab *symbuf,
	WORD initflag);
struct lsrtl *getsrtl(UWORD index);
struct ossrtl *findsrtl(struct srtlid *sidptr);
LONG srtlload(LONG fnum, LONG fileptr, BYTE *FileNamePath, UWORD comflags);
LONG loadrel(WORD share, UWORD comflags, BYTE *FileNamePath,
	struct lstruct *lstruct, LONG addmem, UWORD loadtype, LONG *symbuf);
LONG load286(WORD share, BYTE *FileNamePath, BYTE *commandtail,
	UWORD comflags, LONG *symbuf);
#endif
 
#ifndef LF286
LONG loadelf(short share, UWORD comflags, BYTE *fnampath, struct lstruct *ldstruct,
	LONG addmem, UWORD loadtype, LONG *symbuf);
#endif
 
#ifndef LUTILS
struct fixarray *pmkfix(UWORD buknum, UWORD bukseg, LONG usradd,
	struct fixarray *fixroot, UWORD *error);
struct fixtab *get_nearest_seg(UWORD buknum, UWORD bukseg, struct fixarray *fixptr);
VOID killfix(struct fixarray *fixroot);
LONG lgetadd(LONG base, LONG offset);
LONG l_read(LONG fnum, BYTE *buffer, LONG bufsiz, LONG offset,
	UBYTE addrtyp);
struct fixrec *getfixrec(UWORD *n, LONG fd, struct fixrec *buffer,
	LONG *fptr, LONG buflen, UWORD addrtype);
BYTE *fgetadd(struct md *lbase, LONG offset, UWORD type, UWORD flg,
        struct globfix **glfixroot);
void free_gselectors(struct globfix *gfixptr);	
#endif

#ifndef OVERLAY
LONG overlay(struct pblkstruct *p);
#endif
						/* SUPERVISOR */

#ifndef SUP
LONG xsupif(WORD funcno, struct pblkstruct *pp);
struct _dbd *newblk(struct _dbd *oldp, UWORD len);
BYTE *prefix(BYTE *p);
LONG xlat(BYTE **p);
WORD wmatch(BYTE *wild, BYTE *name);
LONG fadnum(struct _fnumt *fnaddr);
#endif

#ifndef SUPERMAN 
LONG superman(WORD f, struct _pd *p);
#endif

#ifndef PMGET 
BYTE *pmgetblk(WORD len);
VOID pmfreblk(BYTE *block);
VOID pmfreall(struct _pd *pd);
#endif

#ifndef PEWTER
LONG s_get(BYTE table, LONG id, LONG buffer, LONG bufsiz);
LONG s_set(BYTE table, LONG id, LONG buffer, LONG bufsiz);
LONG s_lookup(BYTE table, UWORD flags, LONG name, LONG buffer,
	LONG bufsiz, LONG itemsiz, LONG key);
LONG s_open(UWORD flags, BYTE *name);
LONG s_close(UWORD flags, LONG fnum);
LONG s_seek(UWORD flags, LONG fnum, LONG offset);
LONG s_read(UWORD flags, LONG fnum, BYTE *buffer, LONG bufsiz,
	LONG offset);
LONG s_write(UWORD flags, LONG fnum, BYTE *buffer, LONG bufsiz,
	LONG offset);
LONG s_vccreate(UWORD flags, LONG fnum, UWORD rows, UWORD cols,
	BYTE top, BYTE bottom, BYTE left, BYTE right);
LONG s_order(BYTE order, LONG fnum);
LONG s_define(UWORD flags, LONG lname, LONG prefix, LONG psize);
LONG s_command(UWORD flags, LONG cmd, LONG buf, LONG bsize, LONG procinfo);
LONG s_exit(WORD retc);
LONG s_return(LONG emask);
LONG s_rdelim(UWORD flags, LONG fnum, LONG buffer, LONG bufsiz,
	LONG offset, LONG delimiters);
LONG s_install(BYTE option, UWORD flags, LONG devname, LONG parm);
LONG s_cancel(LONG p);
LONG e_timer(LONG swi, UWORD flags, LONG time);
#endif

#ifndef INSTALL 
LONG svinstall(struct pblkstruct *pb);
LONG install(BYTE *name, UWORD access, struct dhstruct *dhp);
LONG xinstall(BYTE *name, UWORD access, struct dhstruct *dhp,
	LONG *lpb);
struct dlestruct *dlesrch(BYTE *n);
#endif

						/* FILE SYSTEM */

#ifndef FPOOL
LONG init_pool(struct _pool *pool_ptr, LONG pool_size);
BYTE *get_pool(struct _pool *pool_ptr, WORD asize);
VOID free_pool(struct _pool *pool_ptr, LONG *uptr);
LONG fspsize(LONG *block);
#endif

#ifndef FSCACHE 
VOID mediachange(struct ds *dsp);
LONG phyio(struct ds *dsp, UWORD fx, UWORD nrs, LONG recn, UBYTE *dmap,
	UWORD flags);
LONG bcb_io(struct ds *dsp, UWORD fx, struct bcb *bcbp);
VOID bcbrel(struct bcb *bcbp);
struct bcb *bcbio(UWORD fx, UWORD mode, LONG recn);
struct bcb *bcbsearch(UWORD fx, UWORD mode, LONG recn, struct bcb **cbcbp,
	short *matchp);
VOID bcbfree(struct bcb *bcbp);
UWORD bcbidx(UWORD bsize);
VOID bcbdiscard(UWORD cmask);
VOID bcbinsert(struct bcb *bcbp, struct bcb **root);
VOID bcbremove(struct bcb *bcbp, struct bcb **root);
VOID bcbon(struct bcb *bcbp, struct bcb **root);
VOID bcboff(struct bcb *bcbp, struct bcb **root);
VOID bcbup(struct bcb *bcbp);
VOID bcbclear(UWORD mode, LONG recn, LONG nrecs);
VOID flushbcb(struct bcb *bcbp);
VOID zapbcb();
VOID unzapbcb();
UWORD getblk(UWORD blk, UWORD mode);
VOID delfat(UWORD blk);
UWORD scanfat();
UWORD getnblk(UWORD blk);
UWORD alloc(UWORD i);
VOID fixfat(UWORD blk, UWORD nxtblk);
VOID flushfat(struct bcb *bcbp);
#endif

#ifndef FSDM 
LONG gettime();
LONG dminit();
LONG diskman(UWORD func, struct parblk *pbp);
VOID fxsync(struct spb *sbp, short mode);
short dsync(struct spb *sbp);
VOID undsync(struct spb *sbp);
short superuser();
VOID superok(LONG errcode);
LONG dspecial(struct parblk *pbp);
LONG devrw(short reading, struct parblk *pbp);
VOID flushdrv();
UWORD getrwed(struct prot *protp);
short diraccess(UWORD access);
#endif

#ifndef FSNAME 
WORD checkdelim(UWORD chr, UWORD mode);
UBYTE *remdot(UBYTE *string, UBYTE *fcb, UWORD mode);
VOID fixdotdot(struct dirfcb *dirp, UWORD dblk);
LONG drename(struct parblk *pbp, UBYTE *oldnp);
UBYTE *parse(UBYTE *string, UBYTE *fcb, UWORD action, UWORD mode);
WORD doschkdelim(UWORD chr, UWORD mode);
#endif

#ifndef FSPATH
short myolist(struct olist *olp);
short myfamily(struct olist *olp);
VOID chkdlock();
LONG dopen(struct parblk *pbp, UBYTE *fnp);
LONG dclose(UWORD flags);
short delolist(struct olist *olp, short dozero);
VOID flush(struct olist *olp);
VOID relflushbcbs(struct bcb **bcbpp);
struct dirfcb *getempty();
LONG dcreate(struct parblkx *pbp, UBYTE *fnamep);
struct dirfcb *rddir(UWORD dcnt);
struct dirfcb *dsearch(UBYTE *fnp, UWORD option);
UWORD tstolist(short delfile, short create);
LONG ddelete(UBYTE *fnamep, short create);
LONG dlookup(struct parblk *pbp, UBYTE *fnamep);
UBYTE *pkname(UBYTE *p, struct dirfcb *dirp, short tablename);
VOID dsfcbts(struct dirfcb *dirp, struct td *tdp);
LONG dgetset(short get, struct parblk *pbp);
VOID inithash();
UWORD cmphash(UBYTE *dirp);
short pathcmp(UBYTE *s, UBYTE *d);
struct path *findpathp(UBYTE *spathp);
VOID fixhash(UWORD dcnt, UWORD hcode);
VOID findhashp(WORD dcnt);
UWORD pathlevels(UBYTE *p);
short dotdot(UBYTE *dirp);
UBYTE *srchpath(UBYTE *p, UWORD *mcntp);
VOID chkspace();
VOID removepath(UBYTE *spathp);
UWORD savepath(UBYTE *p, short proton, struct prot *protp);
LONG unpack(UBYTE *pathp, UBYTE *fnamep, UWORD mode);
VOID freepath();
short chkpro(struct prot *protp, struct prot *cprotp);
LONG dpath(UWORD flags, UBYTE *pathp, UBYTE *fnamep);
VOID checkmedia(UBYTE mode);
#endif

#ifndef FSVOL
struct dvrle *findsib(struct dvrle *dlp);
LONG dinstall(struct parblk *pbp);
LONG remount(struct parblk *pbp);
LONG dinitm();
short dchksum(UWORD recn, LONG *dmap, short update);
UWORD irootdir();
VOID chkmedia(struct ds *dsp, UWORD fatrecn);
VOID olistdiscard();
short scanolist(UWORD option);
LONG ddvrlock(UBYTE option);
LONG makelock(LONG offset, LONG total, UWORD atts, struct evb *evbp,
	struct olist *olp);
struct lrlist *dellock(struct lrlist *plp, struct lrlist *lp);
VOID freelocks(struct olist *olp);
UWORD lockcancel(struct evb *e);
UBYTE scanlock(struct lrlist *lp, LONG offset, LONG endpt);
LONG testlock(short reading, LONG offset, LONG nbytes);
short compolp(struct olist *lolp, struct olist *olp);
short comprlr(struct olist *olp);
struct lrlist *doswtch(UBYTE olap, struct lrlist *plp, struct lrlist *lp,
	LONG endpt, LONG offset, struct olist *olp);
short conflict(struct olist *olp, LONG offset, LONG endpt, UWORD flags,
	UBYTE pend, struct lrlist *pendp);
VOID trywakeup(struct olist *olp);
LONG dlock(struct parblk *pbp);
VOID sychkmedia( UWORD fatrecn );
#endif

#ifndef FSWINDOW 
VOID freepkt();
LONG getrecn(UWORD blk, UWORD blkoff);
VOID qio(LONG len, UWORD blk, UWORD blkoff);
VOID zeroblk(UWORD blk);
short chksize(UWORD size, LONG i, LONG j);
LONG dseek(UWORD flags, LONG offset, LONG length);
LONG drw(short reading, struct parblk *pbp);
LONG drwb(UWORD param, struct parblk *pbp);
VOID bld_window();
UWORD alloc_clus(UWORD num, struct parblk *pbp, UWORD blk);
LONG mictick();
#endif

#ifndef HOOK 
VOID ibm_hook(UBYTE n, struct ds *d);
#endif

						/* CONSOLE SYSTEM */

#ifndef CRMAN 
LONG conman(WORD f, struct pblkstruct *p);
LONG cm_success(LONG p);
LONG cm_noimp(LONG p);
LONG cm_special(struct _cpackstruct *c);
struct _cpackstruct *mkcpack(struct pblkstruct *p);
#endif

#ifndef CRMCONV8 
UWORD cmconv8(BYTE ch8, BYTE *buffer);
#endif

#ifndef CRMCOPY 
LONG cm_copy(struct _cpackstruct *c);
LONG cm_alter(struct _cpackstruct *c);
LONG cm_xcopy(WORD f, struct _cpackstruct *c);
LONG gvframe(UWORD table, struct vcbstruct *v);
#endif

#ifndef CRMCREAT 
LONG cm_create(struct _vccpblkstruct *vcc_param);
#endif

#ifndef CRMDEL 
LONG cm_delete(struct pblkstruct *c_param);
LONG vc_delete(struct vcbstruct *v);
LONG delvc(struct vcbstruct *vcb);
#endif

#ifndef CRMGSL 
LONG cm_get(struct _cpackstruct *c);
LONG cm_set(struct _cpackstruct *c);
LONG cm_lookup(struct pblkstruct *c_param);
VOID maknam(BYTE vcnum);
#endif

#ifndef CRMINST 
LONG cm_install(struct pblkstruct *p);
#endif

#ifndef CRMKB
VOID keyboard(LONG pconid, LONG chin);
VOID ringit(struct vcbstruct *v, LONG emask);
VOID eringit(struct vcbstruct *v, LONG evnum);
LONG cm_give(struct _cpackstruct *c);
VOID putkeys(struct vcbstruct *vcb, WORD *buffer, WORD bufsiz);
LONG cm_kctrl(struct _cpackstruct *c);
#endif

#ifndef CRMMOUSE
LONG cm_rwait();
LONG cm_bwait();
LONG dorat();
LONG ratbut();
VOID mbtimer();
VOID mouse_run();
VOID upd_mouse();
#endif 

#ifndef CRMOPEN 
LONG cm_open(struct pblkstruct *p);
LONG cmvcopen(struct vcbstruct *v, struct fnumtabstruct *pfnt);
LONG cm_close(struct pblkstruct *p);
#endif

#ifndef CRMREAD 
LONG cm_read(struct _cpackstruct *c);
LONG cm_aread(struct _cpackstruct *c);
VOID cm_rasr(struct evb *e, struct _cpackstruct *c);
VOID rddone(LONG r, struct evb *e);
UWORD rd1ch(struct vcbstruct *v, BYTE option, UWORD flags);
BYTE read8(BYTE *c8buf, WORD ch16, WORD kbmode);
BYTE *get52(UWORD ch16);
WORD size8(UWORD ch16, int kbmode);
#endif

#ifndef CRMRDEL 
LONG cmrdelim(struct _cpackstruct *c);
VOID rdecho(struct _cpackstruct *c, UWORD ch16);
VOID recho(struct _cpackstruct *c, UWORD ch16);
WORD echosiz(UWORD ch16);
LONG cmsread1(struct _cpackstruct *c, WORD mode);
#endif

#ifndef CRMWIND 
WORD wmin(WORD a, WORD b);
WORD wmax(WORD a, WORD b);
struct orectstruct *mkleft(struct orectstruct *new, struct orectstruct *old);
struct orectstruct *mkright(struct orectstruct *new, struct orectstruct *old);
struct orectstruct *mktop(struct orectstruct *new, struct orectstruct *old);
struct orectstruct *mkbot(struct orectstruct *new, struct orectstruct *old);
struct orectstruct **brkrect(struct orectstruct *new, struct orectstruct *r,
	struct orectstruct *p);
LONG breakit(struct vcbstruct *v);
VOID getvsync(struct vcbstruct *v);
LONG vcsync(struct vcbstruct *v);
VOID givevsync(struct vcbstruct *v);
LONG vcunsync(struct vcbstruct *v);
LONG newrect(struct vcbstruct *v);
LONG buildlist(struct vcbstruct *v);
VOID newphys(struct vcbstruct *v);
VOID clipvc(struct vcbstruct *v);
LONG overlap(struct orectstruct *new, struct orectstruct *rx,
	struct orectstruct *pr);
WORD bclip(struct rectstruct *d, WORD row, WORD col, WORD nrow,
	WORD ncol);
VOID dovc(struct vcbstruct *v, struct orectstruct *sr);
VOID dobord(struct vcbstruct *v, struct orectstruct *r);
VOID bordcopy(struct vcbstruct *vcb);
VOID vccopy(struct vcbstruct *vcb);
LONG rctupdate(struct vcbstruct *v);
VOID bordupdate(struct vcbstruct *v);
VOID vconupdate(struct vcbstruct *v);
LONG everyvcb(struct vcbstruct *start, struct vcbstruct *stop,
	LONG (*routine)());
LONG cm_order(struct _cpackstruct *c);
struct vcbstruct *newtop(struct vcbstruct *v);
LONG nottop(struct vcbstruct *v);
struct vcbstruct *gettop(struct vcbstruct *vcb);
#endif

#ifndef CRMWRITE 
LONG cm_write(struct _cpackstruct *c);
LONG cm_echo(struct _cpackstruct *c);
LONG cm_awrite(struct _cpackstruct *c, UWORD scmode, LONG bufdone);
LONG cmxfer(struct _cpackstruct *c, struct evb *e, WORD scmode);
VOID cmwaddfl(LONG predone, struct evb *e);
VOID cmwoutfl(struct evb *e, struct _cpackstruct *c);
VOID cmwmore(struct vcbstruct *v, LONG x);
VOID cmwtimer(struct vcbstruct *v, LONG x);
VOID cmwetime(LONG evnum, struct vcbstruct *v);
VOID cmwflush(struct vcbstruct *v, LONG evnum);
VOID cmwwbuf(struct vcbstruct *v, LONG evnum);
VOID cmwupdate(struct vcbstruct *v, LONG evnum);
#endif

#ifndef CRMXLAT 
LONG cm_pcreate(struct _pd *newp);
LONG cm_pabort(struct _pd *p);
LONG kill_xlat(struct vcbstruct *v);
LONG cm_xlat(struct pblkstruct *pb);
struct xlatstruct *add_xkey(struct xlatstruct *x, struct xlatstruct *buffer);
struct xlatheaderstruct *newhead();
LONG cmespec(struct vcbstruct *v, WORD funcno, WORD flags, WORD cols,
	WORD rows);
#endif

