/*****************************************************************
 * "Copyright (C) 1985, Digital Research, Inc.  All Rights       *
 * Reserved.  The Software Code contained in this listing is     *
 * proprietary to Digital Research Inc., Monterey, California    *
 * and is covered by U.S. and other copyright protection.        *
 * Unauthorized copying, adaptation, distribution, use or        *
 * display is prohibited and may be subject to civil and         *
 * criminal penalties.  Disclosure to others is prohibited.  For *
 * the terms and conditions of software code use refer to the    *
 * appropriate Digital Research License Agreement."              *
 *****************************************************************/

/*===============================================================*
 *   Version 1.5.00     IIFDMOT.C                                *
 *                      Motor spinup and spin down routines.     *
 *---------------------------------------------------------------*
 *    VERSION   DATE    BY      CHANGE/COMMENTS                  *
 *---------------------------------------------------------------*
 *    1.0       6/12/85 reb     rewritten/added to system        *
 *    1.1	6/13/86 mei	High C Port.                     *
 *    1.2       1/27/87 KPB     Added OUTPW INPW                 *
 *    1.3	87Nov06 glp	Added DOD support
 *  1.5.00	88Jan19	glp	Changed reset_dcl to make sure that reset_seek
 				is called as an ASR.  This was done so that I
				could remove the hard polling loops from
				reset_seek(). SPR 1862
				*** 1.5.00 88Jan19 ***
 *===============================================================*
 *  INCLUDES:                                                    */

#if (MACHINE == XMACHINE)

EXTERN	VOID	reset_dcl();		/* Forward declaration	*/
EXTERN	VOID	evasr();
EXTERN	int	fdc_notinasr;		/* 1.5.00 88Jan19 */
#endif

/**************************************************************************
*  fd_motor -
*
*  RETURNS:
*	When request is turn ON motor and NO check for DOD is requested
*	  TRUE		If motor is on.
*	  FALSE		If motor is spinning up to speed.
*	  E_DOOROPEN	If the diskette door has been opened(Motor is on).
*
*	When request is turn ON motor and a check for DOD is requested
*	  E_SUCCESS	Door has not been opened.
*	  E_DOOROPEN	If the diskette door has been opened.
*
*/

unsigned int	fd_motor( on , driveno , checkdod)
BYTE    on , driveno ;
BOOLEAN	checkdod;	/* True if JUST checking DOD, if checking for DOD
			we leave motor in state as entered routine.	*/

{
        /**********/
        ENUM            e ;
        BYTE            b ;
	BYTE		old_dor_image;
        /**********/

        if( on )
        {
                  /*  she/he wants us to turn the drive on  */
		if (checkdod) {
			old_dor_image = dor_image;
		} else {
                	IoFlag[ driveno ] = IoInProg = 1 ;      /*  [2]  */
		}
                b = dor_image ;                         /*  select drive  */
                if( driveno )
                        b |= 1 ;
                else
                        b &= ~1 ;
#if	(MACHINE == XMACHINE)
                if( motor_on[ driveno ] || spinningup[driveno] )
#else
                if( motor_on[ driveno ] )
#endif
                {
                        OUTPW(FDCPORT , dor_image = b) ;   /*  select drive  */
#if	(MACHINE == XMACHINE)
			/*
			**  see if the floppy door has been opened
			*/
			if ( (UnitType[driveno] == UT_96TPIDOD) &&
			     		      (CtlrType == CT_DOD) &&
						 (INPW(FDCDIR) & DISKCHANGED) )
			{
/* 1.5.00 88Jan19 (start) */
				reset_dcl(checkdod,old_dor_image);
				return(E_DOOROPEN);
/* 1.5.00 88Jan19 (end) */
			}
			/*
			**  If spinning up we say so, if we think we are
			** spinning up, but are done then we will wait
			** a little longer than need be.  Maybe flopasr_io
			** should check spinningup before it does its timer
			** wait.
			*/
			if (checkdod)
			{
				dor_image = old_dor_image;
				OUTPW(FDCPORT, dor_image);
				return(E_SUCCESS);
			}
			if (spinningup[driveno]) return(FALSE);
			else return(TRUE);
#else
                        return( TRUE ) ;
#endif
                }
                /*
                **  select drive and turn on motor.  
                **  do not turn off the other motor.
                */
                b = dor_image ;                 /*  current image       */
                if( driveno )
                        b |= ( 1 | 0x20 ) ;             /*  drive 1 [1] */
                else
                        b = ( b & ~(1) ) | 0x10 ;       /*  drive 0 [1] */
                OUTPW(FDCPORT , dor_image = b) ; /*  update curr image   */
#if     (TIMEOUTS == TRUE)
#if	(MACHINE == XMACHINE)
		if (!checkdod)
		{
			/*
			**  setup asr to tell us when the motor has spun up
			*/
			spinningup[driveno] = TRUE;
	                e = e_timer( NULLSWI , RELTIME , FDMOTORTIME ) ;
	                NEXTASR( e , spintime , e , (LONG) driveno , DKASRPRI-1) ;
		}
		/*
		**  see if the floppy door has been opened
		*/
		if ( (UnitType[driveno] == UT_96TPIDOD) &&
		     		      (CtlrType == CT_DOD) &&
					 (INPW(FDCDIR) & DISKCHANGED) )
		{
			  /* The Disk Resource Manager(DRM) can only be
			  told once that the media may have changed, so
			  reset disk change line.			*/
/* 1.5.00 88Jan19 (start) */
			reset_dcl(checkdod,old_dor_image);
			return(E_DOOROPEN);
/* 1.5.00 88Jan19 (end) */
		}
		if (checkdod)
		{
			dor_image = old_dor_image;
			OUTPW(FDCPORT, dor_image);
			return(E_SUCCESS);
		}
                return( FALSE ) ;	/* Tell caller we are spinning up */
#else
                e = e_timer( NULLSWI , RELTIME , FDMOTORTIME );
                NEXTASR( e , spintime , e , (LONG) driveno , DKASRPRI-1) ;
                return( FALSE ) ;	/* Tell caller we are spinning up */
#endif
#else
                /*
                **  Ticks aren't on, we can't asynchronously wait for the 
                **  motor to spin up, so we must do it in a hard loop.
                */

                for( e = ((750 * 1000)/4) ; e ; e-- ) ;
                return( motor_on[ driveno ] = TRUE ) ;
#endif
        }
        else
        {
                /*  he wants us to turn the drive off  */

                if( motor_on[ driveno ] )
                {
                        /*
                        **  turn off only this drive.
                        **  do not change select bits.
                        */

                        b = driveno ? ~(0x20) : ~(0x10) ; /*  motor mask  */
                        b &= dor_image ;                  /*  msk off mtr */
                        OUTPW( FDCPORT , dor_image = b ) ;
                        motor_on[ driveno ] = FALSE ;
                        return( TRUE ) ;
                }
                return( FALSE ) ;
        }
}

/*
** [1]  motor on bits for 0x10 (drive 0) and 0x20 (drive 1).  bit 0 is the
**      drive A (drive 0) select:  0 = select drive 0, 1 = select drive 1.
*/

#if     (TIMEOUTS)
/**************************************************************************
*  spintime -
*/

VOID    spintime( e , drivenbr )
ENUM    e ;
LONG    drivenbr ;
{
        BYTE    driveno = (BYTE) drivenbr ;

        ARET( e ) ;                     /*  clear event                 */
        motor_on[ driveno ] = TRUE ;    /*  enable i/o                  */
#if	(MACHINE == XMACHINE)
	spinningup[driveno] = FALSE;
#endif
        e = e_timer( NULLSWI , RELTIME , FDPOLLTIME ) ;
        DKNASR( e , motortime , e , drivenbr ) ;
        /*  now we wait to turn off motor                               */
}

#endif
#if     (TIMEOUTS)

/**************************************************************************
*  motortime -
*/

VOID    motortime( old_e , drivenbr )
ENUM    old_e ;
LONG    drivenbr ;
{
        BYTE    driveno = (BYTE) drivenbr ;
        ENUM    next_e ;


        ARET( old_e ) ;


        if(  (! IoInProg) && (! IoFlag[ driveno ])  )
        {
                /*  we've done no i/o since the last polling period     */
                /*  turn off motor                                      */
                fd_motor( OFF , driveno , FALSE) ;
                /*  now, don't come back                                */
        }
        else 
        {
                if( !IoInProg )
                        IoFlag[ driveno ] = 0 ;
                next_e = e_timer( NULLSWI , RELTIME , FDPOLLTIME ) ;
                DKNASR( next_e , motortime , next_e , drivenbr ) ;
        }
        
}

#endif

#if	(MACHINE == XMACHINE)

/* 1.5.00 88Jan19 (start) */

VOID	reset_dcl(checkdod,old_dor_image)

	BOOLEAN	checkdod;	/* True if JUST checking DOD, if checking
			for DOD	we leave motor in state as entered
			routine.					*/
	BYTE	old_dor_image;	/* Orginal state of motor		*/

{

	EMASK	e;

	if (fdc_notinasr)
	{	  /* We are not an ASR so use DOASR */
		e = FLAGEVENT( FDU->fu_ioflagno , NULLPTR );
		doasr(reset_seek,0L,0L,DKASRPRI);
		if ( e != NULLPTR ) {
			WAIT(e);
			if (checkdod)
			{
				dor_image = old_dor_image;
				OUTPW(FDCPORT, dor_image);
			}
			ARET(e);
		}
		else
		{	  /* We could not get an event */
			FDI->io_error = (ED_DISK | E_GENERAL);
		}
	}
	else
	{	  /* We are an ASR so make a direct call */
		reset_seek();
	}


}
/* 1.5.00 88Jan19 (end) */

#endif
