/******************************************************************************
*	THING.C
*
*	usage: THING [-f device_name] [-m] [-l level] [-c color]
*
*	Draws a series of connected lines on the screen. Uses color.
*
*	-f	Choose the output device. Default is vdi01:
*	-m	Force output to be monochrome on color devices.
*	-l	Sets number of points.
*	-c	Sets maximum color.
******************************************************************************/


#include <portab.h>
#undef	NULL
#include <stdio.h>
#include <ctype.h>
#include <string.h>
#include "vdibind.h"

#define	DFTLEV	10

EXTERN LONG s_open(), s_close(), s_timer();
EXTERN WORD atoi();
EXTERN DOUBLE cos(), sin();

void draw_something(), doline(), getcoord();

WORD contrl[12];
WORD intin[128];
WORD ptsin[128];
WORD intout[128];
WORD ptsout[128];

LONG gdvr;
WORD xmax, ymax;
WORD maxcol;
WORD work_out[60];
WORD handle;

BYTE dftdev[20] = "vdi01:";
WORD mono = 0;
WORD level = -1;

DOUBLE CX, CY, RADIUS;
DOUBLE xasp, yasp;

WORD doswitch(argc,argv)
WORD argc;
BYTE *argv[];
{
    LONG rc;
    WORD acnt, i, collim = -1;
    BYTE *s;

    for(acnt=0; ++acnt < argc;){
	if(*argv[acnt] == '-'){
	    s = argv[acnt] + 1;
	    switch(*s++){
		case 'f':			/* Alt vdi name */
		    if(!*s){
			if(acnt == (argc-1)){
			    printf("Missing device name.\n");
			    return(0);
			    }
			else{
			    s = argv[++acnt];
			    strcpy(dftdev,s);
			    strcpy(s,"-");
			    }
			}
		    else strcpy(dftdev,s);
		    printf("VDI = %s\n",dftdev);
		    break;
		case 'l':			/* Set running level */
		    if(!*s){
			if(acnt == (argc-1)){
			    printf("Missing fractal level.\n");
			    return(0);
			    }
			else{
			    s = argv[++acnt];
			    level = atoi(s);
			    strcpy(s,"-");
			    }
			}
		    else level = atoi(s);
		    if(level < 0){
			printf("Fractal Level must be >= 0.\n");
			return(0);
			}
		    printf("Fractal Level = %d\n",level);
		    break;

		case 'c':			/* Set maximum color */
		    if(!*s){
			if(acnt == (argc-1)){
			    printf("Missing maximum color.\n");
			    return(0);
			    }
			else{
			    s = argv[++acnt];
			    collim = atoi(s);
			    strcpy(s,"-");
			    }
			}
		    else collim = atoi(s);
		    if(collim < 2){
			printf("Maximum Color must be >= 2.\n");
			return(0);
			}
		    printf("Maximum Color = %d\n",collim);
		    break;

		case 'm':			/* Run it in monochrome */
		    printf("Monochrome enabled.\n");
		    ++mono;
		    break;

		case '\0':			/* Null argument */
		    break;

		default:
		    printf("Unrecognized argument -- \"-%s\"\n",s);
		    return(0);
		}
	    }
	}
    if(strncmp(dftdev,"vdi",3) || !(isdigit(dftdev[3])) ||
	!(isdigit(dftdev[4])) || (dftdev[5] != ':')){
	printf("Illegal vdi name \"%s\".\n",dftdev);
	return(0);
	}
    else i = (dftdev[3]-'0')*10 + (dftdev[4]-'0');

    if((rc=s_open(0,dftdev)) < 0){
	printf("Error %4lx while opening \"%s\".\n",rc,dftdev);
	return(0);
	}
    gdvr = rc;
    intin[0] = i;
    if(i != 1){
	if(level == -1){
	    printf("Choosing default fractal level of %d.\n",DFTLEV);
	    level = DFTLEV;
	    }
	}
    if(level != -1 && level < 4) level = 4;
    for(i=1; i<10;) intin[i++] = 1;
    intin[10] = 2;
    (void) v_opnwk(intin,&handle,work_out);
    xmax = work_out[0];
    ymax = work_out[1];
    maxcol = work_out[13];
    if((collim >= 2) && (collim < maxcol)) maxcol = collim;
    if(maxcol == 2) ++mono;
    else if(mono) maxcol = 2;
    return(1);
}

LONG shutdown(){
    (VOID) v_clswk(handle);
    return(s_close(0,gdvr));
}

LONG main(argc,argv)
WORD argc;
BYTE *argv[];
{
    WORD i;

    if(!doswitch(argc,argv)) return(1);		/* Error in switches */

    xasp = (DOUBLE)work_out[3]; yasp = (DOUBLE)work_out[4];

/* Draw the little figure */

    draw_something();

    (void) vrq_locator(handle,xmax/2,ymax/2,&i,&i,&i);

    return(shutdown());
}

void draw_something(){
    WORD i, j, k, col;

    CX = (DOUBLE)(xmax+1) * xasp;
    CY = (DOUBLE)(ymax+1) * yasp;

    RADIUS = ((CX > CY) ? CY : CX) * 5.0 / 12.0;

    CX /= 2.0;
    CY /= 2.0;
    col = 1;

    if(level != -1)
	for(j=0; j < level-1; ++j)
	    for(i=j+1; i < level; ++i){
		(void) vsl_color(handle,col);
		if(++col == maxcol) col = 1;
		doline(level,j,i);
		}
    else for(k=4; k<=DFTLEV; ++k){
	if(k != 4){
	    (void) s_timer(0,1000L);
	    (void) v_clrwk(handle);
	    }
	for(j=0; j < k-1; ++j)
	    for(i=j+1; i < k; ++i){
		(void) vsl_color(handle,col);
		if(++col == maxcol) col = 1;
		doline(k,j,i);
		}
	}
}

void doline(k,j,i)
WORD k,j,i;
{
    WORD pxy[4];
    
    getcoord(k,j,&pxy[0],&pxy[1]);
    getcoord(k,i,&pxy[2],&pxy[3]);
    (void) v_pline(handle,2,pxy);
}

void getcoord(sides,step,xp,yp)
WORD sides, step, *xp, *yp;
{
    DOUBLE theta;
    DOUBLE tx, ty;

    theta = (step * 6.283186)/sides;
    tx = (RADIUS * cos(theta) + CX) / xasp;
    ty = (RADIUS * sin(theta) + CY) / yasp;
    *xp = (WORD)tx;
    *yp = (WORD)ty;
}
