/******************************************************************************
 SPLDRV.C - Print spooler driver main source.			Version 1.5.00
*******************************************************************************
* Copyright(c)1985-87, Digital Research, Inc. All Rights Reserved. The Software
* Code contained in this listing is proprietary to Digital Research, Inc.,
* Monterey, California and is covered by U.S. and other copyright protection.
* Unauthorized copying, adaptation, distribution, use or display is prohibited
* and may be subject to civil and criminal penalties.  Disclosure to others is
* prohibited.  For the terms and conditions of software code use refer to the
* appropriate Digital Research License Agreement.
*******************************************************************************
* Version   Date   Who  Description
* ======= ======== ===  =======================================================
* v1.5.00 88Mar02  AM	Create write parameter block, use supif instead of
*			s_write, and check for user space in sp_write() so
*			buffer being passed will be marked correctly.
* v1.6	  12/29/87 ldt	SPR#1773, could not create over 99 temp files.
*			*** 1.6 12/29/87 ***
* v1.5	  12/23/87 ldt	renamed drtl calls from ds_* to s_* and de_* to e_*.
* v1.4	  08/26/86 ldt	rename h_to_a to hx_to_as to avoid a conflict with
*			sptools.c h_to_a();
* v1.3	  07/07/86 Lin	Add fixes for Metaware conversion.
* v1.2	  04/16/86 Lin	Make sp_init load the spool.286 to avoid initialization
*			problem with redirected i/o, also don't send the job
*			to spooler if the file size is zero. Fix sp_uninit().
* v1.1	  03/04/86 Lin	Move hard-coded ASCII messages to splmsg.c file
*	  02/02/86 Lin	Make changes to use p_rpid instead of p_pid for net 
*	  01/19/86 DAB	Added dsploadperm()
*	  11/12/85 DAB	Many more comments, miscl bug fixes.
*	  08/01/85 KSO  Remove EXTERN for s_delete() and s_get(), no longer
*			used
*	  07/30/85 KSO	Add delete file after print support
*			Get user name at flush entry to send to spooler
*	  07/25/85 KSO	Re-organized all routines for multiuser support
******************************************************************************/

/* INCLUDES */

#include "portab.h"
#include "sysbuild.h"
#include "system.h"
#include "struct.h"  
#include "flags.h"
#include "utils.h"
#include "spldrv.h"

/* DRTL.L86 */
EXTERN  LONG    s_open(), s_close(), e_read(),  s_abort(),  e_command();
EXTERN  LONG    s_define(), s_create(), s_delete(), s_return(), s_cancel();
EXTERN  LONG    s_wait(),   s_read(),   s_write(),  s_lookup();
EXTERN  LONG    flagget(),  flagevent(), flagset(), flagrel(),  flagclr();
EXTERN	LONG	supif();		/* V1.5.00 (88Mar02) */

/* SPTOOLS.C */
EXTERN  BYTE    *splalloc();
EXTERN  VOID    splfree();
EXTERN  WORD    splminit();
EXTERN  WORD    splmuninit();
EXTERN  BYTE    *strcpy();
EXTERN  BYTE    *strncpy();
EXTERN  WORD    strlen();
EXTERN  VOID    itoa();
EXTERN  VOID    reverse();

/* data defined in sptools.c 		*/
EXTERN  BYTE	SPACE, COLON, ZERO, BIGa;
EXTERN  BYTE	*namemsg[];
EXTERN  BYTE	*strmsg[];



#define SPL_PRIOR 200 	/* Spooler process priority */
#define DSP_PRIOR 200 	/* Despooler process priority */
			/* fill block 'b' with zeros for 'n'bytes    */
#define _bzero(b, n) \
	_fill_char(b, n, 0)

/* Locals */
WORD    initsfe();      /* Initialize front-end and spooler process     */
WORD    inits();        /* Send sfe initialization message              */
FLIST   *finsert();     /* Allocate and insert file entry into list     */
FLIST   *fsearch();     /* Search file entry list according to pid      */
VOID    fdelete();      /* Delete from file list according to a pid     */
WORD    getmsg();       /* Read a message from the message box          */
WORD    sendmsg();      /* Send a message to a target message box       */
WORD    get_ext();      /* Get unused extension number for tempfile     */
VOID    fillmsg();      /* Fill up fields of a print request message    */
BYTE    *mktemp();      /* Create a temporary file name                 */

VOID    clearmsg();     /* Clear out a message buffer                   */
VOID    hx_to_as();     /* Convert a long hexadecimal to ascii          */

LONG    sp_init();
LONG    sp_uninit();
LONG    sp_select();
LONG    sp_flush();
LONG    sp_write();
LONG    sp_implement();

			/* spooler Driver Header.........has to be the	*/
			/* topmost part of all the static data!		*/
DVRHDR  sp_dh =         
{
        DVR_SPL,                /* Spool driver type                    */
        (UBYTE)1,               /* Handles 1 unit                       */
        (UBYTE)0x0001,          /* Synchronize at the driver level      */
        sp_init,                /* INIT                                 */
        sp_implement,           /* SUBDRV                               */
        sp_uninit,              /* UNINIT                               */
        sp_select,              /* SELECT                               */
        sp_flush,               /* FLUSH                                */
        sp_implement,           /* READ                                 */
        sp_write,               /* WRITE                                */
        sp_implement,           /* GET                                  */
        sp_implement,           /* SET                                  */
        sp_implement,           /* SPECIAL                              */
        0L,0L,0L,0L,0L          /* Control and rlr fields               */
};


LONG    splflag;                /* Spool driver event flag              */
LONG    lderr = 0L;             /* Spooler load error return code       */
BYTE    dev[16];                /* Device name                          */
BYTE    sfeq[32];               /* Message box name                     */
BYTE    pname[32]; 		/* Permanent Despooler mailbox pipe name*/
WORD    count = 0;              /* Current file extension number for    */
                                /* tempfiles                            */
FLIST   *flist = (FLIST *)0;    /* Open file list                       */
LONG	spl_pid = 0L;		/* Spooler Process ID			*/
LONG	dsp_pid = 0L;		/* Permanent despool process ID		*/


LONG    sp_select( pb )
REG     SEL_PB  *pb;
{
        REG     FLIST   *f;
        REG     BYTE    *tfile;
        REG     LONG    rc;
        REG     LONG    pid;

        pid = ((PD *)pb->sel_pdaddr)->p_rpid;

        /* If the same process has already opened this device,  */
        /* then increment the open count of the open list item  */

        if( (f = fsearch(pid)) == NULLPTR )
        {
            /* If this is the first open on this device, create */
            /* and insert a new entry into the open list        */

            if( (f = finsert()) != NULLPTR )
            {
                f->f_ocount = 1;        /* First open           */

                /* Create the temporary file                    */

                if( (tfile = mktemp(pid)) != NULLPTR )
                {
                    if( (rc = s_create(0,CREATE_FLG,
                        tfile,0,CREATE_SEC,0L)) > 0L )
                    {
                        f->f_fnum = rc;
                        f->f_fspec = tfile;
                        f->f_pid = pid;
                        rc = E_SUCCESS;
                    }
                }
                else rc = ED_SPLDVR | E_MEMORY;

                /* If there was an error up to this point we    */
                /* must delete the open file list entry         */

                if( rc < 0L ) fdelete( f );
            }
            else rc = ED_SPLDVR | E_MEMORY;
        }
        else
        {
            ++f->f_ocount;
            rc = E_SUCCESS;
        }
        return( rc );
}

LONG    sp_write( pb )
REG     WRI_PB  *pb;
{
        REG     LONG    rc;
        REG     LONG    emask;
        REG     FLIST   *f;
        REG     PD      *pd;
		PBLK	pblk;

        /* Make sure the flag is free                           */

        if( (rc = flagclr(splflag)) == E_SUCCESS )
        {
            /* Get an event for this write operation            */

            if( (emask = flagevent(splflag,pb->wri_swi)) > 0L )
            {
                /* Find the current process's open file list    */
                /* item to get the temporary file fnum          */

                pd = (PD *)pb->wri_pdaddr;
                if( (f = fsearch(pd->p_rpid)) != NULLPTR )
                {
                    /* Write the data to the temporary file     */
/* v1.5.00 88Mar02 (start) */
		    _bzero(&pblk, sizeof(pblk));	/* Zero parm block */
		    if (pb->wri_flags & MEM_MSK)	/* If user buffer  */
			pblk.pa_mode = 2;		/*  set user space */
		    pblk.pa_flags = WRITE_FLG;		/* Our flags	   */
		    pblk.pa_id = f->f_fnum;		/* File number	   */
		    pblk.pa_buf = (LONG)pb->wri_buffer;	/* Buffer -->	   */
		    pblk.pa_bsiz = pb->wri_bufsize;	/* Buffer length   */
		    pblk.pa_offset = pb->wri_offset;	/* Offset into file*/
		    rc = supif(F_WRITE, &pblk);		/* Do write call   */
/* v1.5.00 88Mar02 (end) */
                }
                else rc = ED_SPLDVR | E_GENERAL;

                /* Make this event complete so that the Msc.    */
                /* Res. Mgr. can get the return code            */

                flagset( splflag,pd,rc );
            }

            /* If no errors were detected return the event mask */
            /* otherwise return the error code                  */

            if( rc >= E_SUCCESS ) rc = emask;
        }
        return( rc );
} 

LONG    sp_flush( pb )
FLU_PB  *pb;
{
        REG     FLIST   *f;
        REG     MSG     *msg;
        REG     PD      *pd;
        REG     LONG    rc;
        REG     LONG    pid;
        SPD     spd;
	DISKFILE dbuf;

        pid = (pd = (PD *)pb->flu_pdaddr)->p_rpid;
        rc = E_SUCCESS;

        /* Lookup the open file entry for the calling process   */

        if( (f = fsearch(pid)) != NULLPTR )
        {			      	/* not a partial close	*/
            if( !(pb->flu_flags & 0x0001) )	
            {
                /* If this is the last close then flush the     */
                /* file to the Spooler, otherwise decrement the */
                /* open count and return                        */

                if( f->f_ocount == 1 )
                {
                    s_close(0,f->f_fnum);
                    f->f_fnum = 0L;

		    s_lookup(T_FILE, 0, f->f_fspec, &dbuf, 
			(LONG) sizeof(DISKFILE), (LONG) sizeof(DISKFILE), 0L);
		    if (dbuf.df_size == 0L)
		    {
			s_delete(0, f->f_fspec); /* delete this null file */
			goto out1;		 /* don't need to spool   */
		    }

                    if( (rc = s_define(DEF_GET+DEF_SYS,
                         strmsg[6], dev,16L)) == E_SUCCESS )
                    {
                        clearmsg( msg = &spd.spd_msg );
                        if( (initsfe(&spd,pid) == 0) &&
                            (inits(&spd,pd) == 0) )
                        {
                            /* Send the file name to spooler    */
                            /* through the message system	*/

                            clearmsg( msg );
                            strncpy( msg->msg_dev,dev,strlen(dev) );
                            strncpy( msg->msg_fspec,f->f_fspec,
                                     strlen(f->f_fspec));
                            fillmsg( &spd );
                            sendmsg( spd.spd_sfn,msg );
                            getmsg( spd.spd_rfn,msg );
                            if( (msg->msg_type != MT_MEMORY) &&
                                !(msg->msg_type & MT_ERROR) )
                            {
                                msg->msg_flags = MF_SFE;
                                msg->msg_type  = MT_DINIT;
                                sendmsg( spd.spd_sfn,msg );
                            /*  getmsg( spd.spd_rfn,msg );	*/
                            }
                            else rc = ED_SPLDVR | E_GENERAL;

                            s_close( 0,spd.spd_rfn );
                            s_close( 0,spd.spd_sfn );
                        }
                        else	/* attachment(spooler) didn't respond..	*/
			    rc = ED_SPLDVR | E_DKATTACH;   /* IBM jargon*/
                    }
                    else	/* can't found definition of 'bgprn:'	*/ 
			rc = ED_SPLDVR | E_GENERAL;

                    	  /* Free up the open file entry on last close  */
out1:               fdelete( f );
                }
                else --f->f_ocount;
            }	/* end if: full close; else just exit for partial close */
        }
        else 		/* can't find the file entry!? what to do...	*/
		rc = ED_SPLDVR | E_GENERAL;
        return( rc );
}
 
/** Load and run despooler for bgprn: (i.e., load the "permanent" despooler).
    This function is called only once, at init time, from sp_init().
    The reason is to avoid a potential problem.  The scenerio is this:

        User #1 does a print command, installing spool.286.

        While spool.286 is still running, user #2 tries to print a file
        which user #1 is not authorized to see.  The print command will
        fail, because spool.286 (and, hence, despool.286) inherited the
        user and group of user #1,  and thus are not authorized to open
        the file.

    The strategy to avoid this problem is simply to permanently install
    the despooler from the init entry point of SPLDVR.286.

    We only do this for the standard background printer, "bgprn:".  For
    other printers, the problem is unsolved (but probably so rare as to
    be inconsequential).

    Much of this function was copied from function dspload() in spool.c.
                                      -DAB  1/19/86
**/
VOID dsploadperm()
{
   LONG   mxevent, /* emask from our "mx" (sic) e_read */
          ldevent, /* emask from e_command call */
          emask, /* return value of s_wait */
          mxq, /* filenum for our "mx" pipe */
          fn; /* temp filenum for confirming existance of printer driver */
   PINFO  pi; /* process info structure */
   BYTE   *q; /* a pointer into p[] */
   BYTE   p[128]; /* buffer for constructing pipe names & despooler command
                     line parameters
                  */
   BYTE   dev[16]; /* Device name to print upon */
   BYTE   buf[128]; /* translated device to print upon (driver path?) */
/*   LONG   dsp_pid; 	 despooler process ID, it's global now....Lin */
   BYTE   scratch[2]; /* a little buffer for our "mx" read */
          /* scratch[] is 2 bytes, not 1, so that stack stays even aligned */

    /** get default print device: "bgprn:" **/
    if (s_define(DEF_GET+DEF_SYS, strmsg[6],dev,16L) != E_SUCCESS)
        return;
    s_lookup( T_PNAME,0,dev,buf,128L,128L,0L );

    /** confirm that there really is a printer driver by that name **/
    if( (fn = s_open(DSP_DOPEN,buf)) < 0L )
        return;
    s_close( 0,fn );

    /** figure out the name for the "MX pipe" (actually, we are
        not concerned with mutual exclusion; the "mx" pipe is just the
        way that the despooler confirms to us that it has loaded).
    **/
    strcpy( p, namemsg[3] );  			/* that's 'local::pi:%'	*/
    q = p + strlen( p );
    strcpy( q,buf );  				/* Copy in device name  */
    q += strlen( buf ) - 1;
    if( *q == COLON ) *q = NULL;	/* get rid of trailing colon	*/
    strcpy(pname,p);  			/* looks like "local::pi:%lpt0" */
    strcpy( q, strmsg[13] );		/* that's 'mx'.....missile!	*/
    q += 2;

    /** Create MXQ (the "mx" pipe) **/
    if( (mxq = s_create(0,SPL_MXCREATE_FLG,p,1,DFLT_SEC,1L)) <= 0L )
        return;

    /** fill in process info structure for despooler process **/
    pi.pi_prior = DSP_PRIOR;
    pi.pi_maxmem = DFLT_MMEM;
    pi.pi_addmem = DFLT_AMEM;
    strcpy( pi.pi_pname, namemsg[5] );

    /** build despooler's command line parameters: mx pipe name,
        a blank, mailbox pipe name, a blank, and the device name
    **/
    *q++ = SPACE;
    strcpy( q,pname ); /* Copy in dspl_mbox */
    q += strlen( pname );
    *q++ = SPACE;
    strcpy( q, buf ); /* Copy in device name */

    /** start the despooler **/
    ldevent = e_command( 0L,&dsp_pid,0x80, namemsg[7],
			p,(LONG)strlen(p)+1,&pi );
    if (ldevent < 0L)
      {
        s_close( 0,mxq );  /* close (& delete) "mx" pipe */
        return;
      }

    /** Await completion of load (or load failure).

        To tell when the load is complete, we post a read on the (misnamed)
        "mx" pipe; the despooler will write a byte to it when it begins
        execution.  If, however, the e_command event completes before a byte
        is read from the "mx" pipe, then it means that the load failed for
        some reason.
    **/
    mxevent = e_read( 0L,SPL_READ,mxq,scratch,1L,0L );
    emask = s_wait( (ldevent | mxevent) );

    if (emask & ldevent)
        s_return( ldevent );
    else
        s_cancel( ldevent );  /* discard "process complete" event */
    if (emask & mxevent)
        s_return( mxevent );
    else
        s_cancel( mxevent );  /* discard e_read event */
    s_close( 0,mxq );  /* close (& delete) "mx" pipe */

} /* dsploadperm */

/** init entry point; get the needed flag and call splminit() to initialize
    the heap (memory pool).

    Added 1/19/86: Load the despooler process for the system-defined default
    background print spooler (bgprn:).                              -DAB
**/
LONG sp_init()
{
   LONG		rc, mask, mxq, e1, e2;
   PINFO	pi;
   BYTE		ch;

    if( (splflag = flagget()) == 0L )		/* no flag available */
        rc = ED_SPLDVR | E_EMASK;
    else
        rc = (splminit() < 0 ? (ED_SPLDVR | E_MEMORY) : DVR_SPL);

    if (rc >= 0)
    {
        if( (mxq=s_create(0,SFE_MXCREATE_FLG, namemsg[0],
  	    1,DFLT_SEC,1L)) > 0L )
	{
	    pi.pi_prior = SPL_PRIOR;
    	    pi.pi_maxmem = DFLT_MMEM;
    	    pi.pi_addmem = DFLT_AMEM;
       	    strcpy( pi.pi_pname, namemsg[4]);
            e1 = e_command(0L, &spl_pid, 0x80,namemsg[6],namemsg[2],
                      (LONG)strlen(namemsg[2]),&pi );
            e2 = e_read( 0L,(SFE_READ)|A_NODESCT,mxq,&ch,1L,0L );
	    mask = s_wait(e1 | e2);	/* mask returned may contain any*/
					/* combination of e1 & e2 event */
	    if (mask & e2)		/* spool.286 loaded & running	*/
		s_return(e2);
	    else
		s_cancel(e2);
	    if (mask & e1)		/* spool.286 already exited?	*/
		rc = s_return(e1);
	    else
		s_cancel(e1);
	    s_close(0, mxq);
	}
        dsploadperm();       	    /* load background despooler if any	*/
    }
    return( rc );
} 

LONG    sp_uninit()
{
        REG     LONG    rc;

        if( flagrel(splflag) == E_SUCCESS )
        {
            splmuninit();
            rc = s_abort(spl_pid);	/* you are Superuser, aren't you? */
	    if (!rc && dsp_pid)		/* we have a permanent despooler  */
	    {
		if ((rc = s_open(DSP_DOPEN, pname)) >= 0L)
		{				/* He's still there....?  */
			s_close(0, rc);
			rc = s_abort(dsp_pid);
		}
	    }
        }
        else
            rc = ED_SPLDVR | E_CONFLICT;
        return( rc );
}


/** read/get/set/special/subdrive entry point: returns "unimplemented" error **/
LONG    sp_implement()
{
        return( ED_SPLDVR | E_IMPLEMENT );
} 

/** Allocate another FLIST entry for another file; add it to the
    doubly-linked list of open files.  Return the pointer, or NULL
    if the memory allocate fails.
**/
FLIST   *finsert()
{
        REG     FLIST   *f;

        if(( f = (FLIST*)splalloc(FL_SIZ)) != NULLPTR )
          {
            if( (f->f_next = flist) != NULLPTR )
                f->f_next->f_prev = f;
            flist = f;
          }
        return( f );
} /* finsert */


/** Search file entry list according to pid (Process ID), return the pointer
    to the FLIST structure for this pid.  It should always be found (but if
    not, return NULL pointer).
**/
FLIST   *fsearch( pid )
REG     LONG    pid;
{
        REG     FLIST   *f;

        for( f = flist; f && (f->f_pid != pid); f = f->f_next )
            ;
        return( f );
} 


/** Delete an FLIST structure from the doubly-linked list of open files.  Call
    splfree to free up the memory (for both the FLIST structure and for the
    f_fspec filename field).
**/
VOID    fdelete( f )
REG     FLIST   *f;
{
        if( f->f_prev )
        {
            if( (f->f_prev->f_next = f->f_next) != NULLPTR )
                f->f_next->f_prev = f->f_prev;
        }
        else
        {
            if( (flist = f->f_next) != NULLPTR )
                flist->f_prev = (FLIST *)0;
        }
        if( f->f_fspec )
            splfree( f->f_fspec );
        splfree( f );
} 

/** create our mailbox pipe (so spooler can send us replys); install the
    spooler process (spool.286); open spooler mailbox pipe.  Return fnums for
    the two mailbox pipes (ours and the spooler's) in spd->sfn and spd->rfn.
    Return a function result of zero (OK) or negative (error).  This routine is
    similar, but not identical, to the function by the same name in xprint.c.
**/
WORD initsfe( spd,pid ) /* Open message pipe to SPOOLER */
REG SPD *spd;
REG LONG pid; /* process ID -- needed to name our mailbox pipe */
{
    LONG    emask, ldevent, mxevent, mxq;
    WORD    r;
    BYTE    *save, buf[128], ch;
    PINFO   pi;

        spd->spd_rfn = spd->spd_sfn = 0L; /* zero out any old FNUMs */
        r = 0; 

        strcpy( sfeq, namemsg[1] );
        /* Our mailbox pipe needs a unique name, so we append our process ID */
        itoa( (UWORD)pid,(sfeq + strlen(sfeq)) );
        /* create our mailbox pipe: */
        if( (spd->spd_rfn = s_create(0,SFE_MBCREATE_FLG,sfeq,1,DFLT_SEC,
					1024L)) > 0L )
        {
            /** See if spooler is around: try to open his mailbox **/
            if( (spd->spd_sfn = s_open(SFE_SOPEN, namemsg[2])) < 0L )
            {
                /** If open fails, check to see if spooler is loading: try to
                    create the Mutual Exclusion pipe.  If create succeeds, then
                    nobody else is loading the spooler, so we must do it.  But
                    first, make sure that the open failed due to a "file does
                    not exist" error.        **/
                if (E_NO_FILE != (WORD)(spd->spd_sfn))
                {
                    r = -2; 		/* spooler is not there...	*/
                    lderr = spd->spd_sfn;
                    goto end_initsfe;
                }
                if( (mxq=s_create(0,SFE_MXCREATE_FLG, namemsg[0],
				  1,DFLT_SEC,1L)) > 0L )
                {
		/* save the "stdout" define string because if we're invoked */
		/* by redirected I/O then this driver is the "stdout" itself*/
		/* but this driver is NOT re-entrant, and in command SVC the*/
		/* Misc. Manager will open all the standard files....so we  */
		/* define it to be "null:" to avoid deadlock in e_command() */
		    s_define(A_RETURN+A_LIT, strmsg[16], buf, 128L);
		    save = splalloc(128);
		    strcpy(save, buf);
		    s_define(0, strmsg[16], strmsg[14], 0);

                    pi.pi_prior = SPL_PRIOR;
                    pi.pi_maxmem = DFLT_MMEM;
                    pi.pi_addmem = DFLT_AMEM;
                    strcpy( pi.pi_pname, namemsg[4]);
                    ldevent = e_command( 0L,&spl_pid,0x80,namemsg[6],namemsg[2],
                                         (LONG)strlen(namemsg[2]),&pi );
                    /** post read on Mutual Exclusion Pipe, so spooler process
                        can notify us when he's finished loading   **/
                    mxevent = e_read( 0L,(SFE_READ)|A_NODESCT,mxq,&ch,1L,0L );
                           /* Changed to a non-destructive read 12/16/85 -DAB */

                    /** wait for spooler process to either finish or fail **/
                    emask = s_wait( (ldevent | mxevent) );

                    /* Hmmmm... I think there is a hole here: We should probably
                       write a byte to the MX pipe if the e_command completed
                       instead of the e_read, in case somebody else was waiting
                       for the load to complete when it failed.  The way it is,
                       they'll just hang, waiting for their read to complete.

                       Note that another area deserving of our attention is what
                       happens if spool.286 is in the midst of uninstalling
                       itself.  I think there is a window where we could decide
                       that spool.286 was already there, but he could be gone
                       by the time we wrote to his pipe.

                       This stuff gives me a headache when I think about it.

                                                                  -DAB  12/16/85

                       OK, I added the 1-byte write (below, search for "\377").
                                                                  -DAB   1/19/86
                       OK, I added code to SPOOL.C to solve the window during
                       uninstall problem.  Search for SPL_MBREOPEN_FLG.
                                                                  -DAB   1/19/86
                    */

                    if( emask & mxevent )       /* Spooler initialized  */
                    {
                        s_cancel( ldevent );
                        s_return( mxevent );
                        /* open mailbox to spooler (this time it'll work!) */
                        spd->spd_sfn = s_open( SFE_SOPEN, namemsg[2] );
                        if (spd->spd_sfn < 0L)
                        {
                            r = -2; /* just in case... -DAB */
                            lderr = spd->spd_sfn; /* error code for debugging */
                        }
                    }
                    else                        /* Spooler load error   */
                    {                           
                        s_cancel( mxevent );
                       	lderr = s_return( ldevent );
                        r = -2;
                        /* An attempt to close the aforementioned hole: */
                        s_write( SPL_WRITE,mxq, strmsg[20],1L,0L );
                    }
                    s_close( 0,mxq );    /* close Mutual Exclusion pipe */
			/* restore the original definition for "stdout" */
		    s_define(0, strmsg[16], save, (LONG)strlen(save));
		    splfree(save);
                }
                else /* Spooler process is already loading */
                {
                    /** try to open Mutual Exclusion pipe -- if open fails,
                        then the load has already completed.  Otherwise, we
                        post a read to find out when the load completes.
                    **/
                    if( (mxq = s_open(SFE_MXOPEN_FLG, namemsg[0])) > 0L )
                      /* that's open for shared read; delete on last close */
                    {
                        /* Wait for spooler to initialize */
                        s_read( (SFE_READ)|A_NODESCT,mxq,&ch,1L,0L );
                           /* Changed to a non-destructive read 12/16/85 -DAB */
                        s_close( 0,mxq );        /* added "0," 12/16/85  -DAB */
                    }
                    /** now we should be able to open the spooler mailbox **/
                    spd->spd_sfn = s_open( SFE_SOPEN, namemsg[2]);
                    if (spd->spd_sfn < 0L)
                    {
                        r = -2; /* just in case... -DAB */
                        lderr = spd->spd_sfn;
                    }
                }/*else*/
            }/*if*/
            /*
            else we successfully opened spool mailbox ('twas already there)
            */
          }
        else
          {
            lderr = spd->spd_rfn;  /* for examination w/ DASH/DAB */
            r = -5; /* Error creating our own mailbox pipe */
          }
end_initsfe:
        if /** error occurred **/
           (r < 0)
        {
            /** close any open mailbox files **/
            if (spd->spd_rfn > 0L)
            {
                s_close(0,spd->spd_rfn); /* delete our mailbox */
                spd->spd_rfn = 0L;
                if (spd->spd_sfn > 0L)
                {
                    s_close(0,spd->spd_sfn); /* close spooler mailbox */
                    spd->spd_sfn = 0L;
                }
            }
        }/*if r < 0 */
        return( r );
}

WORD    inits( spd,pd )
REG     SPD     *spd;
REG     PD      *pd;
{
        REG     MSG     *msg;
        BYTE    buf[128];

        s_lookup( T_PNAME,0,dev,buf,128L,128L,0L );
        msg = &spd->spd_msg;
        msg->msg_flags = MF_SFE;        /* Set SFE sent message flag    */
        msg->msg_type = MT_INIT;        /* Set INIT command type        */
        msg->msg_gid = pd->p_group;     /* Establish user and group id  */
        msg->msg_uid = pd->p_user;        /***If print file request,tell***/
        strcpy( msg->msg_fspec,sfeq );  /***  the spooler to initialize**/
        strcpy( msg->msg_dev,buf );     /***  a despooler process      **/
        sendmsg( spd->spd_sfn,msg );    /* Send the msg and wait for a  */
        getmsg( spd->spd_rfn,msg );     /*    reply                     */
        spd->spd_dspid = msg->msg_dsp;  /* The spooler will return      */
        spd->spd_sfeid = msg->msg_sfe;  /*    despooler and spooler ids */
        return( (msg->msg_type & MT_ERROR ? -4 : 0) );
} 

WORD    getmsg( fn,m )          /* Read message from mbox               */
REG     LONG    fn;
REG     MSG     *m;
{
        if( s_read(SFE_READ,fn,m,(LONG)sizeof(MSG),0L) < 0L ) return( -1 );
        return( 0 );
}

WORD    sendmsg( fn,m )         /* Send a message to target mbox        */
REG     LONG    fn;
REG     MSG     *m;
{
        if( s_write(SFE_WRITE,fn,m,(LONG)sizeof(MSG),0L) < 0L ) return( -1 );
        return( 0 );
}

WORD    get_ext( count,tempfile )
REG     WORD    *count;
REG     BYTE    *tempfile;
{
        REG     LONG    rc;
        REG     WORD    start;
        REG     WORD    templen;
        BYTE    ext[4];

        start = *count;
        templen = strlen( tempfile );
        (*(long*)ext) = 0L; /* zero out ext[] */

        /* find a file name with an unused extension of the form ".%xx",
           where xx is to be determined.  We start with xx as the ASCII
           string representing *count, and then we increment until we find
           an xx for which the file does not already exist.
        */
        rc = 0L;
        do
        {
            if( rc > 0L )
                s_close( 0,rc );
            itoa( start,ext );
            strcpy( tempfile + templen,ext );
            rc = s_open( OPEN_FLG, tempfile );
            start++;
            start %= 100;				/*** 1.6 12/29/87 ***/
        }
        while( (rc > 0L) && (start != *count) ); 	/*** 1.6 12/29/87 ***/

        if( start == *count )
        {
            s_close( 0,rc );
            return( 0 );
        }
        else
        {
            *count = start;
            return( 1 );
        }
} /* get_ext */


/* :h1.hx_to_as
. end-heading */
/** convert long int to ASCII hex string of digits **/
VOID    hx_to_as( h,a )
REG     LONG    h;
REG     BYTE    *a;
{
        /* simplified 12/16/85  -DAB */
    int i;
    BYTE temp;

        i = 0;
        do
        {
            temp = ((BYTE)h) & (BYTE)15; /* get low nibble */

            /* convert it to an ASCII digit & store it away */
            if( temp <= (char)9)
                a[i++] = temp + ZERO;
            else
                a[i++] = temp + (BIGa-(char)10);

            /* right shift 4 bits for next digit */
            h = 0x0FFFFFFFL & (h>>4);
        }
        while( h );
        a[i] = NULL;

        /* reverse order of digits */
        reverse( a );
 } /* hx_to_as */


/* :h1.fillmsg & clearmsg
. end-heading */
VOID    fillmsg( spd )
REG     SPD     *spd;
{
        REG     MSG     *m;
        BYTE    user[16];

        m = &spd->spd_msg;
        if( s_define(DEF_GET+DEF_PROC, strmsg[7],user,16L) == E_SUCCESS )
            strcpy( m->msg_name,user );
        m->msg_len   = (BYTE)sizeof(MSG);
        m->msg_flags = MF_SFE + MF_DELETE;
        m->msg_type  = MT_PRINT;
        m->msg_fmt   = DFLT_FMT;
        m->msg_uid   = (UBYTE)0;
        m->msg_gid   = (UBYTE)0;
        m->msg_nc    = DFLT_NC;
        m->msg_plen  = DFLT_PLEN;
        m->msg_pwid  = DFLT_PWIDTH;
        m->msg_sfe   = spd->spd_sfeid;
        m->msg_dsp   = spd->spd_dspid;
} /* fillmsg */


VOID    clearmsg( t )
REG     BYTE    *t;
{
        REG     WORD    i;

        for( i = 0; i < MSIZE; i++ )
            *t++ = NULL;
} /* clearmsg */


/* :h1.mktemp
. end-heading */
/** create a unique name for our temporary file **/
BYTE    *mktemp( pid )
REG     LONG    pid;
{
    REG     WORD    pidlen;
    REG     BYTE    *tfile;
    REG     BYTE    *t;
    BYTE    pidstr[10];

        hx_to_as( pid,pidstr );
        pidlen = strlen( pidstr );
        if( (t = tfile = splalloc(pidlen + 13)) != NULLPTR )
        {
            strncpy( t, strmsg[12],8 );
            strncpy( t += 8,pidstr,pidlen );
            strncpy( t += pidlen, strmsg[19], 2 );
            *(t + 2) = NULL;
            if( !get_ext(&count,tfile) )
                tfile = NULLPTR;
        }
        return( tfile );
} /* mktemp */

