/************************************************************************
*									*
*    "Copyright (C) 1985, Digital Research, Inc.  All Rights		*
*    Reserved.  The Software Code contained in this listing is		*
*    proprietary to Digital Research Inc., Monterey, California		*
*    and is covered by U.S. and other copyright protection.		*
*    Unauthorized copying, adaptation, distribution, use or		*
*    display is prohibited and may be subject to civil and		*
*    criminal penalties.  Disclosure to others is prohibited.  For 	*
*    the terms and conditions of software code use refer to the		*
*    appropriate Digital Research License Agreement."			*
*									*
************************************************************************/

/************************************************************************
*									*
*  Filename:  CKDSKMSG.C						*
*									*
*   Purpose:  Messages used by the CHKDSK utility.
*									*
*  Maintenance Log							*
*									*
*  Version No.	 Date	Initials   SPR/APR No.	 Change/Comments	*
*  -----------	 ----	---------  -----------	 ---------------	*
*    1.0       09/18/87    DS	      N/A	 Created.		*
*    1.1       11/04/87    WeD	      N/A	 Modified.		*
*    1.2       11/11/87    WeD	      N/A	 Major modifications.	*
*    1.3       02/04/88    ldt	      ---        renamed the file.
************************************************************************/

/************************************************************************
*									*
*  Included Files:							*
*									*
************************************************************************/
#include <portab.h>
#include "pistruct.h"

/************************************************************************
*									*
*  Static Option Variables						*
*									*
************************************************************************/

static	POption  CDArgOpt0 = { ' ', FALSE, -1L };
static	POption  CDArgOpt1 = { 'F', FALSE, -1L };
static	POption  CDArgOpt2 = { 'V', FALSE, -1L };

PCommandLineOptions  CDParseStructure =
{
    3,
    &CDArgOpt0, &CDArgOpt1, &CDArgOpt2
};

/************************************************************************
*									*
*  Message Variables							*
*									*
************************************************************************/

char  BannerMsg[] =
    "Digital Research Inc. FlexOS\nChkdsk utility.  Version 1.4\nCopyright (C) DRI 1988\n";

char  DirectoryMsg[] =
    "\nDirectory %s";

char  FileMsg[] =
    "\n      %s";

char  ErrorsMsg[] =
    "\n\nErrors have been found.  Since the F option was not specified,\n\
corrections will NOT be written to disk.\n";

char  AllocationErrorMsg[] =
    "\n%s\n   Allocation error -- size adjusted";

char  InvalidSubdirMsg[] =
    "\n%s\n   Invalid subdirectory -- entry not processed";

char  InvalidDotMsg[] =
    "\n%s\n   Subdirectory has invalid '.' entry";

char  InvalidDotDotMsg[] =
    "\n%s\n   Subdirectory has invalid '..' entry";

char  InvalidClusterMsg[] =
    "\n%s\n   Has an invalid cluster -- entry truncated";

char  InvalidFirstClusterMsg[] =
    "\n%s\n   First cluster is invalid -- entry truncated";

char  CrossLinkMsg[] =
    "\n%s\n   Is cross-linked at cluster %d";

char  TruncatedMsg[] =
    " -- entry truncated";

char  CrossLinkMsg2[] =
    "\nA lost chain is linked to file's cluster %d -- lost chain truncated";

char  InitialCrossMsg[] =
    "\n%s\n   First cluster (%d) is cross-linked";

char  DirReadErrorMsg[] =
    "\n%s\n   Error reading directory -- unable to process it further";

char  DirWriteErrorMsg[] =
    "\nError writing directory";

char  FATReadErrorMsg[] =
    "\nError reading the FAT -- processing cannot continue";

char  FATWriteErrorMsg[] =
    "\nError writing the FAT -- processing cannot continue";

char  LostClustersMsg[] =
    "\n\n%d lost clusters found in %d chains.";

char  FreedBytesMsg[] =
    "\n%ld bytes disk space freed.";

char  NoRoomMsg[] =
    "\nInsufficient room in the root directory.\n\
Erase %d files from the root and repeat CHKDSK.";

char  CommandLineErrorMsg[] =
    "\nInvalid command-line options.";

char  DefaultDriveErrorMsg[] =
    "\nUnable to get default drive name.";

char  DriveLockErrorMsg[] =
    "\nThe disk is either invalid or locked by another process.";

char  UnreadableMediaMsg[] =
    "\nDisk has unreadable media.";

char  NoMemoryMsg[] =
    "\nInsufficient memory to continue.";


char  VolumeLabelMsg[] =
    "\n\n\tVolume %s in drive %s created %3.3s %d, %d %2d:%02d%cm";

char  BytesInDiskSpaceMsg[] =
    "\n\nDisk:\n\t%9ld bytes total disk space.\n";

char  BytesInBootAreaMsg[] =
    "\t%9ld bytes in boot area.\n";

char  BytesInFATsMsg[] =
    "\t%9ld bytes in %d FATs.\n";

char  BytesInRootDirectoryMsg[] =
    "\t%9ld bytes in %d root-directory entries.\n";

char  WastedSectorsMsg[] =
    "\t%9ld bytes in cluster round-off.\n";

char  BytesInFileSpaceMsg[] =
    "\t%9ld bytes total file space.\n";

char  BytesInHiddenFilesMsg[] =
    "\t%9ld bytes in %d hidden files.\n";

char  BytesInDirectoriesMsg[] =
    "\t%9ld bytes in %d directories.\n";

char  BytesInUserFilesMsg[] =
    "\t%9ld bytes in %d user files.\n";

char  BytesInRecoveredFilesMsg[] =
    "\t%9ld bytes in %d recovered files.\n";

char  BytesInLostChainsMsg[] =
    "\t%9ld bytes in %d lost chains.\n";

char  BytesInBadClustersMsg[] =
    "\t%9ld bytes in bad clusters.\n";

char  AvailableBytesMsg[] =
    "\t%9ld bytes available on disk.\n";


char  DashesMsg[] =
    "\t---------\n";

char  TotalMemoryMsg[] =
    "\nMemory:\n\t%9ld bytes total.\n";

char  SystemMemoryMsg[] =
    "\t%9ld bytes system.\n";

char  AllocatedMemoryMsg[] =
    "\t%9ld bytes allocated.\n";

char  FreeMemoryMsg[] =
    "\t%9ld bytes free.\n";


char  NonContiguousMsg[] =
    "\n%s\n   Contains %d non-contiguous blocks.";

char  FileNotFoundMsg[] =
    "\n%s\n   File not found.\n";

char  ContiguousMsg[] =
    "\nAll specified file(s) are contiguous.\n";

char  UnlinkDriveMsg[] =
    "";

PDisplayObject	ConvertDirectoryObj =
{
    { 0 }, { "\n   Convert directory to a file (Y/N)? " }
};

PDisplayObject	MakeFilesObj =
{
    { 0 }, { "\n\nDo you want to create files from them (Y/N)? " }
};


/*
    Define the characters to be used for Yes and No responses.
*/

char  YesNoChar[] = "YyNn";

