/*****************************************************************
 * "Copyright (C) 1985, Digital Research, Inc.  All Rights       *
 * Reserved.  The Software Code contained in this listing is     *
 * proprietary to Digital Research Inc., Monterey, California    *
 * and is covered by U.S. and other copyright protection.        *
 * Unauthorized copying, adaptation, distribution, use or        *
 * display is prohibited and may be subject to civil and         *
 * criminal penalties.  Disclosure to others is prohibited.  For *
 * the terms and conditions of software code use refer to the    *
 * appropriate Digital Research License Agreement."              *
 *****************************************************************/
/***************************************************************************/
/*								   	   */
/*                            CONSTRCT.H                                   */
/*									   */
/*  Author:	Larry Towner						   */
/*  Date:	05/15/87						   */
/*  Compiler:	Meta-Ware 						   */
/*  O/S:	FlexOS							   */
/*  Purpose:	Global access to FlexOS Structures and DEFINES		   */ 
/*  Versions:								   */
/*		Date	   Author   Comments		   		   */
/*		--------   ------   -------------------------------------- */
/*		06/23/87   LDT      Created                    		   */
/*									   */
/***************************************************************************/
/*
    Structures.
*/

struct shmem {
	LONG	key;
	BYTE	name[10];
	UWORD	size;
	UWORD	r1;
	UWORD	security;
	BYTE	user;
	BYTE	group;
	UWORD	r2;
	BYTE	*ubuffer;
	BYTE	*sbuffer;
};

struct cmdenv {
	BYTE	cmdfile[128];
	BYTE	cmdtail[128];
}; 

struct console {
	WORD	tahead,smode,kmode,currow,curcol,nrows,ncols;
	BYTE	vcnum,type;
	BYTE	cname[10];
};

struct environ {
	LONG	stdi,stdo,stde,overlay;
	UWORD	security,res1;
	UBYTE	user,group;
	UWORD	fid;
	ULONG	pid;
	UWORD	rnid,rfid;
	ULONG	rpid;
};

struct disk {
	BYTE	name[10];
	WORD	type, ioptions, status, lrfid, lrnid;
	LONG	lrpid, free, size;		
	WORD	sectize, firstsize;
	LONG	nsectors;
	WORD	sects_trk, sects_blk;
	BYTE	nfats, fatid;
	WORD	nfsects, dirsize;
	BYTE	nheads, format;
	LONG	hidden, syssize;
	BYTE	laflag, lamode, lauser, lagroup;
	BYTE	label[14];
};

struct diskfile {
	LONG	key;		/* lookup ID			*/
	UBYTE	name[18];	/* file name			*/
	UWORD	attrib;		/* file attributes		*/
	UWORD	recsize;	/* file record size		*/
	BYTE	user;		/* file user ID			*/
	BYTE	group;		/* file group ID		*/
	UWORD	prot;		/* file protection		*/
	UWORD	rsvd1;		/* Reserved			*/
	UWORD	rsvd2;		/* Reserved			*/
	UWORD	rsvd3;		/* Reserved			*/
	LONG	size;		/* current file size		*/
	WORD	modyear;	/* last mod time & date stamp	*/
	BYTE	modmonth;
	BYTE	modday;
	BYTE	modhour;
	BYTE	modmin;
	BYTE	modsec;
	BYTE	reserved;	/* Reserved			*/
};

struct define {
	LONG 	key;
	BYTE 	lname[10];
	BYTE 	prefix[128];
};

struct device  {
	LONG    key;
	BYTE	name[10];
	WORD	type;
	WORD	access;
	WORD	instat;
	WORD	ownerid;
};

struct procinfo {
	BYTE   name[10];
	BYTE   prior;
	BYTE   reserved;
	LONG   maxmem;
	LONG   addmem;
};

struct process {
	ULONG	pid;
	UWORD	fid;
	UBYTE	cid,vcid;
	BYTE	name[10];
	UBYTE	state,prior;
	ULONG	maxmem;
	UWORD	flags;
	UBYTE	cuser,cgroup;
	ULONG	parent,events,code,csize;
	ULONG	data,dsize,heap,hsize;	
};

struct pipetab {
	LONG	key;
	BYTE	name[10];
	UWORD	size;
	UWORD	recsize;
	UWORD	security;
};

struct timedate {
	WORD	year;
	BYTE	month,day;
	LONG	time;
	WORD	timezone;
	BYTE 	weekday;
	BYTE	res1;
};

struct mempblk {
	ULONG	start;
	ULONG	minimum;
	ULONG	maximum;
};

struct memory {
	ULONG free;
	ULONG total;
	ULONG sys;
};

struct system {
	BYTE  cpu;
	BYTE  ostype;
	BYTE  version;
	BYTE  release;
	LONG  serial;
	LONG  idlecnt;
};

struct pcon_tab {
	BYTE	name[10];
	BYTE	nvc,cid;
	WORD	rows,cols,crows,ccols;
	BYTE	type,planes,attrp,extp;
	WORD	country;
	BYTE	nfkeys,res1;
	LONG	res2;
};

struct vcon_tab {
	LONG  key;
	WORD  mode;
	BYTE  vcnum, type;
	WORD  viewrow, viewcol, nrow, ncol, posrow, poscol, rows, cols;
	BYTE  top, bottom, left, right;
};


/*  
	Global DEFINES.
*/

/* cursor access modes */
#define CUR_SET	    "\033Y"	/* Set the cursor position */
#define CUR_ON	    "\033e"	/* Enable the cursor  */
#define CUR_OFF	    "\033f"	/* Disable the cursor */
#define UP	    "\033I"	/* Move cursor up */
#define DOWN	    "\033B"	/* Move cursor down */
#define RIGHT	    "\033C"     /* Move cursor right                       */
#define LEFT        "\033D"     /* Move cursor left                        */
#define CLS         "\033E"     /* Clear screen code for IBM term.	   */
#define ERA_EOL     "\033K"     /* Erase to end of line for IBM term.      */
#define ERA_EOD     "\033J"     /* Erase to end of display for IBM term.   */
#define ERA_BEG     "\033o"     /* Erase to beginning of line from cur pos */
#define REV_ON      "\033p"     /* Reverse video on.			   */
#define REV_OFF     "\033q"     /* Reverse video off.			   */
#define INT_ON      "\033r"     /* Intensity on.			   */
#define INT_OFF     "\033u"     /* Intensity off.			   */
#define DEL_CHR	    "\033N"     /* Delete character. 			   */
#define DEL_LIN     "\033l"     /* Erase current line contents             */
#define BLINK_ON    "\033s"     /* Blink on.				   */
#define BLINK_OFF   "\033t"     /* Blink off.				   */
#define	WRAP_OFF    "\033w"	/* Wrap around off.			   */
#define INS_ON	    "\033@"	/* insert mode on			   */
#define INS_OFF	    "\033O"	/* insert mode off			   */
#define SAV_CUR	    "\033j"     /* Save cursor position			   */
#define RES_CUR     "\033k"     /* Restore cursor to the saved position    */

/* Table Lookups */

#define PROCESS_T   0x00        /* SVC table number for processes.         */
#define PIPE_T      0x10        /* SVC table number for pipes.             */
#define DEVICE_T    0x45	/* SVC table number for devices.  	   */
#define VCON_T      0x32	/* SVC table number for virtual consoles   */
#define SYSDEF_T    0x42	/* SVC table number for system define tab. */
#define PROCDEF_T   0x43	/* SVC table number for process define tab.*/
#define ENVIRON_T   0x01        /* SVC table number for environ table.     */
#define CONSOLE_T   0x30	/* SVC number for the console table.	   */
#define MEMORY_T    0x03        /* SVC table number for memory table.      */
#define SYSTEM_T    0x40        /* SVC table number for system table.      */
#define TIMEDATE_T  0X02
#define SHMEM_T	    0x11
#define CMDENV_T    0X44
#define DISKFILE_T  0x20

/* Structure sizes */

#define CMDSIZ 		(LONG)sizeof(struct cmdenv)
#define PROCSIZ 	(LONG)sizeof(struct procinfo)
#define PROCESIZ	(LONG)sizeof(struct process)
#define ENVSIZ 		(LONG)sizeof(struct environ)
#define PROSIZ 		(LONG)sizeof(struct process)
#define REGSIZ 		(LONG)sizeof(struct regsav)
#define REGSIZ68 	(LONG)sizeof(struct regsav1)
#define TIMESIZ		(LONG)sizeof(struct timedate)
#define CONSIZ		(LONG)sizeof(struct console)
#define VCONSIZ		(LONG)sizeof(struct vcon_tab)
#define PIPESIZ     	(LONG)sizeof(struct pipetab)
#define DEVSIZ		(LONG)sizeof(struct device)
#define DEFSIZ		(LONG)sizeof(struct define)
#define SHMSIZ		(LONG)sizeof(struct shmem)
#define MEMSIZ		(LONG)sizeof(struct memory)
#define SYSSIZ		(LONG)sizeof(struct system)
#define DISKSIZ		(LONG)sizeof(struct diskfile)
