/*#######################################################################
#                                                                       #
#                            NOTICE:                                    #
#                                                                       #
#    The source code contained in this listing is a proprietary trade   #
#    secret of DIGITAL RESEARCH, INC., Pacific Grove, California and    #
#    is also subject to copyright protection as an unpublished work     #
#    pursuant to Section 104(a) of Title 17 of the United States Code.  #
#    Unauthorized copying, adaptation, distribution, use or display is  #
#    prohitibed by law and may be subject to civil and criminal         #
#    penalties.                                                         #
#                                                                       #
#######################################################################*/

/*#######################################################################
#                                                                       #
#  Filename: FDMSGS.C                                                   # 
#                                                                       # 
#   Purpose: Static messages for the FDISK utility.  The strings are    #
#            referenced in FDISK.C and FDSCREEN.C                       #
#                                                                       #
#  Routines:                                                            # 
#      none -- data only.
#                                                                       #  
#  Maintenance Log                                                      #
#                                                                       #
#  Version No.   Date   Initials   SPR/APR No.   Change/Comments        #
#  -----------   ----   ---------  -----------   ---------------        #
#    1.0       01/25/88   jmb                    Initial creation.      # 
#    1.1       02/18/88   Y.S.                   IBM switch enable      #
#                                                                       #
#######################################################################*/


/*#######################################################################
#                                                                       #
#  Included Files:                                                      #
#                                                                       #
#######################################################################*/
#include "portab.h"
#include "piglobal.h"

/*#######################################################################
#                                                                       #
#  Strings used in FDISK.C:                                             #
#                                                                       #
#######################################################################*/


BYTE fdmsg01[] = "\nInvalid drive name -- The removable drive can not be\
 partitioned.\n";
BYTE fdmsg02[] = "\033rChanges have been made. Reboot system with CTRL-ALT-DEL\n\033u\7\7";
BYTE fdmsg03[] = "..........\n";
BYTE fdmsg04[] = "\nIllegal O Option.\n";
BYTE fdmsg05[] = "\nIllegal Option.\n";
BYTE fdmsg06[] = "\nThe specified hard disk is unusable\n";
BYTE fdmsg07[] = "\nThe first master boot record is not readable.\n";
BYTE fdmsg08[] = "\nCannot create the partition.  The space requested is not available.\n";
BYTE fdmsg09[] = "Invalid option specified.\n\7\7";
BYTE fdmsg10[] = "\nThere is not enough space available to create a 32 megabyte\
 partition.\n";
BYTE fdmsg11[] = "\nActive partition already exists.\n";
BYTE fdmsg12[] = "\nInvalid cylinder starting address.\n";
BYTE fdmsg13[] = "\nInvalid cylinder size.\n";
BYTE fdmsg14[] = "\nInvalid data.  The data entered is either out of range or\n\
overlapping existing partition entries.\n";
BYTE fdmsg15[] = "\nThe specified partition cannot be found.\n";
BYTE fdmsg16[] = "\nNot enough working memory.\n";
BYTE fdmsg17[] = "\nMust delete logical partitions before first extended\
 partition\n";
BYTE fdmsg18[] = "\nOnly a DOS or FlexOS partition can be activated.\n";
BYTE fdmsg19[] = "\nPrimary partition does not exist.\n";
BYTE fdmsg20[] = "\nMaster boot record is fully used.\n";
BYTE fdmsg21[] = "\nDisk is unpartitioned \n";
BYTE fdmsg22[] = "\nThis FDISK can only delete DOS or FlexOS partitions.\n";
BYTE fdmsg23[] = "\nDriver reading or writing error == %lx";

/*#######################################################################
#                                                                       #
#  Command line option help.                                            #
#                                                                       #
#######################################################################*/
#if IBM_FDISK
BYTE hpmsg[]  =
"\n\033rFDISK HELP:\033u Valid command-line options are:		\
\n									\
\n\033r    -C         Display\033u the \"Create Logical Partition\" menu.\
\n\033r    -C -W      Create\033u the entire disk as one partition.      \
\n\033r    -C -E      Partition\033u the entire disk into 32 megabyte partitions. \
\n\033r    -C -S -N   Create\033u a partition, \033rS\033u = Start cylinder, \033rN\033u = Number of cylinders.\
\n									\
\n\033r    -A         Display\033u the \"Active Partition Table\".	\
\n\033r    -A -N      Activate\033u the specified partition ( 1-3 ).   	\
\n									\
\n\033r    -D         Display\033u the \"Delete Partition Table\".	\
\n\033r    -D -N      Delete\033u the partition specified by \033rN\033u.\
\n									\
\n\033r    -I         Display\033u the \"Partition Information Table\".	\
\n\n									\
\n\033rFDISK\033u without options \033rdisplays\033u the FDISK main menu.\
\n									\
\nExamples:      FDISK HD0: -c -s0 -n306      ( Create a partition )	\
\n               FDISK HD0: -a -n2            ( Activate partition 2 )\n";
#else
BYTE hpmsg[]  =
"\n\033rFDISK HELP:\033u Valid command-line options are:		\
\n									\
\n\033r    -C         Display\033u the \"Create Logical Partition\" menu.\
\n\033r    -C -E      Partition\033u the entire disk into 32 megabyte partitions. \
\n\033r    -C -S -N   Create\033u a partition, \033rS\033u = Start cylinder, \033rN\033u = Number of cylinders.\
\n									\
\n\033r    -A         Display\033u the \"Active Partition Table\".	\
\n\033r    -A -N      Activate\033u the specified partition ( 1-3 ).   	\
\n									\
\n\033r    -D         Display\033u the \"Delete Partition Table\".	\
\n\033r    -D -N      Delete\033u the partition specified by \033rN\033u.\
\n									\
\n\033r    -I         Display\033u the \"Partition Information Table\".	\
\n\n									\
\n\033rFDISK\033u without options \033rdisplays\033u the FDISK main menu.\
\n									\
\nExamples:      FDISK HD0: -c -s0 -n306      ( Create a partition )	\
\n               FDISK HD0: -a -n2            ( Activate partition 2 )\n";
#endif

/*#######################################################################
#                                                                       #
#  Strings used in FDSCREEN.C:                                          #
#                                                                       #
#######################################################################*/

char  YesNoChar[] =		"YyNn"; 
BYTE BannerMsg[] =		"Digital Research Inc. FlexOS\n\
   Fixed Disk Setup Program Version 1.4\n   Copyright (C) DRI 1988";
BYTE ChosenDiskMsg[] =		"Current fixed disk \033r%s\033u";
BYTE OptionListMsg[] =		"\033rFDISK Options\033u";
BYTE ChooseMsg[] =		"Select ONE of the following:";
BYTE ChoiceOneMsg[] =		"1.  Create logical partition(s)";
BYTE ChoiceTwoMsg[] =		"2.  Change active partition";
BYTE ChoiceThreeMsg[] =		"3.  Delete logical partition(s)";
BYTE ChoiceFourMsg[] =		"4.  Display partition information";
BYTE ChoiceFiveMsg[] =		"5.  Select next hard disk drive";
BYTE EnterChoiceMsg[] =		"Enter Choice ( 1 - 5 ) ";
BYTE EscapeFdiskMsg[] =		"Press \033rESC\033u to leave FDISK";
BYTE CreatePartitionMsg[] =	"\033rCreate logical partition(s) on physical hard\
 disk %s\033u";
BYTE SelectOneMsg[] =		"1. Partition the entire disk into 32 megabyte\
 partitions";
BYTE SelectTwoMsg[] =		"2. Create single partition(s) of specified size";
BYTE WarningMsg[] =		"\033rWARNING:  CURRENT DISK INFORMATION MAY\
 BE LOST!\033u\7\7";
BYTE EnterSelectionMsg[] =	"Enter Choice ( 1 - 2 ) ";
BYTE EscapeToMainMenuMsg[] =	"Press \033rESC\033u to return ";
BYTE CreateAllMsg[] =		"Create 32 megabyte partitions on\
 physical hard disk %s";
BYTE SpaceLeftMsg[] =		"There is enough room for a total of \033r%d\033u new\
 32 megabyte partitions.";
BYTE MakePartitionsMsg[] =	"Make the partitions (Y/N)? ";
BYTE MakePartitionMsg[] =	"Make the partition (Y/N)? ";
BYTE RemainingMsg[] =		"\033r%d\033u cylinders are left.";
BYTE EscapeToCreateMenuMsg[] =	"Press \033rESC\033u to return to the Create Menu";
BYTE CurrentPartitionsMsg[] =	"";
/*
BYTE CurrentPartitionsMsg[] =	"Current Partitions";
*/
BYTE HeadingMsg[] =		"Partition Status Type Start Cylinder End\
 Cylinder Total Cylinders Megabytes";
BYTE UnderLineMsg[] =		"--------- ------ ---- --------------\
 ------------ --------------- ---------";
BYTE ViewPartitionsMsg[] =	"Display more partition information (Y/N)? ";
BYTE DefaultCylinderMsg[] =	"Enter starting cylinder: \033r%d\033u  ";
BYTE EnterCylinderMsg[] =	"";
BYTE DefaultSizeMsg[] =		"Enter cylinder size:     \033r%d\033u  ";
BYTE EnterSizeMsg[] =		"";
BYTE MegaSizeMsg[] =		"Size in megabytes: \033r%5.1f\033u  ";
BYTE ChangePartitionMsg[] =	"\033rChange current active partition on\
 physical hard disk %s\033u";
BYTE EnterNewPartitionMsg[] =	"Enter new active partition: ";
BYTE ActivatePartitionMsg[] =	"Activate the partition (Y/N)? ";
BYTE DeletePartitionMsg[] =	"\033rDelete a partition on physical hard\
 disk %s\033u";
BYTE DeleteNumberMsg[] =	"Partition number to delete: ";
BYTE DeleteVerifyMsg[] =	"Delete the partition (Y/N)? ";
BYTE DisplayPartitionMsg[] =	"\033rDisplay current partitions on physical\
 hard disk %s\033u";
BYTE PartitionNumMsg[] =	" %d ";
BYTE PartActiveMsg[] =		"ACTIVE";
BYTE PartInactiveMsg[] =	" INACT";
BYTE PartExtendedMsg[] =	"EXTEND";
BYTE DOSPartMsg[] =		"DOS";
BYTE UnknownPartMsg[] =		"????";
BYTE FlexOSPartMsg[] =		"FLEX";
BYTE DataMsg[] =		"%4d ";
BYTE MegDataMsg[] =		" %5.1f ";
BYTE No32GapMsg[] =		"\033rThe disk does not contain 32 megabytes of\
 free space.\7\033u";
BYTE IllegalDataMsg[] =		"Invalid input - Press \033rESC\033u and reenter.";
BYTE PartIsActiveMsg[] =	"The active partition already exists.";
BYTE PartNotExistMsg[] =	"The partition does not exist.";
BYTE DeleteOrderErrorMsg[] =	"MUST DELETE THE LOGICAL PARTITIONS BEFORE\
 EXTENDED PARTITION";
BYTE NoSpaceMsg[] =		"\033rThere is no space available to create\
 a partition.\7\033u";
BYTE EscapePosMsg[] =		"";
BYTE AllPartDeletedMsg[] =	"\033rAll partitions are deleted.\7\033u";
BYTE DiskUnPartMsg[] =		"The disk is unpartitioned.";
BYTE NoForeignPartDelMsg[] =	"Only DOS or FlexOS partition can be deleted.";
BYTE IllegalPartNumMsg[] =	"Partition number out of range. \033r<ESC>\033u ";
BYTE PrimePartNotExistMsg[]=	"\033rA primary partition does not exist.\7\033u";
BYTE ReinvokeMsg[] =		"Exit and reinvoke FDISK with the new drive\
 specification.";
BYTE DriverErrorMsg[] =         "Driver read or write error (Possibly a bad cylinder is found) <<ESC>>";
BYTE CylinderSizeMsg[] =	"Total hard disk space is \033r%d\033u cylinders";

/*#######################################################################
#                                                                       #
#                            NOTICE:                                    #
#                                                                       #
#    The source code contained in this listing is a proprietary trade   #
#    secret of DIGITAL RESEARCH, INC., Pacific Grove, California and    #
#    is also subject to copyright protection as an unpublished work     #
#    pursuant to Section 104(a) of Title 17 of the United States Code.  #
#    Unauthorized copying, adaptation, distribution, use or display is  #
#    prohitibed by law and may be subject to civil and criminal         #
#    penalties.                                                         #
#                                                                       #
#######################################################################*/
