/*#######################################################################
#									#
#			     NOTICE:					#
#									#
#    The source code contained in this listing is a proprietary trade	#
#    secret of DIGITAL RESEARCH, INC., Pacific Grove, California and	#
#    is also subject to copyright protection as an unpublished work	#
#    pursuant to Section 104(a) of Title 17 of the United States Code.	#
#    Unauthorized copying, adaptation, distribution, use or display is	#
#    prohitibed by law and may be subject to civil and criminal		#
#    penalties.								#
#									#
#######################################################################*/

/*#######################################################################
#									#
#  Filename:  PISTRUCT.H						#
#									#
#   Purpose:  Defines the primitive library structures used by Format,	#
#	      Chkdsk, and Fdisk for PS/2 project.			#
#									#
#  Routines:  None							#
#									#
#  Maintenance Log							#
#									#
#  Version No.	 Date	Initials   SPR/APR No.	 Change/Comments	#
#  -----------	 ----	---------  -----------	 ---------------	#
#    1.0       09/14/87    DS	      N/A	 Created.		#
#    1.1       09/29/87    DM	      N/A	 Added.			#
#    1.2       09/30/87    DS	      N/A	 Integration		#
#    1.3       10/06/87    DS	      N/A	 Added ErrorEntryStruct #
#    1.4       10/08/87    DS	      N/A	 Added PLockTable	#
#    1.5       10/11/87    DS	      N/A	 Modified PErrorEntry	#
#    1.6       10/13/87    YS	      N/A	 Modify			#
#    1.7       11/09/87    WeD	      N/A	 File numbers ==> LONG	#
#    1.8       11/11/87    WeD	      N/A	 Fixed date bitstrings	#
#    1.9       11/13/87    WeD	      N/A	 Reserved Sectors==ULONG#
#    2.0       11/14/87    WeD	      N/A	 PDisplayObject defined #
#######################################################################*/

#ifndef  PISTRUCT
#define  PISTRUCT  1
#include "piglobal.h"

#ifndef  PORTAB

#ifdef	HC
#include <portab.h>
#else
#include "portab.h"
#endif
#endif

/*
    Structure of the FlexOS CONSOLE Table.
*/

typedef struct
{
   WORD   tahead;
   WORD   smode;	  /* Screen Mode */
   WORD   kmode;	  /* Keyboard Mode */
   WORD   currow;
   WORD   curcol;
   WORD   nrows;	  /* Number of Rows */
   WORD   ncols;	  /* Number of Columns */
   BYTE   vcnum;
   BYTE   type;
   WORD   cname[ 5 ];
} ConsoleTable;

/*
	Time and Date Structures.
*/

typedef struct
{
   unsigned   second : 5;
   unsigned   minute : 6;
   unsigned   hour   : 5;
} PTime;

typedef struct
{
   unsigned   day   : 5;
   unsigned   month : 4;
   unsigned   year  : 7;
} PDate;

/*
    Menu Object Structure.
*/

typedef struct
{
   WORD   Row;
   WORD   Column;
} PLocation;

typedef struct
{
   PLocation   UpLeft;
   PLocation   LowRight;
} PRectangle;

/*
    Object Definition.	Objects are passed to PDisplayObject by address.
    The object pointer points to a control string which is passed to
    printf() with up to three long arguments (6 word arguments).
*/

typedef struct
{
    PLocation   Position;	/* Screen Location	  */
    char        *Object;	/* Pointer to the format string */
} PDisplayObject;

/*
	Command Line Arguments/Options Parsing Structure.
*/

typedef struct
{
   BYTE   Option;	      /* Option Flag -P, etc. */
   WORD   Found;	      /* Was it found on the command line ? */
   LONG   Result;	      /* Storage for the result */
} POption;

#define PMAX_OPTION  10

typedef struct
{
   WORD     Total;
   POption  *ArgpPtr[ PMAX_OPTION ];
} PCommandLineOptions;

#ifndef LEN_FILENAME
#define LEN_FILENAME  11
#endif

typedef struct
{
   UBYTE   FileName[ LEN_FILENAME ];
   UWORD   Attributes;
   UBYTE   Reserved[ 3 ];
   UWORD   RecordSize;
   UBYTE   UserID;
   UBYTE   GroupID;
   UWORD   FileProtection;
   PTime   TimeLastMod;
   PDate   DateLastMod;
   UWORD   FirstCluster;
   ULONG   FileLength;
} PDirEntryStruct;

typedef struct
{
   UWORD SectorSize;
   UWORD FirstFatTrack0;
   ULONG TotalSecInPartition;
   UWORD SectorsPerTrack;
   UWORD SectorsPerCluster;
   UBYTE NumberFats;
   UBYTE FatID;
   UWORD TotalSecInFat;
   UWORD NumberRootDirEntries;
   UBYTE NumberOfHeads;
   UBYTE TypeOfFileSystem;
   ULONG TotalHiddenSectors;
   ULONG SystemSize;
   UWORD NumberOfCylinders;
   UWORD ParkingZone;
   UWORD PrecompCylinder;
   UWORD ReduceWriteCurrent;
   UWORD StepRate;
   UWORD PhysicalDriveNumber;
   UWORD DriveUnitNumber;
}  PMediaDescriptionBlock;

typedef struct
{
   UBYTE   DriveType;
   UBYTE   UnitNumber;
   UBYTE   DriveName[ LEN_DRIVENAME ];
   LONG    DriveSVCID;
   UWORD   Partitioned;
   ULONG   FileLength;
   PMediaDescriptionBlock   MediaDesBlock;
} PDiskIDStruct;

/* FDisk Local Structure Declarations */

typedef struct
{
   UBYTE   Head;
   UBYTE   Sector;
   UWORD   Cylinder;
} DiskAddress;

typedef struct
{
   UBYTE Head;
   UBYTE Sector;
   UBYTE Cylinder;
}  WellDoneDiskAddr;

typedef struct
{
   UBYTE BootIndor;
   WellDoneDiskAddr StartAddr;
   UBYTE OwnerType;
   WellDoneDiskAddr EndAddr;
   ULONG SectorNumBeforePart;
   ULONG PartSize;
}  PartitionTable;

typedef struct GapStruct
{
   DiskAddress StartAddr;
   DiskAddress EndAddr;
   ULONG GapSizeInSectors;
   ULONG LastMBRAddr;
   DiskAddress OSBootStartAddr;
   struct GapStruct *NextGapEntry;
}  GapEntry;

typedef struct
{
   UBYTE BootCode[0x1BE];
   PartitionTable PartTable[NUM_PART_INMBR];
   UWORD  Signature;
}  MasterBootRec;

typedef struct
{
   UBYTE JumpCode[3];
   UBYTE OEMName[8];
   UWORD BytesPerSector;
   UBYTE SectorsPerCluster;
   UWORD OSResSectors;
   UBYTE NumFatsInPart;
   UWORD NumRootDirEntries;
   UWORD NumSectorsInPart;
   UBYTE MediaDescripByte;
   UWORD FatSizeInSectors;
   UWORD SectorsPerTrack;
   UWORD NumHeadsOnDisk;
   ULONG NumPrecedSectors;
   ULONG ExtenNumSecInPart;
   ULONG FirstDataSector;
   ULONG OSCodeLoadAddress;
   ULONG SizeOfOSCode;
   ULONG OSDataLoadAddress;
   ULONG SizeOfOSData;
}  PBiosParBlock;

typedef struct
{
   PBiosParBlock   BPB;
   UBYTE	   OSBootCode[512-sizeof(PBiosParBlock)-sizeof(UWORD)];
   UWORD	   Signature;
} POSBootRec;

typedef struct Err
{
   struct Err	*NextPtr;
   UWORD	ErrorType;
   UWORD	EntryType;
   UWORD	ClusterIndex;
   UWORD	EntryIndex;
   UWORD	BadIndex;
   ULONG	WrongSize;
   ULONG	CorrectSize;
} PErrorEntry, *ERRPTR;

#ifndef  PMAX_DISK_LOCKS
#define  PMAX_DISK_LOCKS  64
#endif

typedef struct
{
   ULONG   NumOfLocks;
   LONG    Locks[ PMAX_DISK_LOCKS ];
} PLockTable;

#endif

/*#######################################################################
#									#
#			     NOTICE:					#
#									#
#    The source code contained in this listing is a proprietary trade	#
#    secret of DIGITAL RESEARCH, INC., Pacific Grove, California and	#
#    is also subject to copyright protection as an unpublished work	#
#    pursuant to Section 104(a) of Title 17 of the United States Code.	#
#    Unauthorized copying, adaptation, distribution, use or display is	#
#    prohitibed by law and may be subject to civil and criminal		#
#    penalties.								#
#									#
#######################################################################*/
