/************************************************************************/
/*	File	 : splmsg.c						*/
/*									*/
/*	Function : Offer universal message tables for Spooling system.  */
/*		   OEM from foreign countries can modify the message	*/
/* 		   tables in this file and use their languages instead. */
/*									*/
/* Ver  Date	  Who   Comment						*/
/* ---- --------  ----- ----------------------------------------------- */
/* 1.1	02/26/86  Lin	Started						*/
/* 1.2  04/29/86  Lin	Add error message # 23 .. 25			*/
/*									*/
/************************************************************************/
#include	"portab.h"

UBYTE SPACE 	= ' ';
UBYTE EQUAL	= '=';
UBYTE COLON	= ':';
UBYTE CARET	= '^';
UBYTE STAR	= '*';
UBYTE DASH	= '-';
UBYTE FSLASH	= '/';
UBYTE BSLASH	= '\\';
UBYTE TAB	= '\t';
UBYTE LF	= '\n';
UBYTE CR	= '\r';
UBYTE QUESTION  = '?';

UBYTE ZERO	= '0';
UBYTE NINE	= '9';
UBYTE PLUS	= '+';
UBYTE SMALLa	= 'a';
UBYTE SMALLz	= 'z';
UBYTE BIGa	= 'A';
UBYTE SMALLs	= 's';

UBYTE S_OPT	= 'S';
UBYTE D_OPT	= 'D';
UBYTE H_OPT	= 'H';
UBYTE C_OPT	= 'C';
UBYTE N_OPT	= 'N';
UBYTE T_OPT	= 'T';
UBYTE L_OPT	= 'L';

UBYTE 	*namemsg[]=		/* mail box(pipe file) names for everybody */
	{
/*00*/	"local::pi:%spoolmx",
/*01*/	"local::pi:%sfe",
/*02*/	"local::pi:%spl",
/*03*/	"local::pi:%",
/*04*/	"spool",
/*05*/	"despool",
/*06*/	"system:spool.286",
/*07*/	"system:despool.286",
/*08*/	"system:%pld.spl",
/*09*/	"ABCDEFGH",
/*10*/	"&&&&&&&&",
/*11*/	"LOCAL::\0",		/* gurantee a trailing NULL for comparision */
	""
	};

UBYTE	*errmsg[] =
	{
/*00*/	"",
/*01*/  "\r\n *** You can only give 20 file specifications. ***\r\n",              
/*02*/  "\r\n *** Unable to load the Spooler. ***\r\n",
/*03*/  "\r\n *** No default printer device attatched. ***\r\n",
/*04*/  "\r\n *** The specified device was invalid. ***\r\n",
/*05*/  "\r\n *** Unable to talk to the Spooler. ***\r\n",
/*06*/  "\r\n *** No files matched the file specification. ***\r\n",
/*07*/  "",
/*08*/  "\r\n *** Spooler unable to function or despooler can not be loaded. ***\r\n",
/*09*/  "\r\n *** Unable to cancel the job. ***\r\n",
/*10*/  "\r\n *** Unable to terminate your job(s). ***\r\n",
/*11*/  "\r\n *** Specified device not found or status queue creation error. ***\r\n",
/*12*/  "\r\n *** Spooler out of memory - either cancel some jobs, or wait. ***\r\n",
/*13*/	"\r\n *** No file(s) matched the filespec: ",
/*14*/  "\r\n *** Unable to load the PLD file(on-disk printer queue). ***\r\n",
/*15*/  "\r\n *** Unable to get job status from printer queue. ***\r\n",
/*16*/  "\r\n *** Please specify which node to use or define 'prn:' first. ***\r\n",
/*17*/  "\r\n *** Please set up local machine name first. ***\r\n",
/*18*/  "\r\n *** Please start spooler system on server node first. ***\r\n",
/*19*/  "\r\n *** Server node not found or unable to talk to it. ***\r\n",
/*20*/  "\r\n *** Unable to open the file(s): ",
/*21*/	"\r\n *** Spooler unable to locate the file(s): ",
/*22*/	"\r\n *** Spooler unable to print some of the file(s): ",
/*23*/	"\r\n *** Expect file specs when talking to PC-DOS servers. ***\r\n",
/*24*/	"\r\n *** The option(s) specified not supported on PC-DOS servers. ***\r\n",
/*25*/  "\r\n *** Unable to open spool driver on the PC-DOS server. ***\r\n",
	""
	};

UBYTE	*strmsg[] =
	{
/*00*/	"\r\n",
/*01*/	"*:",
/*02*/	"*",
/*03*/	" ",
/*04*/	"  ",
/*05*/	"prn:",
/*06*/	"bgprn:",
/*07*/	"name",
/*08*/	"pi:%spl",
/*09*/	"switchar",
/*10*/	"\r\014",			/* ASCII code for Form Feed 	*/
/*11*/  "\006",				/* ASCII code for Acknowledge	*/
/*12*/	"tempdir:",
/*13*/	"mx",
/*14*/	"null:",
/*15*/	"stdin",
/*16*/	"stdout",
/*17*/	"stderr",
/*18*/	"stdcmd",
/*19*/	".%",
/*20*/	"\377",
	""
	};

UBYTE	*dspmsg[] =
	{
/*00*/	"\r\n *DEVICE* ",
/*01*/	"    STATUS: ",
/*02*/	"free   ",
/*03*/	"inuse  ",
/*04*/	"offline",
/*05*/	"unknown",
/*06*/	"    TOTAL JOBS: ",
/*07*/	"PRINTING  ",
/*08*/	"QUEUED    ",
/*09*/	"WAITING   ",
/*10*/	"Status    Job_id User     Filespec     ",
/*11*/	"--------- ------ -------- ------------ ",
/*12*/	" on NODE ",
/*13*/	"Node              Device    \r\n",
/*14*/	"----------------- ----------\r\n",
	""
	};

UBYTE 	*dsplmsg[] =
	{
/*00*/	"\r\n *** File not found.\r\n",
/*01*/	"\r\n *** Device locked.\r\n",
/*02*/	"\r\n *** Improper file ownership.\r\n",
/*03*/	"\r\n *** OPEN error: ",
/*04*/	"\r\n *** Disk removed or changed.\r\n",
/*05*/	"\r\n *** READ error: ",
/*06*/	"\r\n *** Unable to delete the temporary file(s).\r\n",
	""
	};

UBYTE 	*usage[]   =
	{
	"\033\105\r--------------------------------------------------------------------------\r\n",
	"Print Command Usage:\r\n\n",
	"	print [filespec1 filespec2 .....] [option1 option2 .....]\r\n\n",
	"		where 'filespec' is the actual file name,\r\n",
	"		and 'option' is one of the following:\r\n\n",
	"		-n=node   .....the remote spooler Node for printing\r\n",
	"		-d=device .....the Device for printing\r\n",
	"		-c=job_id .....Cancel the print job by its job_id\r\n",
	"		-s 	  .....show Status of the print queue\r\n",
	"		-h	  .....put this Hot job atop the print queue\r\n",
/*10*/	"		-t	  .....Terminate(Kill) all your print jobs\r\n",
	"		-l	  .....Load job queue after system recovery\r\n\n",
	"NOTE: 1). You can have more than one option on the same command line but be sure\r\n",
	"          they don't cause conflict.  For example, '-t' ignores '-h','-c','-l'.\r\n",
/*14*/	"      2). Wildcards are allowed in the filespecs.\r\n",
/*15*/	"      3). Your node should be on the DR-NET(FlexOS-286 Network) before you\r\n",
/*16*/	"          specify the '-n' option.  You can DEFINE an entry 'prn:=node::spldrv:'\r\n",
/*17*/	"          where 'node' is the name of your default server node.",
/*18*/	""
	};

