###########################################################################
#
#   UTLMSG.MAK - 
#
#       Pre-requisite to running this make file is run the batch file:
#
#             SETIPATH.BAT - define the following:
#
#		  utl: = where utility include files can be found.
#
#		  cmn: = where system include files can be found.
#
#		  hc:  = where Meta_Ware include files can be found.
#
#                 ipath = utl:;cmn:;hc:;
#
#############################################################################
##
##   Utility Library Dependencies...
##
CCMSGS  = ccmsgs.l86
CCRTL   = ccrtl.l86
CCUTLS  = ccutls.l86
UTOOLS  = utools.l86
COMPACT = c:\highc\compact\hcce.l86
BIG     = c:\highc\big\hcbe.l86

##
##   Make it easy to include the libraries by using
##   the following definition.
##
COMMON  = $CCMSGS $CCRTL $CCUTLS $UTOOLS $COMPACT $BIG

##
##   Check all the utilities everytime this make file
##   is executed.
##
exec :		backup.286 restore.286 chkdsk.286 \
		comp.286 copy.286 date.286 diskcomp.286 diskcopy.286 \
		dir.286 diskset.286 find.286 fset.286 config.286 \
		logon.286 password.286 more.286 print.286 spool.286 \
		despool.286 process.286 recdir.286 \
		recfile.286 rename.286 sort.286 systab.286 time.286 \
		tree.286 type.286 ver.286 vol.286 \
		command.286

##
## BACKUP and RESTORE...
##
backup.286 :	bkresmsg.obj $COMMON

 link backup[inp]
 +-postlink backup.286

restore.286 :	bkresmsg.obj $COMMON

 link restore[inp]
 +-postlink restore.286

bkresmsg.obj :	bkresmsg.c portab.h concur.h
  hc bkresmsg -pro util.pro

##
## CHKDSK
##
chkdsk.286 :	ckdskmsg.obj $COMMON

 link chkdsk[inp]
 +-postlink chkdsk.286

ckdskmsg.obj :	ckdskmsg.c portab.h pistruct.h
  hc ckdskmsg -pro cnfgutl.pro

##
## COMP
##
comp.286 :	compmsg.obj $COMMON

 link comp[inp]
 +-postlink comp.286

compmsg.obj :	compmsg.c portab.h
  hc compmsg -pro util.pro

##
## COPY
##
copy.286 :	copymsg.obj $COMMON

 link copy[inp]
 +-postlink copy.286

copymsg.obj :	copymsg.c portab.h
  hc copymsg -pro util.pro

##
## DATE
##
date.286 :	datemsg.obj $COMMON
 
 link date[inp]
 +-postlink date.286

datemsg.obj :	datemsg.c portab.h
  hc datemsg -pro util.pro

##
## DISKCOMP
##
diskcomp.286 :	dcompmsg.obj $COMMON

 link diskcomp[inp]
 +-postlink diskcomp.286

dcompmsg.obj :	dcompmsg.c portab.h
  hc dcompmsg -pro util.pro

##
## DISKCOPY
##
diskcopy.286 :	dcopymsg.obj $COMMON

 link diskcopy[inp]
 +-postlink diskcopy.286

dcopymsg.obj :	dcopymsg.c portab.h
  hc dcopymsg -pro util.pro

##
## DIR
##
dir.286 :	dirmsg.obj $COMMON

 link dir[inp]
 +-postlink dir.286

dirmsg.obj :	dirmsg.c portab.h
  hc dirmsg -pro util.pro

##
## DISKSET
##
diskset.286 :	dsetmsg.obj $COMMON

 link diskset[inp]
 +-postlink diskset.286

dsetmsg.obj :	dsetmsg.c portab.h
  hc dsetmsg -pro util.pro

##
## FIND 
##
find.286 :	findmsg.obj $COMMON

 link find[inp]
 +-postlink find.286

findmsg.obj :	findmsg.c portab.h
  hc findmsg -pro util.pro

##
## FSET
##
fset.286 :	fsetmsg.obj $COMMON

 link fset[inp]
 +-postlink fset.286

fsetmsg.obj :	fsetmsg.c portab.h
  hc fsetmsg -pro util.pro

##
## CONFIG
##
config.286 :	konmsg.obj $COMMON

 link konfig[inp]
 +-postlink config.286

konmsg.obj :	konmsg.c portab.h concur.h
  hc konmsg -pro util.pro

##
## LOGON
##
logon.286 :	logmsg.obj $COMMON

 link logon[inp]
 +-postlink logon.286

logmsg.obj :	logmsg.c portab.h cmn:sysbuild.h
  hc logmsg -pro util.pro

##
## PASSWORD
##
password.286 :	passmsg.obj $COMMON

 link password[inp]
 +-postlink password.286

passmsg.obj :	passmsg.c portab.h
  hc passmsg -pro util.pro

##
## MORE 
##
more.286 :	moremsg.obj $COMMON

 link more[inp]
 +-postlink more.286

moremsg.obj :	moremsg.c portab.h
 hc moremsg -pro util.pro

##
## PRINT, SPOOL, and DESPOOL....
##
print.286 :	splmsg.obj $COMMON

 link print[inp]
 +-postlink print.286

spool.286 :	splmsg.obj $COMMON

 link spool[inp]
 +-postlink spool.286

despool.286 :	splmsg.obj $COMMON

 link despool[inp]
 +-postlink despool.286

splmsg.obj :	splmsg.c portab.h
  hc splmsg -pro util.pro

##
## PROCESS
##
process.286 :	procmsg.obj $COMMON

 link process[inp]
 +-postlink process.286

procmsg.obj :	procmsg.c portab.h concur.h
  hc procmsg -pro util.pro

##
## RECDIR
##
recdir.286 :	recdmsg.obj $COMMON

 link recdir[inp]
 +-postlink recdir.286

recdmsg.obj :	recdmsg.c portab.h
  hc recdmsg -pro util.pro

##
## RECFILE
##
recfile.286 :	recfmsg.obj $COMMON

 link recfile[inp]
 +-postlink recfile.286

recfmsg.obj :	recfmsg.c portab.h
  hc recfmsg -pro util.pro

##
## RENAME
##
rename.286 :	renmsg.obj $COMMON

 link rename[inp]
 +-postlink rename.286

renmsg.obj :	renmsg.c portab.h
  hc renmsg -pro util.pro

##
## SORT
##
sort.286 :	sortmsg.obj $COMMON

 link sort[inp]
 +-postlink sort.286

sortmsg.obj :	sortmsg.c portab.h concur.h
  hc sortmsg -pro util.pro

##
## SYSTAB
##
systab.286 :	systmsg.obj $COMMON

 link systab[inp]
 +-postlink systab.286

 link stime[inp]
 +-postlink stime.286

systmsg.obj :	systmsg.c portab.h constrct.h
 hc systmsg -pro util.pro

##
## TIME
##
time.286 :	timemsg.obj $COMMON

 link time[inp]
 +-postlink time.286

timemsg.obj :	timemsg.c portab.h
  hc timemsg -pro util.pro

##
## TREE
##
tree.286 :	treemsg.obj $COMMON

 link tree[inp]
 +-postlink tree.286

treemsg.obj :	treemsg.c portab.h
  hc treemsg -pro util.pro

##
## TYPE
##
type.286 :	typemsg.obj $COMMON

 link type[inp]
 +-postlink type.286

typemsg.obj :	typemsg.c portab.h
  hc typemsg -pro util.pro

##
## VER
##
ver.286 :	vermsg.obj $COMMON

 link ver[inp]
 +-postlink ver.286

vermsg.obj :	vermsg.c portab.h
  hc vermsg -pro util.pro

##
## VOL
##
vol.286 :	volmsg.obj $COMMON

 link vol[inp]
 +-postlink vol.286

volmsg.obj :	volmsg.c portab.h
  hc volmsg -pro util.pro

##
## SHELL
##
command.286 :	shmsgs.obj asnmsgs.obj securmsg.obj \
		breakmsg.obj chdirmsg.obj defmsg.obj vfymsg.obj \
		eramsg.obj cancemsg.obj mkdirmsg.obj rmdirmsg.obj \
		$COMMON

 link shell[inp]
 +-postlink command.286

shmsgs.obj :	shmsgs.c portab.h
 hc shmsgs -pro util.pro

breakmsg.obj :	breakmsg.c portab.h
 hc breakmsg -pro util.pro

chdirmsg.obj :	chdirmsg.c portab.h
 hc chdirmsg -pro util.pro

defmsg.obj :	defmsg.c portab.h
 hc defmsg -pro util.pro

vfymsg.obj :	vfymsg.c portab.h
 hc vfymsg -pro util.pro

eramsg.obj :	eramsg.c portab.h
 hc eramsg -pro util.pro

cancemsg.obj :	cancemsg.c portab.h
 hc cancemsg -pro util.pro

mkdirmsg.obj :	mkdirmsg.c portab.h
 hc mkdirmsg -pro util.pro

rmdirmsg.obj :	rmdirmsg.c portab.h
 hc rmdirmsg -pro util.pro

asnmsgs.obj :	asnmsgs.c portab.h concur.h
 hc asnmsgs -pro util.pro

securmsg.obj :	securmsg.c portab.h concur.h
 hc securmsg -pro util.pro

