
/*****************************************************************
 * "Copyright (C) 1985, Digital Research, Inc.  All Rights       *
 * Reserved.  The Software Code contained in this listing is     *
 * proprietary to Digital Research Inc., Monterey, California    *
 * and is covered by U.S. and other copyright protection.        *
 * Unauthorized copying, adaptation, distribution, use or        *
 * display is prohibited and may be subject to civil and         *
 * criminal penalties.  Disclosure to others is prohibited.  For *
 * the terms and conditions of software code use refer to the    *
 * appropriate Digital Research License Agreement."              *
 *****************************************************************/

/*===============================================================*
 *   Version 1.2        WMOS.H					 *
 *                      Operating System defines for WMEX.C	 *
 *---------------------------------------------------------------*
 *    VERSION   DATE    BY      CHANGE/COMMENTS                  *
 *---------------------------------------------------------------*
 *                                                               *
 *      1.2   09/17/86  ldt     Changed references of file-nums  *
 *				from ULONG to LONG.		 *
 *	1.1   05/10/85	jsr	E_LOGOFF = 0x7fffffff.		 *
 *	1.0   04/18/85	jsr					 *
 *                                                               *
 *===============================================================*/
/* Normal characters */

#define	CH_BS		0x0008		/* backspace		*/
#define	CH_NL		0x000a		/* newline (linefeed)	*/
#define	CH_CR		0x000d		/* carriage return	*/

#define	CH_0		0x0030		/* 0			*/
#define	CH_1		0x0031		/* 1			*/
#define	CH_2		0x0032		/* 2			*/
#define	CH_3		0x0033		/* 3			*/
#define	CH_4		0x0034		/* 4			*/
#define	CH_5		0x0035		/* 5			*/
#define	CH_6		0x0036		/* 6			*/
#define	CH_7		0x0037		/* 7			*/
#define	CH_8		0x0038		/* 8			*/
#define	CH_9		0x0039		/* 9			*/

#define	CH_C		0x0043		/* C			*/
#define	CH_D		0x0044		/* D			*/
#define	CH_M		0x004d		/* M			*/

#define	CH_LC		0x0063		/* c			*/
#define	CH_LD		0x0064		/* d			*/
#define	CH_LM		0x006d		/* m			*/


/* Special characters */

#define	CI_HELP		0x2000		/* Help Key		*/
#define CI_WINDOW	0x2001		/* Window Key		*/
#define CI_NEXT		0x2002		/* Next Key		*/
#define CI_PREV		0x2003		/* Previous Key		*/
#define	CI_PSCRN	0x2004		/* Print Screen		*/

/****************************************************************/
/*								*/	
/*	Driver types						*/
/*								*/
/****************************************************************/

#define	DVR_TIME	0x01	/* Timer Driver			*/
#define	DVR_PIPE	0x11	/* Pipe Driver			*/
#define	DVR_DISK	0x21	/* Disk Driver			*/
#define	DVR_CON		0x31	/* Console Driver		*/
#define	DVR_PRN		0x71	/* Printer Driver		*/
#define DVR_SER		0x72	/* Serial Driver		*/

#define DVR_CLOCK	0x7e	/* DOS Clock Driver Emulator	*/
#define DVR_NULL	0x7f	/* Null Device			*/

#define	DVR_PORT	0x81	/* Port Driver			*/
#define	DVR_OEM		0x82	/* 1st OEM Driver		*/

/****************************************************************/
/*								*/	
/*	System information table types				*/
/*								*/
/****************************************************************/

#define	T_PROC		0x00		/* Process table		*/
#define	T_ENV		0x01		/* Environment table		*/
#define	T_TD		0x02		/* Time and date table		*/
#define	T_MEM		0x03		/* Memory table			*/
#define	T_PIPE		0x10		/* Pipe table			*/
#define	T_FILE		0x20		/* Disk File table		*/
#define	T_DISK		DVR_DISK	/* Disk table			*/
#define	T_CON		0x30		/* Screen table			*/
#define	T_PCON		DVR_CON		/* Physical Console table	*/
#define	T_VCON		0x32		/* Virtual Console table	*/
#define	T_MOUSE		0x33		/* Mouse table			*/
#define T_TOP		0x34		/* Top Border (no table)	*/
#define T_BOTTOM	0x35		/* Bottom Border (no table)	*/
#define T_LEFT		0x36		/* Left Border (no table)	*/
#define T_RIGHT		0x37		/* Right Border (no table)	*/
#define	T_SYS		0x40		/* System table			*/
#define	T_FNUM		0x41		/* File number table		*/
#define	T_SDEF		0x42		/* System Defines table		*/
#define	T_PDEF		0x43		/* Process Defines table	*/
#define	T_CMD		0x44		/* Command Environment table	*/
#define	T_DEV		0x45		/* Device table			*/
#define	T_PNAME		0x46		/* Pathname table		*/
#define T_SER		DVR_SER		/* Serial table			*/
#define	T_PRN		DVR_PRN		/* Printer table		*/
#define T_CLOCK		DVR_CLOCK	/* DOS Clock Driver table	*/
#define T_NULL		DVR_NULL	/* Null Device table		*/
#define	T_PORT		DVR_PORT	/* Port table			*/

	/* Note:  Tables from 0x82 -> 0xff are special tables */

/* NOTE: Error codes are WORD values */

#define	E_MEMORY	0x400D	/* Not enough memory available		*/

#define	E_NOMEM		0x4015	/* Non-existant memory			*/
#define	E_MBOUND	0x4016	/* Memory Bound error			*/
#define E_EBOUNDEX	E_MBOUND
#define	E_ILLINS	0x4017	/* Illegal instruction			*/
#define	E_DIVZERO	0x4018	/* Divide by zero			*/
#define	E_BOUND		0x4019	/* Bound exception			*/
#define	E_OFLOW		0x401A	/* Overflow exception			*/
#define	E_PRIV		0x401B	/* Privilege violation			*/
#define	E_TRACE		0x401C	/* Trace				*/
#define	E_BRKPT		0x401D	/* Breakpoint				*/
#define	E_FLOAT		0x401E	/* Floating point exception		*/
#define	E_STACK		0x401F	/* Stack fault				*/
#define	E_NOTON286	0x4020	/* Exception not caught by 286		*/
#define E_EM1		0x4021	/* emulated instruction group 1		*/

					       /* end of SYSTEM.H stuff */

#define	E_LOGOFF	(LONG)0x7FFFFFFF   /* Logoff requested by Shell */

/****************************************
 *					*
 *   WMEX specific defines...		*
 *					*
 ****************************************/

/* Utility Return Codes */
#define	UR_SOURCE	(LONG)0			/* Utility Return Module ID  */
#define	UR_SUCCESS	(LONG)0			/* Successful completion     */
#define	UR_PARM		0x0001			/* Parameter error	     */
#define	UR_CONFLICT	0x0002			/* Contention conflict	     */
#define	UR_UTERM	0x0003			/* Terminated by user	     */
#define	UR_FORMAT	0x0004			/* Data structure format err */
#define	UR_INTERNAL	0x0005			/* Internal utility error    */

#define MAXVC		9			   /* maximum vcons per pcon */

#define	WNDWDESK	0			      /* DESK window (vc000) */
#define	WNDWMSSG	1			      /* MSSG window (vc001) */
#define	WNDWSTAT	2			      /* STAT window (vc002) */
#define	WNDWUSR1	3			      /* USR1 window (vc003) */
#define WNDWUSR2	4			      /* USR2 window (vc004) */
#define	WNDWUSR3	5			      /* USR3 window (vc005) */
#define	WNDWUSR4	6			      /* USR4 window (vc006) */
#define	WNDWUSR5	7			      /* USR5 window (vc007) */
#define	WNDWUSR6	8			      /* USR6 window (vc008) */

#define	RMIN		0				      /* row minimum */
#define	CMIN		0				   /* column minimum */

#define	BRWIDTH		1				 /* ROW border width */
#define	BCWIDTH		1				 /* COL border width */

#define EV_MESSAGE	0			     /* internal event types */
#define EV_WINDOW	1
#define EV_PREV		2
#define EV_NEXT		3
#define EV_CHAR		4
#define	EV_PRTSCRN	5
#define EV_PRINTER	6

							   /* OS event types */
#define	OSEVDESK	WNDWDESK  /* 0) not used by DESK, just a placeholder */
#define	OSEVMSSG	WNDWMSSG  /* 1) not used by MSSG, just a placeholder */
#define	OSEVSTAT	WNDWSTAT  /* 2) not used by STAT, just a placeholder */
#define	OSEVUSR1	WNDWUSR1	/* 3) USR1 shell process termination */
#define	OSEVUSR2	WNDWUSR2	/* 4) USR2 shell process termination */
#define	OSEVUSR3	WNDWUSR3	/* 5) USR3 shell process termination */
#define	OSEVUSR4	WNDWUSR4	/* 6) USR4 shell process termination */
#define	OSEVUSR5	WNDWUSR5	/* 7) USR5 shell process termination */
#define	OSEVUSR6	WNDWUSR6	/* 8) USR6 shell process termination */
#define	OSEVMPDK	WNDWDESK+MAXVC	/* 9) DESK placeholder, MSGPIPE read */
#define	OSEVMPMG	WNDWMSSG+MAXVC /* 10) MSSG placeholder, MSGPIPE read */
#define	OSEVMPST	WNDWSTAT+MAXVC 	     /* 11) STAT <HELP> MSGPIPE read */
#define	OSEVMPU1	WNDWUSR1+MAXVC		    /* 12) USR1 MSGPIPE read */
#define	OSEVMPU2	WNDWUSR2+MAXVC		    /* 13) USR2 MSGPIPE read */
#define	OSEVMPU3	WNDWUSR3+MAXVC		    /* 14) USR3 MSGPIPE read */
#define	OSEVMPU4	WNDWUSR4+MAXVC		    /* 15) USR4 MSGPIPE read */
#define	OSEVMPU5	WNDWUSR5+MAXVC		    /* 16) USR5 MSGPIPE read */
#define	OSEVMPU6	WNDWUSR6+MAXVC		    /* 17) USR6 MSGPIPE read */
#define	OSEVKEYBD	WNDWUSR6+MAXVC+1       /* 18) KEYBD async read event */
#define	OSEVPRNT	WNDWUSR6+MAXVC+2    /* 19) PRINTER async write event */
#define	OSEVHELP	WNDWUSR6+MAXVC+3    /* 20) STAT <HELP> MSGPIPE write */
#define	OSEVRSPP	WNDWUSR6+MAXVC+4	   /* 21) MSSG RSPPIPE write */
#define	NOSEVENTS	WNDWUSR6+MAXVC+5       /* 22) number of known events */

						/* Definition of flags field */
						 /* WVARS struct flag values */
#define WV_INUSE	0x0001

					      /* WNDWDESC struct flag values */
							     /* global flags */
#define	W_BORDERS	0x01		     /* BIT 0: 1 = borders, 0 = none */
#define	W_ATTRIBS	0x02		  /* BIT 1: 1 = attributes, 0 = none */
			     /* internal flags - not for use in USRx windows */
#define	W_INTERNF	0x40	     /* BIT 6: 1 = internal fields, 0 = none */
#define	W_PMPTHLP	0x80	      /* BIT 7: 1 = p1st/h2nd, 0 = h1st/p2nd */

						  /* flags for SPEC building */
#define	S_DEV		0x0001
#define	S_PIP		0x0002
#define	S_VCP		0x0004
#define	S_CON		0x0008
#define	S_MSE		0x0010
#define	S_TOP		0x0020
#define	S_BTM		0x0040
#define	S_LFT		0x0080
#define	S_RGT		0x0100
#define	S_VCR		0x0200

					      /* STAT window command numbers */
#define	SCMDUNK		0				  /* unknown command */
#define	SCMDNUM		1				   /* number command */
#define	SCMDCRT		2				   /* create command */
#define	SCMDDEL		3				   /* delete command */
#define	SCMDMOR		4				     /* more command */
#define	SCMDHLP		5				     /* help command */
#define SCMDPRV		6				 /* previous command */
#define	SCMDNXT		7				     /* next command */

					      /* MSSG window command numbers */
#define	MCMDUNK		0				  /* unknown command */

						/* miscellaneous definitions */
#define	PIMAXM		65536			/* maxmem value for procinfo */

#define	FNUMINIT	(LONG)0		      /* init value for file numbers */

#define	ALLUSED		-1			       /* all windows in use */

#define	LTOPMAX		4		       /* max depth level for ltop[] */

#define	NXTWNDW		1		 /* value used to select next window */
#define	PRVWNDW		-1	     /* value used to select previous window */

#define	CMAXW		80		/* max. number of columns for a pcon */
#define	CMAXL		(LONG)80	/* max. number of columns for a pcon */

#define	MAXMLN		10			  /* max number of msg lines */
#define	MAXRLN		1			  /* max number of rsp lines */

#define	SAPOK		2			     /* index of attrib poke */
#define	SALEN		3			 /* length of attrib strings */

#define	NAMELEN		32			     /* max len of pcon name */

#define	VCPIPSIZ	2		    /* vcon # length for mpipe specs */
#define	PCPIPSIZ	4	       /* process pid length for mpipe specs */

#define	HLPSIZ		256		   /* max length of <HELP> info text */

#define	BYTESIZ		3		      /* size of BYTE decimal string */
#define	WORDSIZ		5		      /* size of WORD decimal string */
#define	LONGSIZ		10		      /* size of LONG decimal string */


/* table structures */

#define	SERSIZ		8	/* Size of serialization sequence	    */
#define	NAME1		10	/* Size of a name field			    */
#define	NAME2		14	/* Size of a name field			    */
#define	NAME3		18	/* Size of a name field			    */
#define	MOUSIZ		16	/* Size of mouse data and mask fields	    */
#define	BUFSIZ		128	/* Size of general buffer		    */

#define	DEFINE	struct	_define				/* for PDEF and SDEF */
DEFINE
{
	ULONG	def_lookid;
	UBYTE	def_lname[NAME1];
	UBYTE	def_prefix[BUFSIZ];
};

#define	CMDENV	struct	_cmdenv
CMDENV
{
	UBYTE	cmd_file[BUFSIZ];
	UBYTE	cmd_string[BUFSIZ];
	UBYTE	cmd_info;	/* parent env. strings here, variable length */
};

#define	CONSOLE	struct	_console
CONSOLE
{
	UWORD	cn_numkey;
	UWORD	cn_smode;
	UWORD	cn_kmode;
	UWORD	cn_currow;
	UWORD	cn_curcol;
	UWORD	cn_nrows;
	UWORD	cn_ncols;
	UBYTE	cn_vcnum;
	UBYTE	cn_type;
	UBYTE	cn_name[NAME1];
};

						 /* console smode bit values */
#define	CSM_DUMB	0x0001		 /* disable escape sequence decoding */
#define	CSM_SXB		0x0002			   /* sixteen bit characters */
#define	CSM_CRLF	0x0004			    /* convert lf's to cr/lf */
						 /* console kmode bit values */
#define	CKM_NAB		0x0001			  /* disable aborts (CTRL-C) */
#define	CKM_NSC		0x0002		     /* disable scroll (CTRLs S & Q) */
#define	CKM_NXL		0x0004				   /* no translation */
#define	CKM_ESC		0x0008		    /* Disable ESC sequence decoding */
#define	CKM_SXB		0x0010			   /* sixteen bit characters */
#define	CKM_NEC		0x0020					  /* no echo */
#define	CKM_NCZ		0x0040				     /* no control z */
#define	CKM_TOG		0x0080				/* toggle characters */
#define	CKM_CRLF	0x0100			 /* convert CR or LF to CRLF */

						  /* subset of console table */
#define	MINICON    struct _minicon
MINICON
{
    UWORD	mc_tahead;		   /* # of keys in type-ahead buffer */
    UWORD	mc_sc;					      /* Screen Mode */
    UWORD	mc_kb;					    /* Keyboard Mode */
    UWORD	mc_currow;				      /* current row */
    UWORD	mc_curcol;
};
#define MINISIZE    (LONG)sizeof(MINICON)

#define	ENVIRON	struct	_environ
ENVIRON
{
	LONG	en_stdin;
	LONG	en_stdout;
	LONG	en_stderr;
	LONG	en_overlay;
	UWORD	en_security;
	UWORD	en_rsvd;
	UBYTE	en_user;
	UBYTE	en_group;
	UWORD	en_fid;
	ULONG	en_pid;
	UWORD	en_rnid;
	UWORD	en_rfid;
	ULONG	en_rpid;
};

#define	FILENUM	struct	_filenum
FILENUM
{
	LONG	fn_filenum;
	UBYTE	fn_access;
	UBYTE	fn_table;
	UWORD	fn_rsvd;
	ULONG	fn_infosize;
	UBYTE	fn_infodata;		/* infodata here, variable length    */
};

					  /* filenum table access bit values */
#define	FNA_SET		0x0001			       /* set access allowed */
#define	FNA_EXC		0x0002			   /* execute access allowed */
#define	FNA_WRT		0x0004			     /* write access allowed */
#define	FNA_RD		0x0008			      /* read access allowed */

#define	MOUSE	struct	_mouse
MOUSE
{
	WORD	mou_row;
	WORD	mou_col;
	WORD	mou_pixrow;
	WORD	mou_pixcol;
	WORD	mou_click;
	BYTE	mou_height;
	BYTE	mou_width;
	WORD	mou_hotrow;
	WORD	mou_hotcol;
	UWORD	mou_mask[MOUSIZ];
	UWORD	mou_data[MOUSIZ];
};

#define	PCONSOLE	struct	_pconsole
PCONSOLE
{
	UBYTE	pc_name[NAME1];
	UBYTE	pc_nvc;
	UBYTE	pc_cid;
	UWORD	pc_rows;
	UWORD	pc_cols;
	UWORD	pc_crows;
	UWORD	pc_ccols;
	UBYTE	pc_flags;
	UBYTE	pc_planes;
	UBYTE	pc_attrp;
	UBYTE	pc_extp;
	UWORD	pc_country;
	UBYTE	pc_nfkeys;
	UBYTE	pc_buttons;
	ULONG	pc_serial;
};
#define PCONSIZE    (LONG)sizeof(PCONSOLE)
					   /* pconsole table flag bit values */
#define	PCF_GRP		0x0001				 /* graphics console */
#define	PCF_NNK		0x0002			      /* no numerical keypad */
#define	PCF_MSS		0x0004			   /* mouse support provided */
#define	PCF_CLR		0x0008				    /* color console */
#define PCF_MMV		0x0010			      /* Memory-mapped video */
#define PCF_CGM		0x0020		       /* Currently in Graphics Mode */
					  /* pconsole table plane bit values */
#define	PCP_CHAR	0x0001			/* character plane supported */
#define	PCP_ATTR	0x0002			/* attribute plane supported */
#define	PCP_EXTN	0x0004			/* extension plane supported */

#define	PROCESS	struct	_process
PROCESS
{
	ULONG	p_pid;
	UWORD	p_fid;
	UBYTE	p_cid;
	UBYTE	p_vcid;
	UBYTE	p_name[NAME1];
	UBYTE	p_state;
	UBYTE	p_prior;
	ULONG	p_maxmem;
	UWORD	p_flags;
	UBYTE	p_cuser;
	UBYTE	p_cgroup;
	ULONG	p_parent;
	ULONG	p_events;
	ULONG	p_code;
	ULONG	p_csize;
	ULONG	p_data;
	ULONG	p_dsize;
	ULONG	p_heap;
	ULONG	p_hsize;
};
#define PROCSIZE    (LONG)sizeof(PROCESS)
					    /* process table flag bit values */
#define	PCF_SYS		0x0001				   /* system process */
#define	PCF_LKM		0x0002				 /* locked in memory */
#define	PCF_SWI		0x0004			   /* running in SWI context */
#define	PCF_SUP		0x0008			     /* originally superuser */


#define	VCONSOLE	struct	_vconsole
VCONSOLE
{
	ULONG	vc_lookid;
	UWORD	vc_mode;
	UBYTE	vc_vcnum;
	UBYTE	vc_type;
	WORD	vc_viewrow;
	WORD	vc_viewcol;
	WORD	vc_nrow;
	WORD	vc_ncol;
	WORD	vc_posrow;
	WORD	vc_poscol;
	WORD	vc_rows;
	WORD	vc_cols;
	BYTE	vc_top;
	BYTE	vc_bottom;
	BYTE	vc_left;
	BYTE	vc_right;
};
#define VCONSIZE   (LONG)sizeof(VCONSOLE)

				    /* virtual console table mode bit values */
#define	VCM_FZB		0x0001				    /* freeze border */
#define	VCM_AVC		0x0002			   /* allow auto view change */
#define	VCM_KCE		0x0004		     /* keep cursor on edge (on AVC) */
#define	VCM_AVO		0x0008		       /* auto view change on output */
					  /* virtual console type bit values */
#define	VCT_GRP		(BYTE)0x01			    /* graphics vcon */


#define PL_NPLANE	3
#define FRAME	struct	_frame
FRAME
{
    BYTE	*fr_pl[PL_NPLANE];	/* char, attrib and extension planes */
    UWORD	fr_nrow;
    UWORD	fr_ncol;
    UWORD	fr_use;
};

#define PL_USE0		0x01			       /* Plane 0 usage mask */
#define PL_USE1		0x02			       /* Plane 1 usage mask */
#define PL_USE2		0x04			       /* Plane 2 usage mask */
#define PL_USEALL	0x07			    /* All Planes usage mask */

#define PL_CHAR		0		     /* Character Plane Index, Shift */
#define PL_ATTR		1		     /* Attribute Place Index, Shift */
#define PL_EXTN		2		     /* Extension Plane Index, Shift */


#define RECT	struct	_rect
RECT
{
    WORD	r_row;
    WORD	r_col;
    WORD	r_nrow;
    WORD	r_ncol;
};
						/* command process info	     */
#define	PINFO		struct	_pinfo
PINFO
{
	BYTE	pi_pname[NAME1];
	BYTE	pi_prior;
	BYTE	pi_rsvd1;
	LONG	pi_maxm;
	LONG	pi_addm;
};


#define	SMO_XPND	0x0000			     /* options for S_MALLOC */
#define	SMO_NEW		0x0001
				      /* memory parameter block for S_MALLOC */
#define	MPB	struct	_mpb
MPB
{
	ULONG	mpb_start;
	ULONG	mpb_minact;
	ULONG	mpb_max;
};

						  /* alterbyte array indexes */
#define	ALB_CAND	0
#define	ALB_CXOR	1
#define	ALB_AAND	2
#define	ALB_AXOR	3
#define	ALB_EAND	4
#define	ALB_EXOR	5

/* Window Manager Specific structure definitions */

#define	MPHDR	struct	_mphdr		 /* structure of message pipe header */
MPHDR
{
    UWORD	mp_msgsiz;				  /* size of message */
    LONG	mp_pid;					    /* pid of sender */
    BOOLEAN	mp_rspflg;	       /* response flag (TRUE = rsp wanted ) */
    UBYTE	mp_rspname[NAME1];		    /* name of response pipe */
};
#define MSGPSIZE    (LONG)sizeof(MPHDR)

#define	MPIPE	struct	_mpipe
MPIPE
{
    UWORD	mpi_msgsiz;				  /* size of message */
    LONG	mpi_pid;				    /* pid of sender */
    BOOLEAN	mpi_rspflg;	       /* response flag (TRUE = rsp wanted ) */
    UBYTE	mpi_rspname[NAME1];		    /* name of response pipe */
    UBYTE	mpi_msgbuf[HLPSIZ];		      /* buffer for messages */
};
#define PIPESIZE    (LONG)sizeof(MPIPE)

#define WNDWDESC	struct _wndwdesc
WNDWDESC
{
    UWORD	wd_rmin;		    /* minimum number of rows needed */
    UWORD	wd_cmin;		 /* minimum number of columns needed */
    UWORD	wd_rmax;	 /* maximum number of rows (0 = screen size) */
    UWORD	wd_cmax;      /* maximum number of columns (0 = screen size) */
    UWORD	wd_rorg;				       /* row origin */
    UWORD	wd_corg;				    /* column origin */
    UBYTE	wd_flags;			/* see flag bit values above */
    UBYTE	wd_wfill;		/* character filler value for window */
    UBYTE	wd_tfill;		  /* character filler for top border */
    UBYTE	wd_bfill;	       /* character filler for bottom border */
    UBYTE	wd_lfill;		 /* character filler for left border */
    UBYTE	wd_rfill;		/* character filler for right border */
    UBYTE	wd_wattr;		      /* attribute filler for window */
    UBYTE	wd_battr;		     /* attribute filler for borders */
    UBYTE	*wd_tbhdr;			 /* ptr to top border header */
    UBYTE	*wd_cmdline;		      /* ptr to shell's command line */
};

				  /* special items for mssg and stat windows */
#define	WNDWSPEC	struct _wndwspec
WNDWSPEC
{
    UWORD	ws_numhdr;	    /* count of window header array elements */
    UBYTE	**ws_whdr;	/* ptr to array of ubyte ptrs to header text */
    UWORD	ws_mininfo;		     /* minimum number of info lines */
    UWORD	ws_actinfo;		     /* actual info lines being used */
    UBYTE	*ws_inftxt;	      /* pointer to info text formatter line */
    UWORD	ws_nummore;			     /* number of more lines */
    UBYTE	**ws_mrtxt;	  /* ptr to array of ubyte ptrs to more text */
    UWORD	ws_numpmpt;			   /* number of prompt lines */
    UBYTE	**ws_pmtxt;    /* ptr to array of ubyte ptrs to prompt lines */
    UWORD	ws_numhelp;			     /* number of help lines */
    UBYTE	**ws_hptxt;	 /* ptr to array of ubyte ptrs to help lines */
    UBYTE	**ws_cptxt;	/* ptr to array of ubyte ptrs to CMD prompts */
    UBYTE	**ws_chtxt;   /* ptr to array of ubyte ptrs to CMD help info */
};

#define	WVARS	struct	_wvars
WVARS
{
    UWORD	wv_flags;					    /* flags */
    LONG	wv_pid;				    /* process id of "shell" */
    UWORD	wv_fid;			     /* process family id of "shell" */
    LONG	wv_vnum;			 /* file number for vconsole */
    LONG	wv_cnum;			  /* file number for console */
    LONG	wv_tnum;		 /* file number for top border FRAME */
    LONG	wv_bnum;		 /* file number for btm border FRAME */
    LONG	wv_lnum;		 /* file number for lft border FRAME */
    LONG	wv_rnum;		 /* file number for rgt border FRAME */
    LONG	wv_pnum;			/* file number for MSSG pipe */
    RECT	wv_rwndw;				      /* window RECT */
    RECT	wv_rtbb;			      /* top/btm border RECT */
    RECT	wv_rlrb;			      /* lft/rgt border RECT */
    FRAME	wv_ftop;				 /* top border FRAME */
    FRAME	wv_fbtm;				 /* btm border FRAME */
    FRAME	wv_flft;				 /* lft border FRAME */
    FRAME	wv_frgt;				 /* rgt border FRAME */
    MPHDR	wv_mph;				 /* MSSG pipe message header */
    VCONSOLE	wv_vct;				       /* VCONSOLE structure */
    WNDWDESC	*wv_wdp;		    /* pointer to WNDWDESC structure */
};

					     /* standard device file numbers */
#define	STDIN		(LONG)0
#define	STDOUT		(LONG)1
#define	STDERR		(LONG)2
							    /* file security */

#define	FS_OD	0x0001		/* owner delete/set			     */
#define	FS_OE	0x0002		/* owner execute			     */
#define	FS_OW	0x0004		/* owner write				     */
#define	FS_OR	0x0008		/* owner read				     */
#define	FS_GD	0x0010		/* group delete/set			     */
#define	FS_GE	0x0020		/* group execute			     */
#define	FS_GW	0x0040		/* group write				     */
#define	FS_GR	0x0080		/* group read				     */
#define	FS_WD	0x0100		/* world delete/set			     */
#define	FS_WE	0x0200		/* world execute			     */
#define	FS_WW	0x0400		/* world write				     */
#define	FS_WR	0x0800		/* world read				     */

#define	ORD_BTM		0		   /* value used to ORDER btm window */
#define	ORD_TOP		-1		   /* value used to ORDER top window */

#define	SHLPRI		200		       /* process priority for SHELL */

/* */
