#include	"portab.h"

/*
   cc05xx series messages: These messages are intended to report most DOS
	related errors. This series may require use of the entire parmptr
	block. The basic message is cc0500. The following shows the use of
	the parmptr inserts:

	%0 = module name.
	%1 = device name.
	%2 = filename (if any).
	%3 = area name (if any), generally one of the cc057x series.
	%4 = may be used for extra help information.
	%5 = operation name, generally one of the cc051x/cc052x series.
	%6 = operation name, generally one of the cc053x/cc054x series.
	%7 = device/file/area string, generally of the cc055x series.
	%8 = level 3 help basic message, generally the cc0500[1] message.
	%9 = level 3 help message, generally one of the cc046x series.

	Example message for an S_WRITE that returns an E_SPACE error:

	%0 = "COPY"
	%1 = "a:"
	%2 = "testfile.txt"
	%3 = nullstr (not used).
	%4 = "\r\nYou can erase unneccessary files from your disk to
	      free up space." (cc0490).
	%5 = "WRITE" (cc0526).
	%6 = "WRITING" (cc0546).
	%7 = "%2 on %1" (cc0551).
	%8 = "\r\n%0: An error occurred %6 %7." (cc0500[1]).
	%9 = "\r\nThe disk %1 is full." (cc0461).

	HELPLVL 4:
	    COPY: An error occurred WRITING testfile.txt to a:.
	    The disk a: is full.
	    You can erase unneccessary files from your disk to free up space.

	HELPLVL 3:
	    COPY: An error occurred WRITING testfile.txt to a:.

	HELPLVL 2:
	    COPY: WRITE error.

	HELPLVL 1:
	    This level is reserved by the ERRMSG routine to provide
	    information such as RETURN CODE, ERROR SOURCE and FlexOS
	    FUNCTION. An example is shown below.

		Return code: -2145369344.
		Error source: DISKMAN.
		FlexOS function: F_WRITE.

*/
						     /* basic message format */
BYTE	*cc0500[] = {
	"\r\n%0: %5 error.",
	"\r\n%0: An error occurred %6 %7.",
	"%8%9"
	};

/* Notes on F_SPECIAL errors: */
/* All use *cc0500 as the message base. */
/* All use cc0529 for %5 */
/* F_SPECIAL(RDSYS): %3 = cc0576, %6 = cc0542, & %7 = cc0561 */
/* F_SPECIAL(WTSYS): %3 = cc0576, %6 = cc0547, & %7 = cc0561 */
/* F_SPECIAL(FMSYS): %3 = cc0576, %6 = cc0536, & %7 = cc0561 */
/* F_SPECIAL(FMTRK): %3 = cc0572, %6 = cc0536, & %7 = cc0561 */
/* F_SPECIAL(MDCHK): %3 = cc0572, %6 = cc0549, & %7 = cc0559 */

