###########################################################################
#
#   MKCNFGUT.
#
#   Make File for the configurable utilities......
#
#
#   Library Dependencies :
#			CNFGUTL.L86
#			CCMSGS.L86
#			CCRTL.L86
#			CCUTLS.L86
#			UTOOLS.L86
#
#  Naming covention / definition abbreviatons :
#
#			utl: = where util source is located.
#			       ( define utl: = d:\utils\source\ )
#
#			cmn: = where system common source is located.
#			       ( define cmn: = d:\flexos\comsrc\ )
#
#			system: = system directory
#			       ( defined in config.bat )
#
#                	ipath = utl:;cmn:;
#
#############################################################################

STARTUP = utstart.obj
CCMSGS  = ccmsgs.l86
CCRTL   = ccrtl.l86
CCUTLS  = ccutls.l86
UTOOLS  = utools.l86
CNFGLIB = cnfglib.l86
COMMON  = $STARTUP $CCMSGS $CCRTL $CCUTLS $UTOOLS

exec.286 :	utstart.obj utstart1.obj \
		wmex.286 format.286 sys.286 fdisk.286

##
## WMEX
##
wmex.286 :	wmex.inp wmex.obj wmutls.obj wmexmsg.obj \
		$COMMON
 link wmex[i]
 postlink wmex.286

wmex.obj:	wmex.c portab.h cmn:flags.h wmchar.h wmos.h \
		ccutls.h utlerrs.h wmex.h
 hc wmex -pro util.pro

wmutls.obj:	wmutls.c portab.h cmn:flags.h wmchar.h wmos.h \
		ccutls.h utlerrs.h wmex.h
 hc wmutls -pro util.pro

wmexmsg.obj:	wmexmsg.c portab.h wmos.h wmex.h
 hc wmexmsg -pro util.pro

##
## UTSTART - 	COMPACT model start up assembler module for WMEX.
##
utstart.obj :	utstart.a86
 rasm86 utstart $$pzsznc 286

##
## UTSTART1 - 	BIG model start up assembler module for FORMAT, SYS AND FDISK
##
utstart1.obj :	utstart1.a86
 rasm86 utstart1 $$pzsznc 286

##
## FORMAT
##
format.286 :	format.inp format.obj fmtlib.obj fmutls.obj \
		fmerhand.obj fmtmsgs.obj setfip.obj \
		trnfrsys.obj boot.obj hdboot.obj \
		$CNFGLIB
 link format[i]
 postlink format.286

format.obj:	format.c portab.h concur.h ccutls.h format.h
 hc format -pro cnfgutl.pro

fmtlib.obj:	fmtlib.c portab.h concur.h format.h
 hc fmtlib -pro cnfgutl.pro

fmutls.obj:	fmutls.c portab.h concur.h ccutls.h format.h
 hc fmutls -pro cnfgutl.pro

fmerhand.obj:	fmerhand.c portab.h concur.h ccutls.h \
		format.h
 hc fmerhand -pro cnfgutl.pro

fmtmsgs.obj:	fmtmsgs.c portab.h concur.h
 hc fmtmsgs -pro cnfgutl.pro

##
## FDISK
##
fdisk.286 :	fdisk.inp fdisk.obj fdutls.obj fdmsgs.obj setfip.obj \
		boot.obj hdboot.obj \
		$CNFGLIB
 link fdisk[i]
 postlink fdisk.286

fdisk.obj:	fdisk.c portab.h concur.h ccutls.h fdisk.h
 hc fdisk -pro cnfgutl.pro

fdutls.obj:	fdutls.c portab.h concur.h ccutls.h fdisk.h
 hc fdutls -pro cnfgutl.pro

fdmsgs.obj:	fdmsgs.c portab.h
 hc fdmsgs -pro cnfgutl.pro

##
## SYS
##
sys.286 :	sys.inp sys.obj sysmsgs.obj boot.obj trnfrsys.obj \
		$CNFGLIB
 link sys[i]
 postlink sys.286

sys.obj:	sys.c portab.h concur.h ccutls.h sysut.h
 hc sys -pro cnfgutl.pro

sysmsgs.obj :	sysmsgs.c portab.h
 hc sysmsgs -pro cnfgutl.pro

##
## COMMON CNFG UTL MODULES
##
setfip.obj:	setfip.c portab.h concur.h
 hc setfip -pro cnfgutl.pro

trnfrsys.obj :	trnfrsys.c portab.h concur.h ccutls.h
 hc trnfrsys -pro cnfgutl.pro

boot.obj :	boot.a86
 rasm86 boot $$pzsznc 286

hdboot.obj :	hdboot.a86
 rasm86 hdboot $$pzsznc 286

