/*****************************************************************
 * "Copyright (C) 1985, Digital Research, Inc.  All Rights       *
 * Reserved.  The Software Code contained in this listing is     *
 * proprietary to Digital Research Inc., Monterey, California    *
 * and is covered by U.S. and other copyright protection.        *
 * Unauthorized copying, adaptation, distribution, use or        *
 * display is prohibited and may be subject to civil and         *
 * criminal penalties.  Disclosure to others is prohibited.  For *
 * the terms and conditions of software code use refer to the    *
 * appropriate Digital Research License Agreement."              *
 *****************************************************************/

/*===============================================================*
 *   Version 1.3        FDISK.C					 *
 *                      Hard disk partitioning utility.		 *
 *---------------------------------------------------------------*
 *    VERSION   DATE    BY      CHANGE/COMMENTS                  *
 *---------------------------------------------------------------*
 *      1.3   03/17/87  ldt     Cleaned up displays, fixed 'NO'  *
 *				response on delete partition.    *
 *				Added exit option to menu items  *
 *	1.2   08/06/86  ldt	HC port				 *
 *	1.1   08/06/85	jsr	Added DOSERR, CRLF and UTERM.	 *
 *	1.0   04/11/85	jsr					 *
 *                                                               *
 *===============================================================*/

/*									     */
/* NOTE: This version should be updated to provide the feature of checking   */
/* the start of any partition to be created to verify that the media is	     */
/* readable within system bounds (ie; boot record, FATS, directory and	     */
/* system image area). If an error is found here, either the user should be  */
/* warned of the situation or else the partition should be automatically     */
/* moved down (and shortened ?) in order to protect the non-tolerant boot    */
/* boot routine. How to pick a system image size is debatable. One method    */
/* would be a hard-wired constant set on each issuance of an OS update.	     */
/* Another would be to check "boot:FLEXOS.SYS" for it's size and use this	     */
/* value.								     */
/*									     */

/* include some header files */
#include	"portab.h"
#include	"concur.h"
#include	"ccutls.h"
#include	"fdisk.h"

/* declare local (global) variables */
BYTE	defbuf[2];			  /* Saved input from mainmenu entry */
BYTE	fdpartcnt;				      /* count of partitions */
BYTE	fdcdev[DEVMAX];				   /* name of current device */
BYTE	fdudev[DEVMAX];				/* unavailable device's name */
BYTE	*fdbufptr;			/* ptr to MBPR and BOOT image buffer */
WORD	fdesclvl;				 /* escape level state count */
WORD	fdcommand;				  /* selected command number */
WORD	fdtotcyl;	       /* total number of cylinders on physical disk */
WORD	fddelims[3];				/* S_RDELIM input delimiters */
BOOLEAN	fdchange;			    /* set if MBPR changed (written) */
BOOLEAN	fddevopen;					 /* device open flag */
BOOLEAN	fdmulti;			/* set if multiple fixed disks found */
BOOLEAN	fdpexist[MAXPARTS];			/* partition existance flags */
BOOLEAN	fdfulsrch;				    /* full search loop flag */
BOOLEAN	fddevunav;				   /* dev found, but unavail */
BOOLEAN	fdpartflg;				  /* set if partitioned disk */
BOOLEAN	fdnoinfo;			       /* set if no FMTINFO for disk */
LONG	fdfnum;					       /* device file number */
LONG	fdlookey;					/* lookup search key */
LONG	fdbufsiz;				/* size of fdbufptr's buffer */
LONG	fdbsiz;					       /* size of boot image */
LONG	fdmsiz;				     /* size of hidden sectors image */
DISK	fddsktbl;			    /* disk device information table */
MBPR	*fdmbprptr;		         /* master boot partition record ptr */
BOOTREC	*fdbootptr;					  /* boot record ptr */
MCB	fdmcb;					    /* message control block */
FMTINFO	*fdfmtptr;			     /* pointer to FMTINFO structure */
jumpbuff	fdjmpbuf;		/* error abort control transfer info */

/* cast local procedures */
VOID	fdmainmenu(), fdpcreate(), fdpchange(), fdpdelete();
VOID	fdpdisply(), fddselect();

/* from FDMSGS.C */
EXTERN  BYTE	*fdm0040[], fdm0041[], fdm0042[], fdm0043[];
EXTERN	BYTE	fdm0044[];
EXTERN	BYTE	fdm0050[], fdm0052[], fdm0053[];
EXTERN	BYTE	fdm0054[], fdm0055[], fdm0056[], fdm0057[];
EXTERN	BYTE	fdm0059[];
EXTERN	BYTE	fdm0060[], fdm0061[], fdm0062[], fdm0063[];
EXTERN	BYTE	fdm0064[], fdm0065[];
EXTERN	BYTE	fdm0071[], fdm0073[], fdm0074[], fdm0076[];
EXTERN	BYTE	fdm0087[], fdm0088[];
EXTERN	BYTE	fdm0090[], fdm0092[];
EXTERN	BYTE	fdm0096[], fdm0097[];

/* from FDUTLS.C */
EXTERN	BOOLEAN	fdchknum();
EXTERN	VOID	fdinit(), fdfindsk(), fdcntp();
EXTERN	VOID	fdsortps(), fdfindgaps(), fdmakep();
EXTERN	VOID	fdwtmbpr();
EXTERN	VOID	fddisparts(), fdprnhdr(), fdgetinp();
EXTERN	VOID	fdwarnack();
EXTERN	VOID	fdterminate();
EXTERN	VOID	fderrhand();

/* from CCUTLS.L86 */
EXTERN	BYTE	*utui2ds(), *utskpzro();
EXTERN	WORD	utds2i();
EXTERN	LONG	utprnmsg(), utslen();
EXTERN	VOID	uterrmsg();
EXTERN	LONG	utstjmp();

/* from UTOOLS.L86 */
EXTERN	VOID	xcls();

/* from CCRTL.L86 */
EXTERN	LONG	e_termevent();
EXTERN	LONG	s_close(), s_mfree(), s_write();

/* from CCMSGS.L86 */
EXTERN	BYTE	numconv[], nullstr[], yestxt[], notxt[];
EXTERN	BYTE	crlfmsg[], nextline[], bell[];

/* start of code */
LONG utlmain()
{
    e_termevent(fdterminate,(LONG)0);

    if((fdmcb.retcode = utstjmp(fdjmpbuf)) != 0)  /* set up error abort info */
    {
	uterrmsg(&fdmcb, STDERR, FATAL);	 /* print exit error message */
	goto fdexit;					  /* abort from here */
    }

    defbuf[0] = numconv[1];
    defbuf[1] = NULL;
    fdinit();					  /* initialize this program */
    while(fdesclvl > ESCLVL0)		  /* while the program is active ... */
    {
	while(fdesclvl == ESCLVL1)	   /* while at "main menu" level ... */
	{
	    xcls(STDOUT);
	    fdmainmenu();		/* display main menu and get command */
	    while(fdesclvl == ESCLVL2)	     /* while at "command level" ... */
	    {
		xcls(STDOUT);
		switch(fdcommand)	    /* go perform the chosen command */
		{
		    case FINISHED:
			fdesclvl = ESCLVL0;	   /* Escape from "main menu" */ 
			break;

		    case CREATE:
			fdpcreate();		       /* create a partition */
			break;

		    case ACTIVATE:
			fdpchange();	     /* change active boot partition */
			break;

		    case DELETE:
			fdpdelete();		       /* delete a partition */
			break;

		    case DISPLAY:
			fdpdisply();		   /* display partition info */
			break;

		    case SELECT:
			fddselect();		      /* select another disk */
			break;

		    default:
			fdmcb.pptr[PARM5] = nullstr;
			fderrhand(FDERR008, 0, (UR_SOURCE|UR_INTERNAL));
			break;
		}				    /* end of command switch */
	    }				/* end of "command level " (ESCLVL2) */
	    fdcommand = MAINMENU;
	}			       /* end of "main menu" level (ESCLVL1) */
    }				  /* end of "program active" level (ESCLVL0) */

    fdmcb.retcode = SUCCESS;			/* successful exit from here */

fdexit:

    if(fdchange)				/* if an MBPR was written ...*/
    {
	fdmcb.pptr[PARM5] = bell;
	utprnmsg(fdm0088, fdmcb.pptr, STDOUT);		   /* warn to reboot */
    }
    if(fddevopen)
    {
	s_close(0, fdfnum);			/* close device if left open */
	fddevopen = FALSE;
    }

    s_mfree((LONG)fdbufptr);		/* free up any buffer, ignore errors */

    s_write(WRF_END, STDOUT, (LONG)crlfmsg, utslen(crlfmsg), (LONG)0);

    if(fdmcb.retcode < 0)
	fdmcb.retcode = (UR_SOURCE | UR_DOSERR);

    return(fdmcb.retcode);		       /* return exit code from here */
}

/* local procedures */

/* fdmainmenu() : print main menu, and get command selection		     */
/* Sets the globals "fdesclvl", "fdcommand" and "fdmcb" 		     */
/* Accesses the global "fdmulti"					     */

VOID fdmainmenu()
{

    BYTE	buf1[2], buf2[2];
    WORD	i, numopts;

    fdprnhdr(fdcommand);			    /* show main menu header */
    utprnmsg(fdm0041, fdmcb.pptr, STDOUT);		    /* Choose prompt */

    buf1[1] = NULL;
    fdmcb.pptr[PARM5] = fdm0043;
    fdmcb.pptr[PARM6] = buf1;

    numopts = (fdmulti) ? 6 : 5;		  /* set numopts per fdmulti */
    for(i = 1; i <= numopts; ++i)
    {
	buf1[0] = numconv[i];
	utprnmsg(fdm0040[i], fdmcb.pptr, STDOUT);	       /* print menu */
    }

    buf1[0] = defbuf[0];
    do							    /* input do loop */
    {
	utprnmsg(fdm0042, fdmcb.pptr, STDOUT);		     /* print prompt */
	fdgetinp(buf1, buf2, 1);				/* get input */

	if(fdesclvl <= ESCLVL0)
	    break;	    /* exit "input do loop" if "main menu" level ESC */

	for(i = 1; i <= numopts; ++i)		  /* check if input is valid */
	    if(buf2[0] == numconv[i]) {
		defbuf[0] = buf2[0];
		break;			    /* for loop break if match found */
	    }

	if(i > numopts)				  /* if input is invalid ... */
	{
	    buf2[0] = numconv[numopts];
	    buf2[1] = NULL;
	    fdmcb.pptr[PARM5] = buf2;
	    fdmcb.pptr[PARM6] = bell;
	    utprnmsg(fdm0044, fdmcb.pptr, STDOUT);		/* help user */
	}

    } while(i > numopts);    /* reprompt and input while answers are invalid */

    if(fdesclvl == ESCLVL1)		 /* if "main menu" level not aborted */
    {
	fdcommand = i;				     /* set selected command */
	fdesclvl = ESCLVL2;			   /* set "command" fdesclvl */
    }
}						/* exit of "main menu" level */

/* fdpcreate() : create a partition					     */
/* Sets global "fdmcb" and accesses globals "fdesclvl", "fdcommand" and	     */
/* "fdtotcyl".								     */
VOID fdpcreate()
{
    BYTE	buf[2], buf1[LBUFSIZ], buf2[LBUFSIZ];
    BYTE	buf3[5], buf4[LBUFSIZ], buf5[LBUFSIZ];
    BYTE	*ptr1, *ptr2;
    WORD	i, start, size;
    WORD	pi[MAXPARTS];
    BOOLEAN	bad, invalid;
    GAPINFO	gapinfo;

    while(fdesclvl >= ESCLVL2)			 /* while at "command" level */
    {
	fdprnhdr(fdcommand);			      /* show command header */
	fdmcb.pptr[PARM5] = nullstr;
	utprnmsg(nextline, fdmcb.pptr, STDOUT);
	fdmcb.pptr[PARM5] = fdm0087;
	utprnmsg(nextline, fdmcb.pptr, STDOUT);		     /* show ESC msg */

	fdcntp();
	if(!fdpartcnt)					 /* any partitions ? */
	{
	    invalid = TRUE;

	    do					    /* prompt and input loop */
	    {
		fdmcb.pptr[PARM6] = yestxt;
		fdmcb.pptr[PARM7] = notxt;
		utprnmsg(fdm0050, fdmcb.pptr, STDOUT);		   /* prompt */
		fdgetinp(yestxt, buf, 1);		 /* get user's reply */

		if(fdesclvl < ESCLVL2)
		    break;			     /* break out if aborted */

		if((buf[0] != yestxt[0]) && (buf[0] != notxt[0]))  /* help ? */
		    utprnmsg(fdm0076, fdmcb.pptr, STDOUT);/* Y/N already set */
		else
		    invalid = FALSE;		     /* valid entry accepted */

	    } while(invalid);		      /* retry until answer is valid */

	    if(buf[0] == yestxt[0])			 /* if reply = Y ... */
	    {
		fdmakep(0, 0, fdtotcyl, PARTACTIVE);   /* make the partition */
		buf[0] = numconv[1];
		buf[1] = NULL;
		fdwarnack(fdm0064,buf,fdm0096);			 /* feedback */
		fdesclvl = ESCLVL0;		 /* exit all the way out !!! */
	    }


	    if(fdesclvl < ESCLVL2)
		continue;		     /* break out if aborted or done */
	}

	fddisparts();		/* display partitions and set fdpexist array */

	if(fdpartcnt == MAXPARTS)		/* if MAXPARTS already exist */
	{
		utprnmsg(fdm0059, fdmcb.pptr, STDOUT);
/* LT */        fdgetinp(nullstr, buf, 1);	 	/* get user's reply */
		xcls(STDOUT);
		continue;
	}

	if(fdpartcnt)			      /* if any partition exists ... */
	{
	    fdsortps(pi);			     /* sort parts by relsec */
	    fdfindgaps(&gapinfo, pi);		     /* set up gap structure */
	}

	else
	{
	    for(i = 0; i < MAXPARTS; ++i)
	    {
		pi[i] = i;
		gapinfo.gapstart[i] = 0;
		gapinfo.gapsize[i] = 0;
	    }
	    gapinfo.gapsexist = TRUE;
	    gapinfo.largeindex = MAXPARTS;
	    gapinfo.gapstart[MAXPARTS] = 0;
	    gapinfo.gapsize[MAXPARTS] = fdtotcyl;
	}

	if(!gapinfo.gapsexist)				 /* if no gaps exist */
	{
	    utprnmsg(fdm0057, fdmcb.pptr, STDOUT);
/* LT */    fdgetinp(nullstr, buf, 1);			 /* get user's reply */
	    xcls(STDOUT);
	    continue;
	}

	ptr1 = utskpzro(utui2ds(gapinfo.gapsize[gapinfo.largeindex],buf1));
	ptr2 = utskpzro(utui2ds(gapinfo.gapstart[gapinfo.largeindex],buf2));

	fdmcb.pptr[PARM5] = ptr1;
	fdmcb.pptr[PARM6] = fdm0056;
	fdmcb.pptr[PARM7] = ptr2;
	utprnmsg(fdm0052, fdmcb.pptr, STDOUT);

	bad = TRUE;
	do
	{
	    invalid = TRUE;

	    do
	    {
		utprnmsg(fdm0053, fdmcb.pptr, STDOUT);		/* size pmpt */
		fdgetinp(ptr1, buf3, 4);

		if(fdesclvl < ESCLVL2)
		    break;			     /* break out if aborted */

		size = utds2i(buf3);

		if((!fdchknum(buf3)) || (size < 1))	    /* invalid entry */
		{
		    buf[0] = numconv[1];
		    buf[1] = NULL;
		    fdmcb.pptr[PARM5] = buf;
		    fdmcb.pptr[PARM6] = ptr1;
		    utprnmsg(fdm0065, fdmcb.pptr, STDOUT);
		    continue;			      /* help, then reprompt */
		}

		if(size > gapinfo.gapsize[gapinfo.largeindex])
		{
		    fdmcb.pptr[PARM5] = utskpzro(utui2ds(size, buf4));
		    fdmcb.pptr[PARM6] = nullstr;
		    utprnmsg(fdm0055, fdmcb.pptr, STDOUT);
		    buf[0] = numconv[1];
		    buf[1] = NULL;
		    fdmcb.pptr[PARM5] = buf;
		    fdmcb.pptr[PARM6] = ptr1;
		    utprnmsg(fdm0065, fdmcb.pptr, STDOUT);
		    continue;	     /* not enough room, help, then reprompt */
		}

		invalid = FALSE;		 /* size seems okay (so far) */

	    } while(invalid);

	    if(fdesclvl < ESCLVL2)
		break;				     /* break out if aborted */

	    invalid = TRUE;
	    do
	    {
		utprnmsg(fdm0054, fdmcb.pptr, STDOUT);		/* startpmpt */
		fdgetinp(ptr2, buf3, 4);

		if(fdesclvl < ESCLVL2)
		    break;			     /* break out if aborted */

		start = utds2i(buf3);

		if((!fdchknum(buf3)) || (start < 0))	    /* invalid entry */
		{
		    buf[0] = numconv[0];
		    buf[1] = NULL;
		    fdmcb.pptr[PARM5] = buf;
		    fdmcb.pptr[PARM6] =
		      utskpzro(utui2ds((fdtotcyl - 1), buf4));
		    utprnmsg(fdm0065, fdmcb.pptr, STDOUT);
		    continue;			      /* help, then reprompt */
		}

		invalid = FALSE;
		for(i = MAXPARTS; i >= 0; --i)		   /* check all gaps */
		{
		    if(start >= gapinfo.gapstart[i])
		    {
			if((start + size) <= (gapinfo.gapstart[i] +
			  gapinfo.gapsize[i]))
			{
			    bad = FALSE;
			    break;
			}
		    }
		}

		if(bad)
		{
		    fdmcb.pptr[PARM5] = utskpzro(utui2ds(size, buf4));
		    fdmcb.pptr[PARM6] = fdm0056;
		    fdmcb.pptr[PARM7] = utskpzro(utui2ds(start, buf5));
		    utprnmsg(fdm0055, fdmcb.pptr, STDOUT);
		}

	    } while(invalid);

	    if(fdesclvl < ESCLVL2)
		break;				     /* break out if aborted */

	} while(bad);

	if(fdesclvl < ESCLVL2)
		break;				     /* break out if aborted */

	for(i = 0; i < MAXPARTS; ++i)
	{
	    if(!fdpexist[i])			     /* find 1st empty entry */
	    {
		fdmakep(i, start, size, PARTINACT);	  /* set up MBPR.PTE */
		fdwarnack(fdm0064,utskpzro(utui2ds(i+1,buf5)),fdm0096);
		break;
	    }
	}
    }
}

/* fdpchange() : change the active boot partition */
/* Sets the global "fdmcb". Accesses the globals "fdesclvl" and "fdcommand"  */
VOID fdpchange()
{
    BYTE	buf[2];
    WORD	i, j;
    BOOLEAN	invalid;

    buf[0] = numconv[1];
    buf[1] = NULL; 
    while(fdesclvl >= ESCLVL2)		 /* while at the "command" level ... */
    {
	xcls(STDOUT);
	fdprnhdr(fdcommand);			      /* show command header */
	fdmcb.pptr[PARM5] = nullstr;
	utprnmsg(nextline, fdmcb.pptr, STDOUT);
	fdmcb.pptr[PARM5] = fdm0087;
	utprnmsg(nextline, fdmcb.pptr, STDOUT);		     /* show ESC msg */

	fddisparts();		/* display partitions and set fdpexist array */

	if(!fdpartcnt)				     /* if no partitions ... */
	{
	    fdwarnack(fdm0062, nullstr, fdm0090);
	    fdgetinp(buf, buf, 1);			 /* get user's reply */
	    continue;
	}

	invalid = TRUE;
	do
	{
	    fdmcb.pptr[PARM5] = fdm0090;
	    utprnmsg(fdm0060, fdmcb.pptr, STDOUT);	      /* show prompt */
	    fdgetinp(buf, buf, 1);			 /* get user's reply */

	    if(fdesclvl < ESCLVL2)		  /* "command" level abort ? */
		break;				    /* do loop (input) break */

	    for(i = 1; i <= MAXPARTS; ++i)	    /* check if valid answer */
	    {
		if((buf[0] == numconv[i]) && (fdpexist[i - 1]))
		{
		    invalid = FALSE;
		    break;		    /* for loop break if valid reply */
		}
	    }

	    if(i > MAXPARTS)				/* if invalid answer */
		utprnmsg(fdm0061, fdmcb.pptr, STDOUT);		/* help user */

	} while(invalid);	       /* reprompt and input for valid reply */

	if(fdesclvl >= ESCLVL2)		  /* if "command" wasn't aborted ... */
	{
	    for(j = 0; j < MAXPARTS; ++j)
		fdmbprptr->mbpr_pte[j].pte_bootind =
		  (j==(i-1)) ? PARTACTIVE : PARTINACT;

	    fdwtmbpr();					   /* write the MBPR */
	}
    }						/* exit from "command" level */
}

/* fdpdelete() : delete a partition */
/* Set the globals "fdmbprptr->" and "fdmcb" */
/* Accesses the globals "fdesclvl" and "fdcommand" */

VOID fdpdelete()
{

    BYTE	buf1[2], buf2[2];
    WORD	i, j, cnt;
    BOOLEAN	invalid;

    while(fdesclvl >= ESCLVL2)			 /* while at "command" level */
    {
	fdprnhdr(fdcommand);			      /* show command header */
	fdmcb.pptr[PARM5] = nullstr;
	utprnmsg(nextline, fdmcb.pptr, STDOUT);
	fdmcb.pptr[PARM5] = fdm0087;
	utprnmsg(nextline, fdmcb.pptr, STDOUT);		     /* show ESC msg */

	fddisparts();				      /* show partition info */

	cnt = 0;
	buf1[1] = NULL;

	for(i = 0; i < MAXPARTS; ++i)	    /* count existing DOS partitions */
	{
	    if((fdpexist[i]) &&
	      ((fdmbprptr->mbpr_pte[i].pte_sysind == DOS12B) ||
	      (fdmbprptr->mbpr_pte[i].pte_sysind == DOS16B)))
	    {
		++cnt;
		j = i;				   /* set defaults if only 1 */
		buf1[0] = numconv[i + 1];
	    }
	    else
		fdpexist[i] = FALSE;	     /* no good if not DOS partition */
	}

	if(!cnt)				  /* no DOS partitions exist */
	{
	    fdwarnack(fdm0062, fdm0071, fdm0092);
	    fdgetinp(nullstr, buf1, 1);		       /* get acknowledgment */
	    fdesclvl = ESCLVL1;			/* return to "main menu" lvl */
	    continue;
	}

	if(cnt > 1)		       /* more than one DOS partition exists */
	{
	    do				      /* prompt for partition number */
	    {
		fdmcb.pptr[PARM5] = fdm0092;
		utprnmsg(fdm0060, fdmcb.pptr, STDOUT);
		fdgetinp(nullstr, buf1, 1);		/* get partition num */

		if(fdesclvl < ESCLVL2)
		    break;			       /* break out if abort */

		for(i = 1; i <= MAXPARTS; ++i)
		{
		    if((buf1[0] == numconv[i]) && (fdpexist[i - 1]))
		    {
			j = i - 1;		 /* set index if valid entry */
			break;
		    }
		}

		if(i > MAXPARTS)		   /* if invalid partition # */
		    utprnmsg(fdm0061, fdmcb.pptr, STDOUT);	     /* help */

	    } while(i > MAXPARTS);		 /* while replys are invalid */

	    if(fdesclvl < ESCLVL2)
		continue;			     /* break out if aborted */
	}

	fdwarnack(fdm0063, buf1, fdm0097);	     /* warn which partition */

	if(fdmbprptr->mbpr_pte[j].pte_bootind == PARTACTIVE) /* warn if actv */
	{
	    fdmcb.pptr[PARM5] = buf1;			    /* set [5] again */
	    fdmcb.pptr[PARM6] = bell;
	    utprnmsg(fdm0073, fdmcb.pptr, STDOUT);
	}

	invalid = TRUE;
	do				       /* prompt for delete go ahead */
	{
	    fdmcb.pptr[PARM5] = buf1;			    /* set [5] again */
	    fdmcb.pptr[PARM6] = yestxt;
	    fdmcb.pptr[PARM7] = notxt;
	    utprnmsg(fdm0074, fdmcb.pptr, STDOUT);		   /* prompt */
	    fdgetinp(notxt, buf2, 1);				/* get input */

	    if(fdesclvl < ESCLVL2)
		break;			     /* break out if "command" abort */

	    if((buf2[0] != notxt[0]) && (buf2[0] != yestxt[0]))
		utprnmsg(fdm0076, fdmcb.pptr, STDOUT);		  /* invalid */
	    else {
		invalid = FALSE;			     /* Y or N reply */
	        if(buf2[0] == notxt[0]) /* no, do not delete, prep to leave */
		    fdesclvl = ESCLVL1;
	    }

	} while(invalid);

	if(fdesclvl < ESCLVL2)
	    continue;			    /* back another level if aborted */

	if(buf2[0] == yestxt[0])		      /* yes, delete desired */
	{
	    fdmbprptr->mbpr_pte[j].pte_bootind = PARTINACT;/* clear this pte */
	    fdmbprptr->mbpr_pte[j].pte_shead = 0;
	    fdmbprptr->mbpr_pte[j].pte_ssector = 0;
	    fdmbprptr->mbpr_pte[j].pte_scylinder = 0;
	    fdmbprptr->mbpr_pte[j].pte_sysind = UNKSYS;
	    fdmbprptr->mbpr_pte[j].pte_ehead = 0;
	    fdmbprptr->mbpr_pte[j].pte_esector = 0;
	    fdmbprptr->mbpr_pte[j].pte_ecylinder = 0;
	    fdmbprptr->mbpr_pte[j].pte_relsec = 0;
	    fdmbprptr->mbpr_pte[j].pte_nsecs = 0;

	    fdwtmbpr();					   /* write the MBPR */

	    fdwarnack(fdm0064, buf1, fdm0097);			 /* feedback */
	}
    }
}

/* fdpdisply() : display partition information */
/* Accesses the globals "fdesclvl" and "fdcommand" */

VOID fdpdisply()
{

    BYTE	buf[2];

    fdprnhdr(fdcommand);			      /* show command header */

    fddisparts();				   /* display partition info */

    while(fdesclvl >= ESCLVL2)				     /* wait for ESC */
    {
	utprnmsg(fdm0087, fdmcb.pptr, STDOUT);
	fdgetinp(nullstr, buf, 1);
    }
}

/* fddselect() : select another fixed disk for operation */
/* Accesses the globals "fdesclvl" and "fdcommand" */

VOID fddselect()
{
    fdprnhdr(fdcommand);			      /* show command header */

    fdfindsk();						  /* get "next" disk */

    fdesclvl = ESCLVL1;			       /* go back to main menu level */
}

/* */	
