/*****************************************************************
 * "Copyright (C) 1985, Digital Research, Inc.  All Rights       *
 * Reserved.  The Software Code contained in this listing is     *
 * proprietary to Digital Research Inc., Monterey, California    *
 * and is covered by U.S. and other copyright protection.        *
 * Unauthorized copying, adaptation, distribution, use or        *
 * display is prohibited and may be subject to civil and         *
 * criminal penalties.  Disclosure to others is prohibited.  For *
 * the terms and conditions of software code use refer to the    *
 * appropriate Digital Research License Agreement."              *
 *****************************************************************/

/*===============================================================*
 *   Version 1.3        FDISK.H					 *
 *                      Definition header file for FDISK.C.	 *
 *---------------------------------------------------------------*
 *    VERSION   DATE    BY      CHANGE/COMMENTS                  *
 *---------------------------------------------------------------*
 *                                                               *
 *      1.3   07/16/87  KPB     Added SIXTY_MEG                  *
 *      1.2   03/17/87  ldt	Added FINISHED			 *
 *	1.1   08/06/85	jsr	Added FDERR018 and FDERR019.	 *
 *	1.0   04/11/85	jsr					 *
 *                                                               *
 *===============================================================*/

/* define some things */

#define	TEST		FALSE			/* compile test code if TRUE */

#define	ESCLVL0		0				     /* exit program */
#define	ESCLVL1		1				  /* main menu level */
#define	ESCLVL2		2				    /* command level */

							    /* command codes */
#define	MAINMENU	0
#define FINISHED	1
#define	CREATE		2
#define	ACTIVATE	3
#define	DELETE		4
#define	DISPLAY		5
#define	SELECT		6

				    /* values for logical fixed disk formats */
#define	FXDSKDIR	0x0200			    /* number of DIR entries */
#define	FXDSKSEC	0x7fa8	   /* nsecs at which FATsize and SPB changes */
#define SIXTY_MEG_LIMIT 0x1d164     /* big disk supposrt */
#define	SPB1		0x0008			/* SPB value for small disks */
#define	SPB2		0x0004			/* SPB value for large disks */
#define SPB3            0x0016                  /* SPB value for larger disks*/
						       /* error return codes */
#define	FDERR000	0		/* no error			     */
#define	FDERR001	1		/* no device found		     */
#define	FDERR002	2		/* device unavail, open conflict     */
#define	FDERR003	3		/* device unavail, partitioned	     */
#define	FDERR004	4		/* device unavail, no FMTINFO	     */
#define	FDERR005	5		/* sector size too large	     */
#define	FDERR006	6		/* max>BUFSIZ or def>max getinput()  */
#define	FDERR007	7		/* number too large, fixnum() conv.  */
#define	FDERR008	8		/* invalid command at switch	     */
#define	FDERR009	9		/* S_GET error on DISK_INFO table    */
#define	FDERR010	10		/* S_LOOKUP error on DEV_INFO table  */
#define	FDERR011	11		/* S_OPEN error (non-conflict)	     */
#define	FDERR012	12		/* S_RDELIM error of STDIN	     */
#define	FDERR013	13		/* S_READ error of MBPR		     */
#define	FDERR014	14		/* S_WRITE error of MBPR	     */
#define	FDERR015	15		/* S_WRITE error of BOOTREC	     */
#define	FDERR016	16		/* S_MALLOC error		     */
#define	FDERR017	17		/* S_MFREE error		     */
#define	FDERR018	18		/* User terminate		     */
#define	FDERR019	19		/* Process terminate		     */

#define	GAPINFO	struct	_gapinfo		/* gap information structure */
GAPINFO
{
	BOOLEAN		gapsexist;
	WORD		largeindex;
	WORD		gapstart[MAXPARTS + 1];
	WORD		gapsize[MAXPARTS + 1];
};

