/*****************************************************************
 * "Copyright (C) 1985, Digital Research, Inc.  All Rights       *
 * Reserved.  The Software Code contained in this listing is     *
 * proprietary to Digital Research Inc., Monterey, California    *
 * and is covered by U.S. and other copyright protection.        *
 * Unauthorized copying, adaptation, distribution, use or        *
 * display is prohibited and may be subject to civil and         *
 * criminal penalties.  Disclosure to others is prohibited.  For *
 * the terms and conditions of software code use refer to the    *
 * appropriate Digital Research License Agreement."              *
 *****************************************************************/

/*===============================================================*
 *   Version 1.2        FMERHAND.C				 *
 *                      Error handling procedures for FORMAT.	 *
 *---------------------------------------------------------------*
 *    VERSION   DATE    BY      CHANGE/COMMENTS                  *
 *---------------------------------------------------------------*
 *                                                               *
 *	1.2    5/09/86	DR-K	modified for MetaWare compiler	 *
 *	1.1   08/01/85	jsr	Added user terminate errors,	 *
 *				changed FMERR017 to return UTERM *
 *				not INTERNAL, added RDSYS error. *
 *	1.0   04/10/85	jsr					 *
 *                                                               *
 *===============================================================*/

/* include some header files */

#include	"portab.h"
#include	"concur.h"
#include	"ccutls.h"
#include	"format.h"

/* declare local procedures */

VOID	fmcriterr(), fmcritarea();
VOID	fmxfmap(), fmpdmap();
VOID	fmerhand();

/* declare external variables */
						    /* globals from FORMAT.C */
EXTERN	FMTINFO		*fmtptr;
EXTERN	DISK		fmdtbl;
EXTERN	MCB		fmmcb;
EXTERN	jumpbuff	fmjbuf;
						      /* text from FMTMSGS.C */
EXTERN	BYTE	*fm0030[], *fm0031[], *fm0032[];
EXTERN	BYTE	fm0050[];

						     /* text from CCMSGS.L86 */
EXTERN	BYTE	stdiname[], nullstr[], *nullmsg[];
EXTERN	BYTE	*cc0415[], *cc0416[];
EXTERN	BYTE	*cc0430[];
EXTERN	BYTE	cc0440[], cc0441[], cc0443[];
EXTERN	BYTE	cc0450[], cc0455[];
EXTERN	BYTE	cc0561[];
EXTERN	BYTE	cc0570[], cc0571[], cc0573[];
EXTERN	BYTE	cc0581[];
EXTERN	BYTE	*cc0600[], *cc0601[], *cc0602[];
EXTERN	BYTE	*cc0810[], *cc0811[], *cc0812[];

/* declare external procedures */
							  /* from CCUTLS.L86 */
EXTERN	BYTE	*utskpzro(), utui2ds();
EXTERN	VOID	utstmcb();
EXTERN	VOID	utecrop(), utegtlk(), utemaloc();
EXTERN	VOID	utemfree(), uterw(), uteset(), utespec();
EXTERN	LONG	utfarjmp();

							  /* from CCDBUG.L86 */
#if TEST
EXTERN	VOID	dbpslh();
#endif

/****************************************** start of code ******************/

/* fmcriterr() : handle critical disk area errors */

VOID fmcriterr(errsec, dosfunc)

LONG	errsec;					   /* sector in error number */
WORD	dosfunc;				      /* dos function number */

{

    LONG	ca;			      /* critical area high boundary */

#if TEST
    dbpslh("\r\nCritical area check. Sector in error = ",errsec);
#endif

    ca = 0;

    if((!fmdtbl.dsk_ioptions & DIO_PDD) && (!fmdtbl.dsk_type & DTP_RMV))
    {
	ca += fmtptr->fi_hidesecs;
	if(errsec < ca)
	    fmerhand(FMERR014, dosfunc, fmmcb.retcode, SPEC_DM);
    }

    ca += fmtptr->fi_bootsecs;
    if(errsec < ca)
	fmerhand(FMERR014, dosfunc, fmmcb.retcode, SPEC_DB);
    ca += (fmtptr->fi_nfats * fmtptr->fi_fsecs);
    if(errsec < ca)
	fmerhand(FMERR014, dosfunc, fmmcb.retcode, SPEC_DF);
    ca += ((fmtptr->fi_dirsize * BPDE) / fmtptr->fi_ssize);
    if(errsec < ca)
	fmerhand(FMERR014, dosfunc, fmmcb.retcode, SPEC_DD);
}

/* fmxfmap() : map utxfrsys() errors to format() error codes */

VOID fmxfmap(xferr)

REG WORD	xferr;

{

    REG WORD	flags;

    if(xferr > XPDSKOFF)
	fmpdmap(xferr - XPDSKOFF);

    flags = SPEC_DEV;

    switch(xferr)
    {

	case XFERR001:
	    fmmcb.utilcode = FMERR008;
	    break;

	case XFERR002:
	case XFERR012:
	    flags = SPEC_FILE;
	    fmmcb.utilcode = FMERR020;
	    break;

	case XFERR003:
	    flags = SPEC_FILE;
	    fmmcb.utilcode = FMERR021;
	    break;

	case XFERR004:
	    fmmcb.utilcode = (fmmcb.dosfunc == S_MFREE) ? FMERR015 : FMERR018;
	    break;

	case XFERR005:
	case XFERR018:
	    flags = SPEC_FILE;
	    fmmcb.utilcode = FMERR022;
	    break;

	case XFERR006:
	    flags = SPEC_FILE;
	    fmmcb.utilcode = FMERR023;
	    break;

	case XFERR007:
	case XFERR009:
	case XFERR016:
	    fmmcb.utilcode = FMERR009;
	    break;

	case XFERR008:
	    fmmcb.utilcode = FMERR002;
	    break;

	case XFERR010:
	case XFERR014:
	case XFERR015:
	case XFERR017:
	    if(xferr == XFERR010)
		flags = SPEC_DF;
	    else
		flags = SPEC_DB;
	    fmmcb.utilcode = FMERR014;
	    break;

	case XFERR011:
	    flags = SPEC_FILE;
	    fmmcb.utilcode = FMERR024;
	    break;

	case XFERR013:
	    flags = SPEC_FILE;
	    fmmcb.utilcode = FMERR025;
	    break;

	case XFERR019:
	    flags = SPEC_FILE;
	    fmmcb.utilcode = FMERR026;
	    break;

	default:
	    fmmcb.utilcode = FMERR006;
	    fmmcb.dosfunc = 0;
	    fmmcb.retcode = (UR_SOURCE | UR_INTERNAL);
	    break;

    }

    fmerhand(fmmcb.utilcode, fmmcb.dosfunc, fmmcb.retcode, flags);
}

/* fmpdmap() : map utp4dsk() errors to format() error codes. */

VOID fmpdmap(pdskerr)

REG WORD	pdskerr;

{
    switch(pdskerr) {
	case PDERR001:
	case PDERR003:
	    fmmcb.utilcode = FMERR008;
	    break;
	case PDERR002:
	    fmmcb.utilcode = FMERR010;
	    break;
	case PDERR004:
	    fmmcb.utilcode = FMERR009;
	    break;
	case PDERR005:
	    fmmcb.utilcode = FMERR019;
	    break;
	default:
	    fmmcb.utilcode = FMERR006;
	    fmmcb.retcode = 0;
	    fmmcb.dosfunc = 0;
	    break;
    }
    fmerhand(fmmcb.utilcode, fmmcb.dosfunc, fmmcb.retcode, SPEC_DEV);
}

/* fmerhand() : build error messages */

VOID fmerhand(uc, df, rc, special)

REG WORD	uc;
REG WORD	df;
LONG		rc;
REG WORD	special;

{

    BYTE	buf[LBUFSIZ];
    REG WORD	code;

    utstmcb(&fmmcb, nullmsg, uc, df, rc);
    switch(df)
    {

	case 0:
	    switch(uc)
	    {

		case FMERR001:
		    fmmcb.pptr[PARM4] = utskpzro(utui2ds(DEVMAX-1, buf));
		    fmmcb.pptr[PARM5] = cc0430[HLVL3];
		    fmmcb.pptr[PARM6] = cc0440;
		    fmmcb.pptr[PARM7] = cc0450;
		    fmmcb.pptr[PARM8] = cc0441;
		    utstmcb(&fmmcb, cc0430, uc, 0, (UR_SOURCE|UR_PARM));
		    break;

		case FMERR002:
		    fmmcb.pptr[PARM5] = cc0430[HLVL3];
		    fmmcb.pptr[PARM6] = cc0443;
		    fmmcb.pptr[PARM7] = cc0455;
		    utstmcb(&fmmcb, cc0430, uc, 0, (UR_SOURCE|UR_PARM));
		    break;

		case FMERR003:
		    fmmcb.pptr[PARM5] = cc0600[HLVL3];
		    utstmcb(&fmmcb, cc0600, uc, 0, (UR_SOURCE|UR_INTERNAL));
		    break;

		case FMERR004:
		    fmmcb.pptr[PARM5] = cc0601[HLVL3];
		    utstmcb(&fmmcb, cc0601, uc, 0, (UR_SOURCE|UR_INTERNAL));
		    break;

		case FMERR005:
		    fmmcb.pptr[PARM5] = cc0430[HLVL3];
		    fmmcb.pptr[PARM6] = fm0050;
		    utstmcb(&fmmcb, cc0430, uc, 0, (UR_SOURCE|UR_PARM));
		    break;

		case FMERR007:
		    utstmcb(&fmmcb, cc0602, uc, 0, (UR_SOURCE|UR_INTERNAL));
		    break;

		case FMERR016:
		    utstmcb(&fmmcb, fm0032, uc, 0, (UR_SOURCE|UR_INTERNAL));
		    break;

		case FMERR017:
		    utstmcb(&fmmcb, fm0030, uc, 0, rc);
		    break;

		case FMERR021:
		    utstmcb(&fmmcb, cc0810, uc, 0, (UR_SOURCE|UR_FORMAT));
		    break;

		case FMERR023:
		    utstmcb(&fmmcb, fm0031, uc, 0, (UR_SOURCE|UR_PARM));
		    break;

		case FMERR024:
		    fmmcb.pptr[PARM5] = cc0811[HLVL3];
		    utstmcb(&fmmcb, cc0811, uc, 0, (UR_SOURCE|UR_FORMAT));
		    break;

		case FMERR026:
		    fmmcb.pptr[PARM5] = cc0812[HLVL3];
		    fmmcb.pptr[PARM6] = nullstr;
		    utstmcb(&fmmcb, cc0812, uc, 0, (UR_SOURCE|UR_FORMAT));
		    break;

		case FMERR027:
		    utstmcb(&fmmcb, cc0415, uc, 0, rc);
		    break;

		case FMERR028:
		    utstmcb(&fmmcb, cc0416, uc, 0, rc);
		    break;

		case FMERR006:
		default:
		    utstmcb(&fmmcb, nullmsg, uc, 0, (UR_SOURCE|UR_INTERNAL));
		    break;

	    }
	    utfarjmp(fmjbuf, fmmcb.retcode);
	    break;

	case S_SET:
	    uteset(&fmmcb);
	    break;

	case S_GET:
	case S_LOOKUP:
	    code = (uc == FMERR008) ? UE_DEVONLY : UE_DEVFIL;
	    utegtlk(&fmmcb, fmmcb.pptr[PARM1], fmmcb.pptr[PARM2], code);
	    break;

	case S_CREATE:
	case S_OPEN:
	    code = (uc == FMERR009) ? UE_DEVONLY : UE_DEVFIL;
	    utecrop(&fmmcb, fmmcb.pptr[PARM1], fmmcb.pptr[PARM2], code);
	    break;

	case S_READ:
	case S_WRITE:
	    code = UE_DEVONLY;

	    if(uc == FMERR025)
		code = UE_DEVFIL;

	    if(uc == FMERR010)
		fmmcb.pptr[PARM1] = stdiname;

	    uterw(&fmmcb, fmmcb.pptr[PARM1], fmmcb.pptr[PARM2], code);

	    if(uc == FMERR014)
		fmcritarea(special);

	    break;

	case S_MALLOC:
	    utemaloc(&fmmcb);
	    break;

	case S_MFREE:
	    utemfree(&fmmcb);
	    break;

	case S_SPECIAL:
	    code = UE_MDCHK;
	    switch(uc)
	    {
		case FMERR011:
		    code = UE_INITF;
		    break;

		case FMERR012:
		    code = UE_FMSYS;
		    break;

		case FMERR013:
		    code = UE_WTSYS;
		    break;

		case FMERR014:
		case FMERR029:
		    code = UE_FMTRK;
		    break;

		case FMERR030:
		    code = UE_RDSYS;
		    break;
	    }
	    utespec(&fmmcb, code);

	    if((uc == FMERR014) || (uc == FMERR029))
		fmcritarea(special);

	    break;

    }
    utfarjmp(fmjbuf, fmmcb.retcode);
}

/* fmcritarea(): handle critical area message */

VOID fmcritarea(special)

REG WORD	special;

{
    switch(special)
    {

	case SPEC_DM:
	    fmmcb.pptr[PARM3] = cc0581;
	    fmmcb.pptr[PARM7] = cc0561;
	    break;

	case SPEC_DB:
	    fmmcb.pptr[PARM3] = cc0570;
	    fmmcb.pptr[PARM7] = cc0561;
	    break;

	case SPEC_DD:
	    fmmcb.pptr[PARM3] = cc0571;
	    fmmcb.pptr[PARM7] = cc0561;
	    break;

	case SPEC_DF:
	    fmmcb.pptr[PARM3] = cc0573;
	    fmmcb.pptr[PARM7] = cc0561;
	    break;
    }
}

/* */
