/*****************************************************************
 * "Copyright (C) 1985, Digital Research, Inc.  All Rights       *
 * Reserved.  The Software Code contained in this listing is     *
 * proprietary to Digital Research Inc., Monterey, California    *
 * and is covered by U.S. and other copyright protection.        *
 * Unauthorized copying, adaptation, distribution, use or        *
 * display is prohibited and may be subject to civil and         *
 * criminal penalties.  Disclosure to others is prohibited.  For *
 * the terms and conditions of software code use refer to the    *
 * appropriate Digital Research License Agreement."              *
 *****************************************************************/

/*===============================================================*
 *   Version 1.8        FMUTLS.C				 *
 *			Miscellaneous procedures for FORMAT.	 *
 *---------------------------------------------------------------*
 *    VERSION   DATE    BY      CHANGE/COMMENTS                  *
 *---------------------------------------------------------------*
 *                                                               *
 *      1.8    07/17/87 KPB     Added 60 meg support fixed fdcalc*
 *                              split up fmtcon loops            *
 *	1.7    9/02/86	DR-K	fix UWORD<LONG compare problem in*
 *				fmfatwrt()			 *
 *	1.6    7/29/86  DR-K	increment buffptr in fix 1.4	 *
 *	1.5    7/15/86	DR-K	fmrdentry now replaces the whole *
 *				tracks worth of blocks		 *
 *	1.4    7/09/86  DR-K	changed fmfatwrt and fmdirwrt to *
 *				write only 1 sector each s_write *
 *	1.3    5/09/86	DR-K	modified for Metaware compiler	 *
 *	1.2   07/20/85	jsr	Fixed for utgtvfat()/utstvfat()	 *
 *				changes, added user terminate	 *
 *				code, fixes for wrong block #.	 *
 *	1.1   05/07/85	jsr	Fixed for HDBOOT/BOOT changes.	 *
 *	1.0   04/11/85	jsr					 *
 *                                                               *
 *===============================================================*/

#include	"portab.h"
#include	"concur.h"
#include	"ccutls.h"
#include	"format.h"
EXTERN   VOID   printf();
/* declare local procedures */

UWORD	fmgtsec();
BOOLEAN	fmynpmpt();
VOID	fmtdos(), fmtcon(), fmrdretry(), fmtbad();
VOID	fmmemalloc(), fmgtdsk(), fmblinker();
VOID	fmfatinit(), fmfatwrt();
VOID	fmdirinit(), fmdirwrt();
VOID	fmbotinit(), fmbotwrt();
VOID	fmmbprinit(), fmmbprwrt();
VOID	fmsyawrt();
VOID	fmmapbad(), fmterminate();

/* declare external variables */

EXTERN	BYTE		*fmbfptr;
EXTERN	WORD		fmdlims[];
EXTERN	UWORD		fmbadblks, fminti, fmskew;
EXTERN	BOOLEAN		fmfd, fmblink;
EXTERN	LONG		fmfdnum, fmbfsiz, fmfoff;
EXTERN	DISK		fmdtbl;
EXTERN	FMTINFO		*fmtptr;
EXTERN	MCB		fmmcb;
						      /* text from FMTMSGS.C */
EXTERN	BYTE	fm0020[], fm0021[], fm0046[];
EXTERN	BYTE	fm0060[], fm0061[], fm0062[], fm0063[];
EXTERN	BYTE	fm0064[], fm0065[];
						     /* text from CCMSGS.L86 */
EXTERN	BYTE	comma, backspace[];
EXTERN	BYTE	yestxt[], notxt[];
/* declare external procedures */
							  /* from FMERHAND.C */
EXTERN	VOID	fmcriterr(), fmerhand();
							  /* from CCUTLS.L86 */
EXTERN	BYTE	*uti2ds(), *utskpwht(), ut2upr();
EXTERN	WORD	utds2i();
EXTERN	UWORD	utgtvfat();
EXTERN	LONG	utlmax(), utprnmsg();
EXTERN	VOID	utstvfat();
							   /* from CCRTL.L86 */
EXTERN	LONG	s_malloc(), s_rdelim(), s_read(), s_special();
EXTERN	LONG	s_write();
EXTERN	VOID	s_swiret();
							  /* from CCDBUG.L86 */
#if TEST
EXTERN	VOID	dbpslh();
#endif

/* a bug patch pointer used for large disks */
UBYTE *FatBuffer;

/* start of code */

/* fmtdos() : format with DOS style interleave list */
VOID fmtdos()
{

    BYTE	n;
    REG BYTE	*rdbuf;
    REG WORD	i, fflags;
    LONG	rdbufsiz, tn, hightrk, offset;
    FDATDOS	fb;

    if(!(fmdtbl.dsk_ioptions & DIO_PDD))	  /* hard fmt if unpartioned */
    {
	fb.fd.fmt_density = fmtptr->fi_density;
	fb.fd.fmt_fill = fmtptr->fi_fill;
	fb.fd.fmt_ssize = fmtptr->fi_ssize;
	fb.fd.fmt_spt = fmtptr->fi_spt;
	fb.fd.fmt_rsvd = 0;

	if(fmtptr->fi_lstflg == SECLIST)
	{
	    n = N128;
	    if(fmtptr->fi_ssize >= SS256)
		n = N256;
	    if(fmtptr->fi_ssize >= SS512)
		n = N512;
	    if(fmtptr->fi_ssize >= SS1024)
		n = N1024;
	    if(fmtptr->fi_ssize >= SS2048)
		n = N2048;
	    if(fmtptr->fi_ssize >= SS4096)
		n = N4096;
	}
    }

    hightrk = fmtptr->fi_nsecs / fmtptr->fi_spt;
    if(fmtptr->fi_nsecs % fmtptr->fi_spt)
	++hightrk;
    rdbufsiz = fmtptr->fi_ssize * fmtptr->fi_spt;
    rdbuf = (BYTE *)(fmbfptr + (fmtptr->fi_fsecs * fmtptr->fi_ssize));
    fflags = (fmtptr->fi_lstflg == SECLIST) ? FTF_DLS : 0;

    for(tn = offset = 0; tn < hightrk; ++tn, offset+=rdbufsiz)   /* trk loop */
    {
	fmblinker(tn);

	if(!(fmdtbl.dsk_ioptions & DIO_PDD))
	{
	    fb.fd.fmt_head = (UBYTE)(tn % fmtptr->fi_nhds);
	    fb.fd.fmt_cyl = (UWORD)(tn / fmtptr->fi_nhds);
	    fb.fd.fmt_sector = fmgtsec();

	    if(fmtptr->fi_lstflg == SECLIST)
	    {
		for(i = 0; i < fmtptr->fi_spt; ++i)
		{
		    fb.fmt_dosilv[i].dl_cyl = (BYTE)fb.fd.fmt_cyl;
		    fb.fmt_dosilv[i].dl_hd = fb.fd.fmt_head;
		    fb.fmt_dosilv[i].dl_n = n;
		    fb.fmt_dosilv[i].dl_sec =
		      (i==0) ? (BYTE)fb.fd.fmt_sector : (BYTE)fmgtsec();
		}
	    }
	    
	    if((fmmcb.retcode = s_special(SPF_FMTRK, fflags, fmfdnum, (LONG)0,
	      (LONG)0, (LONG)&fb, (LONG)sizeof(fb))) < SUCCESS)
	    {
		fmcriterr((offset / fmtptr->fi_ssize), S_SPECIAL); 
		fmerhand(FMERR029, S_SPECIAL, fmmcb.retcode, SPEC_DEV);
	    }
	}

	fmmcb.retcode =
	  s_read(RDF_BEG, fmfdnum, (LONG)FatBuffer, rdbufsiz, offset);

#if TEST
	if(fmmcb.retcode != rdbufsiz)
	{
	    dbpslh("\r\nError on READ after FMTTRK = ", fmmcb.retcode);
	    dbpslh("\r\nRead buffer size = ", rdbufsiz);
	}
#endif

	if(fmmcb.retcode != rdbufsiz)
	    fmrdretry(rdbuf, offset);

	fmskew = ((fmskew + fmtptr->fi_skewf) % fmtptr->fi_spt);
	fminti = fmskew;
    }
    if(fmblink)
	utprnmsg(fm0046, fmmcb.pptr, STDOUT);

    fmtbad(&fb);					/* zap any bad areas */
}

/* fmtcon() : format with a FlexOS style interleave list */

VOID fmtcon()
{

    REG BYTE	*rdbuf;
    REG WORD	i, fflags;
    LONG	rdbufsiz, tn, hightrk, offset;
    FDATCON	fb;

    if(!(fmdtbl.dsk_ioptions & DIO_PDD))	  /* hard fmt if unpartioned */
    {
	fb.fd.fmt_density = fmtptr->fi_density;
	fb.fd.fmt_fill = fmtptr->fi_fill;
	fb.fd.fmt_ssize = fmtptr->fi_ssize;
	fb.fd.fmt_spt = fmtptr->fi_spt;
	fb.fd.fmt_rsvd = 0;
    }

    hightrk = fmtptr->fi_nsecs / fmtptr->fi_spt;
    if(fmtptr->fi_nsecs % fmtptr->fi_spt)
	++hightrk;
    rdbufsiz = fmtptr->fi_ssize * fmtptr->fi_spt;
    rdbuf = (BYTE *)(fmbfptr + (fmtptr->fi_fsecs * fmtptr->fi_ssize));
    fflags = (fmtptr->fi_lstflg == SECLIST) ? FTF_CLS : 0;

    
    for(tn = offset = 0; tn < hightrk; ++tn)   /* trk loop */
    {
	fmblinker(tn);

	if(!(fmdtbl.dsk_ioptions & DIO_PDD))
	{
	    fb.fd.fmt_head = (UBYTE)(tn % fmtptr->fi_nhds);
	    fb.fd.fmt_cyl = (UWORD)(tn / fmtptr->fi_nhds);
	    fb.fd.fmt_sector = fmgtsec();

	    if(fmtptr->fi_lstflg == SECLIST)
		for(i = 0; i < fmtptr->fi_spt; ++i)
		    fb.fmt_conilv[i] = (i == 0) ? fb.fd.fmt_sector : fmgtsec();

	    if((fmmcb.retcode = s_special(SPF_FMTRK, fflags, fmfdnum, (LONG)0,
	      (LONG)0, (LONG)&fb, (LONG)sizeof(fb))) < SUCCESS) 
              if(fmmcb.retcode = 0L)
	    {
		fmcriterr((offset / fmtptr->fi_ssize), S_SPECIAL); 
		fmerhand(FMERR029, S_SPECIAL, fmmcb.retcode, SPEC_DEV);
	    }
	}


	fmskew = ((fmskew + fmtptr->fi_skewf) % fmtptr->fi_spt);
	fminti = fmskew;
    }



    for(tn = offset = 0; tn < hightrk; ++tn, offset+=rdbufsiz)   /* trk loop */
    {
	fmblinker(tn);

	if(!(fmdtbl.dsk_ioptions & DIO_PDD))
	{
	    fb.fd.fmt_head = (UBYTE)(tn % fmtptr->fi_nhds);
	    fb.fd.fmt_cyl = (UWORD)(tn / fmtptr->fi_nhds);
	    fb.fd.fmt_sector = fmgtsec();

	    if(fmtptr->fi_lstflg == SECLIST)
		for(i = 0; i < fmtptr->fi_spt; ++i)
		    fb.fmt_conilv[i] = (i == 0) ? fb.fd.fmt_sector : fmgtsec();

	}

	fmmcb.retcode =   
	  s_read(RDF_BEG, fmfdnum, (LONG)FatBuffer, rdbufsiz, offset);

         
#if TEST
	if(fmmcb.retcode != rdbufsiz)
	{
	    dbpslh("\r\nError on READ after FMTTRK = ", fmmcb.retcode);
	    dbpslh("\r\nRead buffer size = ", rdbufsiz);
	}
#endif

	if(fmmcb.retcode != rdbufsiz)
	    fmrdretry(FatBuffer, offset);

	fmskew = ((fmskew + fmtptr->fi_skewf) % fmtptr->fi_spt);
	fminti = fmskew;
    }
    if(fmblink)
	utprnmsg(fm0046, fmmcb.pptr, STDOUT);

    fmtbad(&fb);				  /* zap any given bad areas */
}

/* fmgtsec() : get sector value (handle interleave and skew) */

UWORD fmgtsec()
{

    REG UWORD	i;

    i = (fmtptr->fi_interleave[fminti]);
    fminti = (++fminti % fmtptr->fi_spt);
    return(i);
}

/* fmrdretry() : allocate bad blocks for all sectors on this track */

VOID fmrdretry(buf, off)

REG BYTE	*buf;
LONG		off;

{

    REG WORD	i;
    REG UWORD	bn;

    if(off < fmfoff)
	fmcriterr((off / fmtptr->fi_ssize), S_READ);

    for(i = 0; i < fmtptr->fi_spt; ++i)       /* sector by sector track loop */
    {
	    bn = (((off - fmfoff) / fmtptr->fi_ssize) /
	      fmtptr->fi_spb) + FILE_FAT;		       /* calc blk # */

	    fmmapbad(bn);			      /* allocate this block */
	    ++bn;

	    while(((((off - fmfoff) / fmtptr->fi_ssize) /
	      fmtptr->fi_spb) + FILE_FAT) != bn)
	    {
		++i;				  /* skip rest of this block */
		off += fmtptr->fi_ssize;
	    }
	    --i;
    }
}

/* fmtbad() : force bad format routine */

VOID fmtbad(fb)

REG FMTDAT	*fb;

{

    BYTE	buf[BUFSIZ];
    UBYTE	head;
    REG WORD	i;
    REG UWORD	cyl, maxcyl;
    REG UWORD	bb, bn;
    ULONG	sectoff, temp;
    REG BYTE	*ptr;

    if((!(fmdtbl.dsk_ioptions & DIO_PDD)) && (!(fmdtbl.dsk_type & DTP_RMV)))
    {
	maxcyl = ((fmtptr->fi_nsecs / fmtptr->fi_nhds) / fmtptr->fi_spt);
	utprnmsg(fm0060, fmmcb.pptr, STDOUT);
	utprnmsg(fm0061, fmmcb.pptr, STDOUT);

	do
	{
	    utprnmsg(fm0062, fmmcb.pptr, STDOUT);
	    if((fmmcb.retcode = s_rdelim((RDF_DLM|RDF_INC|RDF_EDT|RDF_FP),
	      STDIN,(LONG)buf, (LONG)sizeof(buf), (LONG)0,
	      (LONG)fmdlims)) < SUCCESS)
		fmerhand(FMERR010, S_RDELIM, fmmcb.retcode, SPEC_DEV);
	    ptr = (BYTE *)(buf + fmmcb.retcode - 1);	  /* 8 bit chars !!! */
	    if(*ptr  != (BYTE)fmdlims[1])
	    {
		utprnmsg(fm0061, fmmcb.pptr, STDOUT);	   /* too many msg ? */
		continue;
	    }
	    *ptr = NULL;
	    if(fmmcb.retcode == 1)			  /* 8 bit chars !!! */
		break;
	    ptr = buf;
	    while(*ptr && (*ptr != comma))
		++ptr;
	    if(*ptr != comma)
	    {
		utprnmsg(fm0061, fmmcb.pptr, STDOUT);
		continue;
	    }
	    *ptr++ = NULL;
	    ptr = utskpwht(ptr);
	    cyl = utds2i(ptr);
	    ptr = utskpwht(buf);
	    head = utds2i(ptr);
	    if((head < 0) || (head >= fmtptr->fi_nhds))
	    {
		fmmcb.pptr[PARM5] = fm0064;
		fmmcb.pptr[PARM6] = uti2ds(fmtptr->fi_nhds - 1, buf);
		utprnmsg(fm0063, fmmcb.pptr, STDOUT);
		utprnmsg(fm0061, fmmcb.pptr, STDOUT);
		continue;
	    }
	    if((cyl < 0) || (cyl >= maxcyl))
	    {
		fmmcb.pptr[PARM5] = fm0065;
		fmmcb.pptr[PARM6] = uti2ds(maxcyl - 1, buf);
		utprnmsg(fm0063, fmmcb.pptr, STDOUT);
		utprnmsg(fm0061, fmmcb.pptr, STDOUT);
		continue;
	    }
	    fb->fmt_cyl = cyl;
	    fb->fmt_head = head;

	    sectoff = (fmtptr->fi_spt * head) +
	      (fmtptr->fi_spt * (fmtptr->fi_nhds * cyl));

	    if((fmmcb.retcode = s_special(SPF_FMTRK, FTF_BAD, fmfdnum, (LONG)0,
	      (LONG)0, (LONG)fb, (LONG)sizeof(*fb))) < SUCCESS)
	    {
		fmcriterr(sectoff, S_SPECIAL);
		fmerhand(FMERR029, S_SPECIAL, fmmcb.retcode, SPEC_DEV);
	    }
					      /* map it out in FAT table too */
	    temp = sectoff * fmtptr->fi_ssize;

	    bb = (((temp - fmfoff) / fmtptr->fi_ssize) /
	      fmtptr->fi_spb) + FILE_FAT;

	    for(i = 0; i < fmtptr->fi_spt; ++i)
	    {
		bn = ((((temp - fmfoff) + (i * fmtptr->fi_ssize)) /
		  fmtptr->fi_ssize) / fmtptr->fi_spb) + FILE_FAT;
		if(bn != bb)
		{
		    bb = bn;
		    fmmapbad(bn);
		}
	    }

	} while(TRUE);
    }
}

/* fmmemalloc() : allocate some memory */
/*	Need room for a FAT and a DIR or a TRACK or a BOOT or an MBPR */

VOID fmmemalloc()
{

    MPB		mpb,More;

    mpb.mpb_start = 0;

    mpb.mpb_minact =
      utlmax((LONG)(fmtptr->fi_dirsize * BPDE),
      (LONG)(fmtptr->fi_spb * fmtptr->fi_ssize)); 

    mpb.mpb_minact =
      utlmax(mpb.mpb_minact,(LONG)(fmtptr->fi_spt * fmtptr->fi_ssize));

    mpb.mpb_minact =
      utlmax(mpb.mpb_minact,(LONG)(fmtptr->fi_bootsecs * fmtptr->fi_ssize));

    if(fmdtbl.dsk_ioptions & DIO_PDD)
    {
      mpb.mpb_minact =
	utlmax(mpb.mpb_minact,(LONG)(fmtptr->fi_hidesecs * fmtptr->fi_ssize));
    }

    mpb.mpb_minact = mpb.mpb_max = 0xffff - 1;
/*
      (fmtptr->fi_ssize * fmtptr->fi_fsecs) + mpb.mpb_minact;
*/
#if TEST
	dbpslh("\r\nAsking for memsize of ", mpb.mpb_minact);
#endif

    if((fmmcb.retcode = s_malloc(SMO_NEW, &mpb)) < SUCCESS)
	fmerhand(FMERR018, S_MALLOC, fmmcb.retcode, SPEC_DEV); 
    fmbfptr = (BYTE *)mpb.mpb_start;
    fmbfsiz = mpb.mpb_minact;
    More.mpb_start = 0;
    More.mpb_minact = 0xefff;
    More.mpb_max    = 0xffff;
    FatBuffer = (UBYTE *)s_malloc(SMO_NEW,&More);
    FatBuffer = (UBYTE*) More.mpb_start;
}

/* fmgtdsk() : prompt for the format disk(ette) ready */

VOID fmgtdsk()
{
    if(!fmfd)				     /* prompt for format disk ready */
	utprnmsg(fm0020, fmmcb.pptr, STDOUT);
    if(!fmynpmpt(fm0021))
	fmerhand(FMERR017, 0, (UR_SOURCE|UR_UTERM), SPEC_DEV);
}

/* fmblinker() : blink on screen to show activity */

VOID fmblinker(n)

LONG	n;

{
    
    REG BYTE	*msg;
    BYTE       Fred[10];

    if(!(n % BLINKR))
    {
	if(fmblink)
	{
	    msg = fm0046;
	    fmblink = FALSE;
	}
	else
	{
	    msg = backspace;
	    fmblink = TRUE;
	}
	utprnmsg(msg, fmmcb.pptr, STDOUT);		/* still alive blink */
    }
}

/* fmfatinit() : initialize memory image FAT table */

VOID fmfatinit(bf)

REG BYTE	*bf;				 /* byte level image pointer */

{

    REG BYTE	*bf1;
    REG BOOLEAN	fs;
    LONG	i, endloop;

    bf1 = bf;					 /* create a blank FAT image */
    endloop = fmtptr->fi_fsecs * fmtptr->fi_ssize;
    for(i = 0; i < endloop; ++i)
        *bf1++ = (BYTE)FREE_FAT;
    fs = (fmtptr->fi_format == DFM_DOS2) ? TRUE : FALSE;
    utstvfat(bf,0,(fmtptr->fi_media|0xff00),fs);       /* set FAT media code */
    utstvfat(bf, 1, 0xffff, fs);
}

/* fmfatwrt() : write all copies of FATs from the memory image FAT table */

VOID fmfatwrt(fatptr, fatsize)

REG BYTE	*fatptr;
LONG		fatsize;

{

    WORD	i;
    REG UWORD	ssize;
    REG BYTE	*fp;
    REG LONG	j,offset;

    if(fatsize)
    {
	ssize = fmtptr->fi_ssize;
	offset = fmtptr->fi_bootsecs * ssize;

	if((!(fmdtbl.dsk_ioptions & DIO_PDD))&&(!(fmdtbl.dsk_type & DTP_RMV)))
	       offset += (fmtptr->fi_hidesecs * ssize);

	for(i = 0; i < fmtptr->fi_nfats; ++i )		/* for each fat copy */
	{
	   fp = fatptr;
	   for(j=0; j < fatsize ; j += ssize )		/* for each sector */
	    {
	      fmmcb.retcode=s_write(WRF_BEG,fmfdnum,(LONG)fp,(LONG)ssize,offset);
	        if(fmmcb.retcode != ssize)
		   fmerhand(FMERR014, S_WRITE, fmmcb.retcode, SPEC_DF);
	      offset += ssize; 
	      fp += ssize;
	    }
	}
    }
}

/* fmdirinit() : initialize buffer for clean directory */

VOID fmdirinit(bf)

REG BYTE	*bf;				   /* pointer to buffer area */

{

    REG WORD	i, j;

    for(i = 0; i < fmtptr->fi_dirsize; ++i)	   /* for each DIR entry ... */
	for(j = 0; j < BPDE; ++j) 		 /* create a blank DIR image */
	    *bf++ = 0;
}

/* fmdirwrt() : write out the image of the directory */

VOID fmdirwrt(bp, bs)

REG BYTE	*bp;
LONG		bs;

{

    LONG	offset;
    REG UWORD	i,ssize;

    ssize = fmtptr->fi_ssize;
    offset = fmtptr->fi_ssize *
      (fmtptr->fi_bootsecs + (fmtptr->fi_fsecs * fmtptr->fi_nfats));

    if((!(fmdtbl.dsk_ioptions & DIO_PDD))&&(!(fmdtbl.dsk_type & DTP_RMV)))
	offset += (fmtptr->fi_hidesecs * ssize);

    for( i= 0 ; i < bs ; i += ssize )
    {
	fmmcb.retcode = s_write(WRF_BEG, fmfdnum, (LONG)bp,(LONG)ssize, offset);
	if(fmmcb.retcode != ssize)
	    fmerhand(FMERR014, S_WRITE, fmmcb.retcode, SPEC_DD);
	offset += ssize;
	bp += ssize;
    }
}

/* fmbotinit() : initialize the BOOTREC structure */

VOID fmbotinit()
{

    REG BYTE		*sptr, *dptr;
    REG	WORD		cnt, siz;
    REG BOOTREC		*br;

						     /* copy image to buffer */
    dptr = fmbfptr;
    sptr = (BYTE *)fmtptr->fi_bimage;
    siz = (WORD)(fmtptr->fi_bootsecs * fmtptr->fi_ssize);
    for(cnt = 0; cnt < siz; ++cnt)
	*dptr++ = *sptr++;
    					       /* modify BPB table in buffer */
    br               = (BOOTREC *)fmbfptr;
    br->br_ssize     = fmtptr->fi_ssize;
    br->br_spb       = (BYTE)fmtptr->fi_spb;
    br->br_hidesecs  = fmtptr->fi_hidesecs;
    br->br_rsvdsecs  = (WORD)fmtptr->fi_bootsecs;
    br->br_nfats     = (BYTE)fmtptr->fi_nfats;
    br->br_dirsize   = fmtptr->fi_dirsize;
    br->br_nsectors  = (fmtptr->fi_nsecs > 65535) ? 0 : (WORD)fmtptr->fi_nsecs;
    br->br_drinsecs  = fmtptr->fi_nsecs;
    br->br_media     = fmtptr->fi_media;
    br->br_fsecs     = fmtptr->fi_fsecs;
    br->br_spt       = fmtptr->fi_spt;
    br->br_nheads    = fmtptr->fi_nhds;
    br->br_cbase     = 0;
    br->br_clen      = 0;
    br->br_dbase     = 0;
    br->br_dlen      = 0;
    br->br_filestart = (br->br_hidesecs + br->br_rsvdsecs +
                       (br->br_nfats * br->br_fsecs) +
                       ((br->br_dirsize * BPDE) / br->br_ssize));
}

/* fmbotwrt() : write out the boot image */
VOID fmbotwrt(bp, bs)
REG BYTE	*bp;
LONG		bs;
{

    LONG	offset;

    offset = 0;

    if((!(fmdtbl.dsk_ioptions & DIO_PDD)) && (!(fmdtbl.dsk_type & DTP_RMV)))
	offset += (fmtptr->fi_hidesecs * fmtptr->fi_ssize);

    fmmcb.retcode = s_write(WRF_BEG, fmfdnum, (LONG)bp, bs, offset);
    if(fmmcb.retcode != bs)
	fmerhand(FMERR014, S_WRITE, fmmcb.retcode, SPEC_DB);
}

/* fmmbprinit() : initialize the MBPR image if necessary */

VOID fmmbprinit()
{

    REG BYTE		*sptr, *dptr;
    REG	LONG		cnt, siz;

						     /* copy image to buffer */
    if((!(fmdtbl.dsk_ioptions & DIO_PDD)) && (!(fmdtbl.dsk_type & DTP_RMV)))
    {
	dptr = fmbfptr;
	sptr = (BYTE *)fmtptr->fi_mbprimg;
	siz = (fmtptr->fi_hidesecs * fmtptr->fi_ssize);
	for(cnt = 0; cnt < siz; ++cnt)
	    *dptr++ = *sptr++;
    }
}

/* fmmbprwrt() : write out the MBPR image if necessary */

VOID fmmbprwrt(mbp, mbs)

REG BYTE	*mbp;
LONG		mbs;

{
    if((!(fmdtbl.dsk_ioptions & DIO_PDD)) && (!(fmdtbl.dsk_type & DTP_RMV)))
    {
	fmmcb.retcode = s_write(WRF_BEG, fmfdnum, (LONG)mbp, mbs, (LONG)0);
	if(fmmcb.retcode != mbs)
	    fmerhand(FMERR014, S_WRITE, fmmcb.retcode, SPEC_DM);
    }
}

/* fmsyawrt() : write out the system area image */

VOID fmsyawrt()
{
    if(fmtptr->fi_sysize)
    {
	if((fmmcb.retcode=
	  s_special(SPF_WTSYS,0,fmfdnum,fmbfptr,fmtptr->fi_sysize,
	  (LONG)0,(LONG)0)) < SUCCESS)
	    fmerhand(FMERR013, S_SPECIAL, fmmcb.retcode, SPEC_DS);
    }
}

/* fmmapbad() : map out a bad allocation block */

VOID fmmapbad(bn)

REG UWORD	bn;						     /* block number */

{

    REG BOOLEAN	fs;			/* fatsiz indicator (TRUE = 2 bytes) */

    if(fmtptr->fi_nfats == 0)			 /* return if no FATs at all */
	return;
    if((bn < FILE_FAT) || (bn > (fmtptr->fi_nsecs/fmtptr->fi_spb)))
	return;					     /* ret if out of bounds */
    fs = (fmtptr->fi_format == DFM_DOS2) ? TRUE : FALSE;  /* set fatsiz flag */
    if((utgtvfat(fmbfptr, bn, fs) | 0xf000) != BADB_FAT)
    {
	++fmbadblks;					 /* count this block */
	utstvfat(fmbfptr, bn, BADB_FAT, fs);	      /* then mark it as BAD */
    }
}

/* fmynpmpt() : prompt user for Y or N answer */
/*	Returns: TRUE if "Y", else FALSE if "N" */

BOOLEAN fmynpmpt(msg)

REG BYTE	*msg;

{

    BYTE	c[REPLYSIZ];
    REG BOOLEAN	flag, ret;

    flag = FALSE;
    fmmcb.pptr[PARM5] = yestxt;
    fmmcb.pptr[PARM6] = notxt;

    while(!flag)
    {

	c[REPLY0] = c[REPLY1] = NULL;

	utprnmsg(msg, fmmcb.pptr, STDOUT);

	if((fmmcb.retcode = s_rdelim((RDF_FLS|RDF_DLM|RDF_INC|RDF_EDT|RDF_FP),
	  STDIN, (LONG)c, (LONG)sizeof(c), (LONG)0, (LONG)fmdlims)) < SUCCESS)
	    fmerhand(FMERR010, S_RDELIM, fmmcb.retcode, SPEC_DEV);

	if(c[REPLY1] != (BYTE)fmdlims[REPLY1])
	    continue;

	if(ut2upr(c[REPLY0]) == yestxt[REPLY0])
	    flag = ret = TRUE;

	if(ut2upr(c[REPLY0]) == notxt[REPLY0])
	{

	    flag = TRUE;
	    ret = FALSE;

	}
    }
    return(ret);
}

/* fmterminate() : handle process aborts */

VOID fmterminate(emask, ret)

LONG	emask, ret;

{
    s_swiret(SWO_MAIN);

    if((WORD)(ret & 0x0000ffffL) == E_CTLC)
	fmerhand(FMERR027, 0, (UR_SOURCE | UR_UTERM), SPEC_DEV);
    else
	fmerhand(FMERR028, 0, (UR_SOURCE | UR_UTERM), SPEC_DEV);
}

/* */
