/*
	SETFIP.C
	Version 1.4
	05/09/86
*/

/*
	Sample OEM routine to set FMTINFO pointers for OEM disk devices
*/
/*
 *  09/30/86 PKB
 *  references to CDOS, Concurrent or Concurrent DOS changed to FlexOS
 *  12/27/86 KPB   Added long cast to allow for 40meg drivers  
    12/30/86 KPB   Changed the PUD definetion 
*/


/* include some header files */

#include	"portab.h"
#include	"concur.h"

/* declare some external modules */

union	{				/* The following union is an effort to	*/
     VOID	(*bootcode)();		/* case the bootloader code into a data	*/
     BOOTREC	*bitimage;		/* block pointer (kludge)		*/
} bootunion;

EXTERN	LONG	s_special();
EXTERN	VOID	lbase();
EXTERN	VOID	hdboot();

/**********
*  PUD - Physical Unit Descr
*/
#define PUD struct _PUnitDescr

PUD
{
	UWORD   pu_maxcyl ;     /* max cyl # for i/o        */
	UWORD   pu_nheads ;     /*  no of heads         */
        UBYTE   pu_null;        /* fill */
	UWORD   pu_precomp ;        /*  precomp cylinder no     */
        UBYTE   pu_null2;           /* fill */
	UWORD   pu_step ;       /*  step rate           */
	UWORD   pu_eat ;        /*  even            */
	UWORD   pu_crashpad ;       /*  landing zone cylinder no    */
	UWORD   pu_sectors ;        /*  no sectors/track        */
} ;

/********************** start of code *************************************/

VOID  setfip(f, fdnum, dsk)

FMTINFO	**f;			     /* pointer to pointer to FMTINFO struct */
LONG	fdnum;				 /* format device's open file number */
DISK	*dsk;		       /* pointer to format device's DISK_INFO table */

{
	PUD	pud_s;		/* PUD information from the hard driver */
	LONG	retcode;	/* return code from special		*/

/* Default values for IBM-AT 20 megabyte fixed disk */
/* Values below not checked --- just an example */
/* These values will be updated from the special call to the driver	*/
/* Note: Items below marked (*1) are for the entire disk. These will be */
/*	 modified to partition-size adjusted values as needed.		*/

    MLOCAL FMTINFO	atxxmb = {
	4,						  /* number of heads */
	(LONG)41820,					/* number of sectors */
	17,						/* sectors per track */
	512,						 /* bytes per sector */
	1,					    /* starting sector value */
	SECLIST,				 /* interleave list provided */
	CCLIST,			     /* FlexOS style interleave list */
	UWNULLPTR,				  /* interleave list pointer */
	0,					    /* skew factor (no skew) */
	(LONG)1,			    /* number of hidden sectors (*1) */
	1,					   /* number of boot sectors */
	4,		      /* number of sectors per allocation block (*1) */
	2,					     /* number of FAT copies */
	41,			  /* number of sectors for one FAT copy (*1) */
	512,				 /* number of directory entries (*1) */
	(LONG)0,			      /* size of special system area */
	DBL_DEN,					     /* density info */
	DFM_DOS1,		  /* format code (1.5 byte FAT entries) (*1) */
	0xf8,						       /* media code */
	0xf6,					   /* format fill byte value */
	NULLPTR,			   /* pointer to special system area */
	MRNULLPTR,			  /* pointer to MBPR record (if any) */
	BRNULLPTR,				   /* pointer to boot record */
	616,					    /* landing zone cylinder */
	256			    /* write pre-compensation start cylinder */
	};

    MLOCAL UWORD intlv[] = { 1,4,7,10,13,16,2,5,8,11,14,17,3,6,9,12,15 };


    if(dsk->dsk_type & DTP_RMV)
	*f = 0;				  /* no OEM floppy formats supported */
    else {
            if((retcode=s_special(SPF_PUD,0,fdnum,&pud_s,(LONG)sizeof(PUD),
                   (LONG)0,(LONG)0)) < ((LONG) SUCCESS))
               {
                 *f = 0; /* Format not supported */
               }
            else
               {	 	/* set format values from PUD */
                  atxxmb.fi_nhds = pud_s.pu_nheads;      /* number of heads   */
                                                         /* number of sectors */
                  atxxmb.fi_nsecs = (ULONG)((ULONG)pud_s.pu_maxcyl *
                                           (ULONG)pud_s.pu_nheads  *
                                           pud_s.pu_sectors);

                  atxxmb.fi_spt = pud_s.pu_sectors;      /* sectors per track */
                  atxxmb.fi_landzone = pud_s.pu_crashpad;/* landing zone cyl  */
                  atxxmb.fi_precomp = pud_s.pu_precomp;  /* wrt pre-comp start*/

                  atxxmb.fi_interleave = intlv;
		  bootunion.bootcode = lbase;
		  atxxmb.fi_bimage = bootunion.bitimage;
		  bootunion.bootcode = hdboot;
		  atxxmb.fi_mbprimg = (MBPR *)bootunion.bitimage;
                  *f = &atxxmb;
                }
    }

}
