/*****************************************************************
 * "Copyright (C) 1985, Digital Research, Inc.  All Rights       *
 * Reserved.  The Software Code contained in this listing is     *
 * proprietary to Digital Research Inc., Monterey, California    *
 * and is covered by U.S. and other copyright protection.        *
 * Unauthorized copying, adaptation, distribution, use or        *
 * display is prohibited and may be subject to civil and         *
 * criminal penalties.  Disclosure to others is prohibited.  For *
 * the terms and conditions of software code use refer to the    *
 * appropriate Digital Research License Agreement."              *
 *****************************************************************/

/*===============================================================*
 *   Version 2.4        TRNFRSYS.C                               *
 *              Installs system on disk and xfers SYS files.     *
 *---------------------------------------------------------------*
 *    VERSION   DATE    BY      CHANGE/COMMENTS                  *
 *---------------------------------------------------------------*
 *	2.4	3/5/86	DR-K	Do physical remount on each open *
 *	2.3   02/07/86	cpg	Reinserted reb's 12/02/85 change *
 *				(modified flags on GET only      *
 *				 calls to the source drive.)     *  	
 *      2.2   11/07/85  brm     Get size of loader before create *
 *                              of contiguous loader image.      *
 *                              Add 'write_loc' and modify       *
 *                              xwrited() to write absolute when *
 *                              copying loader.                  * 
 *                                                               *
 *	2.1   11/07/85  cpg	Changed cast in utgtvfat() call  *
 *				 that prevented use of 16 bit FAT*	
 *	2.0   09/26/85	jsr	Modified for two phase loader.	 *
 *								 *
 *	1.3   08/07/85	jsr	Fixed error return status for	 *
 *				case of "sf" given but not found.*
 *				Also added code to set destfile	 *
 *				time/date to same as source's.	 *
 *				Fixed problem with pre-delete of *
 *				destfile. Removed FREE SPACE chk *
 *				and added destfile delete if err.*
 *				Added REG variable declarations. *
 *	1.2   08/02/85	jsr	Fixed and reinstated FREE SPACE  *
 *				check code in xxfrfils(), 	 *
 *				modified for 68K compile,	 *
 *				modified memory alloc code.	 *
 *	1.1   05/07/85	jsr	Delete FLEX286.SYS before FAT check *
 *				and check if FAT > 64k in size.  *
 *      1.0   03/22/85  jsr                                      *
 *                                                               *
 *===============================================================*/
/* include some header files */

#include        "portab.h"
#include        "concur.h"
#include        "ccutls.h"

/*
  NOTE:		.SYS files contain the FIX286 header.
		.IMG files have the FIX286 header stripped off, and are
		     sector aligned.
*/
/*******************************************************
*	set TEST to TRUE for debug version             *
* 	must also include CCDBUG.L86 in LINK file      *
*   	Example use of if TEST  		       *
*						       *
*	dbpsid("\r\nTRNFRSYS: nfe = ",nfe);            *
*    	dbpstr("\r\nTRNFRSYS: back from xcreatd().");  *
*						       *
********************************************************/
#define TEST    FALSE

#if TEST
EXTERN  VOID    dbpstr(), dbpss(), dbpsid(), dbpsld(); /* from CCDBUG.L86 */
#endif


#ifndef	OPF_PMNT
#define	OPF_PMNT	0x0200
#endif

/* cast local procedures */

WORD    utxfrsys();
VOID    xferfile(), xxfrfils();
VOID    xsrcalloc(), xcreatd(), xreads(), xwrited();
VOID    xstxfi(), xdskinfo();
VOID    xrdboot();
VOID    xdopmpt(), xchgfnam(), xsetattrib();
VOID    xferr();
VOID	xsetxsdf();
VOID    xfixboot();

/* declare external variables (TEXT) */
                                                          /* from CCMSGS.L86 */
EXTERN  BYTE    devdelim, dir1delim, dir2delim, wildfile[];
EXTERN  BYTE    scdldr[], icdldr[], sfile[];
EXTERN  BYTE    cc0305[], cc0306[], cc0312[];
EXTERN  BYTE    cc0480[];
EXTERN  BYTE    cc0578[], cc0579[];
EXTERN  BYTE    cc0800[], cc0801[], cc0802[];

/* BOOT.A86 */
EXTERN 	VOID 	lbase();
union {
	    VOID	(*clbase)();
            BOOTREC	*blbase;
} wlbase;

/* CCUTLS.L86 */
EXTERN	LONG	utstjmp();
EXTERN	VOID	utfarjmp();
EXTERN  WORD    strcmp(), utp4dsk(), utgtvfat();
EXTERN  LONG    utslen(), utgtpdv(), utprnmsg();
EXTERN  VOID    strcat();

/* from CCRTL.L86 */
EXTERN  LONG    s_close(), s_create(), s_delete(), s_get(), s_lookup();
EXTERN  LONG    s_malloc(), s_mfree(), s_open(), s_read();
EXTERN  LONG    s_set(), s_write();

/* declare local (global) variables */

BYTE            *xlddev, *xlsdev;        /* log dst & src "device" name ptrs */
BYTE            xddev[DEVMAX], xsdev[DEVMAX]; /* phys dst & src device names */
BYTE            xdspec[SPECMAX], xsspec[SPECMAX];  /* src and dest filespecs */
BOOLEAN         xsdf;                               /* set if xsdev == xddev */
BOOLEAN         xcdf;                                    /* current dev flag */
BOOLEAN         xsfopen, xdfopen;                     /* dev/file open flags */
BOOLEAN		xxferflg;		     /* set if file xfer in progress */
LONG            xsfnum, xdfnum;                         /* open file numbers */
LONG		xmp1, xmp2, xmp3;	       /* allocated memory addresses */
LONG            write_loc;            /* write location within contig file.  */
DISK            xddsk, xsdsk;                     /* disk information tables */
DISKFILE	xdf;		       /* to hold source file time/date info */
XFINFO          xfi;                           /* xfer information structure */
MCB             *xmcb;                      /* message control block pointer */
jumpbuff        xjmpbuf;                          /* error abort information */

#if P286
SHDR286         xshdr;                             /* 286 system file header */
#endif

#if P68K
SHDR68K         xshdr;                             /* 68K system file header */
#endif

/* start of code */

/* utxfrsys() : Install a FlexOS system and transfer other "system" files */

WORD utxfrsys(dd, sd, sf, mp)

BYTE		*dd, *sd, *sf;
REG MCB		*mp;

{
/*  REG BYTE	*ptr, *ptr1;                   general purpose BYTE pointers */
    REG WORD	i;                           /* general purpose WORD counter */
    REG WORD	flags;                              /* DOS function variable */
    REG WORD	nfe;                    /* number of FAT entries for imgfile */
    REG WORD	dpadsiz;           /* number of bytes of destination padding */
    REG WORD	spadsiz;                /* number of bytes of source padding */
    BOOLEAN     imode;					   /* .IMG xfer mode */
    LONG        siz;                                        /* variable size */
    SFI         sfi;                    /* source file information structure */
    MPB         mpb;                           /* memory alloc return buffer */

                                                 /* intialize some variables */
    xmcb = mp;
    xlddev = dd;
    xlsdev = sd;
    xcdf = DEST;
    sfi.soff = 0;
    xmp1 = xmp2 = xmp3 = 0;
    xdspec[0] = xsspec[0] = NULL;
    xxferflg = xsfopen = xdfopen = imode = sfi.eoflag = FALSE;

    if(!*sf)		    /* if no system file name given, use the default */
	sf = sfile;

                                   /* set error abort info before any errors */
    if(0L!=(siz = utstjmp(xjmpbuf)))
    {
	xmcb->utilcode = (WORD)(siz & 0x0000ffffL);
        goto xfexit;
    }
                                                /* get physical device names */
    if((xmcb->retcode =
      utgtpdv(xlddev, xddev, xmcb)) < 1)                    /* get phys ddev */
        xferr(XFERR001, xmcb->dosfunc, xmcb->retcode);       /* S_LOOKUP err */

    if((xmcb->retcode =
      utgtpdv(xlsdev, xsdev, xmcb)) < 1)                    /* get phys sdev */
        xferr(XFERR001, xmcb->dosfunc, xmcb->retcode);       /* S_LOOKUP err */

                                                       /* setup system specs */
    strcat(xdspec, xlddev);
    strcat(xdspec, icdldr);
    strcat(xsspec, xlsdev);
    strcat(xsspec, scdldr);
                                   /* get some information about the devices */
    xsetxsdf();

    xdskinfo(xsdev, &xsdsk, SOURCE);

    xdskinfo(xddev, &xddsk, DEST);

    if(xddsk.dsk_1stsect < 1)           /* does DEST disk have BOOT record ? */
        xferr(XFERR021, 0, (UR_SOURCE | UR_FORMAT));         /* error if not */

                                              /* check if source file exists */
    xdopmpt(SOURCE, TRUE);
    flags = (LUF_FCAS|LDF_SYS);

    if((xmcb->retcode = s_lookup(DF_INFO, flags, xsspec,
      &xdf, (LONG)sizeof(xdf), (LONG)sizeof(xdf), (LONG)0)) < SUCCESS)
    {
        xmcb->pptr[PARM4] = cc0305;
        xferr(XFERR005, S_LOOKUP, xmcb->retcode);          /* S_LOOKUP error */
    }
    if(xmcb->retcode < 1)
    {
        xchgfnam(xsspec, icdldr);
        if((xmcb->retcode = s_lookup(DF_INFO, flags, xsspec, &xdf,
          (LONG)sizeof(xdf), (LONG)sizeof(xdf), (LONG)0)) < 1)
        {
	    if(!xmcb->retcode)
		xmcb->retcode = (UR_SOURCE | UR_INTERNAL);
            xmcb->pptr[PARM4] = cc0305;
            xferr(XFERR005,S_LOOKUP,xmcb->retcode);    /* src file not found */
        }
        imode = TRUE;                        /* BLOAD286.IMG - bootable image */
    }


    if(imode)
    {
	xrdboot();	     /* read the src bootrec to get code & data info */

    }

    else			    /* BLOAD286.SYS - non-bootable image xfer */
    {                     /* read the srcfile header to get code & data info */

        flags = (OPF_PMNT|OPF_RD|OPF_SHAR|OPF_SHRD|OPF_FCAS);
        if((xsfnum = s_open(flags,xsspec)) < SUCCESS)
            xferr(XFERR002, S_OPEN, xsfnum);
        xsfopen = TRUE;


        sfi.bufptr = (BYTE *)&xshdr;
        sfi.bufsiz = (LONG)sizeof(xshdr);
        xreads(&sfi);                             /* read the srcfile header */
                                                 /* check some header values */
        s_close(0x0000, xsfnum);
        xsfopen = FALSE;

#if P286
        if((LONG)(sizeof(xshdr)+xshdr.h86_clen+xshdr.h86_dlen) > xdf.df_size)
            xferr(XFERR003, 0, (UR_SOURCE | UR_FORMAT));     /* file 2 small */
#endif

#if P68K
        if((LONG)(sizeof(xshdr)+xshdr.h68_clen+xshdr.h68_dlen) > xdf.df_size)
            xferr(XFERR003, 0, (UR_SOURCE | UR_FORMAT));     /* file 2 small */
        if((xshdr.h68_signature[0] != H68KSIG1) ||
          (xshdr.h68_signature[1] != H68KSIG2))
            xferr(XFERR003, 0, (UR_SOURCE | UR_FORMAT));          /* bad hdr */
#endif

        if(sfi.eoflag)
            xferr(XFERR003, 0, (UR_SOURCE | UR_FORMAT));        /* early eof */
    }

                 /* calculate pad sizes and # of FAT entries for system file */

#if P286
    dpadsiz = (xshdr.h86_clen % xddsk.dsk_sectsize) ?
      xddsk.dsk_sectsize - (xshdr.h86_clen % xddsk.dsk_sectsize) : 0;
    spadsiz = (xshdr.h86_clen % xsdsk.dsk_sectsize) ?
      xsdsk.dsk_sectsize - (xshdr.h86_clen % xsdsk.dsk_sectsize) : 0;
    nfe = (xshdr.h86_clen + dpadsiz + xshdr.h86_dlen);
#endif

#if P68K
    dpadsiz = (xshdr.h68_clen % xddsk.dsk_sectsize) ?
      xddsk.dsk_sectsize - (xshdr.h68_clen % xddsk.dsk_sectsize) : 0;
    spadsiz = (xshdr.h68_clen % xsdsk.dsk_sectsize) ?
      xsdsk.dsk_sectsize - (xshdr.h68_clen % xsdsk.dsk_sectsize) : 0;
    nfe = (xshdr.h68_clen + dpadsiz + xshdr.h68_dlen);
#endif

    i = (nfe % xddsk.dsk_sectsize);
    nfe /= xddsk.dsk_sectsize;
    if(i)
        ++nfe;
    i = (nfe % xddsk.dsk_spb);
    nfe /= xddsk.dsk_spb;
    if(i)
        ++nfe;


                                                  /* set non-buffer xfi info */
    xstxfi();

                                          /* Now create the destination file */
    xcreatd( xfi.recsiz, xfi.protct, nfe );


    xdopmpt(SOURCE, TRUE);
    xsrcalloc();	                             /* allocate file buffer */

    if(!xsdf)
    {
        flags = (OPF_PMNT|OPF_RD|OPF_SHAR|OPF_SHRD|OPF_FCAS);
        if((xsfnum = s_open(flags,xsspec)) < SUCCESS)
            xferr(XFERR002, S_OPEN, xsfnum);
        xsfopen = TRUE;
        flags = (OPF_PMNT|OPF_WRT|OPF_FCAS);
        if((xdfnum = s_open(flags, xdspec)) < SUCCESS)
            xferr(XFERR012, S_OPEN, xdfnum);         /* dstfile S_OPEN error */
        xdfopen = TRUE;
    }

    write_loc = 0L;          /* Start at begining of BLOAD286.IMG space */
  
    if(!imode)                      /* BLOAD286.SYS - non-bootable image xfer */
    {                        /* xfer the code section, padding for dest disk */
                                                    /* xfer the data section */

                                                 /* transfer the code module */

#if P286
        siz = xshdr.h86_clen;
#endif

#if P68K
        siz = xshdr.h68_clen;
#endif


        while(siz && (!sfi.eoflag))
        {
            sfi.bufptr = xfi.bufptr;
            sfi.bufsiz = (xfi.bufsiz < siz) ? xfi.bufsiz : siz;
            xreads(&sfi);
            xwrited( xfi.bufptr, sfi.nbytes, 0 );   /* Write absolute */
            siz -= sfi.nbytes;
        }
        if(sfi.eoflag)
            xferr(XFERR003, 0, (UR_SOURCE | UR_FORMAT));        /* early eof */

        if(dpadsiz)                                      /* add dest padding */
        {
            mpb.mpb_start = (LONG)xfi.bufptr;
            mpb.mpb_minact = mpb.mpb_max = (LONG)dpadsiz;
            if((xmcb->retcode = s_malloc(SMO_XPND, &mpb)) < SUCCESS)
                xferr(XFERR004, S_MALLOC, xmcb->retcode);
            sfi.bufptr = (BYTE *)mpb.mpb_start;
	    xmp1 = mpb.mpb_start;
            for(sfi.nbytes=0; sfi.nbytes<dpadsiz; ++sfi.bufptr, ++sfi.nbytes)
                *sfi.bufptr = 0x00;
            xwrited( mpb.mpb_start, sfi.nbytes, 0 );   /* write absolute */
            s_mfree(mpb.mpb_start);
        }

                                                 /* transfer the data module */
        while(!sfi.eoflag)
        {
            sfi.bufptr = xfi.bufptr;
            sfi.bufsiz = xfi.bufsiz;
            xreads(&sfi);
            xwrited( xfi.bufptr, sfi.nbytes, 0 );   /* write absolute */
        }

    }
    if(imode)                           /* BLOAD286.IMG - bootable image xfer */
    {                        /* xfer the code section, padding for dest disk */
                                       /* read and strip padding from source */
                                                    /* xfer the data section */

                                                 /* transfer the code module */

#if P286
        siz = xshdr.h86_clen;
#endif

#if P68K
        siz = xshdr.h68_clen;
#endif

        while(siz && (!sfi.eoflag))
        {
            sfi.bufptr = xfi.bufptr;
            sfi.bufsiz = (xfi.bufsiz < siz) ? xfi.bufsiz : siz;
            xreads(&sfi);
            xwrited( xfi.bufptr, sfi.nbytes, 0 );   /* write absolute */
            siz -= sfi.nbytes;
        }
        if(sfi.eoflag)
            xferr(XFERR003, 0, (UR_SOURCE | UR_FORMAT));        /* early eof */


        if(spadsiz)                                  /* strip source padding */
        {
            siz = spadsiz;
            while(siz && (!sfi.eoflag))
            {
                sfi.bufptr = xfi.bufptr;
                sfi.bufsiz = (xfi.bufsiz < siz) ? xfi.bufsiz : siz;
                xreads(&sfi);
                siz -= sfi.nbytes;
            }
            if(sfi.eoflag)
                xferr(XFERR003, 0, (UR_SOURCE | UR_FORMAT));    /* early eof */
        }

        if(dpadsiz)                                      /* add dest padding */
        {
            mpb.mpb_start = (LONG)xfi.bufptr;
            mpb.mpb_minact = mpb.mpb_max = (LONG)dpadsiz;
            if((xmcb->retcode = s_malloc(SMO_XPND, &mpb)) < SUCCESS)
                xferr(XFERR004, S_MALLOC, xmcb->retcode);
            sfi.bufptr = (BYTE *)mpb.mpb_start;
	    xmp1 = mpb.mpb_start;
            for(sfi.nbytes=0; sfi.nbytes<dpadsiz; ++sfi.bufptr, ++sfi.nbytes)
                *sfi.bufptr = 0x00;
            xwrited( mpb.mpb_start, sfi.nbytes, 0 );  /* write absolute */
            s_mfree(mpb.mpb_start);
        }

                                                 /* transfer the data module */
        while(!sfi.eoflag)
        {
            sfi.bufptr = xfi.bufptr;
            sfi.bufsiz = xfi.bufsiz;
            xreads(&sfi);
            xwrited( xfi.bufptr, sfi.nbytes, 0 );  /* write absolute */
        }

    }

    if(!xsdf)
    {
        s_close(0x0000, xsfnum);
        xsfopen = FALSE;
        s_close(0x0000, xdfnum);
        xdfopen = FALSE;
    }

    xsetattrib();                                      /*set file attributes */

                                           /* free up the system file buffer */
    s_mfree(xfi.bufptr);
                                            /* patch destination boot record */
    xfixboot();

    utprnmsg(cc0802, xmcb->pptr, STDOUT);		     /* loaders done */
							 /* xfer system file */
    xferfile(sf, sfile);

    utprnmsg(cc0800, xmcb->pptr, STDOUT);		 /* System file done */

                           /* system file done, now do all SYS&HID&R/O files */
    xxfrfils(sf);

                                                        /* return successful */
    xmcb->dosfunc = 0;
    xmcb->retcode = SUCCESS;
    xmcb->utilcode = XFERR000;
                                                          /* utxfrsys return */
xfexit:

    return(xmcb->utilcode);
}

/* local utility procedures */

/* xxfrfils() : transfers all SYS&HID&R/O files */

VOID xxfrfils(sf)

REG BYTE	*sf;

{

    REG UWORD	flags;
    LONG        lkey, filefound;

    lkey = 0;
    filefound = 1;
    while(filefound)
    {
        xdopmpt(SOURCE, TRUE);
        flags = (LUF_FCAS | LDF_SYS | LDF_EXN);
        xchgfnam(xsspec, wildfile);
        if((filefound = s_lookup(DF_INFO, flags, xsspec, &xdf,
          (LONG)sizeof(xdf), (LONG)sizeof(xdf), lkey)) < SUCCESS)
        {
            xmcb->pptr[PARM4] = cc0305;
            xferr(XFERR005, S_LOOKUP, filefound);
        }
        if(!filefound)
            break;
        lkey = xdf.df_lookid;
        flags = (FA_READ | FA_HIDE | FA_SYS);
        if((xdf.df_attrib & flags) ^ flags)
            continue;            /* skip if not hidden system read-only file */
        if((!strcmp(xdf.df_name, scdldr)) || (!strcmp(xdf.df_name, icdldr)) ||
          (!strcmp(xdf.df_name, sf)))
            continue;                           /* skip if system image file */

	xferfile(xdf.df_name, xdf.df_name);
    }
}

/* xferfile() : straight file transfer */

VOID xferfile(sname, dname)
REG	BYTE	*sname, *dname;
{
    REG	UWORD	flags;
	SFI	sfi;

    xchgfnam(xsspec, sname);
    xchgfnam(xdspec, dname);

    xdopmpt(SOURCE, TRUE);
    if((xmcb->retcode = s_lookup(DF_INFO, (LUF_FCAS | LDF_SYS), xsspec,
      &xdf, (LONG)sizeof(xdf), (LONG)sizeof(xdf), (LONG)0)) <= 0)
    {
	xmcb->pptr[PARM4] = cc0305;
	xferr(XFERR005, S_LOOKUP, xmcb->retcode);
    }

    xsrcalloc();

    xmcb->pptr[PARM2] = sname;
    utprnmsg(cc0801, xmcb->pptr, STDOUT);

    xcreatd( xfi.recsiz, xfi.protct, 0 );

    sfi.soff = 0;
    sfi.eoflag = FALSE;

    if(!xsdf)
    {
        flags = (OPF_PMNT|OPF_RD|OPF_SHAR|OPF_SHRD|OPF_FCAS);
        if((xsfnum = s_open(flags,xsspec)) < SUCCESS)
            xferr(XFERR002, S_OPEN, xsfnum);
        xsfopen = TRUE;

        flags = (OPF_PMNT|OPF_WRT|OPF_FCAS);
        if((xdfnum = s_open(flags, xdspec)) < SUCCESS)
            xferr(XFERR012, S_OPEN, xdfnum);     /* dstfile S_OPEN error */
        xdfopen = TRUE;
    }

    while(!sfi.eoflag)
    {
        sfi.bufptr = xfi.bufptr;
        sfi.bufsiz = xfi.bufsiz;
        xreads(&sfi);
        xwrited( xfi.bufptr, sfi.nbytes, WRF_END );  /* write to EOF */
    }

    if(!xsdf)
    {
        s_close(0x0000, xsfnum);
        xsfopen = FALSE;
        s_close(0x0000, xdfnum);
        xdfopen = FALSE;
    }

    xsetattrib();                                  /*set file attributes */
                                       /* free up the system file buffer */
    s_mfree(xfi.bufptr);
}

/* xsetxsdf() : set XSDF flag (accesses device-dependant info only) */

VOID xsetxsdf()
{

    DISK        dsk;

    xsdf = FALSE;
    if((xsfnum = s_open(0x0000,xsdev)) < SUCCESS) /* 12/02/85-reb	*/
    {
        xmcb->pptr[PARM1] = xlsdev;
        xferr(XFERR007, S_OPEN, xsfnum);
    }
    xsfopen = TRUE;
    if((xmcb->retcode =
      s_get(DISK_INFO,xsfnum,&dsk,(LONG)sizeof(dsk))) < SUCCESS)
    {
        xmcb->pptr[PARM4] = cc0306;
        xferr(XFERR001, S_GET, xmcb->retcode);
    }
    s_close(0x0000, xsfnum);
    xsfopen = FALSE;
                                       /* see if disk swapping is neccessary */
    if(!(strcmp(xsdev, xddev)))                           /* xsdev = xddev ? */
    {
        xsdf = TRUE;                                       /* set flag if so */
        if(!(dsk.dsk_type & DTP_RMV))              /* media is non-removable */
            xferr(XFERR006, 0, (UR_SOURCE | UR_PARM));
    }
}

/* xdskinfo() : get device info */

VOID xdskinfo(dev, dsk, flag)

REG BYTE	*dev;
REG DISK	*dsk;
REG BOOLEAN	flag;

{

    FILENUM     fntbl;

    xdopmpt(flag, TRUE);
    if((xsfnum = s_open((OPF_PMNT|OPF_SHAR|OPF_FCAS), dev)) < SUCCESS)
    {
        xmcb->pptr[PARM1] = (flag) ? xlsdev : xlddev;
        xferr(XFERR007, S_OPEN, xsfnum);
    }
    xsfopen = TRUE;
    if((xmcb->retcode =
      s_get(FNUM_INFO,xsfnum,&fntbl,(LONG)sizeof(fntbl))) < SUCCESS)
    {
        xmcb->pptr[PARM4] = cc0312;
        xferr(XFERR001, S_GET, xmcb->retcode);          /* error on FNUM get */
    }
    if(fntbl.fn_table != DISK_INFO)             /* error if not a dsk device */
    {
        xmcb->pptr[PARM1] = (flag) ? xlsdev : xlddev;
        xferr(XFERR008, 0, (UR_SOURCE | UR_PARM));
    }
    if((xmcb->retcode =
      s_get(DISK_INFO,xsfnum,dsk,(LONG)sizeof(*dsk))) < SUCCESS)
    {
        xmcb->pptr[PARM4] = cc0306;
        xferr(XFERR001, S_GET, xmcb->retcode);
    }
    s_close(0x0000, xsfnum);
    xsfopen = FALSE;
}

/* xsrcalloc() : get srcinfo, alloc a buffer and set xfi buffer info */

VOID xsrcalloc()
{

    LONG        rs;
    MPB         mpb;

    xstxfi();
    rs = (xfi.recsiz == 0) ? (LONG)1 : (LONG)xfi.recsiz;
                                      /* allocate a buffer for the file xfer */
    mpb.mpb_start = 0;
    mpb.mpb_minact = rs;
    mpb.mpb_max = (xfi.sfsize > FMAX) ? FMAX : xfi.sfsize;
    if((xmcb->retcode = s_malloc(SMO_NEW, &mpb)) < SUCCESS)
        xferr(XFERR004, S_MALLOC, xmcb->retcode);
                                           /* set the xfi (XFINFO) structure */
    xfi.bufptr = (BYTE *)mpb.mpb_start;
    xfi.bufsiz = mpb.mpb_minact - (mpb.mpb_minact % rs);
    xmp2 = mpb.mpb_start;
}

/* xstxfi() : set non-buffer xfi info */

VOID xstxfi()
{
    xfi.recsiz = xdf.df_recsize;
    xfi.protct = xdf.df_protect;
    xfi.sfsize = xdf.df_size;
}

/* xcreatd() : create the destination file */

VOID xcreatd(rs, pt, nfe)

REG WORD	rs, pt, nfe;

{

    REG WORD	i, flags;
    WORD        cflags;
    BOOLEAN     fs;
    LONG        fnum, fatsize, fatoff;
    MPB         mpb;
    MDF		mdf;
    LONG        bsize;      /* Loader output file size in bytes */
					 /* prompt for destination if needed */
    xdopmpt(DEST, TRUE);
						     /* pre-delete dest file */
    if((fnum = s_open((OPF_PMNT|OPF_DEL|OPF_FCAS),
      xdspec)) >= SUCCESS)
    {
	if(s_get(DF_INFO, fnum, &mdf, (LONG)sizeof(mdf)) >= SUCCESS)
	{
	    mdf.mdf_attrib &= ~FA_READ;
	    s_set(DF_INFO, fnum, &mdf, (LONG)sizeof(mdf));
	}
	s_close(0x0000, fnum);
    }

    s_delete(DLF_FCAS, xdspec);

    cflags = 0;                           /* Set up contig or not */
    if ( nfe ) {                          /* need to check the FAT table ? */
        bsize   = (LONG)nfe *                  /* Caluculate size of output*/ 
                  (LONG)xddsk.dsk_sectsize *   /* loader in bytes. */
                  (LONG)xddsk.dsk_spb;
        cflags  |= CRF_CONT;                   /* Make loader contig */ 
    } else
       bsize    = 0L;
 
    if ( nfe ) {
        fatsize = xddsk.dsk_nfrecs * xddsk.dsk_sectsize;

	if(fatsize > 65536)
	    xferr(XFERR021, 0, (UR_SOURCE | UR_FORMAT));

        fatoff = xddsk.dsk_1stsect * xddsk.dsk_sectsize;
        fs = (xddsk.dsk_format == DFM_DOS2) ? TRUE : FALSE;

        mpb.mpb_start = 0;
        mpb.mpb_minact = mpb.mpb_max = fatsize;
        if((xmcb->retcode = s_malloc(SMO_NEW, &mpb)) < SUCCESS)
            xferr(XFERR004, S_MALLOC, xmcb->retcode);

        flags = (OPF_PMNT | OPF_WRT | OPF_RD | OPF_FCAS);
        if((xdfnum = s_open(flags, xddev)) < SUCCESS)
	{
	    s_mfree(mpb.mpb_start);
            xferr(XFERR009, S_OPEN, xdfnum);
	}
        xdfopen = TRUE;

        if((xmcb->retcode =
          s_read(RDF_BEG,xdfnum,mpb.mpb_start,fatsize,fatoff)) != fatsize)
	{
	    s_mfree(mpb.mpb_start);
            xferr(XFERR010, S_READ, xmcb->retcode);
	}

        s_close(0x0000, xdfnum);
        xdfopen = FALSE;

        for(i = FILE_FAT; i < nfe + FILE_FAT; ++i)
	{
            if(utgtvfat((BYTE *)mpb.mpb_start, (WORD)i, fs) != FREE_FAT)
	    {
		s_mfree(mpb.mpb_start);
                xferr(XFERR011, 0, (UR_SOURCE | UR_FORMAT));
	    }
	}
                                                   /* free up the FAT buffer */
        s_mfree(mpb.mpb_start);
    }
                                                     /* create the dest file */
    cflags |= ( CRF_WRT | CRF_FDEL | CRF_SEC | CRF_FCAS );
    if(
       ( xdfnum=s_create(CRO_NRML,cflags,xdspec,rs,pt,bsize)
      ) < SUCCESS)
        xferr(XFERR012, S_CREATE, xdfnum);       /* return dest S_CREATE err */
    s_close(0x0000, xdfnum);                              /* close dest file */
    xxferflg = TRUE;
}

/* xreads() : read the source file */

VOID xreads(sfi)

REG SFI		*sfi;

{

    REG WORD	flags;

    sfi->nbytes = 0;
    if(xsdf)
    {
        xdopmpt(SOURCE, TRUE);		    /* get source diskette if needed */
        flags = (OPF_PMNT|OPF_RD|OPF_SHAR|OPF_SHRD|OPF_FCAS);
        if((xsfnum = s_open(flags,xsspec)) < SUCCESS)
            xferr(XFERR002, S_OPEN, xsfnum);
        xsfopen = TRUE;
    }
                                                                /* read loop */
    while((sfi->bufsiz) && (!sfi->eoflag)) /* read til buffull, EOF or error */
    {
        if((xmcb->retcode =
          s_read(RDF_BEG,xsfnum,sfi->bufptr,
          sfi->bufsiz,sfi->soff)) < SUCCESS)
        {
						             /* was it EOF ? */
            if((WORD)(xmcb->retcode & 0x0000ffffL) == E_EOF)
            {
                sfi->eoflag = TRUE;                        /* set flag if so */
                continue;                            /* exit read while loop */
             }
            else
                xferr(XFERR013, S_READ, xmcb->retcode);        /* read error */
        }
        sfi->soff += xmcb->retcode;                /* update the read offset */
        sfi->nbytes += xmcb->retcode;               /* update the read count */
        sfi->bufptr += xmcb->retcode;              /* update the read bufptr */
        sfi->bufsiz -= xmcb->retcode;                   /* update the bufsiz */
    }
    if(xsdf)
    {
        s_close(0x0000, xsfnum);                      /* close up the source */
        xsfopen = FALSE;
    }
}

/* xwrited() : write to destination file */

VOID xwrited( bufptr, nbytes, flg )

REG BYTE	*bufptr;
LONG		nbytes;
WORD            flg;      /* File write flag for absolute or EOF relative */
{

    REG WORD	flags;

    if(nbytes)
    {
        if(xsdf)
        {
            xdopmpt(DEST, TRUE);
            flags  = (OPF_PMNT|OPF_WRT|OPF_FCAS);
            xdfnum = s_open(flags, xdspec);
            if ( xdfnum < SUCCESS )
                xferr(XFERR012, S_OPEN, xdfnum);     /* dstfile S_OPEN error */
            xdfopen = TRUE;
        }
                                                               /* write loop */
        while(nbytes)                  /* while something valid to write ... */
        {
            if ( flg == WRF_END) {
               xmcb->retcode = s_write( 
                                        WRF_END, xdfnum, 
                                        bufptr, nbytes,
                                        0L );
            } else {
               xmcb->retcode = s_write(
                                        0, xdfnum, 
                                        bufptr, nbytes, 
                                        write_loc );
               write_loc += xmcb->retcode; 
            }
            if (xmcb->retcode < SUCCESS)                    /* write error ? */
                xferr(XFERR014, S_WRITE, xmcb->retcode);     /* report error */
            nbytes -= xmcb->retcode;            /* decrement amount to write */
            bufptr += xmcb->retcode;                        /* update bufptr */
        }
        if(xsdf)
        {
            s_close(0x0000, xdfnum);               /* close up the dest file */
            xdfopen = FALSE;
        }
    }
}

/* xfixboot() : patch xshdr info into BOOTREC */
VOID xfixboot()
{
    REG WORD	i;
    REG	LONG	size;
    REG	BOOTREC	*sbr, *dbr;
    REG	BYTE	*s, *d;
    MPB         mpb;
                                                        /* allocate a buffer */
    wlbase.clbase = lbase;
    dbr = wlbase.blbase;
    size = (xsdsk.dsk_sectsize < sizeof(*dbr)) ?
           (LONG)sizeof(*dbr) : (LONG)xsdsk.dsk_sectsize;

    mpb.mpb_start = 0;
    mpb.mpb_minact = mpb.mpb_max = size;
    if((xmcb->retcode = s_malloc(SMO_NEW, &mpb)) < SUCCESS)
        xferr(XFERR004, S_MALLOC, xmcb->retcode);
    sbr = (BOOTREC *)mpb.mpb_start;
    xmp3 = mpb.mpb_start;

                                          /* get and open destination device */
    xdopmpt(DEST, TRUE);
    if((xdfnum = s_open((OPF_PMNT|OPF_RD|OPF_WRT|OPF_FCAS), xddev)) < SUCCESS)
        xferr(XFERR009, S_OPEN, xdfnum);
    xdfopen = TRUE;
                                                         /* read the BOOTREC */
    if((xmcb->retcode = s_read(RDF_BEG,xdfnum,sbr,size,(LONG)0)) != size)
        xferr(XFERR015, S_READ, xmcb->retcode);
                                                  /* get new bootrec entries */
    s = sbr->br_oemname;
    d = dbr->br_oemname;
    for(i = 0; i < BPBXFER; ++i)
	*d++ = *s++;
				  /* special attention to DRI BPB extensions */
    if(!(sbr->br_hidesecs & 0xffff0000L))
	dbr->br_hidesecs = (WORD)sbr->br_hidesecs;
    dbr->br_filestart = (dbr->br_hidesecs + sbr->br_rsvdsecs +
      (sbr->br_nfats * sbr->br_fsecs) +
      ((sbr->br_dirsize * BPDE) / sbr->br_ssize));
    if(sbr->br_nsectors)
	dbr->br_drinsecs = (LONG)(sbr->br_nsectors & 0x0000ffffL);

#if P286
    dbr->br_cbase = xshdr.h86_cbase;
    dbr->br_clen = xshdr.h86_clen;
    dbr->br_dbase = xshdr.h86_dbase;
    dbr->br_dlen = xshdr.h86_dlen;
#endif

#if P68K
    dbr->br_cbase = xshdr.h68_cbase;
    dbr->br_clen = xshdr.h68_clen;
    dbr->br_dbase = xshdr.h68_dbase;
    dbr->br_dlen = xshdr.h68_dlen;
#endif
                                                        /* write the BOOTREC */
    if((xmcb->retcode =
      s_write(WRF_BEG,xdfnum,dbr,size,(LONG)0)) != size)
        xferr(XFERR016, S_WRITE, xmcb->retcode);

    s_close(0x0000, xdfnum);                             /* close the device */
    xdfopen = FALSE;
                                               /* free up the bootrec buffer */
    s_mfree(mpb.mpb_start);
}

/* xrdboot() : read src bootrec and get code/data info */
VOID xrdboot()
{

    LONG	size;
    MPB         mpb;
    REG BOOTREC	*sbr;

    size =
      (xsdsk.dsk_sectsize < sizeof(*sbr)) ? sizeof(*sbr) : xsdsk.dsk_sectsize;
                                                        /* allocate a buffer */
    mpb.mpb_start = 0;
    mpb.mpb_minact = mpb.mpb_max = size;
    if((xmcb->retcode = s_malloc(SMO_NEW, &mpb)) < SUCCESS)
        xferr(XFERR004, S_MALLOC, xmcb->retcode);
    sbr = (BOOTREC *)mpb.mpb_start;
    xmp3 = mpb.mpb_start;
                                               /* get and open source device */
    xdopmpt(SOURCE, TRUE);
    if((xsfnum = s_open((OPF_PMNT|OPF_RD|OPF_FCAS), xsdev)) < SUCCESS)
        xferr(XFERR017, S_OPEN, xsfnum);
    xsfopen = TRUE;
                                                         /* read the BOOTREC */
    if((xmcb->retcode =
      s_read(RDF_BEG,xsfnum,sbr,size,(LONG)0)) != size)
        xferr(XFERR018, S_READ, xmcb->retcode);


#if P286
    xshdr.h86_cbase = sbr->br_cbase;
    xshdr.h86_clen = sbr->br_clen;
    xshdr.h86_dbase = sbr->br_dbase;
    xshdr.h86_dlen = sbr->br_dlen;
#endif

#if P68K
    xshdr.h68_cbase = sbr->br_cbase;
    xshdr.h68_clen = sbr->br_clen;
    xshdr.h68_dbase = sbr->br_dbase;
    xshdr.h68_dlen = sbr->br_dlen;
#endif

    s_close(0x0000, xsfnum);                             /* close the device */
    xsfopen = FALSE;
                                               /* free up the bootrec buffer */
    s_mfree(mpb.mpb_start);
}

/* xdopmpt() : prompt for a diskette if needed */

VOID xdopmpt(sd, flag)

REG BOOLEAN sd;			  /* flag for desired diskette (SOURCE/DEST) */
REG BOOLEAN flag;		/* flag is FALSE if in error exit, else TRUE */

{

    REG BYTE	*ldev;

    if(xsdf && (xcdf != sd))        /* if src==dst && current != desired ... */
    {
        if(sd == SOURCE)
        {
            xmcb->pptr[PARM5] = cc0578;
            xmcb->pptr[PARM6] = ldev = xlsdev;
        }
        else
        {
            xmcb->pptr[PARM5] = cc0579;
            xmcb->pptr[PARM6] = ldev = xlddev;
        }
        if((xmcb->utilcode = utp4dsk(cc0480, ldev, xmcb)) != 0)
	    if(flag)
		xferr(xmcb->utilcode+XPDSKOFF, xmcb->dosfunc, xmcb->retcode);
        xcdf = sd;                                  /* set current = desired */
    }
}

/* xchgfnam() : change file name in spec */

VOID xchgfnam(s, n)

REG BYTE	*s, *n;

{

    REG BYTE	*t;

    t = (BYTE *)(s + utslen(s));
    while((t>=s) && (*t!=dir1delim) && (*t!=dir2delim) && (*t!=devdelim))
        --t;
    *++t = NULL;
    strcat(s, n);
}

/* xsetattrib() : set file attributes (& time and date info) */

VOID xsetattrib()

{

    DISKFILE    df;

    xdopmpt(DEST, TRUE);
    if((xdfnum = s_open((OPF_PMNT|OPF_FCAS|OPF_WRT|OPF_DEL), xdspec)) < SUCCESS)
        xferr(XFERR012, S_OPEN, xdfnum);
    xdfopen = TRUE;

    if((xmcb->retcode = s_get(DF_INFO, xdfnum, &df,
      (LONG)sizeof(df))) < SUCCESS)
    {
        xmcb->pptr[PARM4] = cc0305;
        xferr(XFERR019, S_GET, xmcb->retcode);
    }

    df.df_attrib |= (FA_READ | FA_HIDE | FA_SYS);

    df.df_dostime = xdf.df_dostime;
    df.df_dosdate = xdf.df_dosdate;
    df.df_modyear = xdf.df_modyear;
    df.df_modmonth = xdf.df_modmonth;
    df.df_modday = xdf.df_modday;
    df.df_modhr = xdf.df_modhr;
    df.df_modmin = xdf.df_modmin;
    df.df_modsec = xdf.df_modsec;

    if((xmcb->retcode = s_set(DF_INFO, xdfnum, &df,
      (LONG)sizeof(df))) < SUCCESS)
    {
        xmcb->pptr[PARM4] = cc0305;
        xferr(XFERR019, S_SET, xmcb->retcode);
    }

    s_close(0x0000, xdfnum);
    xdfopen = xxferflg = FALSE;
}

/* xferr() : set mcb for XFERRxxx */

VOID xferr(xf, df, dc)

REG WORD	xf, df;
LONG		dc;

{
    if(xsfopen)
        s_close(0x0000, xsfnum);                 /* close anything left open */
    xsfopen = FALSE;

    if(xdfopen)
        s_close(0x0000, xdfnum);                 /* close anything left open */
    xdfopen = FALSE;

    if(xxferflg)					  /* xfer incomplete */
    {
	xdopmpt(DEST, FALSE);
	s_delete(DLF_FCAS, xdspec);
    }

    xmcb->utilcode = xf;
    xmcb->dosfunc = df;
    xmcb->retcode = dc;

    switch(xf)
    {
        case XFERR002:
        case XFERR003:
        case XFERR005:
        case XFERR013:
xmcb->pptr[PARM1] = xsspec;
            break;

        case XFERR009:
        case XFERR010:
        case XFERR011:
        case XFERR015:
        case XFERR016:
        case XFERR020:
        case XFERR021:
            xmcb->pptr[PARM1] = xlddev;
            if(xf == XFERR020)
                xmcb->pptr[PARM2] = xsspec;
            break;

        case XFERR012:
        case XFERR014:
        case XFERR019:
            xmcb->pptr[PARM1] = xdspec;
            break;

        case XFERR017:
        case XFERR018:
            xmcb->pptr[PARM1] = xlsdev;
            break;

    }
						     /* free up just in case */
    s_mfree(xmp1);
    s_mfree(xmp2);
    s_mfree(xmp3);

    utfarjmp(xjmpbuf, (LONG)xf);
}

