### FlexOS 386 System Makefile
### High C version
#############################################################
##                                                         ##
##    Execute this Makefile from the directory where all   ##
##    the FlexOS system source and object modules are      ##
##    located....                                          ##
##                                                         ##
##    This make file will create a "new"                   ##
##    FLEXOS.SYS every time it is executed.                ##
##                                                         ##
##    Execute on the command line :                        ##  
##                                                         ##
##         MAKE -F FLEX386.MAK                             ##
##                                                         ##
#############################################################
#####################################
##                                 ##
##    Compile time definitions.    ##
##                                 ##
#####################################D
HCPRO 	=  -pro system.pro -def
################################
##                            ##
##    Set the Code segments   ##
##                            ##
################################
MKKERN 	=  $HCPRO kern
MKLOADER=  $HCPRO loader
MKPRM 	=  $HCPRO prm
MKCRM 	=  $HCPRO crm
MKCONF 	=  $HCPRO conf
MKMRM 	=  $HCPRO mrm
MKFS 	=  $HCPRO drm
MKFLOP 	=  $HCPRO floppy
MKGMAN	=  $HCPRO gman
MKSYS 	=  $HCPRO sys
MKPDRV 	=  $HCPRO pdrv
MKYDK	=  $HCPRO hdisk
MKFE	=  $HCPRO fe
MKOTHER =  $HCPRO other
###################################
##                               ##
##    Create the FlexOS system.  ##
##                               ############################
##                                                         ##
##    To reduce the amount of time it takes to run this    ##
##    makefile,  remove the MAKE commands of those files   ##
##    you don't need to re-generate.                       ##
##                                                         ##
#############################################################
system :	bootload.sys \
		disp386.obj config.obj aconf386.obj clock.obj clockat.obj

 make -f cnfglib.mak
 make -f hd.mak
 make -f sdrv.mak
 make -f rnetdrv.mak
 make -f mdrv.mak
 make -f ramdsk.mak
 make -f printint.mak

 +-if exist kernel.mak make -f kernel.mak
 +-if exist miscrm.mak make -f miscrm.mak
 +-if exist piperm.mak make -f piperm.mak
 +-if exist conrm.mak  make -f conrm.mak
 +-if exist diskrm.mak make -f diskrm.mak
 +-if exist aelib386.mak make -f aelib386.mak

 link debug386[i]
 link boot386[i]
 fix bootprot.tmp flexos.sys

#######################
# System loader....   #
#######################
bootload.sys :	bootload.obj
 link bootload.tmp = bootload.obj[data[max[0],origin[0]]
 fix bootload.tmp bootload.sys /r

bootload.obj :	sysbuild.equ bootload.a86
 rasm86 bootload $$pzsz286

#######################
# LINKED in OBJs..... #
#######################
disp386.obj :	sysbuild.equ struct.equ segs.equ system.equ \
		panic.equ i386.equ \
		disp386.a86
 rasm86 disp386 $$pzszlo286

config.obj :	portab.h sysbuild.h system.h sup.h \
		dh.h flags.h struct.h baspag.h \
		panic.h protos.h \
		imc286.h config.h \
		config.c
 hc config $MKCONF

aconf386.obj :	sysbuild.equ struct.equ segs.equ panic.equ \
		system.equ i386.equ \
		aconf386.a86
 rasm86 aconf386 $$pzsz286

clock.obj :	portab.h sysbuild.h struct.h system.h \
		baspag.h protos.h \
		clock.c
 hc clock $MKKERN

clockat.obj :	sysbuild.equ struct.equ system.equ \
		clockat.a86
 rasm86 clockat $$pzsz286

