/************************************************************************
* hdasync.c								*
*	Asynchronous interface for the PC/AT hard			*
*	disk driver.							*
*************************************************************************
* Copyright (c) 1987 Digital Research Inc. All rights reserved. {proprietary} *
* The Software Code contained in this listing is proprietary to Digital       *
* Research Inc., Monterey, California, and is covered by U.S. and other       *
* copyright protection. Unauthorized copying, adaption, distribution, use or  *
* display is prohibited and may be subject to civil and criminal penalties.   *
* Disclosure to others is prohibited. For the terms and conditions of software*
* code use, refer to the appropriate Digital Research License Agreement.      *
*		U.S. GOVERNMENT RESTRICTED RIGHTS			       *
* This software product is provided with RESTRICTED RIGHTS.  Use, duplication *
* or disclosure by the Government is subject to restrictions as set forth in  *
* FAR 52.227-19 (c) (2) (June, 1987) when applicable or the applicable        *
* provisions of the DOD FAR supplement 252.227-7013 subdivision (b) (3) (ii)  *
* (May, 1981) or subdivision (c) (1) (ii) (May, 1987). Contractor/manufacturer*
* is Digital Research Inc. / 60 Garden Court / BOX DRI / Monterey, CA 93940.  *
*******************************************************************************
* Revision History:
* Date   Author SPR #	Comments
* 880128 reb		fix for errors in isr context.
* 880126 reb		added intermediate buffering to the write code
* 880122 reb		performance update.
* 871231 reb		Originated from consolidation of previous separate
* 			"C" files of the old version of the driver.
************************************************************************/

/************************************************************************
* File:		hdasync.c
*
* Description:	Consolidation of the asynchronous portions of the athd.drv
*		driver.
*
* Build Info:	See file hd.mak for the dependencies of this module.
*
* Overview:
*
************************************************************************/
#include    "portab.h"
#include    "hd.h"


/*
 *  code macros
 */

#define	MIN	_min
#define HDCBUSY         (inp( HDCSTAT ) & HDC_BSY)


/************************************************************************/
/*               Global Data						*/
/************************************************************************/

GLOBAL   EMASK  timemask[DKMAXUNITS] ;
GLOBAL   WORD   timeouts[HDMAXUNITS] ;	
GLOBAL   BOOLEAN pollevnt;	     	/* TRUE indicates adapter free	*/
GLOBAL   EMASK  pollmask ;                                  

#define tortry  10			

/************************************************************************/
/* HTF - array of task files, one for each phys unit.			*/
/************************************************************************/
HDTF    HTF[ DKMAXUNITS ] ;

/************************************************************************/
/* P2LM - Pysical to Logical mapping array				*/
/************************************************************************/
P2L    P2LM[ HDMAXUNITS ] ;

/************************************************************************/
/* HDTIMPB - parm block for watch dog timer call.			*/
/************************************************************************/
DKTIMPB HDTIMPB =
{
    1,                                              /* async 		*/
    0,                                              /* reserved 	*/
    0,                                              /* relative time 	*/
    0L,                                             /* swi address 	*/
    0L						/* time in milliseconds	*/
} ;

EXTERN	LONG	DriveSync[];

/************************************************************************/
/*                                                                      */
/*          Hard Disk Driver Low Level Interace                         */
/*                                                                      */
/*  code which interfaces the high level (logical drivers) to the low   */
/*  level routines and their primitives.  These routines run as         */
/*  synchronous routines, but should probably be called from async code,*/
/*  thus making them async routines (get it?).  They return...          */
/*                                                                      */
/*  Note that these are primitive (not smart) routines!  They assume    */
/*  that the caller knows what it is doing -- e.g., the caller won't    */
/*  try to perform an operation on a drive (physical unit) that is busy */
/*                                                                      */
/************************************************************************/
/************************************************************************/
/* hd_select -								*/
/*   The upper level routines call select to establish a connection	*/
/*   between the upper and lower level routines.			*/
/*									*/
/************************************************************************/
ERROR   hd_select( )
{
    return(E_SUCCESS) ;
}

/************************************************************************/
/*  hd_io -								*/
/*   starts the i/o request, is re-entered from hd_io1()		*/
/*   if there is any more left to do					*/
/*									*/
/************************************************************************/
ASR hd_io( u )
LUTE    *u ;
{
    HDTF    *f ;				/* hard disk task file	*/
    WORD    driveno,y ;				/* Local Drive Number	*/
    ERROR   r ;					/* Error / Return Value	*/

    driveno = (*u).lu_driveno ;
    P2LM[driveno].physlute = u ;		/* LUTE pointer		*/

    
    yGetHscAddr( &(*u).io_dkaddr , (*u).io_stssn , u ) ;

			/* number of sectors the controller can handle.	*/
    (*u).io_nsecs = _min( (*u).ld_mdb.md_sectrk, (*u).io_totnsecs ) ;

    y = (*u).lu_driveno ? 0 : 1 ;      	/* get index for the other unit	*/

    if ((*u).io_error) return(0);     	/* parachute clause timeouts etc*/

					/* syncing on seeks only	*/
    if ( ( (WORD)P2LM[y].seqisr == (WORD)seekisr) || 
	 ( (WORD)P2LM[y].seqisr == (WORD)dummyisr) )
    { 
			/* check the other phys drive for in read/write */

        f = &HTF[(*u).lu_unitno] ;
        hd_bldtf( f , u, driveno ) ;		/*  ;build task file	*/
				/* initialize the intermediate buffer	*/

        if ( P2LM[driveno].curcyl != (*u).io_dkaddr.hsc_cyl )
	{

            f->hd_cmd[6] = (HDCSEEK|P2LM[driveno].pudp->pu_step) ;

            P2LM[driveno].seqisr = seekisr ;

            if(  ! outputcmd( f )  )
	    {					/*  output command	*/
                P2LM[driveno].seqisr = dummyisr ;
                if(( r = doasr( hd_io , u , 0L, DKASRPRI )) < 0L)
		{
                    hd_terminate( u , r ) ;
                }
                return(0) ;
            }
	    hd_settimer(5000L,u) ;
            return(0) ;
        }
        else
	{
	    (*u).io_tbuff = (LONG)P2LM[driveno].tbuff ;
	    (*u).io_tnsecs = (*u).io_nsecs ;

					/* set discrete isr addr.	*/
            switch( (BYTE)(*u).io_op )
	    {
                case DKREAD:    P2LM[driveno].seqisr = readisr ;
                        break ;
                case DKWRITE:   P2LM[driveno].seqisr = writeisr ;
                        break ;
                case DKVERIFY:  P2LM[driveno].seqisr = verifyisr ;
                        break ;
            }
            if(( r = doasr( hd_startio , u , 0L, DKASRPRI  )) < 0L)
	    {
                hd_terminate( u , r ) ;
            }
            return (0);
        }
    }
    else
    {
		/* set up pollevent to wait completion of other unit	*/
        if(( pollmask = pollevent(hd_poll,NULLPTR)) < 0L)
	{
		hd_terminate( u , pollmask ) ;
        }
	else
	{
        	pollevnt = FALSE;		/* set adapter not free	*/
		nextasr( pollmask, hd_io, u, 2L, DKASRPRI );
	}
        return(0) ;
    }
}

/************************************************************************/
/* hd_io1 - gets execution after the interrupt from the actual i/o.	*/
/* determines if more to be done.					*/
/************************************************************************/
VOID    hd_io1(u)
LUTE    *u ;
{

    (*u).io_totnsecs -= (*u).io_nsecs ;
    (*u).io_stssn += (*u).io_nsecs ;

    if( (*u).io_error )
    {
        hd_iocompl(u) ;
    }
    else
    {
        if( (*u).io_totnsecs )
	{
            hd_io(u) ;
        }
        else
	{
            if( (BYTE)(*u).io_op == DKWRITE )
	    {
                if( (*u).lu_iflag & 0x0200 )
		{
                    (*u).io_op = DKVERIFY ;
                    (*u).io_totnsecs = (*u).io_savnsecs ;
                    (*u).io_stssn = (*u).io_savssn ;
                    hd_io( u ) ;
                    return ;
                }
            }
            hd_iocompl(u) ;
        }
    }
}

/************************************************************************/
/* hd_startio -								*/
/* If the controller is ready to accept read/write/verify then output	*/
/* the command else spin off new asr to retry.				*/
/************************************************************************/
ASR hd_startio( u )
LUTE    *u ;
{
    WORD    y ;
    HDTF    *f ;
    ERROR   r ;
    BYTE	*tbuff ;	/* temp buffer pointer for first sector	*/

    f = &HTF[(*u).lu_unitno] ;

    y = (*u).lu_driveno ? 0 : 1 ;	/* get index for the other unit	*/

    if (((WORD)P2LM[y].seqisr == (WORD)dummyisr)||
        ((WORD)P2LM[y].seqisr == (WORD)headisr) ||
        ((WORD)P2LM[y].seqisr == (WORD)seekisr))
    {
			/* check the other phys drive for in read/write */

        if ((*u).io_error) return(0) ;

        if(  ! outputcmd( f )  )
	{					/* output command	*/
            if(( r = doasr( hd_startio , u , 0L, DKASRPRI  )) < 0L)
	    {
                hd_terminate( u , r ) ;
            }
            return(0) ;
        }
        else
	{
            if( (BYTE)(*u).io_op == DKWRITE )
	    {

		/* have to wait for the DRQ bit due to the new set of WD1010s */
		while( !(inp( HDCSTAT) & HDC_DRQ) ) ;

					/* have to wet nurse 1st one	*/
                if( (*u).lu_flags & DKF_UADDR ) mapu( (*u).lu_b_pdaddr ) ;

			/* move this increment of data to the local buff*/
		_bmove((BYTE *)(*u).io_buffer,(BYTE *)(*u).io_tbuff,
		    (WORD) ( (*u).io_nsecs * (*u).ld_mdb.md_secsiz) ) ;

				/* save the local buffer pointer	*/
		tbuff = (BYTE *)(*u).io_tbuff ;

			/* skip the first sector since we write it here	*/
		(*u).io_tbuff += (*u).ld_mdb.md_secsiz ;

		outpstr( (LONG)tbuff, (*u).ld_mdb.md_secsiz) ;
            }
        }
    }
    else
    {
        if(( r = doasr( hd_startio , u , 0L, DKASRPRI)) < 0L)
	{
            hd_terminate( u , r ) ;
        }
        return (0);
    }
}

/************************************************************************/
/* hd_terminate - terminate the i/o request.				*/
/************************************************************************/
VOID    hd_terminate( u , r )
LUTE    *u;
ERROR   r ;
{
    (*u).io_error = r ;
    hd_iocompl( u ) ;
}

/************************************************************************/
/* hd_iocompl -								*/
/************************************************************************/
VOID    hd_iocompl( u )
LUTE    *u ;
{

    P2LM[(*u).lu_driveno].seqisr = dummyisr ;
    pollevnt = TRUE ;
    						/* error logging hook	*/
    flagset( (*u).lu_ioflagno , (*u).lu_pdaddr , (*u).io_error ) ;
    mxrel(DriveSync[(*u).lu_driveno]);
					/* reset global addresses	*/
}

/************************************************************************/
/* dummyisr - return false (no dispatch)				*/
/************************************************************************/
CNEAR	ISR dummyisr(drno)
WORD	drno ;
{
    return(drno ^= drno) ;
}

/************************************************************************/
/* hd_bldtf - build the task file and do some hardware manupulation.	*/
/************************************************************************/
VOID    hd_bldtf( hdtfp , u , driveno )
HDTF    *hdtfp ;
LUTE    *u ;
WORD	driveno ;
{

    BYTE    ss ;                        /* sector size indicator	*/
    BYTE    cmd ;                       /* controller specific cmd	*/
    BYTE    *tfptr ;                    /* pointer to current task file	*/

    tfptr = &hdtfp->hd_cmd[6] ;

		/* set hardware latch for 8 or 16 head hard disk option	*/
   
    if( P2LM[driveno].pudp->pu_nheads > 8 )
    {
        outp(HDCREG,HDC_H16) ;
    }
    else
    {
        outp(HDCREG,HDC_H8) ;
    }
						/* setup the task file */
    cmd = hcmdcode((BYTE)(*u).io_op) ;

    if( *tfptr == HDCFORMAT )
    {
        if( cmd == HDCREAD )
	{				/* assume same head,cyl		*/
            cmd = cmd | HDCRETRY ;	/* no retries post fmt read	*/
        }
    }
    *tfptr-- = cmd ;					/* hdc opcode	*/

    ss = bpsx( (*u).ld_mdb.md_secsiz ) ;
    *tfptr-- = HDCECC | ( ss << 5 ) | ((*u).lu_driveno << 4) | (*u).io_dkaddr.hsc_head ;
							/*  select byte */

    *tfptr-- = (BYTE) (((*u).io_dkaddr.hsc_cyl & 0xff00) >> 8 ) ;
    *tfptr-- = (BYTE) ((*u).io_dkaddr.hsc_cyl & 0xff) ;

    *tfptr-- = (*u).io_dkaddr.hsc_sector ;
    *tfptr-- = (BYTE) (*u).io_nsecs ;

    *tfptr = (BYTE) (P2LM[driveno].pudp->pu_precomp >> 2) ;

}

/************************************************************************/
/*			Hard Disk Driver ISR's				*/
/************************************************************************/
/************************************************************************/
/* seekasr - 								*/
/* gets execution in asr contexrt after a seek command is issued	*/
/* and the seek complete interrupt is received.				*/
/************************************************************************/
ASR seekasr(u)
LUTE	*u ;
{
    P2LM[(*u).lu_driveno].curcyl = (*u).io_dkaddr.hsc_cyl ;
    hd_cleartimer( u ) ;
    hd_io( u ) ;
    return ( 0 ) ;
}

/************************************************************************/
/* seekisr - gets execution in isr context after a seek command		*/
/* is issued.								*/
/************************************************************************/
CNEAR	ISR seekisr(drno)
WORD    drno ;
{
    LONG    r ;
    LUTE    *u ;
    u = P2LM[drno].physlute ;

    if(( r = doasr( seekasr , u , 0L, DKASRPRI )) < 0L)
    {						/* re queue the request */
        hd_terminate( u , r ) ;				/* error on asr */
    }
    return( TRUE ) ;					/* dispatch	*/
}

/************************************************************************/
/* headisr - gets execution in isr context after a restore or seek	*/
/* command is issued.							*/
/************************************************************************/
CNEAR	ISR headisr(drno)
WORD    drno ;
{
    LONG    r ;
    LUTE    *u ;
    u = P2LM[drno].physlute ;

    if(( r = doasr( headasr , u , 0L, DKASRPRI )) < 0L)
    {
        hd_terminate( u , r ) ;
    }
    return( TRUE ) ;                                /* dispatch */

}

/************************************************************************/
/* headasr - executed after headisr to check and save status in a global*/
/* location and terminate the req (no system functions in isr context) .*/
/************************************************************************/
ASR headasr(u)
LUTE	*u ;
{
    if( ! HDCBUSY  )
    {
        (*u).io_error = chk_stat() ;
    }
    else
    {
        (*u).io_error = (ED_DISK | E_DKATTACH) ;
    }
    hd_cleartimer(u) ;
    hd_iocompl( u ) ;
    return(0);
}

/************************************************************************/
/* readisr - gets execution in isr context during a read command. This	*/
/* routine fires off an asr to do the work required.			*/
/************************************************************************/
CNEAR	ISR readisr(drno)
WORD    drno ;
{
    LONG    r ;
    LUTE    *u ;
    UWORD	stat ;

    u = P2LM[drno].physlute ;

			/* read the sector into a local buffer		*/
			/* for this trk size read command.		*/
    (*u).io_tbuff = inpstr( (*u).io_tbuff, (*u).ld_mdb.md_secsiz ) ;

    (*u).io_tnsecs-- ;
			/* decrement the count of the number of sectors	*/
			/* for this part of the full read.		*/

    stat = inp(HDCSTAT) ;

    if ( (*u).io_tnsecs && !(stat & HDC_ERR) )
    {
	return(FALSE) ;	/* if more sectors on this command then we do	*/
			/* not need to ask for a dispatch.		*/
    }
    else
    {			/* if this was the last sector for this command	*/
			/* then we need to move this buffer to the user	*/
			/* buffer and start the command for the next	*/
			/* buffer fill command.				*/

	if (( r = doasr( readasr, u, 0L, DKASRPRI )) < 0L )
	{
	    hd_terminate(u, r) ;
	}
	return(TRUE) ;
    }
}

/************************************************************************/
/* readasr - checks for command completion and terminates the request	*/
/* if so, or inputs a buffer load of data and sets up for the next	*/
/* interation.								*/
/************************************************************************/
ASR readasr(u)
LUTE	*u ;
{
    LONG	r ;

    if ( (r = chk_stat()) != 0 )
    {
	(*u).io_error = r ;
    }
    else
    {
	if( (*u).lu_flags & DKF_UADDR ) mapu( (*u).lu_b_pdaddr ) ;

    	_bmove( (BYTE *)P2LM[(*u).lu_driveno].tbuff,
		(BYTE *)(*u).io_buffer,
		(WORD) ( (*u).io_nsecs * (*u).ld_mdb.md_secsiz) ) ;
    	(*u).io_buffer += ( (*u).io_nsecs * (*u).ld_mdb.md_secsiz ) ;
    }
    hd_io1(u) ;
    return(0) ;
}

/************************************************************************/
/* writeisr - gets execution in isr context during a write command.	*/
/* This routine fires off an asr to do work required.			*/
/************************************************************************/
CNEAR	ISR writeisr(drno)
WORD    drno ;
{
    LONG r ;
    LUTE    *u ;
    WORD	status ;

    u = P2LM[drno].physlute ;

			/* write the sector from the local buffer	*/
			/* for this trk size write command.		*/
    status = inp( HDCSTAT /* 0x3f6 */ ) ;

    if( status & HDC_DRQ )
    {						/* output data	*/
        (*u).io_tbuff = 
	outpstr( (*u).io_tbuff, (*u).ld_mdb.md_secsiz ) ;
	(*u).io_tnsecs-- ;
    }
    else
    {
	(*u).io_tnsecs = 0 ;
    }

    status = inp( HDCSTAT ) ;

    if ((*u).io_tnsecs && !(status & HDC_ERR) )
    {
	return(FALSE) ;	/* if more sectors on this command then we do	*/
			/* not need to ask for a dispatch.		*/
    }
    else
    {			/* if this was the last sector for this command	*/
			/* then we need to move this buffer to the user	*/
			/* buffer and start the command for the next	*/
			/* buffer fill command.				*/

	if (( r = doasr( writeasr, u, 0L, DKASRPRI )) < 0L )
	{
	    hd_terminate(u, r) ;
	}
	return(TRUE) ;
    }
}

/************************************************************************/
/* writeasr - This routine checks for command completion and terminates	*/
/* the request if so, or inputs a buffer of data and sets up for the	*/
/* next interation.							*/
/************************************************************************/
ASR writeasr(u)
LUTE	*u ;
{
    (*u).io_buffer += ( (*u).io_nsecs * (*u).ld_mdb.md_secsiz ) ;
    (*u).io_error = chk_stat() ;
    hd_io1(u) ;
    return (0);
}

/************************************************************************/
/* verifyisr - gets executed in isr context after a verify command has	*/
/* completed. this routine fires off an asr to do the work required.	*/
/************************************************************************/
CNEAR	ISR verifyisr(drno)
WORD    drno ;
{
    LONG    r ;
    LUTE    *u ;

    u = P2LM[drno].physlute ;

    if(( r = doasr( verifyasr , u , 0L, DKASRPRI )) < 0L)
    {
        hd_terminate( u , r ) ;
    }
    return( TRUE ) ;					/* dispatch	*/
}

/************************************************************************/
/* verifyasr-this routine checks for errors and terminates the request.	*/
/************************************************************************/

ASR verifyasr(u)
LUTE    *u ;
{

    if( ! HDCBUSY )
    {
        (*u).io_error = chk_stat() ;
    }
    else
    {
        (*u).io_error = (ED_DISK | E_DKATTACH) ;
    }
    hd_io1(u) ;
    return(0);
}

/************************************************************************/
/* hd_poll - check for free adapter and post event complete		*/
/************************************************************************/
WORD    hd_poll()
{
    if (pollevnt == TRUE)		/* if adapter is now free 	*/
    {
        return(-1);
    }
    else          		/* still waiting on unit completion	*/
    {
        return(0);
    }
}

/************************************************************************/
/* hd_settimer - set up watch dog timer					*/
/************************************************************************/
VOID    hd_settimer( time,u )
LONG    time ;
LUTE	*u ;
{
    DKTIMPB *timpb ;

    timpb = &HDTIMPB ;
    timpb->tim_time = time ;		/* requested timer setting	*/

    timemask[(*u).lu_unitno] = supif( F_TIMER , timpb ) ;

    nextasr( timemask[(*u).lu_unitno], hd_timex, u, 0L, DKASRPRI+10 );
}

/************************************************************************/
/* hd_cleartimer - cancel timer						*/
/************************************************************************/
VOID    hd_cleartimer(u)
LUTE    *u ;
{
    timemask[(*u).lu_unitno] = supif( F_CANCEL , timemask[(*u).lu_unitno] ) ;
    timeouts[(*u).lu_unitno] = 0 ;
}

/************************************************************************/
/* hd_timex - watch dog timer has barked				*/
/************************************************************************/
ASR hd_timex(u)
LUTE	*u ;
{
    WORD	unit ;
    unit =(*u).lu_unitno ;
			/* if the timer has been canceled do nothing	*/
    if (!(timemask[unit])) return( 0 ) ;

					/* get the timer return code 	*/
    supif( F_RETURN , timemask[unit] ) ;

    if (((WORD)P2LM[unit].seqisr) == (WORD)seekisr)
    {
        if(timeouts[unit]++ < tortry)
	{
            hd_io(u) ;
        }
        else
	{
            (*u).io_error = (ED_DISK | E_DKATTACH) ;
            hd_iocompl( u ) ;
        }
    }
    else
    {
        (*u).io_error = (ED_DISK | E_DKATTACH) ;
        hd_iocompl( u ) ;
    }
    return(0); 
}





