/************************************************************************
*   hdphys.c	      Physical Dependencies section to the Hard		*
*                     disk driver.					*
*************************************************************************
* Copyright (c) 1987 Digital Research Inc. All rights reserved. {proprietary} *
* The Software Code contained in this listing is proprietary to Digital       *
* Research Inc., Monterey, California, and is covered by U.S. and other       *
* copyright protection. Unauthorized copying, adaption, distribution, use or  *
* display is prohibited and may be subject to civil and criminal penalties.   *
* Disclosure to others is prohibited. For the terms and conditions of software*
* code use, refer to the appropriate Digital Research License Agreement.      *
*		U.S. GOVERNMENT RESTRICTED RIGHTS			       *
* This software product is provided with RESTRICTED RIGHTS.  Use, duplication *
* or disclosure by the Government is subject to restrictions as set forth in  *
* FAR 52.227-19 (c) (2) (June, 1987) when applicable or the applicable        *
* provisions of the DOD FAR supplement 252.227-7013 subdivision (b) (3) (ii)  *
* (May, 1981) or subdivision (c) (1) (ii) (May, 1987). Contractor/manufacturer*
* is Digital Research Inc. / 70 Garden Court / BOX DRI / Monterey, CA 93940.  *
*************************************************************************
* Revision History:
* Date   Author SPR #	Comments
* 871231 reb		Originated from re-edit of previous athd.drv sources.
* 880114 reb            Modified ebr address calcs in hd_init
* 880116 reb		Modified makemdb for the virgin disk case.(i.e. no
*			partitions declared.
* 880118 reb		also modded hd_init for above reason.
* 880122 reb		performance update.
************************************************************************/
/************************************************************************
* File:		hdphys.c
*
* Description:	This file contains the physical io and hardware dependent
*		code.
*
* Build Info:	see hd.mak for the build dependencies.
*
* Overview:
*
************************************************************************/
#include    "portab.h"
#include    "hd.h"	

EXTERN	HDTF	HTF[ DKMAXUNITS ] ;
EXTERN	P2L	P2LM[ HDMAXUNITS ] ;
EXTERN	WORD	timeouts[HDMAXUNITS] ;				/* 1.13 */
EXTERN	DKTIMPB HDTIMPB ;
EXTERN	LUTE	physlute[ HDMAXUNITS ] ;	/* physical unit table	*/
				/* parmblock for mappphy call KPB	*/
EXTERN	struct  
{
	LONG   r_Type ;
	ULONG  r_PhysicalAddr ;
	LONG   r_Size ;
} 	RomTable ;

				/* pointer for cmos disk type table	*/
EXTERN	PLIST_ENTRY	part_list[DKMAXUNITS] ;
EXTERN	WORD		cnt_parts ;

EXTERN	LONG	DriveSync[2];
EXTERN	PUD	*puda ;
EXTERN	WORD	physunits ;

static	UWORD	MapFlag = 1;



/************************************************************************/
/*									*/
/*			Media Dependent Code				*/
/*									*/
/************************************************************************/

/************************************************************************/
/* yGetHscAddr -							*/
/*	Get the Head Sector and Cylinder Address			*/
/*	from the Sequential Sector Number.				*/
/*									*/
/*	NOTE:  This is dependent on disk formats.  WILL			*/
/*	NOT WORK on CPM media or hard disks with track			*/
/*	numbers in sector id's instead of cylinder numbers.		*/
/*									*/
/************************************************************************/
VOID	yGetHscAddr( hsc, StSsn , u )
HSCADDR	*hsc ;			/*  ptr to head sector cylinder addr	*/
SSN	StSsn ;			/*  Starting Sequential Sector Number	*/
LUTE	*u ;			/*  ptr to logical unit table entry	*/
{
	UWORD	LogTrkNo ;	/*  Nbr logical trks before start */

	(*hsc).hsc_sector = 
		( StSsn % (*u).ld_mdb.md_sectrk ) + (UBYTE) 1 ;	/* 1,2,.*/
	LogTrkNo = StSsn / (*u).ld_mdb.md_sectrk ;		/* 0,1,.*/
	(*hsc).hsc_head = LogTrkNo % (*u).ld_mdb.md_nheads ;	/* 0,1,.*/
	(*hsc).hsc_cyl = LogTrkNo / (*u).ld_mdb.md_nheads ;		/* 0,1,.*/

}

/************************************************************************/
/*  yGetSsn - calculate an ssn from an hsc addr.			*/
/************************************************************************/
SSN	yGetSsn( hsc , u )
HSCADDR	*hsc ;				/*  disk addr in HSC format	*/
LUTE	*u ;				/*  ptr to Log Unit Table entry	*/
{
	MDB	*m ;
	UWORD	sector, head ;
	ULONG	cyl ;

	m = &(*u).ld_mdb ;

	head = (UWORD) (*hsc).hsc_head ;
	sector = (UWORD) (*hsc).hsc_sector ;
	cyl = (ULONG) (*hsc).hsc_cyl ;
			  
	return( ( cyl * ((*m).md_sectrk * (*m).md_nheads)  )  +
		( head * (*m).md_sectrk ) + sector - 1 ) ;
}

/************************************************************************/
/* hd_dmphyio -  do physical level function				*/
/************************************************************************/
ERROR   hd_dmphyio( u , rtnaddr )
LUTE    *u ;
CFAR	WORD    (*rtnaddr)(LUTE *) ;
{
    ENUM    e ;
    LONG    r ;

    e = flagevent( (*u).lu_ioflagno , 0L ) ;
    if(( r = doasr( rtnaddr , u , 0L, DKASRPRI )) < 0L)
    {
        flagset( (*u).lu_ioflagno , (*u).lu_pdaddr , r ) ;
        mxrel(DriveSync[(*u).lu_driveno]);
        return( r ) ;
    }
    supif( F_WAIT , e ) ;
    return( supif( F_RETURN , e ) ) ;
}

/************************************************************************/
/* dk_findpud - Get the drive type from CMOS, and set the proper index. */
/************************************************************************/
ERROR	dk_findpud(drive)
BYTE	drive;
{
    UBYTE   value ;
    WORD    cmos;

    if( drive >= maxphydrv )  
    {					/* check for bad phy dev #  	*/
        return( 0 ) ;
    }

	/* user hardware register to determine if physical device	*/
    			/*  attached and if so type of device           */

						/*1.6.01 87Nov24 (start)*/
    cmos = getcmos( HDCMOSVAL ) ;
    
    if ( cmos == (WORD)0xffff ) 
    {
		/* Could not read cmos, battery low or chksum error 	*/
    	return(ED_DISK | E_DKATTACH);
    }
    value = cmos;
						/*1.6.01 87Nov24 (end)	*/
    if(value == 0)
    {
         return ( 0 ) ;
    }

    value = (( value  >> (drive ? 0 : 4 )) & 0xf ) ;

    if (value == 0xf)
    {
        value = getcmos( drive ? HD1CMOSVAL : HD0CMOSVAL ) ;
    }

    if( !(value) )
    {
        return( 0 ) ;
    }

		/* maps in the rom table only once for hard disks KPB	*/
    if(MapFlag)
    { 
	MapFlag = !MapFlag;
	RomTable.r_Type         = 0;
	RomTable.r_PhysicalAddr = CMOS_DISK_TABLE_ADDRESS;
	RomTable.r_Size         = 16 * NUMBER_DRIVES_SUPPORTED;
	puda = (PUD *)mapphys(&RomTable,CODE_TYPE);
    }
    MapFlag = value;

    MapFlag = !MapFlag;
    P2LM[drive].pudp = puda + (--value) ; 	/* no 0 type in array	*/

    /* 	allocate a track buffer to enable isr reads to this buffer	*/
    if( (P2LM[drive].tbuff =
    	(BYTE *)salloc( (LONG)(P2LM[drive].pudp->pu_sectors * SECTORSIZE) )
    		      ) == NULLPTR)
    	return( ED_DISK | E_POOL ) ;


    return(TRUE);
}

/************************************************************************/
/*									*/
/*      makemdb - Make Media Descriptor Block				*/
/*		  and fill the rest of the fields in the LUTE		*/
/************************************************************************/
/* Read the OS boot record to build the MDB.  This routine assumes	*/
/* that read failures are due to physical I/O errors - to have		*/
/* gotten this far in the install sequence, at least one MBR/EBR	*/
/* must have been read, so the process must have a free event mask.	*/
/* True is returned iff an OS boot record with a valid signature	*/
/* was read.								*/
/************************************************************************/

LONG	makemdb ( u, buffer )
LUTE	*u;			/* Logical Unit Table Entry Pointer	*/
BYTE	*buffer;		/* buffer for reading OS boot record	*/
{
    MDB		*savedmdb;	/* pointer for saveing mdb information	*/
    WORD	partno = 0 ;	/* partition number for this unit	*/
    WORD	unit ;		/* unit number of the partition to be 	*/
				/* installed				*/
    WORD	driveno ;	/* drive number for local reference	*/

    unit = (*u).lu_unitno ;

    if (part_list[unit].used) return (ED_DISK | E_UNIT) ;
    if (cnt_parts <= unit) return (ED_DISK | E_UNIT) ;

    driveno = (*u).lu_driveno = part_list[unit].physdrive ;
    
    hd_physinfo( u, driveno ) ;
    /********************************************************************/
    /* read OS boot record from the part_list entry for this unit and   */
    /* create an mdb within the LUTE for this unit.			*/
    /* Upon exit from this routine the logical install is complete.	*/
    /********************************************************************/

    (*u).ld_stssn = part_list[unit].unit_part_entry.relsec ;
    (*u).ld_endssn = part_list[unit].unit_part_entry.relsec + 
			part_list[unit].unit_part_entry.nsecs - 1 ;

    if ( (( read ( u, (*u).ld_stssn, buffer ) ) >= 0 ) &&
    ( (*((MBPR *) buffer)).signature == SIGNATURE ))
    {
	savedmdb = &(*u).ld_mdb;
	(*savedmdb).md_partno = partno++ ;
	(*savedmdb).md_driveno = part_list[unit].physdrive ;
	(*savedmdb).md_1sec = ((BPB *)buffer)->bpb_rs;
	if( ( (*savedmdb).md_nsecs =
	(ULONG)(((BPB *)buffer)->bpb_nsli) ) == 0 )
	(*savedmdb).md_nsecs = ((BPB *)buffer)->bpb_nslx ;
	
	(*savedmdb).md_secblk  = ((BPB *)buffer)->bpb_spau;
	(*savedmdb).md_mdb     = ((BPB *)buffer)->bpb_md;
	(*savedmdb).md_nfats   = ((BPB *)buffer)->bpb_nof;
	(*savedmdb).md_nfrecs  = ((BPB *)buffer)->bpb_nsobsf;
	(*savedmdb).md_dirsize = ((BPB *)buffer)->bpb_nrde;
	(*savedmdb).md_hidden  = (*u).ld_stssn ;
	(*savedmdb).md_syssize = 0L;

	switch (part_list[unit].unit_part_entry.sysird)
	{
		case	DOS12	:
		{
			(*savedmdb).md_format = MDDOS ;
			break ;
		}
		case	DOS16:
		{
			(*savedmdb).md_format = MDDOSX ;
			break ;
		}
		case	DOS16L	:
		{
			(*savedmdb).md_format = MDDOSX ;
			break ;
		}
		case	DOSEXT	:
		{
			(*savedmdb).md_format = 0 ;
			break ;
		}
		default:
			break ;
	}

	part_list[unit].used = TRUE ;	

	hd_setparm( u ) ;

	return ( 0 );
    }
    else
    {
	hd_physinfo( u, (*u).lu_driveno ) ;
	savedmdb = &(*u).ld_mdb;
	(*u).ld_stssn = 0 ;
	(*u).ld_endssn = (*savedmdb).md_nsecs-1L ;
	(*savedmdb).md_driveno =(*u).lu_driveno ;
	(*savedmdb).md_1sec = 1 ;
	(*savedmdb).md_syssize = 0L;

	(*savedmdb).md_format = 0 ;
	part_list[unit].used = TRUE ;	
	hd_setparm( u ) ;
	return (E_SUCCESS) ;
    }
} /*				makemdb					*/

/************************************************************************/
/*          Hard Disk Driver Primitives                                 */
/************************************************************************/
/************************************************************************/
/*  outputbyte -							*/
/*  Output a single command/parm byte to the hdc.			*/
/************************************************************************/
BOOLEAN outputbyte( port , byte )
BYTE    byte ;					/* data to output 	*/
WORD    port ;				/* port number to output to	*/
{ 
    if( ! cmdquery()  )
    {
        return( FALSE ) ;
    }
    outp( port , byte ) ;
    return( TRUE ) ;
}

/************************************************************************/
/*  cmdquery -								*/
/*  exit:  TRUE:    hdc is ready for cmd (not busy, seek comp., ready)	*/
/*      FALSE:  hdc is not ready for command (busy)			*/
/*									*/
/************************************************************************/
BOOLEAN cmdquery()
{
WORD    s ;	/* contents of hdc status register for bit masking	*/

    s = inp(HDCSTAT) ;
					    /* removed seek check KPB	*/
    if( !(s & HDC_BSY) && (s & HDC_RDY) )
    {
        return( TRUE ) ;
    }
    else
    {
        return( FALSE ) ;
    }
}

/************************************************************************/
/* hcmdcode -  translate a command code into an hdc operation code.	*/
/************************************************************************/
BYTE    hcmdcode(op)
BYTE    op ;
{
    switch(op)
    {
        case DKREAD:    return( HDCREAD ) ;         /* code for hdc read */
        case DKWRITE:   return( HDCWRITE ) ;        /* code for hdc write*/
        case DKVERIFY:  return( HDCVERIFY ) ;       /* code for hdc verify*/
        case DKFMT:
        case DKFMTBB:
        case DKFMTLST:
        case DKFMTBBLST:
            return( HDCFORMAT ) ;                   /* code for hdc format*/

        default:    return( 0 ) ;
    }
}

/************************************************************************/
/*  hd_setparm - output parameters to hdc for multi-track,		*/
/*  multi-cylinder i/o.	 ( # heads, # sectors/track )			*/
/************************************************************************/
ERROR   hd_setparm( u )
LUTE    *u ;
{
    HDTF    *cf ;
    BYTE    driveno ;                               /* drive number	*/
    BYTE    ss ;

    driveno = (*u).lu_driveno ;			/* init drive anbr	*/

    cf = &HTF[(*u).lu_unitno] ;

    (*cf).hd_cmd[1] = (BYTE) ( P2LM[driveno].pudp->pu_sectors ) ;

    ss = bpsx( (*u).ld_mdb.md_secsiz = SECTORSIZE ) ;

    (*cf).hd_cmd[5] =  HDCECC | (ss << 5) | (driveno << 4) | (P2LM[driveno].pudp->pu_nheads-1) ;

    (*cf).hd_cmd[6] = HDCSET ;		/* set parameter hdc command	*/

    if( !outputcmd( cf ) )
    {
        return( ED_DISK | E_DKATTACH ) ;
    }
    else
    {
        return( E_SUCCESS ) ;
    }
}

/************************************************************************/
/*  outputcmd -  Output a high level disk command to the hdc.		*/
/*  The hdtfp parm is a pointer to the appropriate task file.		*/
/************************************************************************/
BOOLEAN outputcmd( hdtfp )
HDTF    *hdtfp ;                                    /* ptr to Task File */
{

    BYTE    *c ;		/*  ptr to command task file string	*/
    WORD    ccnt ;				/* command count	*/
    WORD    port ;		/* port number of hdc task register	*/

    for(c = &hdtfp->hd_cmd[0], port = HDCPRECOMP, ccnt = CFMAX ; ccnt-- ; )
    {
        if( ! (outputbyte(port++ , *c++))  )
	{
					            /* output failed	*/
            return( FALSE ) ;
        }
    }
    return( TRUE ) ;
}

/************************************************************************/
/*  bpsx -								*/
/*  returns a byte per sector indicator that is controller specific,	*/
/*  given a word value for the number of bytes per sector.		*/
/*  default is 512 bytes per sector.					*/
/************************************************************************/
BYTE    bpsx( n )
WORD    n ;
{
    static  BYTE    bytsec[9] = { 1,3,0,-1,1,-1,-1,-1,2 } ;

    return(bytsec[n/128]) ;
}

/************************************************************************/
/* hd_init - hardware setup						*/
/************************************************************************/
VOID    hd_init(u)
LUTE	*u ;
{
    WORD	n,i ;
    WORD	drive ;
    WORD	phydrive;   	/* physical drive number		*/
    WORD	partno;     	/* partition number of unit on drive	*/
    LONG	rc;	 	/* return code				*/
    BOOLEAN     newpart;    	/* TRUE when a DOS partition found	*/
    SSN	 	diskaddr ;	/* disk addr of next partition - type 5	*/
    BYTE	*buffer ;	/* read buffer for MBR/EBR boot record	*/
    LONG	oldssn = 0 ;
    PTE		*part ;
    BOOLEAN	ebr_found ;
    
    newpart  = FALSE;
    partno   = 0;
 
    /* setup global isr address */

    for (n = 0; n < HDMAXUNITS; n++)
    {
        P2LM[n].seqisr = dummyisr ;
        P2LM[n].curcyl = -1 ;
	timeouts[n] = 0 ;					/* 1.13 */
    }

			/* Setup the interrupt vector for the hard disk	*/

    setvec( hd_int, HDINTNO ) ;

			/* Setup the PIC for Hard Disk Interrupts 	*/

    outp( PIC1MSK , inp(PIC1MSK) & 0xbf ) ;		/* init slave	*/
    outp( PIC0MSK , inp(PIC0MSK) & 0xfb ) ;     	/* init master	*/

						/* reset the controller */

    outp( HDCREG , HDC_RESET ) ;

						        /* wait 4.8 us  */
    for (i=0;i<30;i++) ;

    outp( HDCREG , HDC_H8 ) ;		/* 8 head option as default 	*/

    for (i=0; i < 10 ; i++ )
    {
	if (cmdquery())  break ;
        HDTIMPB.tim_sync = 0 ;
        HDTIMPB.tim_time = 100L ;
        supif ( F_TIMER, &HDTIMPB ) ;
        HDTIMPB.tim_sync = 1 ;
    }
		/* get PUD pointers for each attached drive, and setup   */
		/* hard disk controller for multi-track, multi-cylinder  */
		/* I/O for each attached drive                           */
                                                                  
    for ( drive = 0 ; dk_findpud(drive) != 0 ; drive++)
    {                                                          
    	(*u).lu_driveno = drive;                        
        hd_physinfo( u, drive );
    	hd_dmphyio ( u, hd_recal );    /* recalibrate */
	physlute[drive] = *u ;
    	hd_setparm ( u );                        
    	(*u).lu_driveno = 0;                               
    }                           

    physunits = drive ;			/* set the number of physunits	*/
   
			/* allocate buffer for reading boot records 	*/
    if ( ( buffer = (BYTE *) salloc ( (LONG) MAXREC ) ) == NULLPTR )
        return ;
	
	/****************************************************************/
	/* for each physical drive, while no partition found,		*/
	/* look for an available Primary DOS partition.			*/
	/****************************************************************/
    for (phydrive = 0;(phydrive < physunits) ; phydrive++ )
    {
    		/* build default MDB					*/
	diskaddr = 0 ;

    	(*u).lu_driveno = phydrive;

	ebr_found = TRUE ;

	while ( ebr_found )
	{
		ebr_found = FALSE ;

		if ( ( rc = read ( u, diskaddr, buffer ) ) < 0 )
		{
	        	return ;
		}
    
		if ( ((MBPR *) buffer)->signature == SIGNATURE )
		{
	    	    part = & (*( (MBPR *)buffer )).pte[0];
	    	    for ( i = 0; i < MAXPTES ; i++, part++)
	    	    {
	    				/* if this is a DOS partition */
			if ( ((*part).sysird == DOS16) || 
				((*part).sysird == DOS12) ||
				((*part).sysird == DOS16L) )
	    		{
				part_list[cnt_parts].physdrive = phydrive ;
				part_list[cnt_parts++].unit_part_entry = *part ;

				/* Logical initializers before		*/
				/* making mdb just enough for read.	*/

				part_list[cnt_parts-1].unit_part_entry.relsec = 
					(*u).ld_stssn = diskaddr + (*part).relsec ;
				(*u).ld_endssn = 
					(*u).ld_stssn + (*part).nsecs - 1 ;
				(*u).ld_mdb.md_hidden = (*u).ld_stssn ;
		    	}
	    
				/* if Extended DOS Partition found	*/
		    	if ( (*part).sysird == DOSEXT )
		    	{
				diskaddr = (*part).scylinder +
				   (((UWORD)(*part).ssector << 2) & 0xff00 );
				diskaddr *= P2LM[phydrive].pudp->pu_nheads ;
				diskaddr *= P2LM[phydrive].pudp->pu_sectors ;

				ebr_found = TRUE ;
			}			/* end if DOSEXT	*/
		    }				/* end for pte[0-3]	*/
		}				/* end if(SIGNATURE)	*/
		else	/* no signature un-inited disk found fake it	*/
		{
						/* set code in part_list */
			part_list[cnt_parts].physdrive = phydrive ;
			part_list[cnt_parts].unit_part_entry.relsec = 0 ;
			part_list[cnt_parts].unit_part_entry.nsecs =
							 (*u).ld_mdb.md_nsecs;
			(*u).ld_endssn = (*u).ld_mdb.md_nsecs - 1 ;
			cnt_parts++ ;
			continue ;		/* restart this loop	*/
		}
	}					/* end while ebr fnd	*/
    }						/* end for physdrive	*/

    if ( buffer )
        sfree (buffer );
    
}

/************************************************************************/
/* hd_uninit - hardware un-setup					*/
/************************************************************************/
VOID    hd_uninit()
{
    int n ;

					/* Setup Global isr address	*/

    for (n = 0; n < HDMAXUNITS; n++) P2LM[n].seqisr = dummyisr ;

			/* Unset the PIC for Hard Disk Interrupts	*/

        outp( PIC1MSK , inp(PIC1MSK) | ~0xbf ) ;    	/* uninit slave	*/

			/* Unset the interrupt vector for the hard disk */

        setvec( 0L, HDINTNO ) ;
}

/************************************************************************/
/* hd_recal - recal (restore) to track zero.				*/
/************************************************************************/
ASR hd_recal( u )
LUTE    *u ;
{
    HDTF    *f ;
    BYTE    driveno ;
    driveno = (*u).lu_driveno ;

    P2LM[driveno].seqisr = headisr ;     	/* seek or recal isr	*/
    P2LM[driveno].physlute = u ;	/* save ptr to global lute	*/

    f = &HTF[(*u).lu_unitno] ;			/* setup task file ptr	*/
    
    f->hd_cmd[6] = HDCRECAL | ( P2LM[driveno].pudp->pu_step & 0xf ) ;
						/*  disk op code	*/

    f->hd_cmd[5] =
    HDCECC | ( bpsx((*u).ld_mdb.md_secsiz) << 5 ) | ( driveno << 4 ) ;

    if( ! outputcmd( f )  )
    {                       			/* output command	*/
        hd_terminate( u , (ED_DISK | E_DKATTACH) ) ;
    }
    else
    {
        hd_settimer( 20000L, u ) ;                  /* watchdog timer   */
    }
    return(0);
}

/************************************************************************/
/*  chk_stat -								*/
/*  analyzes result hdc status register and error register		*/
/*  and returns the appropriate return code				*/
/*  note: should not be called if the busy bit is set			*/
/************************************************************************/
ERROR   chk_stat( )
{
    BYTE    status ;			/* hdc status/error register	*/

    status =  inp( HDCSTAT ) & 0xf1 ;	/* mask off unused bits 	*/
                                                    /* drq, ecc, index  */

    if( status == (HDC_RDY+HDC_SC))
    {               				/* quick o.k. check	*/
        return( E_SUCCESS ) ;                       /* good status	*/
    }
    else
    {
        if( !(status & HDC_RDY ))
	{						/* not ready ? 	*/
            return( ED_DISK | E_READY ) ;
        }
        else
	{
            if( status & HDC_WF )
	    {					/* write fault ? 	*/
                return( ED_DISK | E_WRITEFAULT ) ;
            }
            else
	    {
                if( !( status & HDC_SC ))
		{				/* seek not complete ?	*/
                    return( ED_DISK | E_SEEK ) ;
				/* not an error if overlapped seeks	*/
                }
                else
		{
                    if( !( status & HDC_ERR ))
		    {				/* busy slipped in ?    */
                        return( ED_DISK | E_DKATTACH ) ;
                    }
                    else
		    {
                        status = inp( HDCERR ) ;
                        if( status & HDC_BB )
			{			/* bad block detect ?   */
                            return( ED_DISK | E_SEC_NOTFOUND ) ;
                        }
                        else
			{
                            if( status & HDC_CRC )
			    {			/* uncorrectable ecc ?  */
                                return( ED_DISK | E_CRC ) ;
                            }
                            else
			    {
                                if( status & HDC_ID )
				{		/* id mark not found ?  */
                                    return( ED_DISK | E_MISADDR ) ;
                                }
                                else
				{
                                    if( status & HDC_AC )
				    {		/* aborted command ?    */
                                        return( ED_DISK | E_INVCMD ) ;
                                    }
                                    else
				    {
                                        if( status & HDC_TK )
				        {	/* track 0 not found ?  */
                                            return( ED_DISK | E_SEEK ) ;
                                        }
                                        else
					{
                                            if( status & HDC_DM )
						{/* data mark not found ?*/
                                                return( ED_DISK | E_SEC_NOTFOUND ) ;
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }
}


