/*************************************************************************
*     RNETDRV.H	 						Version 1.02
***************************************************************************
* Copyright (c) 1987, Digital Research, Inc. All Rights Reserved. The Software
* Code contained in this listing is proprietary to Digital Research, Inc.,
* Monterey, California and is covered by U.S. and other copyright protection.
* Unauthorized copying, adaptation, distribution, use or display is prohibited
* and may be subject to civil and criminal penalties.  Disclosure to others is
* prohibited.  For the terms and conditions of software code use refer to the
* appropriate Digital Research License Agreement.
***************************************************************************
* Version   Date   Who  Description
* ======= ======== ===  ===================================================
*  1.02   02/29/88 ldt  Renamed modules from hsd*.* to rnet*.*
*  1.01   12/02/87 ldt	Added EIGHTPORTS define.
*  1.00   871015   reb  Originated
*****************************************************************************/

/************************************************************************/
/* The following macros allow a prototype override to be used to alter	*/
/* the calling convention of a "C" function. see Metaware Documentation	*/
/* for details of this usage.						*/
/************************************************************************/

#define NEAR _cc(_DEFAULT_CALLING_CONVENTION | _NEAR_CALL | _CALLEE_POPS_STACK)
#define FAR _cc(_DEFAULT_CALLING_CONVENTION | _FAR_CALL)

/************************************************************************/
/*  Using the ARNET multiport card with 8 serial ports.			*/
/************************************************************************/

#define EIGHTPORTS		TRUE

/************************************************************************/
/*  first some data structures used by any driver			*/
/************************************************************************/

#define	ERROR		LONG	/* type of error code returns		*/
#define EMASK		LONG	/* event mask returned by FLAGEVENT 	*/

/************************************************************************/
/* Port Type Defines for use in the port_get_set table			*/
/************************************************************************/

#define	PTT_UNDEFINED	0x00	/*  not used				*/
#define	PTT_SERIAL	0x01	/*  typical serial i/o device		*/
#define	PTT_CHAR	0x02	/*  fixed char i/o dev			*/
#define	PTT_PARALLEL	0x04	/*  typical parallel port i/o device	*/

/************************************************************************/
/*  BD - Baud Rate values 						*/
/************************************************************************/

#define		BDINVALID	0x0000		/* index of baudtab[] 	*/
#define		BD50		0x0900		/* 0			*/    
#define		BD75		0x0600		/* 1			*/
#define		BD110		0x0417		/* 2			*/
#define		BD134		0x0359		/* 3			*/
#define		BD150		0x0300		/* 4			*/
#define		BD300		0x0180		/* 5			*/
#define		BD600		0x00C0		/* 6			*/
#define		BD1200		0x0060		/* 7			*/
#define		BD1800		0x0040		/* 8			*/
#define		BD2000		0x003A		/* 9			*/
#define		BD2400		0x0030		/* 10			*/
#define		BD3600		0x0020		/* 11			*/
#define		BD4800		0x0018		/* 12			*/
#define		BD7200		0x0010		/* 13			*/
#define		BD9600		0x000C		/* 14			*/
#define		BD19200		0x0006		/* 15			*/

/************************************************************************/
/* Port Mode Defines, for the port_tbl not for the phys port	 	*/
/************************************************************************/

#define		PTM_LENGTH	0x03	/* bit mask to isolate xmit len	*/
#define		PTM_L5		0x00	/* 5 bit per character bit set	*/
#define		PTM_L6		0x01	/* 6 bit per character bit set	*/
#define		PTM_L7		0x02	/* 7 bit per character bit set	*/
#define		PTM_L8		0x03	/* 8 bit per character bit set	*/

#define		PTM_STOP	0x0c	/* mask to isolate stop bit bits*/
#define		PTM_XSTOP	0x00	/* no stop			*/
#define		PTM_1STOP	0x04	/* 1 stop bit per character	*/
#define		PTM_12STOP	0x08	/* 1 and 1/2 stop bits 		*/
#define		PTM_2STOP	0x0c	/* 2 stop bits per character	*/


#define PTM_PARITY	        0x30	/* mask to isolate parity bits	*/
#define	PTM_NOPAR		0x00	/* no parity bit set value	*/
#define PTM_PENAB		0x10	/* enable parity bit set	*/
#define	PTM_PEVEN		0x20	/* even parity if set odd if not*/


/************************************************************************/
/* port control defines, for the port table structure not the phys port */
/************************************************************************/
#define	PTC_DTR		0x01	/* rw: data term ready	   		*/
#define	PTC_RTS		0x02	/* rw: req to send	   		*/
#define	PTC_TXENAB	0x04	/* rw: 1 = enable transmit 		*/
#define	PTC_RXENAB	0x08	/* rw: 1 = enable receive  		*/
#define	PTC_XONXOFF	0x10	/* rw: 1 = enable ^s^q log 		*/
#define	PTC_DSR		0x20	/* r:  1 = data set ready  		*/
#define	PTC_DCD		0x40	/* r:  1 = dcd active	   		*/
#define E_IllUnitno	-1020

#define	DPF_UADDR	0x8000	/* addresses are from user space	*/

/************************************************************************/
/*  Console Driver  dependent type definitions 				*/
/************************************************************************/

#define  max(a,b)  ((a) > (b) ? (a) : (b))
#define  min(a,b)  ((a) < (b) ? (a) : (b))
#define  abs(w1)  ((w1) < 0 ? (-w1) : (w1))


#define	CNTRLS	0x13
#define	CNTRLQ	0x11


/************************************************************************/
/*  Driver Parameter Block  definition                                  */
/************************************************************************/
#define DPB     struct DrvrParmBlock
DPB
{
        BYTE    dp_unitno;      /* unit number for this request 	*/
        BYTE    dp_option;      /* some options 			*/
        UWORD   dp_flags;       /* flags 				*/
        LONG    dp_swi;         /* address of software interrupt 	*/
        LONG    dp_pdaddr;      /* address of callers process discriptor*/
        BYTE    *dp_buffer;     /* pointer to the data buffer 		*/
        LONG    dp_bufsiz;      /* size of this buffer 			*/
        LONG    dp_offset;      /* offset for I/O 			*/
        LONG    dp_parm7;       /* some parameter 			*/
        LONG    dp_parm8;       /* another parameter 			*/
};

#define	MAPPB	struct	MapPhysAddrStruct
MAPPB
{
	LONG	zero;		/* not used 				*/
	LONG	physaddr;	/* physical address to translate	*/
	LONG	length;		/* pblk for the mapphys function	*/
};

#define MAXOUTR	0x1000		/* input Queue length 			*/
#define MAXOUTW	0x08		/* The size of the output queue		*/


/************************************************************************/
/* Port  PORT_TBL default defines 					*/
/************************************************************************/
#define HSD_TYPE   0x01		/* Set the default TYPE 		*/
#define HSD_BAUD   14		/* Set the default baud rate		*/ 
				/* Set default MODE 			*/
#define HSD_MODE   PTM_NOPAR + PTM_1STOP + PTM_LENGTH 
				/* Set default PORT CONTROL		*/
#define HSD_CTRL   PTC_TXENAB + PTC_RXENAB + PTC_DTR + PTC_RTS

