echo off
cls
echo :
echo :    MOUSEADD.BAT - This batch file installs the mouse driver using
echo :                   the driver file /DRIVERS/MDRV.DRV
echo :
echo :    For a successful installation, the port driver, PT0:,
echo :    must not have a sub-driver linked to it.

if not exist ser: goto load1

echo :
echo :    The serial port device subdriver SER: exists.  Assuming SER: has
echo :    been linked to PT0: via CONFIG.BAT, the SER: device must be unlinked
echo :    from device PT0:, so the port device can be used with the MOUSE.
echo :
pause
echo :    Execute:  dvrunlk ser:

dvrunlk ser:
goto load2

:load1

pause

:load2

echo :
echo :  ------------------------------------------------------------------------
echo :
echo :    DVRLOAD ( install ) the mouse driver, MOUSE: with the follwing options:
echo :  
echo :      L - Lockable (the device can be locked by a single user)
echo :      N - Shared access (two or more users can share the device)
echo :      R - Raw read access allowed
echo :      W - Raw write access allowed
echo :      S - Raw set access allowed
echo :
echo :    Execute: dvrload mouse: \drivers\mdrv.drv lnrws

dvrload mouse: \drivers\mdrv.drv lnrws
if errorlevel 3 goto getsubdriver
if errorlevel 2 goto mouserr
if errorlevel 1 goto mouserr

:getsubdriver
echo :
echo :    DVRLINK the mouse device, MOUSE:, to port device, PT0:.
echo :
echo :    Execute: dvrlink mouse: pt0:

dvrlink mouse: pt0:
if errorlevel 3 goto mouserr
if errorlevel 2 goto mouserr
if errorlevel 1 goto mouserr

echo :
echo :    DVRLINK the console device, CON0:, to the mouse device, MOUSE:
echo :
echo :    Execute: dvrlink con0: mouse:

dvrlink con0: mouse:
if errorlevel 3 goto mouserr
if errorlevel 2 goto mouserr
if errorlevel 1 goto mouserr

goto end

:mouserr
echo :
echo :    An error occurred installing the MOUSE: device driver....
echo :    The MOUSE: device may already be installed, or the devices
echo :    being accessed have other dependencies which will not allow
echo :    the MOUSE: device to install correctly.
echo :
echo :    Execute SYSTAB.286 ( option D ), and verify the devices
echo :    being accessed in this batch file are free from dependencies. 
:end
