echo off
cls
echo :
echo :    SPOOLADD.BAT - This batch file installs the Print Spooler Device
echo :                   Driver, SPLDRV:, using the file SPLDRV.DRV located
echo :                   in subdirectory /DRIVERS on the default disk device.
rem
rem    NOTE:  GEM applications, 386 systems only, and DOS application
rem           will not be able to output to the printer if the
rem           Print Spooler Driver is installed.
rem
rem    The following command determines if the Print Spooler Driver is
rem    already installed.  If the Print Spooler Driver is not installed,
rem    then install it now.
rem

if exist spldrv: goto EXISTS

rem
rem    The following command determines if the Print Spooler Driver file,
rem    exists in subdirectory /DRIVERS on the default drive.
rem

if not exist /drivers/spldrv.drv goto NOFILE

rem
rem    The following command determines if the system-level logical name
rem    BGPRN: is already defined in the system.
rem

if exist bgprn: goto LOADSPOOLER

rem
rem    Before the Print Spooler Driver can be successfully loaded, the
rem    system-level logical name - BGPRN: - (background printer), must
rem    be defined so the Print Despooler will be loaded as permenent.
rem
echo :
echo :    Define the system-level logical name - BGPRN: - (background printer).
echo :
echo :            DEFINE -S BGPRN: = LPT0:

     define -s bgprn: = lpt0:

:LOADSPOOLER
rem
rem    Load the Spooler checking for errors.  The Print Spooler Driver 
rem    is installed with the following options:
rem
rem      L - Lockable (the device can be locked by a single user)
rem      N - Shared access (two or more users can share the device
rem      R - Raw read access allowed
rem      W - Raw write access allowed
rem      S - Raw set access allowed
rem
echo :
echo :    Load the Print Spooler Driver.
echo :
echo :            DVRLOAD SPLDRV: /DRIVERS/SPLDRV.DRV LNRWS

     dvrload spldrv: /drivers/spldrv.drv lnwrs >* null:
     if errorlevel 2 goto LOADERR2
     if errorlevel 1 goto LOADERR1

rem
rem
rem    NOTE: The Print Spooler Driver places spool files into a logical
rem          directory named TEMPDIR:.   TEMPDIR: can be defined to be any
rem          existing directory on the disk.  For releases, the only
rem          known directory is the root of the default drive.  The
rem          definition of TEMPDIR: should be changed to suit your needs.
rem
echo :
echo :    Define the system-level logical name TEMPDIR:
echo :
echo :            DEFINE -S TEMPDIR: = DEFAULT:/

     define -s tempdir: = default:/


rem
rem    NOTE:  The PRN: device, which was previously defined to be LPT0:,
rem           if this batch file has not already executed, is redefined
rem           to be SPLDRV:.  Now all files sent to the printer under
rem           default circumstances will go through the spooler.  However,
rem           files can be redirected to LPT0:, bypassing the spooler.
rem           
echo :
echo :    Define the system-level logical name PRN: to be spool device SPLDRV:.
echo :
echo :            DEFINE -S PRN: = SPLDRV:

     define -s prn: = spldrv:

echo :
echo :    The Print Spooler Device Driver, SPLDRV:, loaded successfully.

     goto end

rem
rem    For each error below, ring a bell and describe what happened.
rem

:LOADERR2

echo :
echo :
echo :    An error occurred loading SPLDRV.DRV driver.
echo :

if not exist system:spool.286 goto ERRA
if not exist system:despool.286 goto ERRA

echo :    The SPLDRV.DRV file may be corrupt, and/or may not have been
echo :    read correctly during the DVRLOAD procedure.

     goto end

:ERRA

echo :    The SPLDRV.DRV file requires the executable files, SPOOL.286
echo :    and DESPOOL.286, to be located in the SYSTEM: directory before
echo :    the spooler can be loaded.

     goto end

:LOADERR1

echo : 
echo :
echo :    An error occurred loading SPLDRV.DRV driver. 
echo :    The DVRLOAD options are invalid.

     goto end

:NOFILE

echo : 
echo :
echo :    The file, SPLDRV.DRV, was not found on the default disk device
echo :    in subdirectory /DRIVERS.

     goto end

:EXISTS

echo :
echo :
echo :    The Print Spooler Device Driver, SPLDRV:, is already installed.
echo :    To re-install the Print Spooler Driver, execute the command:
echo :
echo :                        DVRUNLK SPLDRV:
echo :
:end
echo :
