#ifndef __portab_included
#define __portab_included
/****************************************************************************
*
*         F L E X O S   R U N   T I M E   L I B   H E A D E R   F I L E
*         -------------------------------------------------------------
*       Copyright 1982 by Digital Research Inc.  All rights reserved.
*
*       This is an include file for assisting the user to write portable
*       programs for C.  All processor dependencies should be located here.
*
****************************************************************************/
/*	may 	1987	KJ	included some of the intrinsic functions of
*				the Metaware C Compiler. This are also used
*				to build the FlexOs system.
*****************************************************************************/
/*
 *      Standard type definitions
 */
#ifndef PORTAB                                  /* Don't define if already */

#define PORTAB  1                               /* Portab is now done      */
#define CDOS4   1                               /* Operating System        */

typedef char BYTE;                              /* Signed byte             */
#ifdef  MC68000
typedef unsigned char UBYTE;          		/* Unsigned byte           */
#else                                           /* Other compilers complain*/
typedef char UBYTE;                             /* Unsigned byte           */
#endif
#define BOOLEAN short                           /* 2 valued (true/false)   */
#ifdef  MC68000
typedef short WORD;                             /* Signed word (16 bits)   */
#else
typedef int WORD;                               /* Signed word (16 bits)   */
#endif

typedef unsigned short UWORD;           /* unsigned word           */

typedef long LONG;                              /* signed long (32 bits)   */
typedef unsigned long ULONG;          /* Unsigned long           */
#define REG     register                        /* register variable       */
#define LOCAL   auto                            /* Local var on 68000      */
#define EXTERN  extern                          /* External variable       */
#define MLOCAL           /* Local to module, left blank for symbols usage  */
#define GLOBAL  /**/                            /* Global variable         */
typedef void VOID;                              /* Void function return    */
#define DEFAULT int                             /* Default size            */
typedef float FLOAT;                            /* Floating Point          */
typedef double DOUBLE;                          /* Double precision        */


/****************************************************************************/
/*      Metaware "intrinsic functions"                                      */
/*	move and compare using the host machine's efficient instructions    */
/*	this functions are bild in the compiler, if not emulate them.       */

#define Meta_intrinsic	1	/* if 0  no Metaware --> emulate intrinsics */
				/* if 1  use Metaware intrinsic funtions    */

/****************************************************************************/

#if Meta_intrinsic

				/* compare 'size' bytes from 's' and 'd'     */
EXTERN	WORD _bcmp(BYTE *s, BYTE *d, WORD size);
/** #define _bcmp(s,d,size) \
*	_compare(s,d,size)  not implemented as intrinsic, using the library 
*			    call _mwcmp.   **/

				/*fill block 'b' with value 'v' for 'n'bytes */
#define _bfill(b, n, v) \
	_fill_char(b, n, v)
				/* move 'size' bytes from 'src' to 'des'     */
#define	_bmove(src, des, size) \
	_move(src, des, size)
				/* move  bytes with overlapping test   */
#define	_bmovt(src, des, size) \
	(src > des)  ? _move(src, des, size) : _move_right(src, des, size)
				/* fill block 'b' with zeros for 'n'bytes    */
#define _bzero(b, n) \
	_fill_char(b, n, 0)
				/* find bigger of two words, return bigger   */
#define _max(x, y) \
	_max(x, y)
				/* find lower of two words, return word      */
#define _min(x, y) \
	_min(x, y)
				/*********************************************/
#else				/* here we substitute the intrinsic functions*/
				/* there is a asembly Version for FlexOs in  */
				/* in TOOLS.A86	                             */
				/*********************************************/
/*	BCMP - Compare two buffers
*			Return:	0 = buffers are the same
*			else buffers are different
*/
EXTERN	WORD _bcmp(BYTE *s, BYTE *d, WORD size);

/*	BFILL - Fill a Buffer with 'fbyte'	 */
EXTERN	VOID _bfill(BYTE *buffer, WORD size, BYTE fbyte);

/*	BMOVE - move 'size' bytes from 's' to 'd', no overlapping test */
EXTERN	VOID	_bmove(BYTE *s, BYTE *d, WORD size);

/*	BMOVT - move 'size' bytes from 's' to 'd', with overlapping test */
EXTERN	VOID	_bmovt(BYTE *s, BYTE *d, WORD size);

/*	BZERO - Zero a Buffer of size 'size'	 */
EXTERN	VOID _bzero(BYTE *buffer, WORD size);

/*	MAX - Find the maximum of two values	 */
#define _max(x,y) \
	((x) > (y)) ? (x) : (y))

/*	MIN - Find the minimum of two values	 */
#define _min(x,y) \
	((x) < (y)) ? (x) : (y))

				/********************************************/
#endif				/* end of Metaware intrinsic substitution   */
				/********************************************/
/****************************************************************************/
/*      Miscellaneous Definitions:                                          */
/****************************************************************************/
#define FAILURE (-1)                    /*      Function failure return val */
#define SUCCESS (0)                     /*      Function success return val */
#define YES     1                       /*      "TRUE"                      */
#define NO      0                       /*      "FALSE"                     */
#define FOREVER for(;;)                 /*      Infinite loop declaration   */
#define NULL    0                       /*      Null character value        */
#define NULLPTR 0L      		/*      Null pointer value          */
#define EOF     (-1)                    /*      EOF Value                   */
#define TRUE    (1)                     /*      Function TRUE  value        */
#define FALSE   (0)                     /*      Function FALSE value        */

		/* Address types */

#define	VADDR	unsigned long
#define	LADDR	unsigned long
#define	PHADDR	unsigned long
#define	ADDR	unsigned long
#define	VALEN	unsigned long
#define	LALEN	unsigned long
#define	PALEN	unsigned long
#define	ALEN	unsigned long
#define BITNO	UWORD
#define NBITS	UWORD
#define	NPAGES	UWORD		/* Type for vars that hold counts of pages */

#endif
/****************************************************************************/

#endif
