
/*****************************************************************
 * "Copyright (C) 1985, Digital Research, Inc.  All Rights       *
 * Reserved.  The Software Code contained in this listing is     *
 * proprietary to Digital Research Inc., Monterey, California    *
 * and is covered by U.S. and other copyright protection.        *
 * Unauthorized copying, adaptation, distribution, use or        *
 * display is prohibited and may be subject to civil and         *
 * criminal penalties.  Disclosure to others is prohibited.  For *
 * the terms and conditions of software code use refer to the    *
 * appropriate Digital Research License Agreement."              *
 *****************************************************************/

/*===============================================================*
 *   Version 1.9.1      FD.C                                     *
 *                      Floppy Disk Main Module+ Entry Points.   *
 *---------------------------------------------------------------*
 *    VERSION   DATE    BY      CHANGE/COMMENTS                  *
 *---------------------------------------------------------------*
 *    1.0       6/12/85 reb     rewritten/added to system        *
 *    1.1       6/17/85 reb     changed calls yabnc to _bmove    *
 *    1.2       6/17/85 reb     removed dopatch, ptch286 module  *
 *    1.3       6/20/85 reb     changed initializers for LUTE    *
 *    1.4       6/24/85 reb     modified get dpd special call    *
 *    1.5       6/25/85 reb     SPR 06/24/85 0315                *
 *    1.6       6/26/85 reb     added copy dpb for copy cpm      *
 *    1.7 	6/13/86 mei	High C port.			 *
 *    1.8       11/6/86 KPB     Intialize RecalRetry in select.  *
 *    1.9       3/5/87  KPB     fix dma call                     *
 *    1.9.1     07/12/87 ldt	remove extern _bmove		 *
 *===============================================================*
                                                                 */
/************************************************************************
 *                      PHYSICAL FLOPPY DRIVERS                         *
 *                                                                      *
 *                       Intel 8272A / NEC 765                          *
 *                           version  2.00                              *
 *                                                                      *
 ************************************************************************
 ************************************************************************
 *                  N O T E   T O   M A I N T A I N E R S               *
 *  below I have added some comment regarding the current upgrade of    *
 *  the floppy drivers.  I should have been maintaining a maintenance   *
 *  list, I know, but I just forgot in the rush to make changes.        *
 *                                                                      *
 *  So while some of the changes are noted below, the list is not       *
 *  complete.  Read the TO DO list, as some comments are added there,   *
 *  and the maint. list below.                                          *
 *                                      - ktb 11-05-84                  *
 ************************************************************************
 ************************************************************************
 *  TO DO:                                                              *
 *      1.      currently, we do not support odd i/o sizes (non-sector) *
 *              size i/o.  If N is 0, we assume a 128 byte i/o.  There  *
 *              should be some method of indicating number of BYTES as  *
 *              opposed to the number of sectors.                       *
 *              11-05-84:  there is no indication that this is necessary*
 *              in any future release.                                  *
 *                              - ktb                                   *
 *                                                                      *
 *      2.      Need to support multi track i/o.                        *
 *              11-05-84:  no we don't; since mini-flops don't support  *
 *              multi track i/o (according to NEC Data Book), I don't   *
 *              think it's all that important to get multi-track i/o    *
 *              in.  But, if you wanna do it for the 8" floppies, be    *
 *              my guest.                                               *
 *                              - ktb                                   *
 *                                                                      *
 *      3.      Currently, if an unexpected interrupt, such as door     *
 *              open, happens during execution of a command, it will    *
 *              screw up the logic in the ISR.                          *
 *                                                                      *
 *              GREG - YOU REALLY OUGHT TO READ THIS STUFF; IT WILL     *
 *              SAVE YOU A LOT OF TIME...                               *
 *                                                                      *
 *      4.      timeouts on motor off and stuck fdc.                    *
 *              12-11-84:  added timeouts and motor off.                *
 *                      - ktb                                           *
 *                                                                      *
 *      5.      retries                                                 *
 *              12-11-84:  added retries in io_end                      *
 *                      - ktb                                           *
 *                                                                      *
 *      6.      eliminate seeks to cylinders we are already on          *
 *              12-11-84:  did this about 3 weeks ago.                  *
 *                      - ktb                                           *
 *                                                                      *
 *                                                                      *
 ************************************************************************/


#include        "portab.h"
#include	"io.h"			/* io system defines		*/
#include        "system.h"              /* system defines               */
#include        "atmc286.h"             /* machine defs                 */
/* (gam) 1 may - combined dk.h and floppy.h to one header file  */
#include        "fd.h"

#if METAWARE 
#define FD
#include "protos.h"
#endif

/************************************************************************
 *                                                                      *
 *                         Logical Disk Drivers                         *
 *                                                                      *
 *  version:  1.00                                                      *
 *                                                                      *
 *  MODS:                                                               *
 *  mod nbr     date      who   why                                     *
 *  -------     --------  ---   ---                                     *
 *  M0001       07/26/84  ktb   changes so setvec not called at every   *
 *                              init.                                   *
 *  M0002       07/27/84  ktb   changing mappimg from logical unit to   *
 *                              physical unit to be done in dkmd        *
 *  M0003       07/31/84  ktb   added RdSys, WrSys, FmSys to logical    *
 *                              level drivers.                          *
 ************************************************************************/


/***********************************************************************
*  conditional compile switches
*/

#define NO_SPECIAL      FALSE

/************************************************************************
*  external declarations
*/

EXTERN  DKH     fd_dh ;
EXTERN  FDLUTE  *FDU ;
EXTERN  IORB    *FDI ;
EXTERN  BYTE    *SPR_BUFF ;
EXTERN  BYTE    *SPC_BUFF ;
EXTERN  LONG    dm_dmamax() ;
EXTERN	VOID	outp();
EXTERN	BYTE	INP();
EXTERN	WORD	copymdb_ldd();
        
/* (gam) added externals                */
EXTERN  BYTE    FDDRIVE ;
EXTERN  WORD    CurCyl[] ;
EXTERN  UWORD   onesdpb[] ;
EXTERN  UWORD   twosdpb[] ;

/***********************************************************************
* forward declarations for routines in this module
        "keep the compiler happy"
*/

LONG    fd_init() ;     /*  initialize driver                           */
LONG    fd_subdrv() ;   /*  add a subdriver                             */
ERROR   fd_uninit() ;   /*  uninitialize a driver                       */
ERROR   fd_select() ;   /*  enable i/o on a unit                        */
LONG    fd_flush() ;    /*  disable i/o on a unit                       */
EMASK   fd_read() ;     /*  start a read operation on a unit            */
EMASK   fd_write() ;    /*  start a write operation on a unit           */
LONG    fd_get() ;      /*  get unit parameters                         */
LONG    fd_set() ;      /*  set new unit parameters                     */
LONG    fd_special() ;  /*  perform special functions                   */
ERROR   flop_io();
ERROR   setup_format( ) ;
SSN     GetSsn( );
BOOLEAN	fd_spcinit();



/***************************************************
 *  Driver Header -
 *      This is the driver header.  It MUST BE THE FIRST ITEM IN THE DATA 
 *      SEGMENT and is used by the supervisor install routines to 'install' 
 *      the driver into the i/o system
 */

#define DKMAXUNITS      2       
                        /*  max nbr of units this dvr allows            */
                        /*  a unit is a logical disk driver             */
                        /*  (eg: partition)                             */

#define DKFLAGVAL       1       
                        /*  driver sync flags.                          */
                        /*  0 = no sync required                        */
                        /*  1 = sync at driver level                    */
                        /*  2 = sync at unit level                      */

#define FILLVAL         0L      /*  fill value for control words        */

GLOBAL DKH fd_dh = 
{
        DVR_DISK,DKMAXUNITS,DKFLAGVAL,
        fd_init,                        /*  address of init routine     */
        fd_subdrv,                      /*  address of subdrv routine   */
        fd_uninit,                      /*  address of uninit routine   */
        fd_select,                      /*  address of select routine   */
        fd_flush,                       /*  address of flush routine    */
        fd_read,                        /*  address of read routine     */
        fd_write,                       /*  address of write routine    */
        fd_get,                         /*  address of get routine      */
        fd_set,                         /*  address of set routine      */
        fd_special,                     /*  address of special routine  */
        FILLVAL,                                        /* must be 0 !  */
        FILLVAL,                                        /* must be 0 !  */
        FILLVAL,                                        /* must be 0 !  */
        (PD **)0L,                      /*  ptr to rlr                  */
        FILLVAL                         /*  ptr to sys table            */
} ;



/***********************************************************************
*  DKUT -
*       Floppy Disk Unit Table.  An array of entries which contain
*       information about the logical unit.  Indexed by the logical
*       unit number (number passed in parm block from supervisor).
*/

FDLUTE  DKUT[ ] =
{
        /*
         *  logical unit 0
         */

                                /*  IORB .............................. */
                0,              /*    io_op                             */
                0,              /*    io_type                           */
                0,              /*    io_totnsecs                       */
                0L,             /*    io_stssn                          */
                0L,             /*    io_buffer                         */
                0,              /*    io_rtc                            */
                    0,          /*        io_pflgs                      */
                    0,          /*        io_dkaddr.hsc_head            */
                    0,          /*        io_dkaddr.hsc_sector          */
                    0,          /*        io_dkaddr.hsc_cyl             */
                0,              /*    io_nsecs                          */
                0L,             /*    io_dmaddr                         */
                0L,             /*    io_dmcount                        */
                0L,             /*    io_error                          */
                                /*  ................................... */
        (PD *) 0L,              /*  current Proc Descr Address  [1]     */
        (PD *) 0L,              /*                                      */
        0L,                     /*  current swi                         */
        (LDD *)0L,              /*  ptr to current Log Disk Descr       */
        (DKH *)0L,              /*  pointer to subdriver dh             */
        0L,                     /*  i/o flag number - init'd @ init     */
        0,                      /*  logical unit number                 */
        0,                      /*  physical Drive Number               */
        FALSE,                  /*  open door support?                  */
        FALSE,                  /*  in format mode?                     */
        FALSE,                  /*  is door open? (open door supp only) */

        /*
         *  logical unit 1
         */

                                /*  IORB .............................. */
                0,              /*    io_op                             */
                0,              /*    io_type                           */
                0,              /*    io_totnsecs                       */
                0L,             /*    io_stssn                          */
                0L,             /*    io_buffer                         */
                0,              /*    io_rtc                            */
                    0,          /*        io_pflgs                      */
                    0,          /*        io_dkaddr.hsc_head            */
                    0,          /*        io_dkaddr.hsc_sector          */
                    0,          /*        io_dkaddr.hsc_cyl             */
                0,              /*    io_nsecs                          */
                0L,             /*    io_dmaddr                         */
                0L,             /*    io_dmcount                        */
                0L,             /*    io_error                          */
                                /*  ................................... */
        (PD *) 0L,              /*  current Proc Descr Address [1]      */
        (PD *) 0L,              /*                                      */
        0L,                     /*  current swi                         */
        (LDD *)0L,              /*  ptr to current Log Disk Descr       */
        (DKH *)0L,              /*  pointer to subdriver dh             */
        0L,                     /*  i/o flag number - init'd @ init     */
        1,                      /*  logical unit number                 */
        0,                      /*  physical Drive Number               */
        FALSE,                  /*  open door support?                  */
        FALSE,                  /*  in format mode?                     */
        FALSE,                  /*  is door open? (open door supp only) */

} ;


/*
*  [1]  there are two pdaddr's in the FDLUTE:  one is the pdaddr of the calling
*       process - this one we use for flagsets.  The other is the pdaddr of 
*       the process who's address space the buffer is in.  these may not 
*       necessarily be the same.
*/





/***************************************************
*  fd_init -
*/

ERROR   fd_init(unitnbr)
LONG    unitnbr ;
{
        EXTERN	ISR     flop_interrupt() ;      /*  interrupt routine   */
        EXTERN  ERROR   fdc_specify() ;         /*  fdc specify parms routine */
        BYTE    unitno ;
        FDLUTE  *u ;
        ERROR   r ;
        UWORD   iflgs ;

        IORB *i ;

        unitno = (BYTE) unitnbr ;

        if( unitno > DKMAXUNITS )
                return( ED_DISK | E_UNITNO ) ;

        u = &DKUT[ unitno ] ;
        i = (IORB *)u ; 

        /* allocate resources   */
        if( (u->fu_ioflagno = FLAGGET() ) != NULLPTR )
                if ( (u->fu_lddp = (LDD *) SALLOC((LONG)sizeof(LDD))) == NULLPTR )
                                return( ED_DISK | E_POOL ) ;

        /* (reb) bit 9 of iflgs is the read after write install flag */
        iflgs = (UWORD)(unitnbr >> 16) ;
        if ( iflgs & (WORD)0x0200 ) 
                        i->io_pflgs |= 0x02 ;

        if(  !unitno  )                 /*  unit zero           */
        {
                SETVEC( flop_interrupt , FDINTNO ) ;    /*  set int vec */

#if     (MACHINE == XMACHINE)
                OUTP(  0x21, INP( 0x21 ) & (~0x40)  ) ; /*  init pic    */
#endif

#if     (MACHINE == COMPUPRO)
                OUTP(0x51,INP(0x51) & 0xef);
#endif


                if( !fd_spcinit() )             /*  special buffer init */
                        return( ED_DISK | E_POOL ) ;
                if((r = fdc_specify( DEFSRT, DEFHUT, DEFHLT, DEFND)) != NULLPTR)
                        return( r ) ;

        }
        
        return(  (LONG)(DVR_DISK) ) ;
}

/*
**
*/


/***************************************************
*  fd_subdrv -
*       establishes the link between the logical level
*       drivers and the physical level drivers.  
*/

LONG    fd_subdrv(pb)
DKSDPB  *pb ;
{
        return( ED_DISK | E_IMPLEMENT ) ;
}



/***************************************************
*  fd_uninit -
*       Uninitialize a driver
*/

ERROR   fd_uninit(unitno)
LONG    unitno ;
{
        return( ED_DISK | E_IMPLEMENT ) ;
}


/***************************************************
 *  fd_flush -
 *      dealloc:  ppd for this unit.
 */

LONG    fd_flush(pb)
DPBLK   *pb ;
{
        return(SUCCESS) ;
}


/***************************************************
*  fd_select -
*       determines the type of drive we are on (if
*       that is a variable) and the type of media
*       in the drive.
*/


ERROR   fd_select(pb)
DKSELPB *pb ;           /*  ptr to select parm block                    */
{
        EXTERN  BYTE    RecalRetry;
        EXTERN	ERROR   fd_DetermineMedia() ;
        ERROR   r ;             /*  return code                         */

        RecalRetry = 2;
        FDU = &DKUT[ pb->dks_unitno ] ;         /*  ptr to FDLUTE       */
        FDDRIVE = FDU->fu_driveno = pb->dks_unitno ;
        FDI = (IORB *) FDU ;                    /*  io req blk          */

        FDU->fu_f_pdaddr = (*fd_dh.dkh_pdaddr) ;        /*  pdaddr for flags    */
        FDU->fu_b_pdaddr = FDU->fu_f_pdaddr ;   /*  pdaddr for buffer   */

        FDU->fu_swi = 0L ;                      /*  null swi addr [1]   */

#if     (MACHINE == XMACHINE)
        FDU->fu_ods = FALSE ;
#endif

#if     (MACHINE == COMPUPRO)
        FDU->fu_ods = TRUE ;
#endif

        r =  fd_DetermineMedia( FDU )  ;


        if(  !r  )                              /*  copy mdb to callers buffer  */
        {
                _bmove(  &FDU->fu_lddp->ld_mdb ,pb->dks_mdbp , sizeof(MDB) ) ;
        }

        return( r ) ;
}
/*
*  [1]  the select parm block does not contain a swi or pdaddr entry.  this is
*       because the call comes from the file system.  Assume that the current
*       process is requesting disk i/o which the file system deems needs a 
*       select before granting.
*/



/***************************************************
 *  fd_read -
 *      start read operation from disk.
 */

EMASK   fd_read(pb)
DKPBLK  *pb ;
{
/* (reb) added conditional for the verify function */
        
        if ( pb->dk_flags & VFYBIT ) {
                return( flop_io( DKVFY , pb ) ) ;
        }
        else  {
                return( flop_io( DKREAD , pb )  ) ;
        }
}




/***************************************************
*  fd_write -
*       start write operation to disk.
*/

EMASK   fd_write(pb)
DKPBLK  *pb ;
{
EMASK   msk ;
ERROR   rtn ;

        msk = ( flop_io( DKWRITE , pb )  ) ;    /* do the write and get mask */

        if ( FDI->io_pflgs & 0x02 ) 
                {       /* if verify after write */
                WAIT ( msk ) ;
                if ( ( rtn = ARET ( msk ) ) < 0L ) 
                        return ( rtn ) ;
                return ( flop_io(DKVFY , SPR_BUFF) ) ;
                }
        else
                return ( msk ) ;

}



/**************************************************************************
*  flop_io -
*       do the read/write.
*/

ERROR   flop_io( op , pb )
BYTE    op ;                                    /*  read or write       */
DKPBLK  *pb ;                                   /*  ptr to parm block   */
{

        HSCADDR *p ;            /* (reb) for extraction of disc address */

        EMASK   e ;

        EXTERN	ASR     flopasr_io() ;

/* (reb) this pblk is used to do the verify on the next pass of fdio */
        _bmove( pb, SPR_BUFF, sizeof(DKPBLK) ) ;
/****/

        /*
        **  setup globals 
        */


        FDU = &DKUT[ pb->dk_unitno ] ;          /*  ptr to FDLUTE       */
        FDDRIVE = FDU->fu_driveno = pb->dk_unitno ;
        FDI = (IORB *) FDU ;                    /*  io req blk          */

        /*
        **  initialize iorb
        */
        FDI->io_op = op ;                       /*  read,write, or verify */
        FDI->io_type = pb->dk_flags & 0x0600 ;  /*  bits 8, 9, 10       */
        FDI->io_totnsecs = pb->dk_nsecs ;       /*  nbr of sector req'd */
        FDI->io_rtc = FDIORTC ;
        FDI->io_pflgs &= ~1 ;                   /* (reb) physical flags added */
		FDI->io_error = 0l ;					/* zero out the error */
        /*
        **  Head/Sector/Cylinder  or   Logical Sector Number? [1]
        */

        if( pb->dk_flags & DKF_HSCADDR)   {     /* (reb) pass thru hscaddr */
                if (FDI->io_totnsecs == 1)  {

                        p = (HSCADDR *) &pb->dk_record ;
                        /* (reb) extract the hsc address from the record number */
                        FDI->io_dkaddr.hsc_head = p->hsc_head ;
                        FDI->io_dkaddr.hsc_sector = p->hsc_sector ;
                        FDI->io_dkaddr.hsc_cyl = p->hsc_cyl ;
        
                        FDI->io_pflgs |= 1 ;
        
                        }
                else {
                        FDI->io_stssn = GetSsn (&pb->dk_record, FDU) ;
                        if (FDI->io_stssn < FDU->fu_lddp->ld_stssn ) {
                                return (ED_DISK | E_SEEK) ;
                                }
                        if (FDI->io_stssn + FDI->io_totnsecs > ( FDU->fu_lddp->ld_endssn +1 )) {
                                return (ED_DISK | E_SEEK) ;
                                }
                        }
                }
        else {
                FDI->io_stssn = pb->dk_record + FDU->fu_lddp->ld_lsnoffset; 

                /*
                **  check address range 
                */

                if(  FDI->io_stssn   <   FDU->fu_lddp->ld_stssn )
                        return( ED_DISK | E_SEEK ) ;
                if( FDI->io_stssn + FDI->io_totnsecs  >  ( FDU->fu_lddp->ld_endssn + 1 ))
                        return( ED_DISK | E_SEEK ) ;      /* (reb) bug fix for last sector */
        }


        /*
        **  is buffer in system space or user space ?
        */

        FDI->io_buffer = (SYSADDR) pb->dk_buffer ;
        if( pb->dk_flags & DKF_UADDR )
                FDI->io_buffer = (SYSADDR) SADDR( FDI->io_buffer ) ;

        /*
        **  get proc descr addresses for buffer address conversions and
        **  flag sets; get swi address
        */

        FDU->fu_b_pdaddr = (PD*) pb->dk_pdaddr ;/*  for buffer addr conver.  */
        FDU->fu_f_pdaddr = (*fd_dh.dkh_pdaddr) ; /*  for flag sets           */

        FDU->fu_swi = pb->dk_swi ;


        DOASR( flopasr_io , 0L , 0L , DKASRPRI ) ;

        if( (e = FLAGEVENT( FDU->fu_ioflagno , pb->dk_swi ) ) != NULLPTR ) 
            return( e ) ;
        return( ED_DISK | E_POOL ) ;
}
/*
*  [1]  addr in HSC format... relative to start of phys disk
*
*       addr in LSN format, relative to start of logical Track 0 ... 
*       add LSN offset.
*       
*       (reb) addendum:
*       Pass thru of the HSC address must be made on sector/cylinder
*       numbers that are out of bounds due to protection schemes.
*       This pass thru will take place only when the request is for a single
*       sector.
*       
*/


/**************************************************
*  fd_get -
*       The parameters for get are machine specific.
*       We will therefore call the machine dependent
*       module to do the work.
*/
LONG    fd_get(pb)
DKPBLK  *pb ;
{
        EXTERN	ERROR   fd_mdget();  /* routine is in fdmd (dependant module) */
        return( (fd_mdget)(pb) ) ;
}



/***************************************************
 * fd_set -
 */
LONG    fd_set(pb)
DPBLK   *pb ;
{
        return( ED_DISK | E_IMPLEMENT ) ;         /*  per spec    */
}



/***************************************************
*  fd_special -
*/
LONG    fd_special(spb)
DKSPPB  *spb ;
{
        FDLUTE  *u = &DKUT[ spb->dsp_unitno ] ;
		LDD		*l = u->fu_lddp ;
        BYTE    opt ;
        ERROR   r ;
        FDDRIVE = spb->dsp_unitno ;             /* set the drive number      */        
        switch( opt = spb->dsp_funcno )
        {
                case    DKO_RDSYS:              /*  READ  SYSTEM AREA        */
                case    DKO_WRSYS:              /*  WRITE SYSTEM AREA        */
                case    DKO_FMSYS:              /*  FORMAT SYSTEM AREA       */
                        r = ( ED_DISK |E_IMPLEMENT );               
                        break ;
                case    DKO_FMTRK:              /*  FORMAT TRACK             */
                        r = setup_format(spb) ; 
                        break ;
                case    DKO_INFMT:              /*  INIT FORMAT              */
                        copymdb_ldd( spb->dsp_buffer , u->fu_lddp ) ;
						CurCyl[ FDDRIVE ] = -1 ;		 /* Force recalibrate */
                        r = SUCCESS ;
                        break ;
                case    DKO_GDPB:               /* GET DRIVE PARAMETER BLOCK CPM SUPPORT */
						if ( ! (l->ld_mdb.md_format) )  {
							r = (ED_DISK | E_BADPB);
						}
						if ( l->ld_mdb.md_nheads == 1 )  {
							_bmove ( twosdpb, spb->dsp_buffer, spb->dsp_bufsiz) ;
						}
						else  {
							_bmove ( onesdpb, spb->dsp_buffer, spb->dsp_bufsiz) ;
						}
						r = SUCCESS ;
                        break ;
                default:
                        r = (ED_DISK | E_BADPB );

        }
        return( r ) ;
}


/***********************************************************************
*  setup_format -
*/

ERROR   setup_format( pb )
DKSPPB  *pb ;
 {
        EMASK   IoMask ;
        FPBUF   *fp ;
        BYTE    op ;
	LDD	*l;
        WORD    chrnsize ;      /*  nbr of bytes in chrn buffer [1]     */
	EXTERN  BOOLEAN fd_BCHRN() ;    /*  builds the chrn buffer              */
        EXTERN	ASR     format_seek() ;


/* set up global variables */
        FDU = &DKUT[ pb->dsp_unitno ] ;         /*  ptr to FDLUTE       */
        FDI = (IORB *) FDU ;                    /*  io req blk          */

        FDU->fu_f_pdaddr = (*fd_dh.dkh_pdaddr) ; 
        FDU->fu_b_pdaddr = FDU->fu_f_pdaddr ;
        FDU->fu_swi = 0L ;

        l = FDU->fu_lddp ;              /* ptr to LDD           */
        fp = pb->dsp_prbuf ;            /* ptr to fmt parm buff */

        switch( pb->dsp_flags & 0x5 )
        {
                case 0 : op = DKFMT ;           /* plain format         */
                         break ;        
                case 1 : op = DKFMTLST ;        /* format w/list of sec #s      */
                         break ;
        }
        FDI->io_op = op ;               

        FDI->io_stssn = (LONG) fp->fp_bytsec ;  /* bytes per sector     */
        FDI->io_dkaddr.hsc_head = fp->fp_head ; /* head                 */
        FDI->io_dkaddr.hsc_sector = fp->fp_stsec ;/* starting sector    */
        FDI->io_dkaddr.hsc_cyl = fp->fp_cyl ;   /* cylinder             */
        FDI->io_nsecs = fp->fp_sectrk ;         /* nbr secs, this trk   */
        FDI->io_totnsecs = (LONG) &fp->fp_list ;        /* ptr to sector list   */

        /* temp use of io_rtc for density/fill info, not retry count 
        - sorry, this needs to be fixed */
        FDI->io_rtc = ( fp->fp_ddens << 8 ) + fp->fp_fill ;

        chrnsize = 4 * (WORD)FDI->io_stssn ;    /*  4 x nbr of sectors  */

        FDI->io_buffer = (LONG)SPC_BUFF ;     /*  buffer for chrn data */
        FDI->io_dmaddr = PADDR( FDI->io_buffer ) ;      /*  for dma             */
        FDI->io_dmcount = chrnsize ;            /*  "                   */
        
        /* build the cyl/head/sec/rec buffer */
        if ( !fd_BCHRN( FDU ) )
                return( ED_DISK | E_PARAM );


/* note this formating is considered "synchrous", ie the driver blocks here
until the flagset in flop_iocompl */
        IoMask = FLAGEVENT( FDU->fu_ioflagno , 0L ) ;
        DKASR( format_seek , FDU , 0L ) ;
        WAIT( IoMask ); /* flagset done in flop_iocompl () */
        return ( ARET( IoMask ) );
}

/*
*  [1]  the 8272/765 fdc requires that the cpu supply it with 4 bytes of 
*       information for each sector it formats on the track.  the bytes are:
*         C:  cylinder number.
*         H:  head number.
*         R:  record number (sector number).
*         N:  bytes per sector indicator.
*       this information is what is used to write out the sector id infor.
*       it is not necessarily the same as the logical HSC address (e.g., there
*       could be a "funny" sector number used for copy protection purposes.
*/




/**************************************************************************
*  fd_spcinit -
*       init the special buffer.  This buffer is used during format, build
*       build the chrn information in; in fdmd, to read in the first two 
*       sectors for media determination; and, on the pc/at, for blocking
*       and deblocking when user buffers cross physical page boundaries.
*/
BOOLEAN fd_spcinit()
{

        /*******************/
        LONG    n ;
        BYTE    *b ;
        BYTE    *b1 ;
        LONG    *AddrTemp;
        /*******************/

        /*
        **  allocate a double size buffer.  if the lower half crosses a 
        ** page boundary, use the upper half.  Otherwise, use the lower
        ** half.  Currently, the half allocated to srp_buff is not used.
        */

        b = (BYTE *)SALLOC( (LONG) (4 * FDMAXREC) ) ;
        if( !b ) return( FALSE ) ;

        b1 = b + (2 * FDMAXREC) ;       /* b1 => 2nd half of buffer     */

        n = dm_dmamax( (LONG) b , (LONG) (2 * FDMAXREC),&AddrTemp ) ;
        if( n < (2 * FDMAXREC) )
        {
                /*  lower half crosses page boundary, use upper half    */
                SPC_BUFF = b1 ;                 /*  special buffer      */
                SPR_BUFF = b ;                  /*  spare buffer        */
        }
        else
        {
                /*  lower half does not cross page... use lower half    */
                SPR_BUFF = b1 ;                 /*  spare buffer        */
                SPC_BUFF = b ;                  /*  special buffer      */
        }

        return( TRUE ) ;

}



/***********************************************************************
*  GetSsn -
*       calculate an ssn from an hsc addr.
*       remember that an hsc address has the structure:
*               HH  SS  CCCC   (head (byte), sector (byte), cylinder (word))
*
*       we check the head and sector address against the highest legal
*       value as determined by the mdb for the drive (we don't bother with
*       the cylinder, as too high of a cylinder nbr would produce an SSN
*       well outside the bounds of the logical disk, which we assume is 
*       checked elsewhere).  If we think we have a bogus address, we return
*       -1 (a VERY large SSN, sure to be out of any logical disks range).
*
*       (SSNs are zero oriented:  0, 1, 2,...)
*/
SSN     GetSsn( hsc , u )
HSCADDR *hsc ;                          /*  disk addr in HSC format     */
FDLUTE  *u ;                            /*  ptr to Log Unit Table entry */
{
        MDB     *m ;
        SSN     ssn ;
        WORD    cyl , sector ,  head ;

        m = &u->fu_lddp->ld_mdb ;

        if                                              /*  range check */
        (
                ( ( (head = (WORD) hsc->hsc_head)  >  (m->md_nheads - 1) )  ||
                ( (sector = (WORD) hsc->hsc_sector)  == 0       )   )       ||
                ( sector  >  m->md_sectrk )  
        )
                ssn = -1 ;
        else                                            /*  calc ssn    */
        {
                cyl = (WORD) hsc->hsc_cyl ;

                ssn = 
                (
                        ( cyl * (m->md_sectrk * m->md_nheads)  )  +
                        ( head * m->md_sectrk )                   +
                        sector - 1
                ) ;
        }

        return( ssn ) ;         
}
