/*****************************************************************
 * "Copyright (C) 1985, Digital Research, Inc.  All Rights       *
 * Reserved.  The Software Code contained in this listing is     *
 * proprietary to Digital Research Inc., Monterey, California    *
 * and is covered by U.S. and other copyright protection.        *
 * Unauthorized copying, adaptation, distribution, use or        *
 * display is prohibited and may be subject to civil and         *
 * criminal penalties.  Disclosure to others is prohibited.  For *
 * the terms and conditions of software code use refer to the    *
 * appropriate Digital Research License Agreement."              *
 *****************************************************************/

/*===============================================================*
 *   Version 3.2.2      IFDMD.C                                  *
 *                      Floppy Disk Media Determination Code.    *
 *---------------------------------------------------------------*
 *    VERSION   DATE    BY      CHANGE/COMMENTS                  *
 *---------------------------------------------------------------*
 *    1.0       6/12/85 reb     rewritten/added to system        *
 *    1.1       6/17/85 reb     changed calls yabnc to _bmove    *
 *    1.2       6/19/85 reb     removed bpb copy and check       *
 *    1.3       6/21/85 reb     removed rest of bpb routines     *
 *    2.0	7/10/85	FMB	Fd_Determine(): Took out cpm ds  *
 *				support. Stssn's were all wrong. *
 *    3.0	8/15/85	FMB	fd_determine(): replaced "1" in  *
 *				call to copy_mdb with "l".	 *
 *    3.1	6/17/86 mei	High C port. Disk errors OR'd    *
 *				  with ED_DISK.			 *	 
 *    3.2       1/27/87 KPB     Added INPW and OUTPW for 386     *
 *    3.2.1     07/12/87 ldt    removed extern _bmove		 * 
 *===============================================================*
 *  INCLUDES:                                                    */
#include        "portab.h"
#include        "system.h"              /*  system defines              */
#include        "atmc286.h"             /* machine defs                 */
#include        "io.h"                  /*  i/o driver definitions      */
/* (gam) 1 may - combined dk.h and floppy.h to one header file  */
#include        "fd.h"
#if ( MACHINE == XMACHINE )
#include        "atmdbs.h"
#endif
#if ( MACHINE == COMPUPRO )
#include        "cpmdbs.h"
#endif

#if METAWARE 
#define IFDMD
#include "protos.h"
#endif

/****************************************************************************
*
*                               floppy disk
*                           media determination module
*
****************************************************************************/

/*
**  misc constants
*/

#define FirstTime       0
#define SecondTime      1
#define NBR_VALID_SECS  sizeof(starray)/sizeof(WORD)

/*
*  forward declarations
*/

ERROR   fd_DetermineMedia() ;
ERROR	ReadFirst2();
ERROR	ReadSecondSide();
ERROR	fd_dmphyio();
VOID	copymdb_ldd();
MDB	*MapFatId();

/*
**  external declarations
*/

EXTERN  FDLUTE  *FDU ;
EXTERN  IORB    *FDI ;
EXTERN  BYTE    FDDRIVE ;
EXTERN  BYTE    *SPC_BUFF ;

EXTERN  LONG    flopasr_io() ;
EXTERN	VOID	outp();
EXTERN  VOID    OUTPW();
#if ( MACHINE == COMPUPRO )
EXTERN	FDLUTE	DKUT[];
#endif

/******************************************************************************
                see cpmdbs.h/atmdbs.h for initilized MDB data sturctures

******************************************************************************/

/******************************************************************************
*  MAXDRTC -
*       retry count for trying different mdbs
*/
#define MAXDRTC sizeof(mdbarray)/sizeof(MDB*)   /* # entries in try list  */

/******************************************************************************
*  fd_DetermineMedia -
*       Synchronous interface to fd_md code.  Call this routine from 
*       synchronous code only.
*/
ERROR   fd_DetermineMedia( u )
FDLUTE  *u ;
{
        MDB     *m ;
        LDD     *l ;
        MDB     **mdbpp ;
#if     (MACHINE == XMACHINE)
        BYTE    *xptr ;
#endif
        ERROR   r ;
        WORD    rtc ;

        /*  routines  */

        							
        l = u->fu_lddp ;                	          /*  init variables */
        FDU = u ;
        FDI = (IORB *) u ;
        FDDRIVE = u->fu_driveno ;

        		     /* setup a pointer to the array of mdb pointers */
        mdbpp = mdbarray ; 
#if     (MACHINE == XMACHINE)
        xptr = xvalarray ;              	     /* data rate value, too */
#endif

        /*
        **  FOR each mdb in the mdb array OR until good read:
        **  read in the first two sectors... try to identify from bpb or
        **  fat id.  if readable, but not identifiable, assume cpm and 
        **  find out if double or single sided.  if not readable, assume
        **  raw disk, and return best guess at mdb.  if hardware error or
        **  not ready, return error
        */

        for( rtc = MAXDRTC ; rtc-- ; mdbpp++ ) 
        {
                			/*  setup ldd's mdb for read attempt */
                copymdb_ldd( *mdbpp , l ) ;     
                m = &l->ld_mdb ;                            /*  current mdb  */
#if             (MACHINE == XMACHINE)
                OUTPW( XPORT , xval[ FDDRIVE ] = *xptr ) ;       
#endif			
		*(SPC_BUFF + m->md_secsiz) = 0 ;
                r = ReadFirst2( SPC_BUFF , u ) ;
                if( !r )         	       /*  we have a successful read */
		{
		    if((m = MapFatId(  *(SPC_BUFF + m->md_secsiz))) != NULLPTR )
		    {			/*  build ldd from mapped fat id [2] */
                        copymdb_ldd( m , l ) ;
                        return( SUCCESS );
                    }
                    else         			  /*assume cpm disk  */
		    {
/*                      copymdb_ldd( &mdb_2sidedcpm, l ) ;
                        if(r = ReadSecondSide(SPC_BUFF, u , FirstTime))
                            r = ReadSecondSide(SPC_BUFF,u,SecondTime) ;
                        if( r )	 
			{
                            copymdb_ldd( &mdb_1sidedcpm , l ) ;
                            return( SUCCESS );
                        }
*/
			copymdb_ldd( &mdb_unformatted , l );
			return(SUCCESS);
                   }
                }
                else 
		if ( ( r == ( ED_DISK | E_READY ) )    || 
		     ( r == ( ED_DISK | E_DKATTACH ) ) || 
		     ( r == ( ED_DISK | E_WPROT ) )		) 
                    return( r ) ;

                				   /*  otherwise, try again  */
#if             (MACHINE == XMACHINE)
                xptr++ ;
#endif
        }

        					    /*  retries have failed  */
        copymdb_ldd( &mdb_unformatted , l ) ;
        return( SUCCESS );
}
/*
**  [1] bpb is in first sector.
**
**  [2] fat id is first byte in second sector
*/


/****************************************************************************
*  ReadFirst2 -
*       Attempts to read in the first two sectors on the disk.
*/

ERROR   ReadFirst2( b , u )

BYTE    *b ;                    /*  input buffer                        */
FDLUTE  *u ;                    /*  ptr to unit table                   */

{

		FDI = (IORB *)u ;
        FDI->io_op = DKREAD ;                   /*  read                */
        FDI->io_stssn = (SSN)0 ;                /*  boot and            */
        FDI->io_totnsecs = 2L ;                 /*      fat sectors     */
        FDI->io_rtc = 0 ;                       /*  no retries [1]      */
        FDI->io_pflgs &= ~1 ;                   /* (reb) zero the phys flags not hsc */
        FDI->io_buffer = (SYSADDR) b ;

        return( fd_dmphyio( u ) ) ;
}
/*
** [1]  we want to fail immediately if we have the wrong mdb
*/


/****************************************************************************
*  ReadSecondSide -
*       attempts to read the second side of the disk on one of two spots,
*       depending on the try switch.  First time we try track 0.  Second
*       time we try cylinder 0x10.
*
*  NOTE:  the formula used to calculate the stssn is:
*               stssn = (2c+h)(sectrk)+1
*       where
*               c    is the desired cylinder number
*               h    is the head number (always 1, in this case (not 0))
*               sectrk  is the number of sectors per track.
*
*       this gives us the first sector on the desired logical track.
*
*       call:
*               r = ReadSecondSide( u , FirstTime ) ;
*               r = ReadSecondSide( u , SecondTime ) ;
*/
ERROR   ReadSecondSide( buff, u , sw ) 

BYTE    *buff ;
FDLUTE  *u ;
BOOLEAN sw ;

{
        IORB    *i ;
        MDB     *m ;
        LONG    stssn ;
        WORD    cyl ;

        m = &u->fu_lddp->ld_mdb ;

	i = (IORB *)u;

	i->io_dkaddr.hsc_head = 1;
	i->io_dkaddr.hsc_sector = 1;

        if( ! sw )              /*  if first time                       */
	    i->io_dkaddr.hsc_cyl = 0;
/*
                cyl = 0 ; 
*/      else    
	    i->io_dkaddr.hsc_cyl = 2;
/*
                cyl = 0x10 ;    

        stssn = (2*cyl + 1)*(m->md_sectrk) + 1 ;
*/

        i->io_op = DKREAD ;
        i->io_stssn = stssn ;
        i->io_totnsecs = 1L ;
        i->io_rtc = 0L ;
	i->io_pflgs |= 1;		/* HSC address in stssn */
        i->io_buffer = (SYSADDR) buff ;

        return( fd_dmphyio( u ) ) ;             /*  do the read         */
        
}

/***************************************************************************
*  fd_dmphyio -
*       get sync'd on the physical level routine.
*/

ERROR   fd_dmphyio( u )
FDLUTE  *u ;                    /*  ptr to FDLUTE                       */
{
        EMASK   e ;

        e = FLAGEVENT( u->fu_ioflagno , 0L ) ;  /*  event for i/o       */
        DKASR( flopasr_io , u , 0L ) ;          /*  start i/o           */
        WAIT( e ) ;                             /*  wait for compl'n    */
        return( ARET(e) ) ;
}


/************************************************************************
*  copymdb_ldd -
*
*       Given the addresses of an MDB and an LDD, make an LDD from the
*       info in the MDB.
*/

VOID    copymdb_ldd(m,l)
MDB *m;
LDD *l;
{

    l->ld_stssn = (SSN) 0 ;
    l->ld_endssn = (SSN)m->md_nsecs - 1 ;
    l->ld_syssecs = m->md_syssize / m->md_secsiz ;
    l->ld_lsnoffset = l->ld_syssecs ;                           /* [1] */

/* (gam) 7 nov - 1st try  resolving the double density 
        see - buildtf() in pfdphys.c */

        if ( m->md_secsiz > 256 )
                      l->ld_ddens = TRUE ;
        else
                      l->ld_ddens = FALSE ;

    /* Make a copy of the MDB for *our* use. */

    _bmove( m, &l->ld_mdb, sizeof(MDB) ) ;

}
/*
**  [1] re: lsnoffset and syssecs.  Note that lsnoffset is the offset from
**      SSN(0) (first physical sector on the diskette) to LSN(0) first sector
**      on track which contains the first FAT.  syssecs is the number of sectors
**      in the system area - that area which has a different structure (e.g.,
**      density) than the rest of the disk.  While usually the same (and 
**      usually zero), they may differ on some oem's formats.
**
**      we do not currently provide a programatic way of determining lsnoffset.
*/



/****************************************************************************
*  MapFatId -
*       Given a Fat ID, returns a pointer to a corresponding mdb or a null
*       ptr.
*/

MDB     *MapFatId( fatid )
BYTE    fatid ;
{
        switch( fatid )
        {
#if (MACHINE == XMACHINE) /* hyper flop fat id */
                case 0xf9:  return(&mdb_f9) ;
#endif
                case 0xfc:  return(&mdb_fc) ;
                case 0xfd:  return(&mdb_fd) ;
                case 0xfe:  return(&mdb_fe) ;
                case 0xff:  return(&mdb_ff) ;
                default:    return((MDB*)0) ;
        }
}


/****************************************************************************
*  SysSize -
*       get system size from boot record.  This is media / machine dependent.
*/

LONG    SysSize( bp )
BPB     *bp ;
{
#if     (MACHINE == XMACHINE)
        return(0L) ;
#endif
}


/*****************************************************************************
*  fd_mdget -
*       the *_get call made by the disk resource mgr is media dependant
* so the inclusion of *_mdget() routine in this modules is intended to signify 
* that fact.
*/

ERROR   fd_mdget( pb )
DKGETPB *pb ;

#if MACHINE == COMPUPRO
{
        pb->fgt_dtype = 03 ;    /*  removable, with door open support */
        pb->fgt_maxrs = FDMAXREC ;      /*  max record size               */
        pb->fgt_addr = 0L ;
        pb->fgt_maxfatrecs = FDMAXFRECS ;
        pb->fgt_mxfsize = FDMAXFRECS * FDMAXREC ;
        pb->fgt_mxdsize = mdb_fd.md_dirsize ;

        FDU = &DKUT[ pb->fgt_unitno ] ;         /*  ptr to FDLUTE       */
        FDU->fu_ods = TRUE ;
        pb->fgt_addr = (UBYTE *)&FDU->fu_ods ;

        return(E_SUCCESS) ;
}
#endif

#if MACHINE == XMACHINE
{
        pb->fgt_dtype = 01 ; /* removeable, no door open support */
        pb->fgt_maxrs = FDMAXREC ;      /* max record size               */
        pb->fgt_addr = 0L ;
        pb->fgt_maxfatrecs = FDMAXFRECS ;
        pb->fgt_mxfsize = FDMAXFRECS * FDMAXREC ;
        pb->fgt_mxdsize = mdb_f9.md_dirsize ;
        return(E_SUCCESS) ;
}
#endif
