/*****************************************************************
 * "Copyright (C) 1985, Digital Research, Inc.  All Rights       *
 * Reserved.  The Software Code contained in this listing is     *
 * proprietary to Digital Research Inc., Monterey, California    *
 * and is covered by U.S. and other copyright protection.        *
 * Unauthorized copying, adaptation, distribution, use or        *
 * display is prohibited and may be subject to civil and         *
 * criminal penalties.  Disclosure to others is prohibited.  For *
 * the terms and conditions of software code use refer to the    *
 * appropriate Digital Research License Agreement."              *
 *****************************************************************/

/*===============================================================*
 *   Version 1.2        IIFDMOT.C                                *
 *                      Motor spinup and spin down routines.     *
 *---------------------------------------------------------------*
 *    VERSION   DATE    BY      CHANGE/COMMENTS                  *
 *---------------------------------------------------------------*
 *    1.0       6/12/85 reb     rewritten/added to system        *
 *    1.1	6/13/86 mei	High C Port.                     *
 *    1.2       1/27/87 KPB     Added OUTPW INPW                 *
 *===============================================================*
 *  INCLUDES:                                                    */

/**************************************************************************
*  fd_motor -
*/
BOOLEAN fd_motor( on , driveno )
BYTE    on , driveno ;
{
        /**********/
        ENUM            e ;
        BYTE            b ;
        /**********/


        if( on )
        {
                /*  he wants us to turn the drive on  */

                IoFlag[ driveno ] = IoInProg = 1 ;      /*  [2]  */

                b = dor_image ;                         /*  select drive  */

                if( driveno )
                        b |= 1 ;
                else
                        b &= ~1 ;

                if( motor_on[ driveno ] )
                {
                        OUTPW(FDCPORT , dor_image = b) ;   /*  select drive  */
                        return( TRUE ) ;
                }

                /*
                **  select drive and turn on motor.  
                **  do not turn off the other motor.
                */

                b = dor_image ;                 /*  current image       */

                if( driveno )
                        b |= ( 1 | 0x20 ) ;             /*  drive 1 [1] */
                else
                        b = ( b & ~(1) ) | 0x10 ;       /*  drive 0 [1] */

                OUTPW(FDCPORT , dor_image = b) ; /*  update curr image   */

#if     (TIMEOUTS == TRUE)

                /*
                **  setup asr to tell us when the motor has spun up
                */

                e = e_timer( NULLSWI , RELTIME , FDMOTORTIME ) ;
                NEXTASR( e , spintime , e , (LONG) driveno , DKASRPRI-1) ;
                return( FALSE ) ;
#else
                /*
                **  if ticks aren't on, we can't asynchronously wait for the 
                **  motor to spin up, so we must do it in a hard loop.
                */

                for( e = ((750 * 1000)/4) ; e ; e-- ) ;
                return( motor_on[ driveno ] = TRUE ) ;
#endif
        }
        else
        {
                /*  he wants us to turn the drive off  */

                if( motor_on[ driveno ] )
                {
                        /*
                        **  turn off only this drive.
                        **  do not change select bits.
                        */

                        b = driveno ? ~(0x20) : ~(0x10) ; /*  motor mask  */
                        b &= dor_image ;                  /*  msk off mtr */
                        OUTPW( FDCPORT , dor_image = b ) ;
                        motor_on[ driveno ] = FALSE ;
                        return( TRUE ) ;
                }
                return( FALSE ) ;
        }
}

/*
** [1]  motor on bits for 0x10 (drive 0) and 0x20 (drive 1).  bit 0 is the
**      drive A (drive 0) select:  0 = select drive 0, 1 = select drive 1.
*/

#if     (TIMEOUTS)
/**************************************************************************
*  spintime -
*/

VOID    spintime( e , drivenbr )
ENUM    e ;
LONG    drivenbr ;
{
        BYTE    driveno = (BYTE) drivenbr ;

        ARET( e ) ;                     /*  clear event                 */
        motor_on[ driveno ] = TRUE ;    /*  enable i/o                  */
        e = e_timer( NULLSWI , RELTIME , FDPOLLTIME ) ;
        DKNASR( e , motortime , e , drivenbr ) ;
        /*  now we wait to turn off motor                               */
}

#endif
#if     (TIMEOUTS)

/**************************************************************************
*  motortime -
*/

VOID    motortime( old_e , drivenbr )
ENUM    old_e ;
LONG    drivenbr ;
{
        BYTE    driveno = (BYTE) drivenbr ;
        ENUM    next_e ;


        ARET( old_e ) ;


        if(  (! IoInProg) && (! IoFlag[ driveno ])  )
        {
                /*  we've done no i/o since the last polling period     */
                /*  turn off motor                                      */
                fd_motor( OFF , driveno ) ;
                /*  now, don't come back                                */
        }
        else 
        {
                if( !IoInProg )
                        IoFlag[ driveno ] = 0 ;
                next_e = e_timer( NULLSWI , RELTIME , FDPOLLTIME ) ;
                DKNASR( next_e , motortime , next_e , drivenbr ) ;
        }
        
}

#endif
