/*===============================================================*
 *   Version 1.0        YHD.H                                    *
 *                      Hard disk controller definitions for     *
 *                      the WD1010AL-5 to be used with the PC/AT *
 *                      hard disk driver modules.                *
 *---------------------------------------------------------------*
 *    VERSION   DATE    BY      CHANGE/COMMENTS                  *
 *---------------------------------------------------------------*
 *                                                               *
 *    1.1       11/25   RB      Added cmos indexes for extended  *
 *                              drive types.                     *
 *                                                               *
 *===============================================================*
 */

/*
 *  structure macros
 *
 */

#define	HDTF	struct HDTaskFile



/***********************************************************************
 *
 *  driver parameter defines
 *
 */


#define	HDMAXUNITS	2	/* 2 hard disks	*/
			/*  max number of phy units supported		*/

#define	HDFLAGVAL	1
			/*  dh flag value				*/

#define	HDFILLVAL	0L
			/*  DH fill value for control words		*/
#define	HDMAXSECS	256

/***********************************************************************
 *
 *  HDC defines
 */

/*
 *  port definitions
 */

#define HDCDATA		0x1f0
			/*  read/write - data port (16 BITS WIDE !!!) */

#define	HDCERR		0x1f1
			/*  read - error flags				*/
#define	HDCPRECOMP	0x1f1
			/*  write - write precomp cyl ( divided by 4 )	*/

#define	HDCSECCNT	0x1f2
			/*  read/write - sector count			*/

#define HDCSECNO	0x1f3
			/*  read/write - sector number			*/

#define HDCCYLLO	0x1f4
			/*  read/write - lsb cylinder number		*/

#define HDCCYLHI	0x1f5
			/*  read/write - msb cylinder number		*/

#define HDCSDH		0x1f6
			/*  read/write - sector size, drv #, head #	*/

#define HDCSTAT		0x1f7
			/*  read - status register			*/
#define HDCCMD		0x1f7
			/*  write - command register			*/
	
/*
 *  HDCSTAT	status port values	
 */

#define	HDC_BSY		0x80
			/*  1 = hdc busy 				*/

#define HDC_RDY		0x40
			/*  1 = hdc ready				*/

#define HDC_WF		0x20
			/*  1 = hdc write fault				*/

#define HDC_SC		0x10
			/*  1 = hdc seek complete			*/

#define HDC_DRQ		0x8
			/*  1 = hdc data request			*/

#define	HDC_ECC		0x4
			/*  0 = hdc reserved bit			*/

#define HDC_INDEX	0x2
			/*  1 = hdc index pulse				*/

#define HDC_ERR		0x1
			/*  1 = hdc error				*/

/*
 *  HDCERR - error register equates
 */

#define HDC_BB		0x80
			/*  1 = hdc bad block detect			*/

#define HDC_CRC		0x40
			/*  1 = hdc crc data field			*/

#define HDC_ID		0x10
			/*  1 = hdc id not found			*/

#define HDC_AC		0x4
			/*  1 = hdc aborted command			*/

#define HDC_TK		0x2
			/*  1 = hdc track 0 error			*/

#define HDC_DM		0x1
			/*  1 = hdc data address mark not found		*/

/*
 *  command summary
 */

#define	HDCRECAL	0x10
			/*  hdc restore command				*/

#define HDCSEEK		0x70
			/*  hdc seek command				*/

#define HDCREAD		0x20
			/*  hdc read sector command			*/

#define HDCWRITE	0x30
			/*  hdc write sector command			*/

#define	HDCVERIFY	0x40
			/*  hdc read sector with no data xfer		*/

#define HDCFORMAT	0x50
			/*  hdc format track command			*/

#define HDCDIAG		0x90
			/*  hdc diagnostics				*/

#define HDCSET		0x91
			/*  hdc set parameters (for multisector i/o)	*/

/*
 *  additional bits/bit masks in command codes/parameter registers
 */

#define HDCRETRY	0x0
			/* hdc retry switch				*/
			/* 0 = enable retries				*/
			/* 1 = disable retries				*/

#define HDCMULTI	0x4
			/* hdc multi - sector read/write		*/
			/*  0 = transfer one sector			*/
			/*  1 = transfer multiple sectors		*/

#define HDCIE		0x8
			/* hdc interrupt enable				*/

#define HDCECC		0x80
			/* extended sector size for ecc field		*/

/*************************************************************************
 *
 *  Hard Disk register defines
 */

#define	HDCREG		0x3f6
			/*  fixed disk register				*/

#define	HDC_H16		0x8
			/* 16 head option, no reset			*/

#define	HDC_H8		0x0
			/* 8 head option, no reset			*/

#define HDC_RESET	0x4
			/* reset, 8 head option 			*/


/***********************************************************************
*  HDTF -
*	Hard Disk Task File.
*/

#define	CFMAX	7
		/*  max number of command bytes in command file		*/

HDTF
{
	BYTE	hd_cmd[CFMAX] ;	/*  disk command file			*/
} ;

/*
 *  hd_misc values 
 */

#define	HDINTNO		118	/* xmacine hard disk interrupt #	*/
#define PIC0CTL		0x20	/* pic control port			*/
#define PIC0MSK		0x21	/* pic mask port			*/
#define	PIC1CTL		0xa0	/* pic 1 control port #			*/
#define PIC1MSK		0xa1	/* pic 1 mask port #			*/
#define PICNSEOI	0x20	/* non specific end of interrupt	*/

#define	HDMAXREC	1024	/* max record size for this controller  */
#define HDCMOSVAL	0x92	/* cmos access value for hard disk type	*/  
#define HD1CMOSVAL      0x9A    /* cmos index drive type for drive d:   */
#define HD0CMOSVAL      0x99    /* cmos index drive type for drive c:   */
#define CODE_TYPE          0    /* type field for mapphys calls         */
